/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.indexing.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.indexing.api.CndTextIndexKey;
import org.netbeans.modules.cnd.repository.relocate.api.UnitCodec;
import org.netbeans.modules.parsing.lucene.support.DocumentIndex;
import org.netbeans.modules.parsing.lucene.support.IndexDocument;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class CndTextIndexImpl {
    private static final Logger LOG = Logger.getLogger("CndTextIndexImpl");
    private final DocumentIndex index;
    private final ConcurrentLinkedQueue<StoreQueueEntry> unsavedQueue = new ConcurrentLinkedQueue();
    private static final RequestProcessor RP = new RequestProcessor("CndTextIndexImpl saver", 1);
    private final RequestProcessor.Task storeTask = RP.create(new Runnable(){

        @Override
        public void run() {
            CndTextIndexImpl.this.store();
        }
    });
    private static final int STORE_DELAY = 3000;
    private final UnitCodec unitCodec;

    public CndTextIndexImpl(DocumentIndex index, UnitCodec unitCodec) {
        this.index = index;
        assert (unitCodec != null);
        this.unitCodec = unitCodec;
    }

    public void put(CndTextIndexKey key, Collection<String> values) {
        if (LOG.isLoggable(Level.FINE)) {
            if (key.getFileNameIndex() < 2) {
                LOG.log(Level.FINE, "Cnd Text Index put for {0}:\n\t{1}", new Object[]{key, values});
            } else {
                LOG.log(Level.FINE, "Cnd Text Index put for {0}:{1}", new Object[]{key, values.size()});
            }
        }
        this.unsavedQueue.add(new StoreQueueEntry(key, values));
        this.storeTask.schedule(3000);
    }

    synchronized void store() {
        if (this.unsavedQueue.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        StoreQueueEntry entry = this.unsavedQueue.poll();
        while (entry != null) {
            CndTextIndexKey key = entry.key;
            IndexDocument doc = IndexManager.createDocument((String)this.toPrimaryKey(key));
            for (String id : entry.ids) {
                doc.addPair("ids", id, true, false);
            }
            this.index.addDocument(doc);
            entry = this.unsavedQueue.poll();
        }
        try {
            this.index.store(false);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        LOG.log(Level.FINE, "Cnd Text Index store took {0}ms", System.currentTimeMillis() - start);
    }

    public Collection<CndTextIndexKey> query(String value) {
        this.store();
        try {
            Collection queryRes = this.index.query("ids", value, Queries.QueryKind.EXACT, new String[]{"_sn"});
            HashSet<CndTextIndexKey> res = new HashSet<CndTextIndexKey>(queryRes.size());
            for (IndexDocument doc : queryRes) {
                res.add(this.fromPrimaryKey(doc.getPrimaryKey()));
            }
            LOG.log(Level.FINE, "Cnd Text Index query for {0}:\n\t{1}", new Object[]{value, res});
            return res;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptySet();
        }
    }

    private String toPrimaryKey(CndTextIndexKey key) {
        return String.valueOf(((long)this.unitCodec.unmaskRepositoryID(key.getUnitId()) << 32) + (long)key.getFileNameIndex());
    }

    private CndTextIndexKey fromPrimaryKey(String ext) {
        long value = Long.parseLong(ext);
        int unitId = (int)(value >> 32);
        unitId = this.unitCodec.maskByRepositoryID(unitId);
        int fileNameIndex = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        return new CndTextIndexKey(unitId, fileNameIndex);
    }

    private static class StoreQueueEntry {
        private final CndTextIndexKey key;
        private final Collection<String> ids;

        public StoreQueueEntry(CndTextIndexKey key, Collection<String> ids) {
            this.key = key;
            this.ids = ids;
        }
    }
}

