/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;

public class CsmDeclarationResolver {
    private static final Comparator<CsmOffsetable> OFFSETABLE_COMPARATOR = new OffsetableComparator<CsmOffsetable>();

    private CsmDeclarationResolver() {
    }

    public static CsmDeclaration findDeclaration(CsmObject obj) {
        if (obj == null) {
            return null;
        }
        CsmClass clazz = null;
        if (CsmKindUtilities.isVariable((CsmObject)obj)) {
            CsmVariable var = (CsmVariable)obj;
            obj = var.getType();
        }
        if (!CsmKindUtilities.isType((CsmObject)obj)) {
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)obj)) {
                clazz = ((CsmClassForwardDeclaration)obj).getCsmClass();
            } else if (CsmKindUtilities.isEnumForwardDeclaration((CsmObject)obj)) {
                clazz = ((CsmEnumForwardDeclaration)obj).getCsmEnum();
            } else if (CsmKindUtilities.isClass((CsmObject)obj)) {
                clazz = (CsmClassifier)obj;
            } else if (CsmKindUtilities.isInheritance((CsmObject)obj)) {
                clazz = ((CsmInheritance)obj).getClassifier();
            }
        }
        return clazz;
    }

    public static CsmDeclaration findTopFileDeclaration(CsmFile file, int offset) {
        assert (file != null) : "can't be null file in findTopFileDeclaration";
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createOffsetFilter(offset);
        Iterator it = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
        while (it.hasNext()) {
            CsmDeclaration decl = (CsmDeclaration)it.next();
            assert (decl != null) : "can't be null declaration";
            if (CsmDeclarationResolver.isFromIncludedFile(decl, file) || !CsmOffsetUtilities.isInObject((CsmObject)decl, offset)) continue;
            return decl;
        }
        return null;
    }

    public static CsmObject findInnerFileObject(CsmFile file, int offset, CsmContext context, FileReferencesContext fileContext) {
        Iterator it1;
        CsmSelect.CsmFilter filter;
        Iterator it;
        assert (file != null) : "can't be null file in findTopFileDeclaration";
        CsmContextUtilities.updateContext((CsmObject)file, offset, context);
        Object lastObject = null;
        if (fileContext != null && !fileContext.isCleaned()) {
            fileContext.advance(offset);
            lastObject = fileContext.findInnerFileDeclaration(offset);
            if (lastObject == null) {
                return fileContext.findInnerFileObject(offset);
            }
            if (CsmOffsetUtilities.isInObject(lastObject, offset)) {
                return CsmDeclarationResolver.findInnerDeclaration(file, (CsmDeclaration)lastObject, context, offset);
            }
            fileContext.advance(offset - 1);
        }
        if ((lastObject = CsmDeclarationResolver.findInnerDeclaration(file, it = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)(filter = CsmSelect.getFilterBuilder().createOffsetFilter(offset))), context, offset)) == null) {
            it1 = CsmSelect.getIncludes((CsmFile)file, (CsmSelect.CsmFilter)filter);
            lastObject = CsmOffsetUtilities.findObject(it1, context, offset);
        }
        if (lastObject == null) {
            it1 = CsmSelect.getMacros((CsmFile)file, (CsmSelect.CsmFilter)filter);
            lastObject = CsmOffsetUtilities.findObject(it1, context, offset);
        }
        return lastObject;
    }

    private static CsmDeclaration findInnerDeclaration(CsmFile contextFile, Iterator<? extends CsmDeclaration> it, CsmContext context, int offset) {
        CsmDeclaration innerDecl = null;
        if (it != null) {
            while (it.hasNext()) {
                CsmDeclaration decl = it.next();
                assert (decl != null) : "can't be null declaration";
                if (CsmDeclarationResolver.isFromIncludedFile(decl, contextFile)) continue;
                if (CsmOffsetUtilities.isInObject((CsmObject)decl, offset)) {
                    if (!CsmKindUtilities.isFunction((CsmObject)decl) || CsmOffsetUtilities.isInFunctionScope((CsmFunction)decl, offset)) {
                        CsmContextUtilities.updateContext((CsmObject)decl, offset, context);
                        innerDecl = CsmDeclarationResolver.findInnerDeclaration(contextFile, decl, offset, context);
                    } else {
                        context.setLastObject((CsmObject)decl);
                    }
                    CsmDeclaration csmDeclaration = innerDecl = innerDecl != null ? innerDecl : decl;
                }
                if (!CsmOffsetUtilities.isBeforeObject((CsmObject)decl, offset)) continue;
                break;
            }
        }
        return innerDecl;
    }

    private static CsmDeclaration findInnerDeclaration(CsmFile contextFile, CsmDeclaration decl, CsmContext context, int offset) {
        CsmDeclaration innerDecl = null;
        assert (decl != null) : "can't be null declaration";
        if (!CsmKindUtilities.isFunction((CsmObject)decl) || CsmOffsetUtilities.isInFunctionScope((CsmFunction)decl, offset)) {
            CsmContextUtilities.updateContext((CsmObject)decl, offset, context);
            innerDecl = CsmDeclarationResolver.findInnerDeclaration(contextFile, decl, offset, context);
        } else {
            context.setLastObject((CsmObject)decl);
        }
        innerDecl = innerDecl != null ? innerDecl : decl;
        return innerDecl;
    }

    private static CsmDeclaration findInnerDeclaration(CsmFile contextFile, CsmDeclaration outDecl, int offset, CsmContext context) {
        CsmTypedef td;
        assert (CsmOffsetUtilities.isInObject((CsmObject)outDecl, offset)) : "must be in outDecl object!";
        Iterator it = null;
        if (CsmKindUtilities.isNamespace((Object)outDecl)) {
            CsmNamespace ns = (CsmNamespace)outDecl;
            it = ns.getDeclarations().iterator();
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)outDecl)) {
            it = ((CsmNamespaceDefinition)outDecl).getDeclarations().iterator();
        } else if (CsmKindUtilities.isClass((CsmObject)outDecl)) {
            CsmClass cl = (CsmClass)outDecl;
            ArrayList list = new ArrayList();
            list.addAll(cl.getMembers());
            if (!cl.getFriends().isEmpty()) {
                list.addAll(cl.getFriends());
                Collections.sort(list, OFFSETABLE_COMPARATOR);
            }
            it = list.iterator();
        } else if (CsmKindUtilities.isEnum((CsmObject)outDecl)) {
            CsmEnum en = (CsmEnum)outDecl;
            it = en.getEnumerators().iterator();
        } else if (CsmKindUtilities.isTypedef((CsmObject)outDecl) && ((td = (CsmTypedef)outDecl).isTypeUnnamed() || td.getName().length() == 0) && CsmOffsetUtilities.isInObject((CsmObject)(outDecl = td.getType().getClassifier()), offset)) {
            CsmContextUtilities.updateContext((CsmObject)outDecl, offset, context);
            return CsmDeclarationResolver.findInnerDeclaration(contextFile, outDecl, offset, context);
        }
        return CsmDeclarationResolver.findInnerDeclaration(contextFile, it, context, offset);
    }

    private static boolean isFromIncludedFile(CsmDeclaration decl, CsmFile file) {
        return CsmKindUtilities.isOffsetable((Object)decl) && !file.equals(((CsmOffsetable)decl).getContainingFile());
    }

    private static class OffsetableComparator<T extends CsmOffsetable>
    implements Comparator<T> {
        private OffsetableComparator() {
        }

        @Override
        public int compare(CsmOffsetable o1, CsmOffsetable o2) {
            int diff = o1.getStartOffset() - o2.getStartOffset();
            if (diff == 0) {
                return o1.getEndOffset() - o2.getEndOffset();
            }
            return diff;
        }
    }
}

