/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.completion.cplusplus.ext.MacroCallback;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

public final class CsmExpandedTokenProcessor
implements CndTokenProcessor<Token<TokenId>>,
MacroCallback {
    private final CndTokenProcessor<Token<TokenId>> tp;
    private final Document doc;
    private final int lastOffset;
    private boolean inMacro;
    private int skipTill = -1;
    private final CsmFile file;
    private List<CsmReference> macros;

    private CsmExpandedTokenProcessor(Document doc, CsmFile file, CndTokenProcessor<Token<TokenId>> tp, int offset, List<CsmReference> macros) {
        this.tp = tp;
        this.doc = doc;
        this.lastOffset = offset;
        this.file = file;
        this.macros = macros;
    }

    public static CndTokenProcessor<Token<TokenId>> create(CsmFile file, Document doc, CndTokenProcessor<Token<TokenId>> tp, int offset) {
        if (doc != null) {
            List macros;
            if (file == null) {
                file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
            }
            if (file != null && (macros = CsmFileInfoQuery.getDefault().getMacroUsages(file)) != null) {
                return CsmExpandedTokenProcessor.create(doc, file, tp, offset, macros);
            }
        }
        return tp;
    }

    private static CndTokenProcessor<Token<TokenId>> create(Document doc, CsmFile file, CndTokenProcessor<Token<TokenId>> tp, int offset, List<CsmReference> macros) {
        CsmMacroExpansion.expand((Document)doc, (CsmFile)file, (int)0, (int)0, (boolean)true);
        return new CsmExpandedTokenProcessor(doc, file, tp, offset, macros);
    }

    public void start(int startOffset, int firstTokenOffset, int lastOffset) {
        this.tp.start(startOffset, firstTokenOffset, lastOffset);
    }

    public void end(int offset, int lastTokenOffset) {
        this.tp.end(offset, lastTokenOffset);
    }

    public boolean isStopped() {
        return this.tp.isStopped();
    }

    @Override
    public boolean isMacroExpansion() {
        return this.inMacro;
    }

    public boolean isMacro(Token<TokenId> token, int tokenOffset) {
        return CndLexerUtilities.isCppIdentifierStart((char)token.text().charAt(0)) && ReferencesSupport.findMacro(this.macros, tokenOffset) != null;
    }

    public boolean token(Token<TokenId> token, int tokenOffset) {
        if (this.skipTill <= tokenOffset) {
            this.skipTill = -1;
        }
        if (this.skipTill < 0 && (this.isMacro(token, tokenOffset) || this.inMacro)) {
            TokenSequence expTS = null;
            String expansion = CsmMacroExpansion.expand((Document)this.doc, (CsmFile)this.file, (int)tokenOffset, (int)(tokenOffset + token.length()), (boolean)false);
            if (expansion != null) {
                if (expansion.equals("")) {
                    if (this.lastOffset == -1 || tokenOffset + token.length() < this.lastOffset) {
                        return false;
                    }
                } else if (this.inMacro) {
                    this.inMacro = false;
                } else {
                    this.inMacro = true;
                    int[] span = CsmMacroExpansion.getMacroExpansionSpan((Document)this.doc, (int)tokenOffset, (boolean)false);
                    if (span[0] < this.lastOffset && this.lastOffset <= span[1]) {
                        this.skipTill = span[1];
                        this.inMacro = false;
                        return this.tp.token(token, tokenOffset);
                    }
                    TokenHierarchy hi = TokenHierarchy.create((CharSequence)expansion, (Language)CndLexerUtilities.getLanguage((Document)this.doc));
                    List tsList = hi.embeddedTokenSequences(tokenOffset + token.length(), true);
                    for (int i = tsList.size() - 1; i >= 0; --i) {
                        TokenSequence uts;
                        TokenSequence ts = (TokenSequence)tsList.get(i);
                        Language lang = ts.languagePath().innerLanguage();
                        if (!CndLexerUtilities.isCppLanguage((Language)lang, (boolean)false)) continue;
                        expTS = uts = ts;
                    }
                    if (expTS != null) {
                        expTS.moveStart();
                        if (expTS.moveNext()) {
                            boolean res;
                            Token expToken = expTS.token();
                            if (!expTS.moveNext()) {
                                res = ((Object)expToken.text()).toString().equals(((Object)token.text()).toString()) && expToken.id().equals(token.id()) ? this.tp.token(token, tokenOffset) : this.tp.token(expToken, tokenOffset);
                            } else {
                                res = this.tp.token(expToken, tokenOffset);
                                res = this.tp.token(expTS.token(), tokenOffset);
                                while (expTS.moveNext()) {
                                    res = this.tp.token(expTS.token(), tokenOffset);
                                }
                            }
                            return res;
                        }
                    }
                }
            }
        }
        if (!this.isWhitespace(token)) {
            this.inMacro = false;
        }
        return this.tp.token(token, tokenOffset);
    }

    private boolean isWhitespace(Token<TokenId> docToken) {
        TokenId id = docToken.id();
        if (id instanceof CppTokenId) {
            switch ((CppTokenId)id) {
                case NEW_LINE: 
                case WHITESPACE: 
                case ESCAPED_WHITESPACE: 
                case ESCAPED_LINE: {
                    return true;
                }
            }
        }
        return false;
    }
}

