/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletion;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.completion.cplusplus.ext.MacroCallback;

final class CsmCompletionTokenProcessor
implements CndTokenProcessor<Token<TokenId>> {
    private static final int NO_EXP = -1;
    private int bufferStartPos;
    private int bufferOffsetDelta;
    private List<CsmCompletionExpression> expStack = new ArrayList<CsmCompletionExpression>();
    private CppTokenId lastValidTokenID;
    private String lastValidTokenText;
    private boolean errorState = false;
    private boolean inPreprocessor = false;
    private CppTokenId curTokenID;
    private int curTokenPosition;
    private String curTokenText;
    private int endScanOffset;
    private boolean supportTemplates;
    private int nrQuestions = 0;
    private MacroCallback macroCallback = null;
    private List<OffsetableToken> lookaheadTokens = new ArrayList<OffsetableToken>();
    private int lookaheadTokensParensLevel = 0;
    private int lookaheadTokensBracketsLevel = 0;
    private int lookaheadTokensBracesLevel = 0;
    private int lookaheadTokensLtgtsLevel = 0;
    private int lastSeparatorOffset = -1;
    private Boolean inPP;

    CsmCompletionTokenProcessor(int endScanOffset, int lastSeparatorOffset) {
        this.endScanOffset = endScanOffset;
        this.lastSeparatorOffset = lastSeparatorOffset;
    }

    void enableTemplateSupport(boolean supportTemplates) {
        this.supportTemplates = supportTemplates;
    }

    final List<CsmCompletionExpression> getStack() {
        return this.expStack;
    }

    final CppTokenId getLastValidTokenID() {
        return this.lastValidTokenID;
    }

    final String getLastValidTokenText() {
        return this.lastValidTokenText;
    }

    final int getCurrentOffest() {
        return this.curTokenPosition;
    }

    final boolean isErrorState() {
        return this.errorState;
    }

    final boolean isInPreprocessor() {
        return this.inPreprocessor;
    }

    final CsmCompletionExpression getResultExp() {
        CsmCompletionExpression result = this.peekExp();
        return result;
    }

    private void clearStack() {
        this.expStack.clear();
    }

    boolean isSeparatorOrOperator(CppTokenId tokenID) {
        return CndLexerUtilities.isSeparatorOrOperator((CppTokenId)tokenID);
    }

    private boolean isEqOperator(CppTokenId tokenID) {
        switch (tokenID) {
            case EQ: 
            case EQEQ: 
            case GTEQ: 
            case GTGTEQ: 
            case AMPEQ: 
            case LTEQ: 
            case LTLTEQ: 
            case PLUSEQ: 
            case NOTEQ: 
            case MINUSEQ: 
            case STAREQ: 
            case SLASHEQ: 
            case BAREQ: 
            case CARETEQ: 
            case PERCENTEQ: {
                return true;
            }
        }
        return false;
    }

    public void setMacroCallback(MacroCallback callback) {
        this.macroCallback = callback;
    }

    private boolean isMacroExpansion() {
        if (this.macroCallback != null) {
            return this.macroCallback.isMacroExpansion();
        }
        return false;
    }

    private void pushExp(CsmCompletionExpression exp) {
        this.expStack.add(exp);
    }

    private CsmCompletionExpression popExp() {
        int cnt = this.expStack.size();
        return cnt > 0 ? this.expStack.remove(cnt - 1) : null;
    }

    private CsmCompletionExpression peekExp() {
        int cnt = this.expStack.size();
        return cnt > 0 ? this.expStack.get(cnt - 1) : null;
    }

    private CsmCompletionExpression peekExp2() {
        int cnt = this.expStack.size();
        return cnt > 1 ? this.expStack.get(cnt - 2) : null;
    }

    private CsmCompletionExpression peekExp(int ind) {
        int cnt = this.expStack.size();
        return cnt >= ind && cnt > 0 ? this.expStack.get(cnt - ind) : null;
    }

    private CsmCompletionExpression createTokenExp(int id) {
        CsmCompletionExpression exp = new CsmCompletionExpression(id);
        this.addTokenTo(exp);
        return exp;
    }

    private void addTokenTo(CsmCompletionExpression exp) {
        exp.addToken(this.curTokenID, this.curTokenPosition, this.curTokenText);
    }

    private int getValidExpID(CsmCompletionExpression exp) {
        return exp != null ? exp.getExpID() : -1;
    }

    private int tokenID2OpenExpID(CppTokenId tokenID) {
        switch (tokenID) {
            case DOT: 
            case DOTMBR: {
                return 5;
            }
            case ARROW: 
            case ARROWMBR: {
                return 26;
            }
            case SCOPE: {
                return 28;
            }
            case IF: {
                return 42;
            }
            case FOR: {
                return 41;
            }
            case SWITCH: {
                return 43;
            }
            case WHILE: {
                return 44;
            }
        }
        assert (false) : "unexpected tokenID " + tokenID;
        return 0;
    }

    private int openExpID2ExpID(int openExpID) {
        switch (openExpID) {
            case 5: {
                return 4;
            }
            case 26: {
                return 25;
            }
            case 28: {
                return 27;
            }
        }
        assert (false) : "unexpected expID" + CsmCompletionExpression.getIDName(openExpID);
        return 0;
    }

    private void setExprToTYPE(CsmCompletionExpression exp) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < exp.getTokenCount(); ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(exp.getTokenText(i));
        }
        exp.setType(buf.toString());
        exp.setExpID(14);
    }

    public boolean token(Token<TokenId> token, int tokenOffset) {
        if (!(token.id() instanceof CppTokenId)) {
            return false;
        }
        if (this.inPP == null) {
            this.inPP = token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE;
        }
        if (token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
            return this.inPP;
        }
        this.lookahead(token, tokenOffset);
        return false;
    }

    private void lookahead(Token<TokenId> token, int tokenOffset) {
        boolean lookahead = false;
        if (this.isTemplateAmbiguity(token) && this.isLookaheadNeeded(token)) {
            lookahead = true;
            this.lookaheadTokens.add(new OffsetableToken(token, tokenOffset, this.isMacroExpansion(), this.inPP));
            switch ((CppTokenId)token.id()) {
                case LT: {
                    ++this.lookaheadTokensLtgtsLevel;
                    break;
                }
                case GT: {
                    --this.lookaheadTokensLtgtsLevel;
                    break;
                }
                case LPAREN: {
                    ++this.lookaheadTokensParensLevel;
                    break;
                }
                case RPAREN: {
                    --this.lookaheadTokensParensLevel;
                    break;
                }
                case LBRACKET: {
                    ++this.lookaheadTokensBracketsLevel;
                    break;
                }
                case RBRACKET: {
                    --this.lookaheadTokensBracketsLevel;
                    break;
                }
                case LBRACE: {
                    ++this.lookaheadTokensBracesLevel;
                    break;
                }
                case RBRACE: {
                    --this.lookaheadTokensBracesLevel;
                }
            }
        }
        if (!lookahead) {
            if (this.lookaheadTokens.isEmpty()) {
                this.tokenImpl(token, tokenOffset, this.isMacroExpansion());
            } else {
                Boolean oldInPP = this.inPP;
                for (OffsetableToken offsetableToken : this.lookaheadTokens) {
                    this.inPP = offsetableToken.inPP;
                    this.tokenImpl(offsetableToken.token, offsetableToken.offset, offsetableToken.macro);
                }
                this.lookaheadTokens.clear();
                this.tokenImpl(token, tokenOffset, this.isMacroExpansion());
                this.inPP = oldInPP;
                this.lookaheadTokensParensLevel = 0;
                this.lookaheadTokensBracketsLevel = 0;
                this.lookaheadTokensBracesLevel = 0;
                this.lookaheadTokensLtgtsLevel = 0;
            }
        }
    }

    private boolean isLookaheadNeeded(Token<TokenId> token) {
        int tempLookaheadTokensParensLevel = this.lookaheadTokensParensLevel;
        int tempLookaheadTokensBracketsLevel = this.lookaheadTokensBracketsLevel;
        int tempLookaheadTokensBracesLevel = this.lookaheadTokensBracesLevel;
        int tempLookaheadTokensLtgtsLevel = this.lookaheadTokensLtgtsLevel;
        switch ((CppTokenId)token.id()) {
            case LT: {
                ++tempLookaheadTokensLtgtsLevel;
                break;
            }
            case GT: {
                --tempLookaheadTokensLtgtsLevel;
                break;
            }
            case LPAREN: {
                ++tempLookaheadTokensParensLevel;
                break;
            }
            case RPAREN: {
                --tempLookaheadTokensParensLevel;
                break;
            }
            case LBRACKET: {
                ++tempLookaheadTokensBracketsLevel;
                break;
            }
            case RBRACKET: {
                --tempLookaheadTokensBracketsLevel;
                break;
            }
            case LBRACE: {
                ++tempLookaheadTokensBracesLevel;
                break;
            }
            case RBRACE: {
                --tempLookaheadTokensBracesLevel;
            }
        }
        if (!this.lookaheadTokens.isEmpty()) {
            return tempLookaheadTokensParensLevel != 0 || tempLookaheadTokensBracketsLevel != 0 || tempLookaheadTokensBracesLevel != 0 || tempLookaheadTokensLtgtsLevel != 0;
        }
        return true;
    }

    private boolean isTemplateAmbiguity(Token<TokenId> token) {
        CsmCompletionExpression top;
        if (this.supportTemplates && (token.id() == CppTokenId.LT || !this.lookaheadTokens.isEmpty() && this.lookaheadTokens.get((int)0).token.id() == CppTokenId.LT) && (top = this.peekExp()) != null) {
            switch (top.getExpID()) {
                case 1: 
                case 4: 
                case 25: 
                case 27: 
                case 32: {
                    return true;
                }
            }
        }
        return false;
    }

    private OffsetableToken isSupportTemplates() {
        LinkedList<CppTokenId> stack = new LinkedList<CppTokenId>();
        for (OffsetableToken offsetableToken : this.lookaheadTokens) {
            switch ((CppTokenId)offsetableToken.token.id()) {
                case LT: {
                    stack.push(CppTokenId.LT);
                    break;
                }
                case GT: {
                    if (stack.isEmpty() || stack.pop() == CppTokenId.LT) break;
                    return offsetableToken;
                }
                case LPAREN: {
                    stack.push(CppTokenId.LPAREN);
                    break;
                }
                case RPAREN: {
                    if (stack.isEmpty() || stack.pop() == CppTokenId.LPAREN) break;
                    return offsetableToken;
                }
                case LBRACKET: {
                    stack.push(CppTokenId.LBRACKET);
                    break;
                }
                case RBRACKET: {
                    if (stack.isEmpty() || stack.pop() == CppTokenId.LBRACKET) break;
                    return offsetableToken;
                }
                case LBRACE: {
                    stack.push(CppTokenId.LBRACE);
                    break;
                }
                case RBRACE: {
                    if (stack.isEmpty() || stack.pop() == CppTokenId.LBRACE) break;
                    return offsetableToken;
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkJoin(CppTokenId tokenID) {
        boolean ret = true;
        boolean cont = true;
        block69: while (cont) {
            cont = false;
            CsmCompletionExpression top = this.peekExp();
            CsmCompletionExpression top2 = this.peekExp2();
            int top2ID = this.getValidExpID(top2);
            int topID = this.getValidExpID(top);
            switch (topID) {
                case 17: {
                    boolean stop = false;
                    switch (top2ID) {
                        case 10: {
                            switch (tokenID) {
                                case STAR: 
                                case AMP: 
                                case CONST: 
                                case IDENTIFIER: {
                                    this.popExp();
                                    CsmCompletionExpression typeExpr = new CsmCompletionExpression(14);
                                    typeExpr.addParameter(top);
                                    this.pushExp(typeExpr);
                                    stop = true;
                                }
                            }
                            break;
                        }
                    }
                    if (stop) break;
                }
                case 1: {
                    boolean stop = false;
                    block11 : switch (top2ID) {
                        case 10: {
                            switch (tokenID) {
                                case STAR: 
                                case AMP: 
                                case CONST: 
                                case IDENTIFIER: {
                                    this.setExprToTYPE(top);
                                    stop = true;
                                    break block11;
                                }
                            }
                            break;
                        }
                        case 29: {
                            switch (tokenID) {
                                case STAR: 
                                case AMP: 
                                case CONST: 
                                case IDENTIFIER: {
                                    this.popExp();
                                    this.setExprToTYPE(top2);
                                    for (int i = 0; i < top.getTokenCount(); ++i) {
                                        top2.addToken(top.getTokenID(i), top.getTokenOffset(i), top.getTokenText(i));
                                    }
                                    top = top2;
                                    stop = true;
                                }
                            }
                            break;
                        }
                    }
                    if (stop) break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 25: 
                case 27: {
                    block21 : switch (top2ID) {
                        case 10: {
                            switch (tokenID) {
                                case STAR: 
                                case AMP: 
                                case CONST: 
                                case IDENTIFIER: {
                                    this.setExprToTYPE(top);
                                    break block21;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (tokenID) {
                                case DOT: 
                                case DOTMBR: 
                                case ARROW: 
                                case ARROWMBR: 
                                case SCOPE: 
                                case LBRACKET: 
                                case PLUSPLUS: 
                                case MINUSMINUS: {
                                    break;
                                }
                                case LT: {
                                    if (this.supportTemplates) break;
                                }
                                case LPAREN: {
                                    if (topID != 1 || top2ID != 3 || top2.getParameterCount() != 0 || top2.getTokenCount() != 1 || top2.getTokenID(0) != CppTokenId.TILDE || top.getParameterCount() != 0 || top.getTokenCount() != 1) break;
                                    this.popExp();
                                    this.popExp();
                                    CppTokenId aCurTokenID = top.getTokenID(0);
                                    int aCurTokenPosition = top2.getTokenOffset(0);
                                    String aCurTokenText = top2.getTokenText(0) + top.getTokenText(0);
                                    CsmCompletionExpression exp = new CsmCompletionExpression(1);
                                    exp.addToken(aCurTokenID, aCurTokenPosition, aCurTokenText);
                                    this.pushExp(exp);
                                    break;
                                }
                                case WHITESPACE: 
                                case NEW_LINE: 
                                case LINE_COMMENT: 
                                case DOXYGEN_LINE_COMMENT: 
                                case BLOCK_COMMENT: 
                                case DOXYGEN_COMMENT: {
                                    break;
                                }
                                default: {
                                    if (top2.getParameterCount() != 0) break;
                                    this.popExp();
                                    top2.addParameter(top);
                                    break;
                                }
                            }
                            break;
                        }
                        case 5: 
                        case 26: 
                        case 28: {
                            if (!this.isSeparatorOrOperator(tokenID)) break;
                            switch (tokenID) {
                                case LPAREN: {
                                    break;
                                }
                                case LT: {
                                    if (this.supportTemplates) break;
                                }
                                default: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    top2.setExpID(this.openExpID2ExpID(top2ID));
                                    cont = true;
                                    break;
                                }
                            }
                            break;
                        }
                        case 33: {
                            if (!this.isSeparatorOrOperator(tokenID)) break;
                            switch (tokenID) {
                                case DOT: 
                                case ARROW: 
                                case SCOPE: 
                                case LPAREN: 
                                case LBRACKET: {
                                    break block21;
                                }
                            }
                            this.popExp();
                            top2.addParameter(top);
                            top2.setExpID(32);
                            cont = true;
                            break;
                        }
                        case 13: {
                            if (!this.isSeparatorOrOperator(tokenID)) break;
                            switch (tokenID) {
                                case RPAREN: 
                                case COMMA: {
                                    CsmCompletionExpression top3 = this.peekExp(3);
                                    if (top3 != null) {
                                        switch (top3.getExpID()) {
                                            case 8: 
                                            case 10: {
                                                this.popExp();
                                                top2.addParameter(top);
                                            }
                                        }
                                        break;
                                    }
                                    break block21;
                                }
                            }
                            break;
                        }
                        case 1: 
                        case 14: 
                        case 27: 
                        case 31: {
                            if (!this.isSeparatorOrOperator(tokenID)) break;
                            switch (tokenID) {
                                case GT: 
                                case RPAREN: 
                                case LBRACKET: 
                                case STAR: 
                                case AMP: {
                                    if (topID != 2 || top.getParameterCount() != 0 || top.getTokenCount() != 1 || top.getTokenID(0) != CppTokenId.STAR && top.getTokenID(0) != CppTokenId.AMP) break block21;
                                    this.popExp();
                                    this.popExp();
                                    CsmCompletionExpression exp = new CsmCompletionExpression(31);
                                    exp.addParameter(top2);
                                    exp.addToken(top.getTokenID(0), top.getTokenOffset(0), top.getTokenText(0));
                                    this.pushExp(exp);
                                    break block21;
                                }
                            }
                        }
                    }
                    continue block69;
                }
            }
        }
        int leftOpID = CsmCompletionExpression.getOperatorID(tokenID);
        if (leftOpID < 0) return ret;
        switch (CsmCompletionExpression.getOperatorPrecedence(leftOpID)) {
            case 0: {
                CsmCompletionExpression lastVar = null;
                CsmCompletionExpression rightOp = this.peekExp();
                int rightOpID = -1;
                rightOpID = CsmCompletionExpression.getOperatorID(rightOp);
                block57 : switch (CsmCompletionExpression.getOperatorPrecedence(rightOpID)) {
                    case 0: {
                        rightOp = null;
                        break;
                    }
                    case 1: {
                        lastVar = rightOp;
                        rightOp = this.peekExp2();
                        rightOpID = CsmCompletionExpression.getOperatorID(rightOp);
                        switch (CsmCompletionExpression.getOperatorPrecedence(rightOpID)) {
                            case 0: {
                                rightOp = null;
                                break block57;
                            }
                            case 1: {
                                return false;
                            }
                        }
                        this.popExp();
                        rightOp.addParameter(lastVar);
                        lastVar = null;
                        break;
                    }
                }
                if (rightOp == null) return ret;
                this.popExp();
                cont = true;
                ArrayList<CsmCompletionExpression> opStack = new ArrayList<CsmCompletionExpression>();
                CsmCompletionExpression leftOp = null;
                do {
                    if (leftOp == null) {
                        leftOp = this.popExp();
                        if (leftOp == null) break;
                        leftOpID = CsmCompletionExpression.getOperatorID(leftOp);
                    }
                    switch (CsmCompletionExpression.getOperatorPrecedence(leftOpID)) {
                        case 0: {
                            this.pushExp(leftOp);
                            cont = false;
                            break;
                        }
                        case 1: {
                            lastVar = leftOp;
                            leftOp = null;
                            break;
                        }
                        default: {
                            int leftOpPrec = CsmCompletionExpression.getOperatorPrecedence(leftOpID);
                            int rightOpPrec = CsmCompletionExpression.getOperatorPrecedence(rightOpID);
                            boolean rightPrec = leftOpPrec > rightOpPrec ? false : (leftOpPrec < rightOpPrec ? true : CsmCompletionExpression.isOperatorRightAssociative(rightOpID));
                            if (rightPrec) {
                                if (lastVar != null) {
                                    rightOp.addParameter(lastVar);
                                }
                                if (opStack.size() > 0) {
                                    lastVar = rightOp;
                                    rightOp = (CsmCompletionExpression)opStack.remove(opStack.size() - 1);
                                    rightOpID = CsmCompletionExpression.getOperatorID(rightOp);
                                    break;
                                }
                                leftOp.addParameter(rightOp);
                                lastVar = null;
                                rightOp = leftOp;
                                rightOpID = leftOpID;
                                leftOp = null;
                                break;
                            }
                            if (lastVar != null) {
                                leftOp.addParameter(lastVar);
                                lastVar = null;
                            }
                            opStack.add(rightOp);
                            rightOp = leftOp;
                            rightOpID = leftOpID;
                            leftOp = null;
                        }
                    }
                } while (cont);
                if (lastVar != null) {
                    rightOp.addParameter(lastVar);
                }
                for (int i = opStack.size() - 1; i >= 0; --i) {
                    CsmCompletionExpression op = (CsmCompletionExpression)opStack.get(i);
                    op.addParameter(rightOp);
                    rightOp = op;
                }
                rightOp.swapOperatorParms();
                this.pushExp(rightOp);
                return ret;
            }
        }
        return ret;
    }

    private void tokenImpl(Token<TokenId> token, int tokenOffset, boolean macro) {
        String kwdType;
        String category;
        int tokenLen = token.length();
        CppTokenId tokenID = (CppTokenId)token.id();
        if (!macro && tokenID != null && ("keyword".equals(category = tokenID.primaryCategory()) || "keyword-directive".equals(category)) && (tokenOffset += this.bufferOffsetDelta) + tokenLen == this.endScanOffset) {
            tokenID = CppTokenId.IDENTIFIER;
        }
        if (tokenID == CppTokenId.PREPROCESSOR_IDENTIFIER || tokenID == CppTokenId.SIZEOF || tokenID == CppTokenId.TYPEID) {
            tokenID = CppTokenId.IDENTIFIER;
        }
        if (tokenID != null) {
            if (this.lastValidTokenID == CppTokenId.COLON) {
                --this.nrQuestions;
            }
            this.lastValidTokenID = tokenID;
        }
        this.curTokenID = tokenID;
        this.curTokenPosition = this.bufferStartPos + tokenOffset;
        CharSequence txt = token.text();
        if (!this.isMacroExpansion() && tokenOffset + tokenLen > this.endScanOffset) {
            assert (this.endScanOffset > tokenOffset) : "end - " + this.endScanOffset + " start - " + tokenOffset + " tokenLen - " + tokenLen + "tokenID - " + tokenID + " txt = \n" + txt;
            txt = txt.subSequence(0, this.endScanOffset - tokenOffset);
        }
        StringBuilder buf = new StringBuilder(txt);
        this.lastValidTokenText = this.curTokenText = buf.toString();
        this.errorState = false;
        this.checkJoin(tokenID);
        CsmCompletionExpression top = this.peekExp();
        int topID = this.getValidExpID(top);
        CsmCompletionExpression constExp = null;
        String string = kwdType = CndLexerUtilities.isType((CppTokenId)tokenID) ? this.curTokenText : null;
        if (tokenID == null) {
            this.errorState = true;
        } else {
            block0 : switch (tokenID) {
                case PREPROCESSOR_START: 
                case PREPROCESSOR_START_ALT: {
                    this.pushExp(this.createTokenExp(39));
                    break;
                }
                case PREPROCESSOR_DEFINE: 
                case PREPROCESSOR_ELIF: 
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ENDIF: 
                case PREPROCESSOR_ERROR: 
                case PREPROCESSOR_IDENT: 
                case PREPROCESSOR_IF: 
                case PREPROCESSOR_IFDEF: 
                case PREPROCESSOR_IFNDEF: 
                case PREPROCESSOR_INCLUDE: 
                case PREPROCESSOR_INCLUDE_NEXT: 
                case PREPROCESSOR_LINE: 
                case PREPROCESSOR_PRAGMA: 
                case PREPROCESSOR_UNDEF: 
                case PREPROCESSOR_WARNING: {
                    if (topID == 39) {
                        top.setExpID(38);
                        this.addTokenTo(top);
                        break;
                    }
                    this.errorState = true;
                    break;
                }
                case STATIC_CAST: 
                case DYNAMIC_CAST: 
                case CONST_CAST: 
                case REINTERPRET_CAST: {
                    this.pushExp(this.createTokenExp(37));
                    break;
                }
                case TRUE: 
                case FALSE: {
                    constExp = this.createTokenExp(0);
                    constExp.setType(((Object)CsmCompletion.BOOLEAN_CLASS.getName()).toString());
                    break;
                }
                case NULL: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("null");
                    break;
                }
                case CLASS: {
                    if (topID == 5 || topID == 26 || topID == 28) {
                        this.pushExp(this.createTokenExp(1));
                        break;
                    }
                }
                case STRUCT: 
                case UNION: {
                    this.pushExp(this.createTokenExp(36));
                    break;
                }
                case GOTO: {
                    this.pushExp(this.createTokenExp(34));
                    break;
                }
                case NEW: {
                    switch (topID) {
                        case 1: 
                        case 15: {
                            this.errorState = true;
                            break block0;
                        }
                    }
                    this.pushExp(this.createTokenExp(15));
                    break;
                }
                case STATIC: {
                    switch (topID) {
                        default: 
                    }
                    this.errorState = true;
                    break;
                }
                case THIS: {
                    this.pushExp(this.createTokenExp(1));
                    break;
                }
                case CASE: {
                    this.pushExp(this.createTokenExp(24));
                    break;
                }
                case IF: 
                case FOR: 
                case SWITCH: 
                case WHILE: {
                    if (topID == -1) {
                        this.pushExp(this.createTokenExp(this.tokenID2OpenExpID(tokenID)));
                        break;
                    }
                    this.errorState = true;
                    break;
                }
                case IDENTIFIER: {
                    switch (topID) {
                        case -1: 
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 10: 
                        case 13: 
                        case 15: 
                        case 16: 
                        case 18: 
                        case 20: 
                        case 21: 
                        case 24: 
                        case 26: 
                        case 28: 
                        case 29: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 36: 
                        case 37: 
                        case 46: {
                            this.pushExp(this.createTokenExp(1));
                            break block0;
                        }
                        case 40: {
                            this.popExp();
                            top = this.peekExp();
                            while (this.getValidExpID(top) == 1 || this.getValidExpID(top) == 2 || this.getValidExpID(top) == 0) {
                                this.popExp();
                                top = this.peekExp();
                            }
                            this.pushExp(this.createTokenExp(1));
                            break block0;
                        }
                        case 19: {
                            top.setExpID(1);
                            this.addTokenTo(top);
                            break block0;
                        }
                        case 14: {
                            if (this.getValidExpID(this.peekExp2()) != 10) {
                                this.popExp();
                                this.pushExp(this.createTokenExp(1));
                                break block0;
                            }
                            this.popExp();
                            CsmCompletionExpression var = this.createTokenExp(1);
                            var.addParameter(top);
                            this.pushExp(var);
                            break block0;
                        }
                        case 1: {
                            if (this.getValidExpID(this.peekExp2()) == 10) {
                                this.addTokenTo(top);
                                break block0;
                            }
                            int cnt = this.expStack.size();
                            CsmCompletionExpression gen = null;
                            for (int i = 0; i < cnt; ++i) {
                                CsmCompletionExpression expr = this.peekExp(i + 1);
                                if (expr.getExpID() != 18) continue;
                                gen = expr;
                                break;
                            }
                            if (gen != null) {
                                this.pushExp(this.createTokenExp(1));
                                break block0;
                            }
                            this.errorState = true;
                            break block0;
                        }
                        case 31: {
                            if (this.getValidExpID(this.peekExp2()) == 10) {
                                this.popExp();
                                CsmCompletionExpression var = this.createTokenExp(1);
                                var.addParameter(top);
                                this.pushExp(var);
                                break block0;
                            }
                            this.errorState = true;
                            break block0;
                        }
                        case 39: {
                            top.setExpID(38);
                            top.addParameter(this.createTokenExp(1));
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case QUESTION: {
                    ++this.nrQuestions;
                    CsmCompletionExpression ternary = new CsmCompletionExpression(40);
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 18: 
                        case 25: 
                        case 27: 
                        case 32: 
                        case 33: 
                        case 46: {
                            this.popExp();
                            ternary.addParameter(top);
                            break;
                        }
                        default: {
                            this.errorState = true;
                        }
                    }
                    this.pushExp(ternary);
                    break;
                }
                case STAR: 
                case AMP: {
                    boolean pointer = false;
                    switch (topID) {
                        case -1: 
                        case 6: 
                        case 8: 
                        case 10: 
                        case 13: 
                        case 18: 
                        case 33: 
                        case 46: {
                            CsmCompletionExpression opExp = this.createTokenExp(33);
                            this.pushExp(opExp);
                            pointer = true;
                            break;
                        }
                        case 14: 
                        case 17: 
                        case 28: 
                        case 31: {
                            this.popExp();
                            CsmCompletionExpression exp = this.createTokenExp(31);
                            exp.addParameter(top);
                            this.pushExp(exp);
                            pointer = true;
                            break;
                        }
                        case 2: {
                            if ((top.getTokenCount() != 1 || !this.isEqOperator(top.getTokenID(0))) && top.getTokenID(0) != CppTokenId.COLON) break;
                            CsmCompletionExpression memPtrExp = this.createTokenExp(33);
                            this.pushExp(memPtrExp);
                            pointer = true;
                        }
                    }
                    if (pointer) break;
                }
                case EQ: 
                case EQEQ: 
                case GTEQ: 
                case GTGTEQ: 
                case AMPEQ: 
                case LTEQ: 
                case LTLTEQ: 
                case PLUSEQ: 
                case NOTEQ: 
                case MINUSEQ: 
                case STAREQ: 
                case SLASHEQ: 
                case BAREQ: 
                case CARETEQ: 
                case PERCENTEQ: 
                case AMPAMP: 
                case BARBAR: 
                case LTLT: 
                case SLASH: 
                case BAR: 
                case CARET: 
                case PERCENT: 
                case COLON: {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 25: 
                        case 27: 
                        case 32: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                        case 14: 
                        case 31: {
                            if (tokenID == CppTokenId.STAR || tokenID == CppTokenId.AMP) {
                                this.pushExp(this.createTokenExp(2));
                                break block0;
                            }
                            if (tokenID != CppTokenId.EQ) break;
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case LT: {
                    boolean genericType = false;
                    if (this.supportTemplates) {
                        switch (topID) {
                            case 1: 
                            case 4: 
                            case 25: 
                            case 27: 
                            case 32: {
                                this.popExp();
                                CsmCompletionExpression genExp = this.createTokenExp(18);
                                genExp.addParameter(top);
                                this.pushExp(genExp);
                                genericType = true;
                                break;
                            }
                        }
                    }
                    if (topID == 37) {
                        this.addTokenTo(top);
                        break;
                    }
                    if (this.errorState || genericType) break;
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 25: 
                        case 27: 
                        case 32: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case GT: {
                    boolean genericType = false;
                    if (this.supportTemplates) {
                        switch (topID) {
                            case 0: 
                            case 1: 
                            case 3: 
                            case 4: 
                            case 7: 
                            case 9: 
                            case 11: 
                            case 14: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 25: 
                            case 27: 
                            case 31: {
                                CsmCompletionExpression param;
                                CsmCompletionExpression expr;
                                int cnt = this.expStack.size();
                                CsmCompletionExpression gen = null;
                                for (int i = 0; i < cnt && (expr = this.peekExp(i + 1)).getExpID() != 8; ++i) {
                                    if (expr.getExpID() != 18) continue;
                                    gen = expr;
                                    break;
                                }
                                if (gen == null) break;
                                while (this.peekExp().getExpID() != 18) {
                                    gen.addParameter(this.popExp());
                                }
                                gen.setExpID(17);
                                top = gen;
                                genericType = true;
                                if (gen.getParameterCount() <= 0 || (param = gen.getParameter(0)).getParameterCount() <= 0) break;
                                switch (param.getExpID()) {
                                    case 32: {
                                        CsmCompletionExpression newMemPointer = this.createTokenExp(param.getExpID());
                                        CsmCompletionExpression newGen = this.createTokenExp(17);
                                        newGen.addParameter(param.getParameter(0));
                                        for (int i = 1; i < gen.getParameterCount(); ++i) {
                                            newGen.addParameter(gen.getParameter(i));
                                        }
                                        newMemPointer.addParameter(newGen);
                                        top = newMemPointer;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    boolean conversion = false;
                    if (!this.errorState && !genericType) {
                        CsmCompletionExpression top2 = this.peekExp2();
                        switch (this.getValidExpID(top2)) {
                            case 36: {
                                CsmCompletionExpression top3 = this.peekExp(3);
                                if (this.getValidExpID(top3) != 37 || !CsmCompletionExpression.isValidType(top)) break;
                                this.popExp();
                                this.popExp();
                                top3.addParameter(top);
                                top3.addParameter(top2);
                                this.addTokenTo(top3);
                                conversion = true;
                                break;
                            }
                            case 37: {
                                if (!CsmCompletionExpression.isValidType(top)) break;
                                this.popExp();
                                top2.addParameter(top);
                                this.addTokenTo(top2);
                                conversion = true;
                            }
                        }
                    }
                    if (this.errorState || genericType || conversion) break;
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 25: 
                        case 27: 
                        case 32: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case GTGT: {
                    boolean genericType = false;
                    if (this.supportTemplates) {
                        switch (topID) {
                            case 0: 
                            case 1: 
                            case 4: 
                            case 7: 
                            case 9: 
                            case 14: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 25: 
                            case 27: {
                                int cnt = this.expStack.size();
                                CsmCompletionExpression genTop = null;
                                CsmCompletionExpression genBottom = null;
                                for (int i = 0; i < cnt; ++i) {
                                    CsmCompletionExpression expr2;
                                    CsmCompletionExpression expr = this.peekExp(i + 1);
                                    if (expr.getExpID() != 18 || this.getValidExpID(expr2 = this.peekExp(i + 2)) != 18) continue;
                                    genTop = expr;
                                    genBottom = expr2;
                                    break;
                                }
                                if (genTop == null || genBottom == null) break;
                                while (this.peekExp().getExpID() != 18) {
                                    genTop.addParameter(this.popExp());
                                }
                                genTop.setExpID(17);
                                this.popExp();
                                genBottom.addParameter(genTop);
                                genBottom.setExpID(17);
                                top = genBottom;
                                genericType = true;
                                break;
                            }
                        }
                    }
                    if (this.errorState || genericType) break;
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 25: 
                        case 27: 
                        case 32: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case PLUSPLUS: 
                case MINUSMINUS: {
                    switch (topID) {
                        case -1: 
                        case 2: 
                        case 3: 
                        case 6: 
                        case 8: 
                        case 10: 
                        case 18: 
                        case 32: 
                        case 33: 
                        case 46: {
                            CsmCompletionExpression opExp = this.createTokenExp(3);
                            this.pushExp(opExp);
                            break block0;
                        }
                        case 1: {
                            CsmCompletionExpression opExp = this.createTokenExp(3);
                            this.popExp();
                            opExp.addParameter(top);
                            this.pushExp(opExp);
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case PLUS: 
                case MINUS: {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 25: 
                        case 27: 
                        case 32: 
                        case 40: {
                            CsmCompletionExpression opExp = this.createTokenExp(2);
                            this.pushExp(opExp);
                            break block0;
                        }
                        case -1: 
                        case 2: 
                        case 6: 
                        case 8: 
                        case 10: 
                        case 13: 
                        case 18: 
                        case 33: 
                        case 46: {
                            CsmCompletionExpression opExp = this.createTokenExp(3);
                            this.pushExp(opExp);
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case TILDE: 
                case NOT: {
                    switch (topID) {
                        case -1: 
                        case 2: 
                        case 3: 
                        case 6: 
                        case 8: 
                        case 10: 
                        case 18: 
                        case 32: 
                        case 33: 
                        case 46: {
                            CsmCompletionExpression opExp = this.createTokenExp(3);
                            this.pushExp(opExp);
                            break block0;
                        }
                        case 5: 
                        case 26: 
                        case 28: {
                            if (tokenID != CppTokenId.TILDE) break;
                            CsmCompletionExpression opExp = this.createTokenExp(3);
                            this.pushExp(opExp);
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case DOT: 
                case DOTMBR: 
                case ARROW: 
                case ARROWMBR: 
                case SCOPE: {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 17: 
                        case 32: {
                            this.popExp();
                            int openExpID = this.tokenID2OpenExpID(tokenID);
                            CsmCompletionExpression opExp = this.createTokenExp(openExpID);
                            if (topID == 13 && tokenID != CppTokenId.SCOPE) {
                                top.setExpID(9);
                            }
                            opExp.addParameter(top);
                            this.pushExp(opExp);
                            break block0;
                        }
                        case 4: {
                            this.addTokenTo(top);
                            top.setExpID(this.tokenID2OpenExpID(tokenID));
                            break block0;
                        }
                        case 25: {
                            this.addTokenTo(top);
                            top.setExpID(this.tokenID2OpenExpID(tokenID));
                            break block0;
                        }
                        case 27: {
                            this.addTokenTo(top);
                            top.setExpID(this.tokenID2OpenExpID(tokenID));
                            break block0;
                        }
                        case -1: 
                        case 2: 
                        case 3: 
                        case 8: 
                        case 10: 
                        case 18: 
                        case 29: 
                        case 46: {
                            CsmCompletionExpression emptyVar = CsmCompletionExpression.createEmptyVariable(this.curTokenPosition);
                            int openExpID = this.tokenID2OpenExpID(tokenID);
                            CsmCompletionExpression opExp = this.createTokenExp(openExpID);
                            opExp.addParameter(emptyVar);
                            this.pushExp(opExp);
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case COMMA: {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 16: 
                        case 17: 
                        case 19: 
                        case 25: 
                        case 27: 
                        case 31: 
                        case 32: {
                            CsmCompletionExpression top2 = this.peekExp2();
                            switch (this.getValidExpID(top2)) {
                                case 10: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    top = top2;
                                    break block0;
                                }
                                case 21: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    this.addTokenTo(top2);
                                    top = top2;
                                    break block0;
                                }
                                case 8: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    top = top2;
                                    break block0;
                                }
                            }
                            int cnt = this.expStack.size();
                            CsmCompletionExpression gen = null;
                            for (int i = 0; i < cnt; ++i) {
                                CsmCompletionExpression expr = this.peekExp(i + 1);
                                if (expr.getExpID() != 18) continue;
                                gen = expr;
                                break;
                            }
                            if (gen != null) {
                                while (this.peekExp().getExpID() != 18) {
                                    gen.addParameter(this.popExp());
                                }
                                top = gen;
                                break block0;
                            }
                            this.errorState = true;
                            break block0;
                        }
                        case 10: {
                            this.addTokenTo(top);
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case SEMICOLON: {
                    this.errorState = true;
                    break;
                }
                case LPAREN: {
                    switch (topID) {
                        case 1: 
                        case 17: {
                            this.popExp();
                            CsmCompletionExpression top2 = this.peekExp();
                            int top2ID = this.getValidExpID(top2);
                            switch (top2ID) {
                                case 20: {
                                    top2.setExpID(21);
                                    top2.addParameter(top);
                                    break block0;
                                }
                                case 5: 
                                case 26: 
                                case 28: {
                                    CsmCompletionExpression top3 = this.peekExp2();
                                    if (this.getValidExpID(top3) != 20) break;
                                    top2.setExpID(this.openExpID2ExpID(top2ID));
                                    top2.addParameter(top);
                                    top3.setExpID(21);
                                    top3.addParameter(top2);
                                    this.popExp();
                                    break block0;
                                }
                            }
                            CsmCompletionExpression mtdOpExp = this.createTokenExp(10);
                            mtdOpExp.addParameter(top);
                            this.pushExp(mtdOpExp);
                            break block0;
                        }
                        case 7: {
                            this.popExp();
                            CsmCompletionExpression mtdExp = this.createTokenExp(11);
                            mtdExp.addParameter(top);
                            this.pushExp(mtdExp);
                            break block0;
                        }
                        case -1: 
                        case 2: 
                        case 3: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 13: 
                        case 14: 
                        case 18: 
                        case 33: 
                        case 37: 
                        case 46: {
                            this.pushExp(this.createTokenExp(8));
                            break block0;
                        }
                        case 11: {
                            this.popExp();
                            CsmCompletionExpression mtdOpExp = this.createTokenExp(10);
                            mtdOpExp.addParameter(top);
                            this.pushExp(mtdOpExp);
                            break block0;
                        }
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: {
                            this.popExp();
                            this.pushExp(this.createTokenExp(46));
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case RPAREN: {
                    CsmCompletionExpression top2;
                    boolean mtd = false;
                    block134 : switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 16: 
                        case 17: 
                        case 25: 
                        case 27: 
                        case 31: 
                        case 32: 
                        case 40: {
                            top2 = this.peekExp2();
                            block139 : switch (this.getValidExpID(top2)) {
                                case 36: {
                                    CsmCompletionExpression top3 = this.peekExp(3);
                                    if (this.getValidExpID(top3) == 8 && CsmCompletionExpression.isValidType(top)) {
                                        this.popExp();
                                        this.popExp();
                                        top3.addParameter(top);
                                        top3.addParameter(top2);
                                        top3.setExpID(13);
                                        this.addTokenTo(top3);
                                        break;
                                    }
                                    if (this.getValidExpID(top3) != 10) break block134;
                                    this.popExp();
                                    this.popExp();
                                    top3.addParameter(top);
                                    top = top3;
                                    mtd = true;
                                    break;
                                }
                                case 8: {
                                    CsmCompletionExpression top3 = this.peekExp(3);
                                    if (this.getValidExpID(top3) == 37) {
                                        this.popExp();
                                        this.popExp();
                                        this.popExp();
                                        top3.addParameter(top);
                                        top3.setExpID(13);
                                        top2.addParameter(top3);
                                        top2.setExpID(9);
                                        top = top2;
                                        this.pushExp(top);
                                        break;
                                    }
                                    this.popExp();
                                    top2.addParameter(top);
                                    if (top2.getParameterCount() == 1 && CsmCompletionExpression.isValidType(top) && this.getValidExpID(top3) != 9 && this.getValidExpID(top3) != 14) {
                                        top2.setExpID(13);
                                    } else {
                                        top2.setExpID(9);
                                    }
                                    this.addTokenTo(top2);
                                    break;
                                }
                                case 46: {
                                    this.popExp();
                                    this.popExp();
                                    break;
                                }
                                case 18: {
                                    this.popExp();
                                    top2.setExpID(2);
                                    top2.addParameter(top);
                                    top = top2;
                                    top2 = this.peekExp2();
                                    if (this.getValidExpID(top2) != 10) break;
                                }
                                case 10: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    top = top2;
                                    mtd = true;
                                    break;
                                }
                                case 13: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    top = top2;
                                    top2 = this.peekExp2();
                                    switch (this.getValidExpID(top2)) {
                                        case 8: {
                                            this.popExp();
                                            top2.addParameter(top);
                                            top2.setExpID(9);
                                            top = top2;
                                            break block139;
                                        }
                                        case 10: {
                                            this.popExp();
                                            top2.addParameter(top);
                                            top = top2;
                                            mtd = true;
                                        }
                                    }
                                    break;
                                }
                                case 33: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    top2.setExpID(32);
                                    top = top2;
                                    top2 = this.peekExp2();
                                    switch (this.getValidExpID(top2)) {
                                        case 8: {
                                            this.popExp();
                                            top2.addParameter(top);
                                            top2.setExpID(9);
                                            top = top2;
                                            break block139;
                                        }
                                        case 10: {
                                            this.popExp();
                                            top2.addParameter(top);
                                            top = top2;
                                            mtd = true;
                                        }
                                    }
                                    break;
                                }
                                default: {
                                    this.errorState = true;
                                    break;
                                }
                            }
                            break;
                        }
                        case 10: {
                            mtd = true;
                            break;
                        }
                        case 8: {
                            this.popExp();
                            break;
                        }
                        default: {
                            this.errorState = true;
                        }
                    }
                    if (!mtd) break;
                    this.addTokenTo(top);
                    top.setExpID(11);
                    top2 = this.peekExp2();
                    int top2ID = this.getValidExpID(top2);
                    switch (top2ID) {
                        case 5: 
                        case 26: 
                        case 28: {
                            CsmCompletionExpression top3 = this.peekExp(3);
                            if (this.getValidExpID(top3) != 15) break;
                            this.popExp();
                            top2.addParameter(top);
                            top2.setExpID(this.openExpID2ExpID(top2ID));
                            this.popExp();
                            top3.setExpID(12);
                            top3.addParameter(top2);
                            break;
                        }
                        case 15: {
                            top2.setExpID(12);
                            top2.addParameter(top);
                            this.popExp();
                        }
                    }
                    break;
                }
                case LBRACKET: {
                    switch (topID) {
                        case 1: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 14: 
                        case 17: 
                        case 25: 
                        case 27: {
                            this.popExp();
                            CsmCompletionExpression arrExp = this.createTokenExp(6);
                            arrExp.addParameter(top);
                            this.pushExp(arrExp);
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case ELLIPSIS: {
                    switch (topID) {
                        case 1: 
                        case 4: 
                        case 7: 
                        case 8: 
                        case 11: 
                        case 14: 
                        case 17: {
                            CsmCompletionExpression exp = this.createTokenExp(2);
                            this.addTokenTo(exp);
                            top.addParameter(exp);
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case RBRACKET: {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 13: 
                        case 16: 
                        case 25: 
                        case 27: 
                        case 32: {
                            CsmCompletionExpression top2 = this.peekExp2();
                            switch (this.getValidExpID(top2)) {
                                case 6: {
                                    CsmCompletionExpression top3 = this.peekExp(3);
                                    this.popExp();
                                    if (this.getValidExpID(top3) == 15) {
                                        this.popExp();
                                        top3.setExpID(7);
                                        top3.addParameter(top2.getParameter(0));
                                        top3.addToken(top2.getTokenID(0), top2.getTokenOffset(0), top2.getTokenText(0));
                                        this.addTokenTo(top2);
                                        break block0;
                                    }
                                    top2.setExpID(7);
                                    top2.addParameter(top);
                                    this.addTokenTo(top2);
                                    break block0;
                                }
                            }
                            this.errorState = true;
                            break block0;
                        }
                        case 6: {
                            top.setExpID(7);
                            this.addTokenTo(top);
                            break block0;
                        }
                    }
                    this.errorState = true;
                    break;
                }
                case LBRACE: {
                    CsmCompletionExpression top2;
                    if (topID == 7 && this.getValidExpID(top2 = this.peekExp2()) == 15) {
                        this.popExp();
                        top2.setExpID(7);
                        top2.addParameter(top.getParameter(0));
                        top2.addToken(top.getTokenID(0), top.getTokenOffset(0), top.getTokenText(0));
                        top2.addToken(top.getTokenID(1), top.getTokenOffset(1), top.getTokenText(1));
                        break;
                    }
                    this.errorState = true;
                    break;
                }
                case RBRACE: {
                    this.errorState = true;
                    break;
                }
                case NEW_LINE: {
                    if (topID == 38) {
                        this.popExp();
                    }
                }
                case WHITESPACE: 
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: {
                    break;
                }
                case CHAR_LITERAL: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("char");
                    break;
                }
                case RAW_STRING_LITERAL: 
                case STRING_LITERAL: {
                    constExp = this.createTokenExp(0);
                    constExp.setType(CsmCompletion.CONST_STRING_TYPE.format(true));
                    break;
                }
                case INT_LITERAL: 
                case UNSIGNED_LITERAL: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("int");
                    break;
                }
                case LONG_LITERAL: 
                case LONG_LONG_LITERAL: 
                case UNSIGNED_LONG_LITERAL: 
                case UNSIGNED_LONG_LONG_LITERAL: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("long");
                    break;
                }
                case FLOAT_LITERAL: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("float");
                    break;
                }
                case DOUBLE_LITERAL: {
                    constExp = this.createTokenExp(0);
                    constExp.setType("double");
                    break;
                }
                case CONST: 
                case TEMPLATE: 
                case TYPENAME: {
                    break;
                }
                default: {
                    this.errorState = true;
                }
            }
        }
        if (constExp != null) {
            switch (topID) {
                case 5: 
                case 26: 
                case 28: 
                case 33: {
                    this.errorState = true;
                    break;
                }
                case -1: 
                case 2: 
                case 3: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 21: 
                case 32: 
                case 40: 
                case 46: {
                    this.pushExp(constExp);
                    this.errorState = false;
                    break;
                }
                case 18: {
                    this.pushExp(constExp);
                    this.errorState = false;
                    break;
                }
                case 0: {
                    if (CsmCompletion.CONST_STRING_TYPE.format(true).equals(top.getType()) && CsmCompletion.CONST_STRING_TYPE.format(true).equals(constExp.getType())) {
                        this.errorState = false;
                        break;
                    }
                    this.errorState = true;
                    break;
                }
                default: {
                    this.errorState = true;
                }
            }
        }
        if (kwdType != null) {
            switch (topID) {
                case -1: 
                case 8: 
                case 15: {
                    CsmCompletionExpression kwdExp = this.createTokenExp(14);
                    kwdExp.setType(kwdType);
                    this.pushExp(kwdExp);
                    this.errorState = false;
                    break;
                }
                case 10: 
                case 18: {
                    int expType = 14;
                    switch (tokenID) {
                        case CONST: 
                        case VOLATILE: {
                            expType = 29;
                        }
                    }
                    CsmCompletionExpression kwdExp = this.createTokenExp(expType);
                    kwdExp.setType(kwdType);
                    this.pushExp(kwdExp);
                    this.errorState = false;
                    break;
                }
                case 29: {
                    int expType = 14;
                    switch (tokenID) {
                        case CONST: 
                        case VOLATILE: {
                            expType = 29;
                        }
                    }
                    this.setExprToTYPE(top);
                    top.setExpID(expType);
                }
                case 14: {
                    CsmCompletionExpression kwdExp = top;
                    this.addTokenTo(kwdExp);
                    kwdExp.setType(kwdExp.getType() + " " + kwdType);
                    this.errorState = false;
                    break;
                }
                case 31: {
                    CsmCompletionExpression kwdExp = this.createTokenExp(14);
                    kwdExp.setType(kwdType);
                    top.addParameter(kwdExp);
                    this.errorState = false;
                    break;
                }
                default: {
                    if (tokenID == CppTokenId.CONST) break;
                    this.errorState = true;
                }
            }
        }
        if (this.errorState) {
            this.clearStack();
            if (tokenID == CppTokenId.IDENTIFIER) {
                this.pushExp(this.createTokenExp(1));
                this.errorState = false;
            } else if (!macro) {
                this.lastSeparatorOffset = tokenOffset;
            }
        }
    }

    public int getLastSeparatorOffset() {
        return this.lastSeparatorOffset;
    }

    public void start(int startOffset, int firstTokenOffset, int lastOffset) {
        this.inPP = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void end(int offset, int lastTokenOffset) {
        boolean oldSupportTemplates = this.supportTemplates;
        Boolean oldInPP = this.inPP;
        int lookaheadSize = this.lookaheadTokens.size();
        OffsetableToken disableTillToken = this.isSupportTemplates();
        this.supportTemplates = disableTillToken == null;
        for (int i = 0; i < lookaheadSize; ++i) {
            OffsetableToken currentToken = this.lookaheadTokens.remove(0);
            this.inPP = currentToken.inPP;
            this.tokenImpl(currentToken.token, currentToken.offset, currentToken.macro);
            if (currentToken != disableTillToken) continue;
            disableTillToken = this.isSupportTemplates();
            this.supportTemplates = disableTillToken == null;
        }
        this.lookaheadTokens.clear();
        this.supportTemplates = oldSupportTemplates;
        this.inPP = oldInPP;
        if (this.lastValidTokenID != null) {
            switch (this.lastValidTokenID) {
                case COLON: {
                    if (this.nrQuestions <= 0) break;
                }
                case GT: 
                case LBRACE: 
                case RBRACE: 
                case STAR: 
                case AMP: 
                case WHITESPACE: 
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: 
                case QUESTION: 
                case SEMICOLON: {
                    if (this.getValidExpID(this.peekExp()) == 17) break;
                }
                case EQ: 
                case EQEQ: 
                case GTEQ: 
                case GTGTEQ: 
                case AMPEQ: 
                case LTEQ: 
                case LTLTEQ: 
                case PLUSEQ: 
                case NOTEQ: 
                case MINUSEQ: 
                case STAREQ: 
                case SLASHEQ: 
                case BAREQ: 
                case CARETEQ: 
                case PERCENTEQ: 
                case LT: 
                case PLUSPLUS: 
                case MINUSMINUS: 
                case AMPAMP: 
                case BARBAR: 
                case LTLT: 
                case SLASH: 
                case BAR: 
                case CARET: 
                case PERCENT: 
                case GTGT: 
                case PLUS: 
                case MINUS: 
                case NOT: {
                    this.pushExp(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                    this.errorState = false;
                    break;
                }
                default: {
                    if (this.getValidExpID(this.peekExp()) != 17) break;
                    this.pushExp(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                    this.errorState = false;
                }
            }
        }
        boolean reScan = true;
        block40: while (reScan) {
            reScan = false;
            CsmCompletionExpression top = this.peekExp();
            CsmCompletionExpression top2 = this.peekExp2();
            int top2ID = this.getValidExpID(top2);
            if (top != null) {
                block5 : switch (this.getValidExpID(top)) {
                    case 1: {
                        switch (top2ID) {
                            case 5: 
                            case 26: 
                            case 28: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(this.openExpID2ExpID(top2ID));
                                reScan = true;
                                break block5;
                            }
                            case 15: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(12);
                                reScan = true;
                                break block5;
                            }
                            case 34: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(35);
                                return;
                            }
                            case 20: 
                            case 21: 
                            case 24: {
                                this.popExp();
                                top2.addParameter(top);
                                return;
                            }
                            case 18: {
                                return;
                            }
                        }
                        break;
                    }
                    case 10: 
                    case 11: {
                        switch (top2ID) {
                            case 5: 
                            case 26: 
                            case 28: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(this.openExpID2ExpID(top2ID));
                                reScan = true;
                                break block5;
                            }
                            case 15: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(12);
                                reScan = true;
                                continue block40;
                            }
                        }
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: {
                        switch (top2ID) {
                            case 15: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(12);
                                reScan = true;
                                break;
                            }
                            case 20: 
                            case 21: {
                                this.popExp();
                                top2.addParameter(top);
                                return;
                            }
                            case 18: {
                                return;
                            }
                            case 2: {
                                CsmCompletionExpression top4 = this.peekExp(4);
                                if (this.getValidExpID(top4) == 21) {
                                    top2.addParameter(this.peekExp(3));
                                    top2.addParameter(top);
                                    top4.addParameter(top2);
                                    this.popExp();
                                    this.popExp();
                                    this.popExp();
                                    return;
                                }
                                continue block40;
                            }
                            case 33: {
                                this.popExp();
                                top2.addParameter(top);
                                return;
                            }
                        }
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.pushExp(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                        break;
                    }
                    case 39: {
                        top.addParameter(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                        break;
                    }
                    case 18: {
                        if (top.getParameterCount() > 1) break;
                    }
                    case 24: {
                        top.addParameter(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                        break;
                    }
                    case 2: {
                        if (top2ID != 1) break;
                        CsmCompletionExpression top3 = this.peekExp(3);
                        if (this.getValidExpID(top3) != 21) continue block40;
                        top.addParameter(top2);
                        top.addParameter(CsmCompletionExpression.createEmptyVariable(offset));
                        top3.addParameter(top);
                        this.popExp();
                        this.popExp();
                        break;
                    }
                    case 33: {
                        this.popExp();
                        this.pushExp(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                        break;
                    }
                    case 3: {
                        switch (top2ID) {
                            case -1: {
                                this.popExp();
                                this.pushExp(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                                break;
                            }
                            case 5: 
                            case 26: 
                            case 28: {
                                if (top.getParameterCount() != 0 || top.getTokenCount() != 1 || top.getTokenID(0) != CppTokenId.TILDE) break;
                                top.setExpID(1);
                                reScan = true;
                            }
                        }
                        continue block40;
                    }
                }
                continue;
            }
            this.pushExp(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
        }
        return;
    }

    public String toString() {
        int cnt = this.expStack.size();
        StringBuilder sb = new StringBuilder();
        sb.append("Stack size is ").append(cnt).append("\n");
        if (cnt > 0) {
            sb.append("Stack expressions:\n");
            for (int i = 0; i < cnt; ++i) {
                CsmCompletionExpression e = this.expStack.get(i);
                sb.append("Stack[");
                sb.append(i);
                sb.append("]: ");
                sb.append(e.toString(0));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public boolean isStopped() {
        return false;
    }

    private class OffsetableToken {
        Token<TokenId> token;
        int offset;
        boolean macro;
        Boolean inPP;

        public OffsetableToken(Token<TokenId> token, int offset, boolean macro, Boolean inPP) {
            this.token = token;
            this.offset = offset;
            this.macro = macro;
            this.inPP = inPP;
        }

        public String toString() {
            return this.token.id().toString();
        }
    }
}

