/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JToolTip;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionUtils;
import org.netbeans.modules.cnd.completion.cplusplus.NbCsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CompletionSupport;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.completion.spi.dynhelp.CompletionDocumentationProvider;
import org.netbeans.modules.cnd.modelutil.CsmPaintComponent;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.MethodParamsTipPaintComponent;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CsmCompletionProvider
implements CompletionProvider {
    private static final boolean TRACE = false;
    private static final CompletionItem lastItem = new LastResultItem();

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        CompletionSupport sup = CompletionSupport.get(component);
        if (sup == null) {
            return 0;
        }
        int dot = component.getCaret().getDot();
        if (CsmCompletionQuery.checkCondition(component.getDocument(), dot, false)) {
            try {
                if (CompletionSupport.needShowCompletionOnText(component, typedText)) {
                    return 1;
                }
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        CompletionSupport sup = CompletionSupport.get(component);
        if (sup == null) {
            return null;
        }
        int dot = component.getCaret().getDot();
        CsmResultItem.setEnableInstantSubstitution(false);
        if (CsmCompletionQuery.checkCondition(component.getDocument(), dot, false, queryType)) {
            if ((queryType & 1) == 1) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new Query(dot, queryType), component);
            }
            if (queryType == 2) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new DocumentationQuery(), component);
            }
            if (queryType == 4) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new ToolTipQuery(), component);
            }
        }
        return null;
    }

    public static CsmCompletionQuery getCompletionQuery() {
        return new NbCsmCompletionQuery(null, CsmCompletionQuery.QueryScope.GLOBAL_QUERY, null);
    }

    public static CsmCompletionQuery getCompletionQuery(CsmFile csmFile, CsmCompletionQuery.QueryScope queryScope, FileReferencesContext fileReferencesContext) {
        return new NbCsmCompletionQuery(csmFile, queryScope, fileReferencesContext);
    }

    private static final class LastResultItem
    extends CsmResultItem {
        private final String str = "" + Query.access$200() + " " + NbBundle.getBundle(CsmCompletionProvider.class).getString("last-item-text");
        private static final CsmPaintComponent.StringPaintComponent stringComponent = new CsmPaintComponent.StringPaintComponent();

        public LastResultItem() {
            super(null, Integer.MAX_VALUE);
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            stringComponent.setString(this.str);
            return stringComponent;
        }

        @Override
        public void defaultAction(JTextComponent component) {
        }

        @Override
        public String getItemText() {
            return this.str;
        }
    }

    private static final class DocumentationQuery
    extends AsyncCompletionQuery {
        private DocumentationQuery() {
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            CompletionDocumentation documentation;
            CompletionDocumentationProvider docProvider;
            CsmObject csmObject;
            CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
            if (csmFile != null && (csmObject = ReferencesSupport.findDeclaration(csmFile, doc, null, caretOffset)) != null && (docProvider = (CompletionDocumentationProvider)Lookup.getDefault().lookup(CompletionDocumentationProvider.class)) != null && (documentation = docProvider.createDocumentation(csmObject, csmFile)) != null) {
                resultSet.setDocumentation(documentation);
            }
            resultSet.finish();
        }
    }

    static class ToolTipQuery
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private int queryCaretOffset;
        private int queryAnchorOffset;
        private JToolTip queryToolTip;
        private Position queryMethodParamsStartPos = null;
        private boolean otherMethodContext;

        ToolTipQuery() {
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            Position oldPos = this.queryMethodParamsStartPos;
            this.queryMethodParamsStartPos = null;
            NbCsmCompletionQuery query = (NbCsmCompletionQuery)CsmCompletionProvider.getCompletionQuery();
            BaseDocument bdoc = (BaseDocument)doc;
            CsmCompletionQuery.CsmCompletionResult res = query.query(this.component, caretOffset, true, false, true, true);
            if (res != null) {
                this.queryCaretOffset = caretOffset;
                ArrayList<List<String>> list = new ArrayList<List<String>>();
                int idx = -1;
                boolean checked = false;
                for (CompletionItem completionItem : res.getItems()) {
                    List<String> parms;
                    if (!(completionItem instanceof CsmResultItem.ConstructorResultItem)) continue;
                    CsmResultItem.ConstructorResultItem item = (CsmResultItem.ConstructorResultItem)completionItem;
                    if (!checked) {
                        CsmCompletionExpression exp = item.getExpression();
                        int idxLast = exp.getTokenCount() - 1;
                        if (idxLast >= 0) {
                            if (exp.getExpID() == 11 && exp.getTokenID(idxLast) == CppTokenId.RPAREN) {
                                if (exp.getTokenOffset(idxLast) + exp.getTokenLength(idxLast) <= caretOffset) {
                                    resultSet.finish();
                                    return;
                                }
                            } else if (exp.getExpID() == 1 && exp.getTokenOffset(0) + exp.getTokenLength(0) >= caretOffset) {
                                resultSet.finish();
                                return;
                            }
                            try {
                                this.queryMethodParamsStartPos = bdoc.createPosition(exp.getTokenOffset(0));
                            }
                            catch (BadLocationException ble) {
                                // empty catch block
                            }
                        }
                        checked = true;
                    }
                    if ((parms = item.createParamsList()).size() > 0) {
                        idx = item.getCurrentParamIndex();
                    } else {
                        parms.add(NbBundle.getMessage(CsmCompletionProvider.class, (String)"CC-no-parameters"));
                    }
                    list.add(parms);
                }
                this.queryAnchorOffset = res.getSubstituteOffset();
                resultSet.setAnchorOffset(this.queryAnchorOffset);
                this.queryToolTip = new MethodParamsTipPaintComponent(list, idx);
                resultSet.setToolTip(this.queryToolTip);
            }
            resultSet.finish();
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected boolean canFilter(JTextComponent component) {
            String text = null;
            int caretOffset = component.getCaretPosition();
            Document doc = component.getDocument();
            try {
                text = caretOffset - this.queryCaretOffset > 0 ? doc.getText(this.queryCaretOffset, caretOffset - this.queryCaretOffset) : (caretOffset - this.queryCaretOffset < 0 ? doc.getText(caretOffset, this.queryCaretOffset - caretOffset) : "");
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            if (text == null) {
                return false;
            }
            boolean filter = true;
            int balance = 0;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    case ',': {
                        filter = false;
                        break;
                    }
                    case '(': {
                        ++balance;
                        filter = false;
                        break;
                    }
                    case ')': {
                        --balance;
                        filter = false;
                    }
                }
                if (balance >= 0) continue;
                this.otherMethodContext = true;
            }
            if (this.otherMethodContext && balance < 0) {
                this.otherMethodContext = false;
            }
            if (this.queryMethodParamsStartPos == null || caretOffset <= this.queryMethodParamsStartPos.getOffset()) {
                filter = false;
            }
            return this.otherMethodContext || filter;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (!this.otherMethodContext) {
                resultSet.setAnchorOffset(this.queryAnchorOffset);
                resultSet.setToolTip(this.queryToolTip);
            }
            resultSet.finish();
        }
    }

    static final class Query
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private CsmCompletionQuery.CsmCompletionResult queryResult;
        private int creationCaretOffset;
        private int queryAnchorOffset;
        private String filterPrefix;
        private boolean caseSensitive = false;
        private CsmCompletionQuery.QueryScope queryScope;
        private static final int MAX_ITEMS_TO_DISPLAY;

        Query(int caretOffset, int queryType) {
            this.creationCaretOffset = caretOffset;
            this.queryAnchorOffset = -1;
            this.queryScope = (queryType & 9) != 9 ? CsmCompletionQuery.QueryScope.SMART_QUERY : CsmCompletionQuery.QueryScope.GLOBAL_QUERY;
        }

        private String getTestState() {
            StringBuilder builder = new StringBuilder();
            builder.append(" creationCaretOffset = ").append(this.creationCaretOffset);
            StringBuilder append = builder.append(" queryAnchorOffset = ").append(this.queryAnchorOffset);
            builder.append(" queryScope = ").append((Object)this.queryScope);
            builder.append(" filterPrefix = ").append(this.filterPrefix);
            if (this.queryResult == null) {
                builder.append(" no queryResult");
            } else if (this.queryResult.isSimpleVariableExpression()) {
                builder.append(" queryResult is simple");
            } else {
                builder.append(" queryResult is not simple");
            }
            return builder.toString();
        }

        protected void preQueryUpdate(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            Document doc = component.getDocument();
            String mimeType = CsmCompletionUtils.getMimeType(component);
            boolean bl = this.caseSensitive = mimeType != null ? CsmCompletionUtils.isCaseSensitive(mimeType) : false;
            if (this.creationCaretOffset > 0 && caretOffset >= this.creationCaretOffset) {
                try {
                    if (this.isCppIdentifierPart(doc.getText(this.creationCaretOffset, caretOffset - this.creationCaretOffset))) {
                        return;
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            Completion.get().hideCompletion();
        }

        private void addItems(CompletionResultSet resultSet, Collection<? extends CompletionItem> toAdd) {
            boolean limit = false;
            ArrayList<CompletionItem> items = new ArrayList<CompletionItem>(toAdd.size());
            HashSet<String> handled = new HashSet<String>(toAdd.size());
            for (CompletionItem completionItem : toAdd) {
                if (completionItem instanceof CsmResultItem) {
                    String stringPresentation = ((CsmResultItem)completionItem).getStringPresentation();
                    if (!handled.add(stringPresentation)) continue;
                    items.add(completionItem);
                    continue;
                }
                items.add(completionItem);
            }
            if (items.size() > MAX_ITEMS_TO_DISPLAY && this.queryResult.isSimpleVariableExpression()) {
                limit = true;
            }
            resultSet.setHasAdditionalItems(this.queryScope == CsmCompletionQuery.QueryScope.SMART_QUERY);
            if (!limit) {
                resultSet.estimateItems(items.size(), -1);
                resultSet.addAllItems(items);
            } else {
                resultSet.estimateItems(MAX_ITEMS_TO_DISPLAY + 1, -1);
                int count = 0;
                for (CompletionItem item : items) {
                    resultSet.addItem(item);
                    if (++count <= MAX_ITEMS_TO_DISPLAY) continue;
                    break;
                }
                resultSet.addItem(lastItem);
            }
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            boolean hide;
            boolean bl = hide = caretOffset <= this.queryAnchorOffset && this.filterPrefix == null;
            if (!hide) {
                this.creationCaretOffset = caretOffset;
                NbCsmCompletionQuery query = (NbCsmCompletionQuery)CsmCompletionProvider.getCompletionQuery(null, this.queryScope, null);
                CsmCompletionQuery.CsmCompletionResult res = query.query(this.component, caretOffset, true);
                if (res == null || res.getItems().isEmpty() && this.queryScope == CsmCompletionQuery.QueryScope.SMART_QUERY) {
                    this.queryScope = CsmCompletionQuery.QueryScope.GLOBAL_QUERY;
                    if (res == null || res.isSimpleVariableExpression()) {
                        query = (NbCsmCompletionQuery)CsmCompletionProvider.getCompletionQuery(null, this.queryScope, null);
                        res = query.query(this.component, caretOffset, true);
                    }
                }
                if (res != null) {
                    if (this.queryScope == CsmCompletionQuery.QueryScope.SMART_QUERY && !res.isSimpleVariableExpression()) {
                        this.queryScope = CsmCompletionQuery.QueryScope.GLOBAL_QUERY;
                    }
                    this.queryAnchorOffset = res.getSubstituteOffset();
                    List<? extends CompletionItem> items = res.getItems();
                    resultSet.setAnchorOffset(this.queryAnchorOffset);
                    this.queryResult = res;
                    this.addItems(resultSet, items);
                }
            } else {
                Completion.get().hideCompletion();
            }
            resultSet.finish();
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected boolean canFilter(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            Document doc = component.getDocument();
            this.filterPrefix = null;
            if (this.queryAnchorOffset > -1 && caretOffset >= this.creationCaretOffset) {
                try {
                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                    if (this.queryResult == null || !this.isCppIdentifierPart(this.filterPrefix)) {
                        this.filterPrefix = null;
                    } else {
                        Collection<CompletionItem> items = this.getFilteredData(this.queryResult.getItems(), this.filterPrefix);
                        if (items.isEmpty()) {
                            this.filterPrefix = null;
                        }
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (this.filterPrefix != null && this.queryResult != null) {
                resultSet.setAnchorOffset(this.queryAnchorOffset);
                Collection<CompletionItem> items = this.getFilteredData(this.queryResult.getItems(), this.filterPrefix);
                this.addItems(resultSet, items);
            }
            resultSet.finish();
        }

        private boolean isCppIdentifierPart(String text) {
            for (int i = 0; i < text.length(); ++i) {
                if (CndLexerUtilities.isCppIdentifierPart((char)text.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection<CompletionItem> getFilteredData(Collection<? extends CompletionItem> data, String prefix) {
            ArrayList<CompletionItem> ret = new ArrayList<CompletionItem>(1024);
            for (CompletionItem completionItem : data) {
                if (!this.matchPrefix(completionItem.getInsertPrefix(), prefix, this.caseSensitive)) continue;
                ret.add(completionItem);
            }
            return ret;
        }

        private boolean matchPrefix(CharSequence text, String prefix, boolean caseSensitive) {
            if (CharSequenceUtils.startsWith((CharSequence)text, (CharSequence)prefix)) {
                return true;
            }
            if (!caseSensitive) {
                return CharSequenceUtils.startsWithIgnoreCase((CharSequence)text, (CharSequence)prefix);
            }
            return false;
        }

        private String getFilteredTitle(String title, String prefix) {
            String ret;
            int lastIdx = title.lastIndexOf(46);
            String string = ret = lastIdx == -1 ? prefix : title.substring(0, lastIdx + 1) + prefix;
            if (title.endsWith("*")) {
                ret = ret + "*";
            }
            return ret;
        }

        static /* synthetic */ int access$200() {
            return MAX_ITEMS_TO_DISPLAY;
        }

        static {
            int val = 256;
            if (System.getProperty("cnd.completion.items") != null) {
                try {
                    val = Integer.parseInt(System.getProperty("cnd.completion.items"));
                }
                catch (NumberFormatException numberFormatException) {
                    val = 256;
                }
            }
            if (val < 0) {
                val = Integer.MAX_VALUE;
            }
            MAX_ITEMS_TO_DISPLAY = val;
        }
    }
}

