/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.api;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class BrowserReloadTask
extends Task {
    private String filePath;
    private String url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        ClassLoader originalLoader = null;
        try {
            ClassLoader current = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (current == null) {
                current = ClassLoader.getSystemClassLoader();
            }
            if (current != null) {
                originalLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(current);
            }
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.filePath)));
            BrowserSupport bs = null;
            Project p = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (p != null) {
                bs = (BrowserSupport)p.getLookup().lookup(BrowserSupport.class);
            }
            if (bs == null) {
                bs = BrowserSupport.getDefault();
            }
            try {
                URL url = new URL(this.getUrl());
                bs.load(url, fileObject);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (originalLoader != null) {
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
        }
        catch (Throwable throwable) {
            if (originalLoader != null) {
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
            throw throwable;
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setFilePath(String path) {
        this.filePath = path;
    }
}

