/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.dirchooser;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.api.project.ProjectManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class DirectoryNode
extends DefaultMutableTreeNode {
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    static final FileNameComparator FILE_NAME_COMPARATOR = new FileNameComparator();
    private File directory;
    private boolean isDir;
    private boolean loaded;
    private boolean isSelected;

    public DirectoryNode(File file) {
        this(file, true, false, false, false);
    }

    public DirectoryNode(File file, boolean allowsChildren) {
        this(file, allowsChildren, false, false, false);
    }

    public DirectoryNode(File file, boolean allowsChildren, boolean isSelected, boolean isChecked, boolean isEditable) {
        super(file, allowsChildren);
        this.directory = file;
        this.isDir = this.directory.isDirectory();
        this.isSelected = isSelected;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public File getFile() {
        return this.directory;
    }

    public void setFile(File file) {
        this.setUserObject(file);
        this.directory = file;
        this.loaded = false;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    @Override
    public boolean isLeaf() {
        return !this.isDir;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isDir;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean loadChildren(JFileChooser chooser, boolean descend) {
        if (!this.loaded) {
            ArrayList files = this.getFiles(chooser);
            if (files.isEmpty()) {
                return false;
            }
            for (int i = 0; i < files.size(); ++i) {
                File child = (File)files.get(i);
                if (!chooser.accept(child)) continue;
                try {
                    DirectoryNode node = new DirectoryNode(child);
                    if (!descend) break;
                    this.add(node);
                    continue;
                }
                catch (NullPointerException t) {
                    Logger.getLogger(DirectoryNode.class.getName()).log(Level.INFO, null, t);
                }
            }
            if (descend || this.getChildCount() > 0) {
                this.loaded = true;
            }
        }
        return this.loaded;
    }

    private ArrayList getFiles(JFileChooser chooser) {
        ArrayList<File> list = new ArrayList<File>();
        if (this.directory == null || !this.directory.exists()) {
            return list;
        }
        File[] files = chooser.getFileSystemView().getFiles(this.directory, chooser.isFileHidingEnabled());
        int mode = chooser.getFileSelectionMode();
        if (mode == 1) {
            for (int i = 0; i < files.length; ++i) {
                File child = files[i];
                if (!child.isDirectory()) continue;
                list.add(child);
            }
            Collections.sort(list, FILE_NAME_COMPARATOR);
        } else if (mode == 2 || mode == 0) {
            ArrayList<File> dirList = new ArrayList<File>();
            ArrayList<File> fileList = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                File child = files[i];
                if (child.isDirectory()) {
                    dirList.add(child);
                    continue;
                }
                fileList.add(child);
            }
            Collections.sort(dirList, FILE_NAME_COMPARATOR);
            Collections.sort(fileList, FILE_NAME_COMPARATOR);
            list.addAll(dirList);
            list.addAll(fileList);
        }
        return list;
    }

    public boolean isNetBeansProject() {
        return DirectoryNode.isNetBeansProject(this.directory);
    }

    public static boolean isNetBeansProject(File directory) {
        FileObject fo;
        boolean retVal = false;
        if (directory != null && (fo = DirectoryNode.convertToValidDir(directory)) != null) {
            retVal = Utilities.isUnix() && fo.getParent() != null && fo.getParent().getParent() == null ? false : ProjectManager.getDefault().isProject(fo);
        }
        return retVal;
    }

    private static FileObject convertToValidDir(File f) {
        File testFile = new File(f.getPath());
        if (testFile == null || testFile.getParent() == null) {
            return null;
        }
        if (!testFile.isDirectory()) {
            return null;
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)testFile));
        if (fo.isValid() && fo.isFolder()) {
            return fo;
        }
        return null;
    }

    private static class FileNameComparator
    implements Comparator<File> {
        private FileNameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            return String.CASE_INSENSITIVE_ORDER.compare(f1.getName(), f2.getName());
        }
    }
}

