/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.diff;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;

public class DiffInformation
extends FileInfoContainer {
    private File file;
    private String repositoryFileName;
    private String rightRevision;
    private String leftRevision;
    private String parameters;
    private final List changesList = new ArrayList();
    private Iterator iterator;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getRepositoryFileName() {
        return this.repositoryFileName;
    }

    public void setRepositoryFileName(String repositoryFileName) {
        this.repositoryFileName = repositoryFileName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(30);
        buf.append("\nFile: " + (this.file != null ? this.file.getAbsolutePath() : "null"));
        buf.append("\nRCS file: " + this.repositoryFileName);
        buf.append("\nRevision: " + this.leftRevision);
        if (this.rightRevision != null) {
            buf.append("\nRevision: " + this.rightRevision);
        }
        buf.append("\nParameters: " + this.parameters);
        return buf.toString();
    }

    public String getRightRevision() {
        return this.rightRevision;
    }

    public void setRightRevision(String rightRevision) {
        this.rightRevision = rightRevision;
    }

    public String getLeftRevision() {
        return this.leftRevision;
    }

    public void setLeftRevision(String leftRevision) {
        this.leftRevision = leftRevision;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public DiffChange createDiffChange() {
        return new DiffChange();
    }

    public void addChange(DiffChange change) {
        this.changesList.add(change);
    }

    public DiffChange getFirstChange() {
        this.iterator = this.changesList.iterator();
        return this.getNextChange();
    }

    public DiffChange getNextChange() {
        if (this.iterator == null) {
            return null;
        }
        if (!this.iterator.hasNext()) {
            return null;
        }
        return (DiffChange)this.iterator.next();
    }

    public class DiffChange {
        public static final int ADD = 0;
        public static final int DELETE = 1;
        public static final int CHANGE = 2;
        protected int type;
        private int leftBeginning = -1;
        private int leftEnd = -1;
        private final List leftDiff = new ArrayList();
        private int rightBeginning = -1;
        private int rightEnd = -1;
        private final List rightDiff = new ArrayList();

        public void setType(int typeChange) {
            this.type = typeChange;
        }

        public int getType() {
            return this.type;
        }

        public void setLeftRange(int min, int max) {
            this.leftBeginning = min;
            this.leftEnd = max;
        }

        public void setRightRange(int min, int max) {
            this.rightBeginning = min;
            this.rightEnd = max;
        }

        public int getMainBeginning() {
            return this.rightBeginning;
        }

        public int getRightMin() {
            return this.rightBeginning;
        }

        public int getRightMax() {
            return this.rightEnd;
        }

        public int getLeftMin() {
            return this.leftBeginning;
        }

        public int getLeftMax() {
            return this.leftEnd;
        }

        public boolean isInRange(int number, boolean left) {
            if (left) {
                return number >= this.leftBeginning && number <= this.leftEnd;
            }
            return number >= this.rightBeginning && number <= this.rightEnd;
        }

        public String getLine(int number, boolean left) {
            if (left) {
                int index = number - this.leftBeginning;
                if (index < 0 || index >= this.leftDiff.size()) {
                    return null;
                }
                String line = (String)this.leftDiff.get(index);
                return line;
            }
            int index = number - this.rightBeginning;
            if (index < 0 || index >= this.rightDiff.size()) {
                return null;
            }
            String line = (String)this.rightDiff.get(index);
            return line;
        }

        public void appendLeftLine(String diffLine) {
            this.leftDiff.add(diffLine);
        }

        public void appendRightLine(String diffLine) {
            this.rightDiff.add(diffLine);
        }
    }
}

