/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.actions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class AttachWindowAction
extends Action {
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String AS_LAST_TAB = "As a Last Tab";
    private static final String windowItem = Bundle.getStringTrimmed("org.netbeans.core.windows.resources.Bundle", "Menu/Window");
    private String sideConstant;
    private String targetTopComponentName;
    private TopComponentOperator targetTopComponentOperator;

    public AttachWindowAction(String targetTopComponentName, String side) {
        super(null, null);
        if (targetTopComponentName == null) {
            throw new IllegalArgumentException("targetTopComponentName cannot be null.");
        }
        this.targetTopComponentName = targetTopComponentName;
        this.mapSide(side);
    }

    public AttachWindowAction(TopComponentOperator targetTopComponentOperator, String side) {
        super(null, null);
        if (targetTopComponentOperator == null) {
            throw new IllegalArgumentException("targetTopComponentOperator cannot be null.");
        }
        this.targetTopComponentOperator = targetTopComponentOperator;
        this.mapSide(side);
    }

    private TopComponentOperator getTargetTopComponentOperator() {
        if (this.targetTopComponentOperator == null) {
            this.targetTopComponentOperator = new TopComponentOperator(this.targetTopComponentName);
        }
        return this.targetTopComponentOperator;
    }

    private void mapSide(String side) {
        if (side == null || side.equals(AS_LAST_TAB)) {
            this.sideConstant = AS_LAST_TAB;
        } else if (side.equals(RIGHT)) {
            this.sideConstant = RIGHT;
        } else if (side.equals(LEFT)) {
            this.sideConstant = LEFT;
        } else if (side.equals(TOP)) {
            this.sideConstant = TOP;
        } else if (side.equals(BOTTOM)) {
            this.sideConstant = BOTTOM;
        } else {
            throw new JemmyException("Cannot attach to position \"" + side + "\".");
        }
    }

    @Override
    public void performAPI(ComponentOperator compOperator) {
        if (!(compOperator instanceof TopComponentOperator)) {
            throw new UnsupportedOperationException("AttachWindowAction can only be called on TopComponentOperator.");
        }
        this.performAPI((TopComponentOperator)compOperator);
    }

    public void performAPI(TopComponentOperator tco) {
        final TopComponent sourceTc = (TopComponent)tco.getSource();
        final TopComponent targetTc = (TopComponent)this.getTargetTopComponentOperator().getSource();
        tco.getQueueTool().invokeSmoothly(new Runnable(){

            @Override
            public void run() {
                Mode mode = WindowManager.getDefault().findMode(targetTc);
                if (AttachWindowAction.this.sideConstant.equals(AttachWindowAction.AS_LAST_TAB)) {
                    mode.dockInto(sourceTc);
                    sourceTc.open();
                    sourceTc.requestActive();
                } else {
                    AttachWindowAction.attachTopComponent(sourceTc, mode, AttachWindowAction.this.sideConstant);
                }
            }
        });
        try {
            new Waiter(new Waitable(){

                public Object actionProduced(Object tc) {
                    return ((TopComponent)tc).isShowing() ? Boolean.TRUE : null;
                }

                public String getDescription() {
                    return "TopComponent is showing.";
                }
            }).waitAction((Object)sourceTc);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", (Throwable)e);
        }
    }

    static Object callWindowManager(String method, Object ... args) {
        return AttachWindowAction.callWindowManager(WindowManager.getDefault().getClass(), method, args);
    }

    private static Object callWindowManager(Class clazz, String method, Object ... args) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (!method.equals(m.getName()) || args == null && m.getParameterTypes().length > 0 || args != null && m.getParameterTypes().length != args.length) continue;
            try {
                return m.invoke((Object)WindowManager.getDefault(), args);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot execute " + method, ex);
            }
        }
        return AttachWindowAction.callWindowManager(clazz.getSuperclass(), method, args);
    }

    private static Class classForName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
    }

    private static void attachTopComponent(TopComponent sourceTc, Mode mode, String sideConstant) {
        try {
            Class centralClass = AttachWindowAction.classForName("org.netbeans.core.windows.Central");
            Class tcdClass = AttachWindowAction.classForName("org.netbeans.core.windows.view.dnd.TopComponentDraggable");
            Class modeImplClass = AttachWindowAction.classForName("org.netbeans.core.windows.ModeImpl");
            Method attachMethod = centralClass.getMethod("userDroppedTopComponents", modeImplClass, tcdClass, String.class);
            Method getCentralMethod = WindowManager.getDefault().getClass().getDeclaredMethod("getCentral", null);
            getCentralMethod.setAccessible(true);
            Object centralInstance = getCentralMethod.invoke((Object)WindowManager.getDefault(), (Object[])null);
            Constructor tcdConstructor = tcdClass.getDeclaredConstructor(TopComponent.class);
            tcdConstructor.setAccessible(true);
            Object tcdInstance = tcdConstructor.newInstance(sourceTc);
            attachMethod.setAccessible(true);
            attachMethod.invoke(centralInstance, mode, tcdInstance, sideConstant);
        }
        catch (Exception e) {
            throw new JemmyException("Cannot attach TopComponent.", (Throwable)e);
        }
    }

    @Override
    public void performAPI(Node[] nodes) {
        throw new UnsupportedOperationException("AttachWindowAction doesn't have popup representation on nodes.");
    }

    @Override
    public void performMenu(Node[] nodes) {
        throw new UnsupportedOperationException("AttachWindowAction doesn't have popup representation on nodes.");
    }

    @Override
    public void performPopup(Node[] nodes) {
        throw new UnsupportedOperationException("AttachWindowAction doesn't have popup representation on nodes.");
    }

    @Override
    public void performShortcut(Node[] nodes) {
        throw new UnsupportedOperationException("AttachWindowAction doesn't have popup representation on nodes.");
    }
}

