/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository.remote;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.libs.git.utils.GitURI;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.repository.remote.ConnectionSettings;
import org.netbeans.modules.git.ui.repository.remote.RemoteRepositoryPanel;
import org.netbeans.modules.git.ui.repository.remote.SSHPanel;
import org.netbeans.modules.git.ui.repository.remote.UserPasswordPanel;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class RemoteRepository
implements DocumentListener,
ActionListener,
ItemListener {
    private boolean valid;
    private AbstractWizardPanel.Message msg;
    private ChangeSupport support = new ChangeSupport((Object)this);
    private final boolean urlFixed;
    private final ConnectionSettingsType[] settingTypes;
    private ConnectionSettingsType activeSettingsType;
    private final RemoteRepositoryPanel panel;
    private boolean ignoreComboEvents = false;
    private Map<String, ConnectionSettings> recentConnectionSettings = new HashMap<String, ConnectionSettings>();

    public RemoteRepository(String forPath) {
        this(forPath, false);
    }

    private RemoteRepository(String forPath, boolean fixedUrl) {
        assert (!fixedUrl || forPath != null && !forPath.trim().isEmpty());
        this.panel = new RemoteRepositoryPanel();
        this.urlFixed = fixedUrl;
        this.settingTypes = new ConnectionSettingsType[]{new GitConnectionSettingsType(), new SSHConnectionSettingsType(), new FileConnectionSettingsType(), new DefaultConnectionSettingsType()};
        this.activeSettingsType = this.settingTypes[0];
        this.attachListeners();
        this.initUrlComboValues(forPath);
        this.updateCurrentSettingsType();
        this.validateFields();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean isValid() {
        return this.valid;
    }

    public AbstractWizardPanel.Message getMessage() {
        return this.msg;
    }

    public GitURI getURI() {
        String uriString = this.getURIString();
        if (uriString != null && !uriString.isEmpty()) {
            try {
                return new GitURI(uriString);
            }
            catch (URISyntaxException ex) {
                Git.LOG.log(Level.INFO, uriString, ex);
            }
        }
        return null;
    }

    public void store() {
        this.activeSettingsType.store();
    }

    public void setEnabled(boolean enabled) {
        this.activeSettingsType.setEnabled(enabled);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    private String getURIString() {
        String uriString = (String)this.panel.urlComboBox.getEditor().getItem();
        return uriString == null ? null : uriString.trim();
    }

    private void attachListeners() {
        this.panel.proxySettingsButton.addActionListener(this);
        this.panel.directoryBrowseButton.addActionListener(this);
        this.panel.urlComboBox.addActionListener(this);
        ((JTextComponent)this.panel.urlComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        this.panel.urlComboBox.addItemListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        if (this.ignoreComboEvents) {
            return;
        }
        this.validateFields();
        this.updateCurrentSettingsType();
        this.findComboItem(false);
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        if (this.ignoreComboEvents) {
            return;
        }
        this.validateFields();
        this.updateCurrentSettingsType();
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        if (this.ignoreComboEvents) {
            return;
        }
        this.validateFields();
        this.updateCurrentSettingsType();
        this.findComboItem(false);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.panel.directoryBrowseButton) {
            this.onBrowse();
        } else if (ae.getSource() == this.panel.proxySettingsButton) {
            this.onProxyConfiguration();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        GitURI guri = this.getURI();
        if (guri != null) {
            this.activeSettingsType.populateFields(this.recentConnectionSettings.get(guri.toString()));
        }
    }

    public static boolean updateFor(String url) {
        boolean retval = false;
        final RemoteRepository repository = new RemoteRepository(url, true);
        JPanel panel = repository.getPanel();
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"ACSD_RepositoryPanel_Title"), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, new HelpCtx(RemoteRepository.class), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        repository.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                dd.setValid(repository.isValid());
            }
        });
        if (repository.isValid()) {
            dd.setValid(true);
        }
        dialog.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            repository.activeSettingsType.store();
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateFields() {
        try {
            this.valid = true;
            this.msg = null;
            GitURI uri = this.getURI();
            if (uri == null) {
                this.valid = false;
                this.msg = new AbstractWizardPanel.Message(NbBundle.getMessage(RemoteRepository.class, (String)"MSG_EMPTY_URI_ERROR"), true);
            }
        }
        finally {
            this.support.fireChange();
        }
    }

    private void updateCurrentSettingsType() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                GitURI uri = RemoteRepository.this.getURI();
                if (uri == null) {
                    return;
                }
                for (ConnectionSettingsType type : RemoteRepository.this.settingTypes) {
                    if (!type.acceptUri(uri)) continue;
                    RemoteRepository.this.activeSettingsType = type;
                    break;
                }
                if (RemoteRepository.this.urlFixed) {
                    ((RemoteRepository)RemoteRepository.this).panel.tipLabel.setText(null);
                }
            }
        });
    }

    private void findComboItem(boolean selectAll) {
        String uriString;
        GitURI uri = this.getURI();
        String string = uriString = uri == null ? this.getURIString() : uri.setUser(null).setPass(null).toString();
        if (uriString == null || uriString.isEmpty()) {
            return;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.panel.urlComboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            final String item = (String)model.getElementAt(i);
            if (!item.toLowerCase().startsWith(uriString.toLowerCase())) continue;
            final int start = selectAll ? 0 : uriString.length();
            final int end = item.length();
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    RemoteRepository.this.ignoreComboEvents = true;
                    try {
                        RemoteRepository.this.setComboText(item, start, end);
                        RemoteRepository.this.updateCurrentSettingsType();
                        RemoteRepository.this.activeSettingsType.populateFields((ConnectionSettings)RemoteRepository.this.recentConnectionSettings.get(item));
                    }
                    finally {
                        RemoteRepository.this.ignoreComboEvents = false;
                    }
                }
            });
        }
    }

    private void setComboText(String item, int start, int end) {
        JTextComponent txt = (JTextComponent)this.panel.urlComboBox.getEditor().getEditorComponent();
        txt.setText(item);
        txt.setCaretPosition(end);
        txt.moveCaretPosition(start);
    }

    private void initUrlComboValues(final String forPath) {
        Git.getInstance().getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ((RemoteRepository)RemoteRepository.this).panel.urlComboBox.setEnabled(false);
                try {
                    final DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
                    try {
                        List<ConnectionSettings> settings = GitModuleConfig.getDefault().getRecentConnectionSettings();
                        for (ConnectionSettings sett : settings) {
                            GitURI g = sett.getUri().setPass(null).setUser(null);
                            model.addElement(g.toString());
                            RemoteRepository.this.recentConnectionSettings.put(g.toString(), sett);
                        }
                    }
                    catch (Throwable t) {
                        Git.LOG.log(Level.WARNING, null, t);
                    }
                    for (Scheme s : Scheme.values()) {
                        model.addElement(s.toString() + (s == Scheme.FILE ? ":///" : "://"));
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RemoteRepository.this.ignoreComboEvents = true;
                            ((RemoteRepository)RemoteRepository.this).panel.urlComboBox.setModel(model);
                            if (forPath != null) {
                                RemoteRepository.this.setComboText(forPath, 0, forPath.length());
                            }
                            RemoteRepository.this.ignoreComboEvents = false;
                            RemoteRepository.this.findComboItem(true);
                            RemoteRepository.this.updateCurrentSettingsType();
                            RemoteRepository.this.validateFields();
                        }
                    });
                }
                finally {
                    if (!RemoteRepository.this.urlFixed) {
                        ((RemoteRepository)RemoteRepository.this).panel.urlComboBox.setEnabled(true);
                    }
                }
            }
        });
    }

    private void onBrowse() {
        JTextComponent comboEditor = (JTextComponent)this.panel.urlComboBox.getEditor().getEditorComponent();
        String txt = comboEditor.getText();
        if (txt == null || txt.trim().isEmpty()) {
            return;
        }
        File file = null;
        try {
            URI uri = new URI(comboEditor.getText());
            file = uri.isAbsolute() && "file".equalsIgnoreCase(uri.getScheme()) ? new File(uri) : new File(comboEditor.getText());
        }
        catch (URISyntaxException ex) {
            // empty catch block
        }
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"RepositoryPanel.FileChooser.Descritpion"), file);
        fileChooser.setDialogTitle(NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"RepositoryPanel.FileChooser.Title"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this.panel, null);
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            comboEditor.setText(f.toURI().toString());
        }
    }

    private void onProxyConfiguration() {
        OptionsDisplayer.getDefault().open("General");
    }

    private class GitConnectionSettingsType
    extends ConnectionSettingsType {
        private final JComponent[] inputFields;

        public GitConnectionSettingsType() {
            this.inputFields = new JComponent[]{((RemoteRepository)RemoteRepository.this).panel.urlComboBox, ((RemoteRepository)RemoteRepository.this).panel.directoryBrowseButton, ((RemoteRepository)RemoteRepository.this).panel.proxySettingsButton, ((RemoteRepository)RemoteRepository.this).panel.repositoryLabel, ((RemoteRepository)RemoteRepository.this).panel.tipLabel};
        }

        @Override
        protected void setEnabled(boolean enabled) {
            for (JComponent inputField : this.inputFields) {
                inputField.setEnabled(enabled);
            }
        }

        @Override
        protected void store() {
            GitURI guri = RemoteRepository.this.getURI();
            assert (guri != null);
            if (guri == null) {
                return;
            }
            final ConnectionSettings settings = new ConnectionSettings(guri);
            Runnable outOfAWT = new Runnable(){

                @Override
                public void run() {
                    GitModuleConfig.getDefault().insertRecentConnectionSettings(settings);
                    RemoteRepository.this.recentConnectionSettings.put(settings.getUri().setUser(null).toString(), settings);
                }
            };
            if (EventQueue.isDispatchThread()) {
                Git.getInstance().getRequestProcessor().post(outOfAWT);
            } else {
                outOfAWT.run();
            }
        }

        @Override
        protected boolean acceptUri(GitURI uri) {
            boolean accepts = false;
            ((RemoteRepository)RemoteRepository.this).panel.tipLabel.setText(null);
            if (uri.getScheme() != null && uri.getScheme().equals(Scheme.GIT.toString())) {
                accepts = true;
                ((RemoteRepository)RemoteRepository.this).panel.tipLabel.setText(Scheme.GIT.getTip());
            }
            if (accepts) {
                ((RemoteRepository)RemoteRepository.this).panel.directoryBrowseButton.setVisible(false);
                ((RemoteRepository)RemoteRepository.this).panel.proxySettingsButton.setVisible(true);
                ((RemoteRepository)RemoteRepository.this).panel.connectionSettings.removeAll();
            }
            return accepts;
        }
    }

    private final class FileConnectionSettingsType
    extends ConnectionSettingsType {
        private final JComponent[] inputFields;
        private final EnumSet<Scheme> acceptableSchemes;

        public FileConnectionSettingsType() {
            this.inputFields = new JComponent[]{((RemoteRepository)RemoteRepository.this).panel.urlComboBox, ((RemoteRepository)RemoteRepository.this).panel.directoryBrowseButton, ((RemoteRepository)RemoteRepository.this).panel.proxySettingsButton, ((RemoteRepository)RemoteRepository.this).panel.repositoryLabel, ((RemoteRepository)RemoteRepository.this).panel.tipLabel};
            this.acceptableSchemes = EnumSet.of(Scheme.FILE);
        }

        @Override
        protected void setEnabled(boolean enabled) {
            for (JComponent inputField : this.inputFields) {
                inputField.setEnabled(enabled);
            }
        }

        @Override
        protected void store() {
            GitURI guri = RemoteRepository.this.getURI();
            assert (guri != null);
            if (guri == null) {
                return;
            }
            final ConnectionSettings settings = new ConnectionSettings(guri);
            Runnable outOfAWT = new Runnable(){

                @Override
                public void run() {
                    GitModuleConfig.getDefault().insertRecentConnectionSettings(settings);
                    RemoteRepository.this.recentConnectionSettings.put(settings.getUri().setUser(null).toString(), settings);
                }
            };
            if (EventQueue.isDispatchThread()) {
                Git.getInstance().getRequestProcessor().post(outOfAWT);
            } else {
                outOfAWT.run();
            }
        }

        @Override
        protected boolean acceptUri(GitURI uri) {
            boolean accepts = false;
            if (uri.getScheme() == null) {
                accepts = true;
            } else {
                for (Scheme s : this.acceptableSchemes) {
                    if (!uri.getScheme().equals(s.toString())) continue;
                    accepts = true;
                    break;
                }
            }
            if (accepts) {
                ((RemoteRepository)RemoteRepository.this).panel.directoryBrowseButton.setVisible(true);
                ((RemoteRepository)RemoteRepository.this).panel.proxySettingsButton.setVisible(false);
                ((RemoteRepository)RemoteRepository.this).panel.connectionSettings.removeAll();
                ((RemoteRepository)RemoteRepository.this).panel.tipLabel.setText(Scheme.FILE.getTip());
            }
            return accepts;
        }
    }

    private final class SSHConnectionSettingsType
    extends ConnectionSettingsType
    implements ActionListener {
        private final JComponent[] inputFields;
        private final SSHPanel settingsPanel;
        private final JComponent[] authKeyFields;
        private final JComponent[] authPasswordFields;

        public SSHConnectionSettingsType() {
            this.settingsPanel = new SSHPanel();
            this.inputFields = new JComponent[]{((RemoteRepository)RemoteRepository.this).panel.urlComboBox, this.settingsPanel.lblUser, this.settingsPanel.lblPassword, this.settingsPanel.lblLeaveBlank, this.settingsPanel.lblIdentityFile, this.settingsPanel.lblPassphrase, this.settingsPanel.userTextField, this.settingsPanel.userPasswordField, this.settingsPanel.savePasswordCheckBox, this.settingsPanel.txtIdentityFile, this.settingsPanel.txtPassphrase, this.settingsPanel.btnBrowse, this.settingsPanel.savePassphrase, this.settingsPanel.rbPrivateKey, this.settingsPanel.rbUsernamePassword, ((RemoteRepository)RemoteRepository.this).panel.directoryBrowseButton, ((RemoteRepository)RemoteRepository.this).panel.proxySettingsButton, ((RemoteRepository)RemoteRepository.this).panel.repositoryLabel, ((RemoteRepository)RemoteRepository.this).panel.tipLabel};
            this.authKeyFields = new JComponent[]{this.settingsPanel.lblIdentityFile, this.settingsPanel.lblPassphrase, this.settingsPanel.txtIdentityFile, this.settingsPanel.txtPassphrase, this.settingsPanel.btnBrowse, this.settingsPanel.savePassphrase};
            this.authPasswordFields = new JComponent[]{this.settingsPanel.lblPassword, this.settingsPanel.userPasswordField, this.settingsPanel.savePasswordCheckBox};
            this.attachListeners();
        }

        private void attachListeners() {
            this.settingsPanel.btnBrowse.addActionListener(this);
            this.settingsPanel.rbPrivateKey.addActionListener(this);
            this.settingsPanel.rbUsernamePassword.addActionListener(this);
        }

        @Override
        protected void setEnabled(boolean enabled) {
            for (JComponent inputField : this.inputFields) {
                inputField.setEnabled(enabled);
            }
            if (enabled) {
                this.updateAuthSelection();
            }
        }

        @Override
        protected void populateFields(ConnectionSettings settings) {
            if (settings == null) {
                return;
            }
            this.settingsPanel.userTextField.setText(settings.getUser());
            char[] pass = settings.getPassword();
            if (pass != null) {
                this.settingsPanel.userPasswordField.setText(new String(pass));
            } else {
                this.settingsPanel.userPasswordField.setText("");
            }
            pass = settings.getPassphrase();
            if (pass != null) {
                this.settingsPanel.txtPassphrase.setText(new String(pass));
            } else {
                this.settingsPanel.txtPassphrase.setText("");
            }
            this.settingsPanel.savePasswordCheckBox.setSelected(settings.isSaveCredentials());
            this.settingsPanel.savePassphrase.setSelected(settings.isSaveCredentials());
            this.settingsPanel.rbPrivateKey.setSelected(settings.isPrivateKeyAuth());
            this.settingsPanel.rbPrivateKey.setSelected(!settings.isPrivateKeyAuth());
            this.settingsPanel.txtIdentityFile.setText(settings.getIdentityFile());
            this.updateAuthSelection();
        }

        @Override
        protected void store() {
            GitURI guri = RemoteRepository.this.getURI();
            assert (guri != null);
            if (guri == null) {
                return;
            }
            final ConnectionSettings settings = new ConnectionSettings(guri);
            settings.setUser(this.settingsPanel.userTextField.getText());
            settings.setPrivateKeyAuth(this.settingsPanel.rbPrivateKey.isSelected());
            settings.setSaveCredentials(settings.isPrivateKeyAuth() ? this.settingsPanel.savePassphrase.isSelected() : this.settingsPanel.savePasswordCheckBox.isSelected());
            settings.setPassword(this.settingsPanel.userPasswordField.getPassword());
            settings.setPassphrase(this.settingsPanel.txtPassphrase.getPassword());
            settings.setIdentityFile(this.settingsPanel.txtIdentityFile.getText());
            Runnable outOfAWT = new Runnable(){

                @Override
                public void run() {
                    GitModuleConfig.getDefault().insertRecentConnectionSettings(settings);
                    RemoteRepository.this.recentConnectionSettings.put(settings.getUri().setUser(null).toString(), settings);
                }
            };
            if (EventQueue.isDispatchThread()) {
                Git.getInstance().getRequestProcessor().post(outOfAWT);
            } else {
                outOfAWT.run();
            }
        }

        @Override
        protected boolean acceptUri(GitURI uri) {
            boolean accepts = false;
            ((RemoteRepository)RemoteRepository.this).panel.tipLabel.setText(null);
            if (uri.getScheme() == null) {
                if (uri.getHost() != null && uri.getHost().length() != 0) {
                    accepts = true;
                    ((RemoteRepository)RemoteRepository.this).panel.tipLabel.setText("[user@]host.xz:path/to/repo.git/");
                }
            } else if (uri.getScheme().equals(Scheme.SSH.toString())) {
                accepts = true;
                ((RemoteRepository)RemoteRepository.this).panel.tipLabel.setText(Scheme.SSH.getTip());
            }
            if (accepts) {
                ((RemoteRepository)RemoteRepository.this).panel.directoryBrowseButton.setVisible(false);
                ((RemoteRepository)RemoteRepository.this).panel.proxySettingsButton.setVisible(true);
                ((RemoteRepository)RemoteRepository.this).panel.connectionSettings.removeAll();
                ((RemoteRepository)RemoteRepository.this).panel.connectionSettings.add((Component)this.settingsPanel, "North");
                this.updateAuthSelection();
            }
            return accepts;
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.settingsPanel.btnBrowse) {
                this.onBrowse();
            } else if (e.getSource() == this.settingsPanel.rbPrivateKey || e.getSource() == this.settingsPanel.rbUsernamePassword) {
                this.updateAuthSelection();
            }
        }

        private void onBrowse() {
            File file = new File(this.settingsPanel.txtIdentityFile.getText());
            AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"RepositoryPanel.IdentityFile.FileChooser.Descritpion"), file);
            fileChooser.setDialogType(0);
            fileChooser.setDialogTitle(NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"RepositoryPanel.IdentityFile.FileChooser.Title"));
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.showDialog(RemoteRepository.this.panel, null);
            File f = fileChooser.getSelectedFile();
            if (f != null) {
                this.settingsPanel.txtIdentityFile.setText(f.getAbsolutePath());
            }
        }

        private void updateAuthSelection() {
            boolean authViaPrivateKey = this.settingsPanel.rbPrivateKey.isSelected();
            boolean authViaPassword = this.settingsPanel.rbUsernamePassword.isSelected();
            if (!authViaPassword && !authViaPrivateKey) {
                authViaPassword = true;
                this.settingsPanel.rbUsernamePassword.setSelected(true);
            }
            for (JComponent c : this.authKeyFields) {
                c.setEnabled(authViaPrivateKey);
            }
            for (JComponent c : this.authPasswordFields) {
                c.setEnabled(authViaPassword);
            }
        }
    }

    private class DefaultConnectionSettingsType
    extends ConnectionSettingsType {
        private final JComponent[] inputFields;
        private final UserPasswordPanel settingsPanel;
        private final EnumSet<Scheme> acceptableSchemes;

        public DefaultConnectionSettingsType() {
            this.settingsPanel = new UserPasswordPanel();
            this.inputFields = new JComponent[]{((RemoteRepository)RemoteRepository.this).panel.urlComboBox, this.settingsPanel.userTextField, this.settingsPanel.userPasswordField, this.settingsPanel.savePasswordCheckBox, ((RemoteRepository)RemoteRepository.this).panel.directoryBrowseButton, ((RemoteRepository)RemoteRepository.this).panel.proxySettingsButton, ((RemoteRepository)RemoteRepository.this).panel.repositoryLabel, this.settingsPanel.userLabel, this.settingsPanel.passwordLabel, this.settingsPanel.leaveBlankLabel, ((RemoteRepository)RemoteRepository.this).panel.tipLabel};
            this.acceptableSchemes = EnumSet.of(Scheme.GIT, Scheme.HTTP, Scheme.HTTPS, Scheme.SFTP);
        }

        @Override
        protected void setEnabled(boolean enabled) {
            for (JComponent inputField : this.inputFields) {
                inputField.setEnabled(enabled);
            }
        }

        @Override
        protected void populateFields(ConnectionSettings settings) {
            if (settings == null) {
                return;
            }
            this.settingsPanel.userTextField.setText(settings.getUser());
            char[] pass = settings.getPassword();
            if (pass != null) {
                this.settingsPanel.userPasswordField.setText(new String(pass));
            } else {
                this.settingsPanel.userPasswordField.setText("");
            }
            this.settingsPanel.savePasswordCheckBox.setSelected(settings.isSaveCredentials());
        }

        @Override
        protected void store() {
            GitURI guri = RemoteRepository.this.getURI();
            assert (guri != null);
            if (guri == null) {
                return;
            }
            final ConnectionSettings settings = new ConnectionSettings(guri);
            settings.setUser(this.settingsPanel.userTextField.getText());
            settings.setPrivateKeyAuth(false);
            settings.setSaveCredentials(this.settingsPanel.savePasswordCheckBox.isSelected());
            settings.setPassword(this.settingsPanel.userPasswordField.getPassword());
            Runnable outOfAWT = new Runnable(){

                @Override
                public void run() {
                    GitModuleConfig.getDefault().insertRecentConnectionSettings(settings);
                    RemoteRepository.this.recentConnectionSettings.put(settings.getUri().setUser(null).toString(), settings);
                }
            };
            if (EventQueue.isDispatchThread()) {
                Git.getInstance().getRequestProcessor().post(outOfAWT);
            } else {
                outOfAWT.run();
            }
        }

        @Override
        protected boolean acceptUri(GitURI uri) {
            boolean accepts = false;
            ((RemoteRepository)RemoteRepository.this).panel.tipLabel.setText(null);
            if (uri.getScheme() != null) {
                accepts = true;
                for (Scheme s : this.acceptableSchemes) {
                    if (!uri.getScheme().equals(s.toString())) continue;
                    ((RemoteRepository)RemoteRepository.this).panel.tipLabel.setText(s.getTip());
                    break;
                }
            }
            if (accepts) {
                ((RemoteRepository)RemoteRepository.this).panel.directoryBrowseButton.setVisible(false);
                ((RemoteRepository)RemoteRepository.this).panel.proxySettingsButton.setVisible(true);
                ((RemoteRepository)RemoteRepository.this).panel.connectionSettings.removeAll();
                ((RemoteRepository)RemoteRepository.this).panel.connectionSettings.add((Component)this.settingsPanel, "North");
            }
            return accepts;
        }
    }

    private abstract class ConnectionSettingsType {
        private ConnectionSettingsType() {
        }

        protected abstract void setEnabled(boolean var1);

        protected void populateFields(ConnectionSettings connSettings) {
        }

        protected abstract void store();

        protected abstract boolean acceptUri(GitURI var1);
    }

    private static enum Scheme {
        FILE("file", "file:///path/to/repo.git/  or  /path/to/repo.git/"),
        HTTP("http", "http[s]://host.xz[:port]/path/to/repo.git/"),
        HTTPS("https", "http[s]://host.xz[:port]/path/to/repo.git/"),
        SSH("ssh", "ssh://host.xz[:port]/path/to/repo.git/"),
        SFTP("sftp", "sftp://host.xz[:port]/path/to/repo.git/"),
        GIT("git", "git://host.xz[:port]/path/to/repo.git/");

        private final String name;
        private final String tip;

        private Scheme(String name, String tip) {
            this.name = name;
            this.tip = tip;
        }

        private String getTip() {
            return this.tip;
        }

        public String toString() {
            return this.name;
        }
    }
}

