/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.git.ui.repository.RepositoryBrowserPanel;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.git.ui.repository.RevisionInfoPanelController;
import org.netbeans.modules.git.ui.repository.RevisionPickerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RevisionPicker
implements PropertyChangeListener {
    private final RevisionPickerDialog panel;
    private final JButton okButton;
    private final RevisionInfoPanelController infoPanelController;
    private Revision revision;
    private DialogDescriptor dd;
    private final RepositoryBrowserPanel browserPanel;

    public RevisionPicker(File repository, File[] roots) {
        this.infoPanelController = new RevisionInfoPanelController(repository);
        this.browserPanel = new RepositoryBrowserPanel(RepositoryBrowserPanel.OPTIONS_INSIDE_PANEL, repository, roots, null);
        this.panel = new RevisionPickerDialog(this.infoPanelController.getPanel(), this.browserPanel);
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(RevisionPicker.class, (String)"LBL_RevisionPickerDialog.okButton.title"));
    }

    boolean open() {
        this.dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(RevisionPicker.class, (String)"LBL_RevisionPickerDialog.title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, new HelpCtx(RevisionPickerDialog.class), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dd);
        this.updateDialogState();
        this.browserPanel.addPropertyChangeListener(this);
        dialog.setVisible(true);
        this.browserPanel.removePropertyChangeListener(this);
        return this.dd.getValue() == this.okButton;
    }

    Revision getRevision() {
        return this.revision;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "RepositoryBrowserPanel.revision") {
            this.revision = (Revision)evt.getNewValue();
            this.updateDialogState();
        }
    }

    private void updateDialogState() {
        boolean enabled = this.revision != null;
        this.dd.setValid(enabled);
        this.okButton.setEnabled(enabled);
        this.infoPanelController.loadInfo(this.revision == null ? null : this.revision.getName());
    }
}

