/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.git.ui.repository.RevisionDialog;
import org.netbeans.modules.git.ui.repository.RevisionInfoPanelController;
import org.netbeans.modules.git.ui.repository.RevisionPicker;
import org.openide.util.NbBundle;

public class RevisionDialogController
implements ActionListener,
DocumentListener,
PropertyChangeListener,
ItemListener {
    private final RevisionDialog panel;
    private final File repository;
    private final RevisionInfoPanelController infoPanelController;
    private final PropertyChangeSupport support;
    public static final String PROP_VALID = "RevisionDialogController.valid";
    private boolean valid = true;
    private final Timer t;
    private boolean internally;
    private final File[] roots;
    private String revision;

    public RevisionDialogController(File repository, File[] roots, String initialRevision) {
        this(repository, roots);
        this.panel.revisionField.setText(initialRevision);
        this.panel.revisionField.setCaretPosition(this.panel.revisionField.getText().length());
        this.panel.revisionField.moveCaretPosition(0);
        this.hideFields(new JComponent[]{this.panel.lblBranch, this.panel.cmbBranches});
    }

    public RevisionDialogController(File repository, File[] roots, Map<String, GitBranch> branches) {
        this(repository, roots);
        this.hideFields(new JComponent[]{this.panel.lblRevision, this.panel.revisionField, this.panel.btnSelectRevision});
        this.setModel(branches);
    }

    private RevisionDialogController(File repository, File[] roots) {
        this.infoPanelController = new RevisionInfoPanelController(repository);
        this.panel = new RevisionDialog(this.infoPanelController.getPanel());
        this.repository = repository;
        this.roots = roots;
        this.support = new PropertyChangeSupport(this);
        this.t = new Timer(500, this);
        this.t.stop();
        this.revision = this.panel.revisionField.getText();
        this.infoPanelController.loadInfo(this.revision);
        this.attachListeners();
    }

    public RevisionDialog getPanel() {
        return this.panel;
    }

    public void setEnabled(boolean enabled) {
        this.panel.btnSelectRevision.setEnabled(enabled);
        this.panel.revisionField.setEnabled(enabled);
    }

    public String getRevision() {
        return this.revision;
    }

    public void addPropertyChangeListener(PropertyChangeListener list) {
        this.support.addPropertyChangeListener(list);
    }

    public void removePropertyChangeListener(PropertyChangeListener list) {
        this.support.removePropertyChangeListener(list);
    }

    private void attachListeners() {
        this.panel.btnSelectRevision.addActionListener(this);
        this.panel.revisionField.getDocument().addDocumentListener(this);
        this.panel.cmbBranches.addItemListener(this);
        this.infoPanelController.addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.btnSelectRevision) {
            this.openRevisionPicker();
        } else if (e.getSource() == this.t) {
            this.t.stop();
            this.infoPanelController.loadInfo(this.revision);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.panel.cmbBranches) {
            this.selectedBranchChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openRevisionPicker() {
        RevisionPicker picker = new RevisionPicker(this.repository, this.roots);
        if (picker.open()) {
            Revision selectedRevision = picker.getRevision();
            this.internally = true;
            try {
                this.panel.revisionField.setText(selectedRevision.toString());
                this.panel.revisionField.setCaretPosition(0);
            }
            finally {
                this.internally = false;
            }
            if (!selectedRevision.getName().equals(this.revision)) {
                this.revision = selectedRevision.getName();
                this.updateRevision();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.revisionChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.revisionChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void setValid(boolean flag) {
        boolean oldValue = this.valid;
        this.valid = flag;
        if (this.valid != oldValue) {
            this.support.firePropertyChange(PROP_VALID, oldValue, this.valid);
        }
    }

    private void revisionChanged() {
        if (!this.internally) {
            this.revision = this.panel.revisionField.getText();
            this.updateRevision();
        }
    }

    private void updateRevision() {
        this.setValid(false);
        this.t.restart();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "RevisionInfoPanelController.valid") {
            this.setValid(Boolean.TRUE.equals(evt.getNewValue()));
        }
    }

    private void hideFields(JComponent[] fields) {
        for (JComponent field : fields) {
            field.setVisible(false);
        }
    }

    private void setModel(Map<String, GitBranch> branches) {
        final ArrayList<Object> branchList = new ArrayList<Object>(branches.size());
        ArrayList<GitBranch> remoteBranchList = new ArrayList<GitBranch>(branches.size());
        for (Map.Entry<String, GitBranch> e : branches.entrySet()) {
            GitBranch branch = e.getValue();
            if (branch.isRemote()) {
                remoteBranchList.add(branch);
                continue;
            }
            if (branch.getName() == "(no branch)") continue;
            branchList.add(branch);
        }
        Comparator<GitBranch> comp = new Comparator<GitBranch>(){

            @Override
            public int compare(GitBranch b1, GitBranch b2) {
                return b1.getName().compareTo(b2.getName());
            }
        };
        Collections.sort(branchList, comp);
        Collections.sort(remoteBranchList, comp);
        branchList.addAll(remoteBranchList);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] objectArray;
                JComboBox jComboBox = ((RevisionDialogController)RevisionDialogController.this).panel.cmbBranches;
                if (branchList.isEmpty()) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = NbBundle.getMessage(RevisionDialogController.class, (String)"MSG_RevisionDialog.selectBranch");
                } else {
                    objectArray = branchList.toArray(new GitBranch[branchList.size()]);
                }
                jComboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
                ((RevisionDialogController)RevisionDialogController.this).panel.cmbBranches.setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        return super.getListCellRendererComponent((JList<?>)list, value instanceof GitBranch ? ((GitBranch)value).getName() : value, index, isSelected, cellHasFocus);
                    }
                });
                RevisionDialogController.this.selectedBranchChanged();
            }
        });
    }

    private void selectedBranchChanged() {
        Object activeBranch = this.panel.cmbBranches.getSelectedItem();
        this.revision = activeBranch instanceof GitBranch ? ((GitBranch)activeBranch).getName() : NbBundle.getMessage(RevisionDialogController.class, (String)"MSG_RevisionDialog.selectBranch");
        this.updateRevision();
    }
}

