/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.GitRepositories;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.branch.CreateBranchAction;
import org.netbeans.modules.git.ui.branch.DeleteBranchAction;
import org.netbeans.modules.git.ui.checkout.CheckoutRevisionAction;
import org.netbeans.modules.git.ui.fetch.FetchAction;
import org.netbeans.modules.git.ui.merge.MergeRevisionAction;
import org.netbeans.modules.git.ui.repository.ControlToolbar;
import org.netbeans.modules.git.ui.repository.RepositoryBrowserAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.git.ui.repository.RevisionListPanel;
import org.netbeans.modules.git.ui.repository.remote.RemoveRemoteConfig;
import org.netbeans.modules.git.ui.tag.CreateTagAction;
import org.netbeans.modules.git.ui.tag.ManageTagsAction;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class RepositoryBrowserPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ListSelectionListener {
    AbstractNode root;
    private static final RequestProcessor RP = new RequestProcessor("RepositoryPanel", 1);
    private static final Logger LOG = Logger.getLogger(RepositoryBrowserPanel.class.getName());
    private final ExplorerManager manager;
    private final EnumSet<Option> options;
    private Revision currRevision;
    private File currRepository;
    public static final String PROP_REVISION_CHANGED = "RepositoryBrowserPanel.revision";
    private final File[] roots;
    public static final EnumSet<Option> OPTIONS_INSIDE_PANEL = EnumSet.of(Option.DISPLAY_BRANCHES_LOCAL, Option.DISPLAY_BRANCHES_REMOTE, Option.DISPLAY_REVISIONS, Option.DISPLAY_TAGS);
    private static final HashMap<String, Image> cachedIcons = new HashMap(2);
    private JSplitPane jSplitPane1;
    final RevisionListPanel revisionsPanel1 = new RevisionListPanel();
    private final ControlToolbar toolbar = new ControlToolbar();
    private final BeanTreeView tree = new BeanTreeView();

    public RepositoryBrowserPanel() {
        this(EnumSet.complementOf(EnumSet.of(Option.DISPLAY_REVISIONS)), null, new File[0], null);
    }

    public RepositoryBrowserPanel(EnumSet<Option> options, File repository, File[] roots, RepositoryInfo info) {
        Parameters.notNull((CharSequence)"roots", (Object)roots);
        this.currRepository = repository;
        this.root = options.contains((Object)Option.DISPLAY_ALL_REPOSITORIES) ? new AbstractNode((Children)new RepositoriesChildren()) : new RepositoryNode(repository, info);
        this.manager = new ExplorerManager();
        this.options = options;
        this.roots = roots;
        this.initComponents();
        if (!options.contains((Object)Option.DISPLAY_TOOLBAR)) {
            this.toolbar.setVisible(false);
        }
        this.tree.setRootVisible(false);
        this.tree.setVerticalScrollBarPolicy(22);
        if (!options.contains((Object)Option.DISPLAY_REVISIONS)) {
            this.remove(this.jSplitPane1);
            this.add((Component)this.tree, "Center");
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getExplorerManager().setRootContext((Node)this.root);
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
        if (this.toolbar.isVisible()) {
            this.attachToolbarListeners();
        }
        this.revisionsPanel1.lstRevisions.addListSelectionListener(this);
        if (this.options.contains((Object)Option.DISPLAY_REVISIONS)) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
            this.revisionsPanel1.updateHistory(this.currRepository, this.roots, this.currRevision);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RepositoryBrowserPanel.this.jSplitPane1.setDividerLocation(0.5);
                }
            });
        }
    }

    @Override
    public void removeNotify() {
        if (this.options.contains((Object)Option.DISPLAY_REVISIONS)) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
        }
        this.revisionsPanel1.lstRevisions.removeListSelectionListener(this);
        this.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.toolbar.isVisible()) {
            this.detachToolbarListeners();
        }
        super.removeNotify();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Component compNew;
        if (evt.getPropertyName() == "selectedNodes") {
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (tc != null) {
                tc.setActivatedNodes(this.getExplorerManager().getSelectedNodes());
            }
            this.currRepository = null;
            Revision oldRevision = this.currRevision;
            this.currRevision = null;
            if (this.getExplorerManager().getSelectedNodes().length == 1) {
                Node selectedNode = this.getExplorerManager().getSelectedNodes()[0];
                this.currRevision = (Revision)selectedNode.getLookup().lookup(Revision.class);
                this.currRepository = this.lookupRepository(selectedNode);
            }
            if (!(this.currRevision == null && oldRevision == null || this.currRevision != null && oldRevision != null && this.currRevision.getName().equals(oldRevision.getName()) && this.currRevision.getRevision().equals(oldRevision.getRevision()))) {
                this.firePropertyChange(PROP_REVISION_CHANGED, oldRevision, this.currRevision);
            }
            if (this.options.contains((Object)Option.DISPLAY_REVISIONS) && this.currRevision != null) {
                this.revisionsPanel1.updateHistory(this.currRepository, this.roots, this.currRevision);
            }
        } else if (this.options.contains((Object)Option.DISPLAY_REVISIONS) && "focusOwner".equals(evt.getPropertyName()) && (compNew = (Component)evt.getNewValue()) != null) {
            int selection;
            if (SwingUtilities.getAncestorOfClass(this.tree.getClass(), compNew) != null) {
                if (this.getExplorerManager().getSelectedNodes().length == 1) {
                    this.propertyChange(new PropertyChangeEvent(this.tree, "selectedNodes", this.getExplorerManager().getSelectedNodes(), this.getExplorerManager().getSelectedNodes()));
                }
            } else if (this.revisionsPanel1.lstRevisions == compNew && (selection = this.revisionsPanel1.lstRevisions.getSelectedIndex()) != -1) {
                this.valueChanged(new ListSelectionEvent(this.revisionsPanel1.lstRevisions, selection, selection, false));
            }
        }
    }

    private File lookupRepository(Node selectedNode) {
        while (!(selectedNode instanceof RepositoryNode)) {
            selectedNode = selectedNode.getParentNode();
        }
        return ((RepositoryNode)selectedNode).getRepository();
    }

    public void selectRepository(File repository) {
        Node[] nodes;
        for (Node node : nodes = this.root.getChildren().getNodes()) {
            if (!(node instanceof RepositoryNode) || !repository.equals(node.getLookup().lookup(File.class))) continue;
            this.tree.expandNode(node);
            try {
                this.getExplorerManager().setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException ex) {}
            break;
        }
    }

    private void attachToolbarListeners() {
    }

    private void detachToolbarListeners() {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.revisionsPanel1.lstRevisions.isFocusOwner()) {
            GitRevisionInfo selectedRevision = (GitRevisionInfo)this.revisionsPanel1.lstRevisions.getSelectedValue();
            Revision oldRevision = this.currRevision;
            if (selectedRevision == null && this.currRevision != null) {
                this.currRevision = null;
                this.firePropertyChange(PROP_REVISION_CHANGED, oldRevision, this.currRevision);
            } else if (selectedRevision != null) {
                this.currRevision = new Revision(selectedRevision.getRevision(), selectedRevision.getRevision());
                if (oldRevision == null || !this.currRevision.getName().equals(oldRevision.getName()) || !this.currRevision.getRevision().equals(oldRevision.getRevision())) {
                    this.firePropertyChange(PROP_REVISION_CHANGED, oldRevision, this.currRevision);
                }
            }
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbar, "First");
        this.jSplitPane1.setResizeWeight(0.5);
        this.tree.setSelectionMode(1);
        this.jSplitPane1.setLeftComponent((Component)this.tree);
        this.jSplitPane1.setRightComponent(this.revisionsPanel1);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private class RemoteUriNode
    extends RepositoryBrowserNode {
        private final RemoteUri uri;
        private final GitRemoteConfig remote;

        public RemoteUriNode(RemoteUri uri, GitRemoteConfig remote) {
            super(Children.LEAF);
            this.uri = uri;
            this.remote = remote;
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/" + (uri.push ? "push" : "fetch") + ".png");
        }

        public String getName() {
            return this.uri.uri;
        }

        @Override
        protected Action[] getPopupActions(boolean context) {
            LinkedList<1> actions = new LinkedList<1>();
            if (!this.uri.push) {
                actions.add(new AbstractAction(NbBundle.getMessage(FetchAction.class, (String)"LBL_FetchAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FetchAction action = (FetchAction)SystemAction.get(FetchAction.class);
                        action.fetch(RepositoryBrowserPanel.this.currRepository, ((RemoteUriNode)RemoteUriNode.this).uri.uri, RemoteUriNode.this.remote.getFetchRefSpecs());
                    }
                });
            }
            return actions.toArray(new Action[actions.size()]);
        }
    }

    private class RemoteChildren
    extends Children.Keys<RemoteUri> {
        private final GitRemoteConfig remote;

        public RemoteChildren(GitRemoteConfig remote) {
            this.remote = remote;
        }

        protected void addNotify() {
            super.addNotify();
            ArrayList<RemoteUri> urls = new ArrayList<RemoteUri>(this.remote.getPushUris().size() + this.remote.getUris().size());
            for (String s : this.remote.getUris()) {
                urls.add(new RemoteUri(s, false));
            }
            if (this.remote.getPushUris().isEmpty() && !this.remote.getUris().isEmpty()) {
                urls.add(new RemoteUri((String)this.remote.getUris().get(0), true));
            } else {
                for (String s : this.remote.getPushUris()) {
                    urls.add(new RemoteUri(s, true));
                }
            }
            Collections.sort(urls, new Comparator<RemoteUri>(){

                @Override
                public int compare(RemoteUri o1, RemoteUri o2) {
                    return o1.uri.compareTo(o2.uri);
                }
            });
            this.setKeys(urls);
        }

        protected Node[] createNodes(RemoteUri key) {
            return new Node[]{new RemoteUriNode(key, this.remote)};
        }
    }

    private class RemoteUri {
        final String uri;
        final boolean push;

        public RemoteUri(String url, boolean push) {
            this.uri = url;
            this.push = push;
        }
    }

    private class RemoteNode
    extends RepositoryBrowserNode {
        private final String remoteName;
        private final File repository;

        public RemoteNode(File repository, GitRemoteConfig remote) {
            super((Children)new RemoteChildren(remote), Lookups.fixed((Object[])new Object[]{remote, repository}));
            this.repository = repository;
            this.remoteName = remote.getRemoteName();
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/remote.png");
        }

        public String getName() {
            return this.remoteName;
        }

        @Override
        protected Action[] getPopupActions(boolean context) {
            LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
            actions.add(new AbstractAction(NbBundle.getMessage(FetchAction.class, (String)"LBL_FetchAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FetchAction action = (FetchAction)SystemAction.get(FetchAction.class);
                    action.fetch(RemoteNode.this.repository, (GitRemoteConfig)RemoteNode.this.getLookup().lookup(GitRemoteConfig.class));
                }
            });
            actions.add(new AbstractAction(NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"LBL_RepositoryPanel.RemoteNode.remove")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new RemoveRemoteConfig().removeRemote(RemoteNode.this.repository, RemoteNode.this.remoteName);
                }
            });
            return actions.toArray(new Action[actions.size()]);
        }
    }

    private class AllRemotesChildren
    extends Children.Keys<GitRemoteConfig>
    implements PropertyChangeListener {
        private final File repository;
        private boolean refreshing;

        private AllRemotesChildren(File repository) {
            this.repository = repository;
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)info));
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshRemotes();
        }

        private void refreshRemotes() {
            new GitProgressSupport.NoOutputLogging(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    RepositoryInfo info = RepositoryInfo.getInstance(AllRemotesChildren.this.repository);
                    AllRemotesChildren.this.refreshing = true;
                    try {
                        info.refreshRemotes();
                        Map<String, GitRemoteConfig> remotes = info.getRemotes();
                        if (!this.isCanceled()) {
                            AllRemotesChildren.this.refreshRemotes(remotes);
                        }
                    }
                    finally {
                        AllRemotesChildren.this.refreshing = false;
                    }
                }
            }.start(RP, this.repository, NbBundle.getMessage(BranchesTopChildren.class, (String)"MSG_RepositoryPanel.refreshingRemotes"));
        }

        private void refreshRemotes(Map<String, GitRemoteConfig> remotes) {
            this.setKeys(remotes.values());
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if (!this.refreshing && "prop.remotes".equals(evt.getPropertyName())) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        AllRemotesChildren.this.refreshRemotes((Map)evt.getNewValue());
                    }
                });
            }
        }

        protected Node[] createNodes(GitRemoteConfig key) {
            return new Node[]{new RemoteNode(this.repository, key)};
        }
    }

    private class RemotesNode
    extends RepositoryBrowserNode {
        public RemotesNode(File repository) {
            super((Children)new AllRemotesChildren(repository), Lookups.fixed((Object[])new Object[]{repository}));
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/repository.png");
        }

        public String getDisplayName() {
            return this.getName();
        }

        public String getName() {
            return NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"LBL_RepositoryPanel.RemotesNode.name");
        }
    }

    private class TagNode
    extends RepositoryBrowserNode {
        private boolean active;
        private final String tagName;
        private String revisionId;
        private final String message;
        private final PropertyChangeListener list;

        public TagNode(File repository, GitTag tag) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{new Revision(tag.getTaggedObjectId(), tag.getTagName())}));
            this.tagName = tag.getTagName();
            this.message = tag.getMessage();
            this.revisionId = tag.getTaggedObjectId();
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/tag.png");
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            this.list = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("prop.activeBranch".equals(evt.getPropertyName()) || "prop.head".equals(evt.getPropertyName())) {
                        TagNode.this.refreshActiveBranch((GitBranch)evt.getNewValue());
                    }
                }
            };
            info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.list, (Object)info));
            this.refreshActiveBranch(info.getActiveBranch());
        }

        public String getDisplayName() {
            return this.getName(false);
        }

        public String getHtmlDisplayName() {
            return this.getName(true);
        }

        public String getName() {
            return this.getName(false);
        }

        public String getName(boolean html) {
            StringBuilder sb = new StringBuilder();
            if (this.active && html) {
                sb.append("<html><strong>").append(this.tagName).append("</strong>");
            } else {
                sb.append(this.tagName);
            }
            if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_COMMIT_IDS)) {
                sb.append(" - ").append(this.revisionId);
            }
            return sb.toString();
        }

        private void refreshActiveBranch(GitBranch activeBranch) {
            String oldHtmlName = this.getHtmlDisplayName();
            this.active = activeBranch.getId().equals(this.revisionId);
            String newHtmlName = this.getHtmlDisplayName();
            if (!oldHtmlName.equals(newHtmlName)) {
                this.fireDisplayNameChange(null, null);
            }
        }

        public String getShortDescription() {
            return this.message;
        }

        @Override
        protected Action[] getPopupActions(boolean context) {
            LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
            actions.add(new AbstractAction(NbBundle.getMessage(RepositoryBrowserAction.class, (String)"LBL_RepositoryBrowser.tagNode.showDetails")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Utils.postParallel((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ManageTagsAction action = (ManageTagsAction)SystemAction.get(ManageTagsAction.class);
                            action.showTagManager(RepositoryBrowserPanel.this.currRepository, TagNode.this.tagName);
                        }
                    }, (int)0);
                }
            });
            actions.add(new AbstractAction(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Utils.postParallel((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CheckoutRevisionAction action = (CheckoutRevisionAction)SystemAction.get(CheckoutRevisionAction.class);
                            action.checkoutRevision(RepositoryBrowserPanel.this.currRepository, TagNode.this.tagName);
                        }
                    }, (int)0);
                }
            });
            actions.add(new AbstractAction(NbBundle.getMessage(CreateBranchAction.class, (String)"LBL_CreateBranchAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Utils.postParallel((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CreateBranchAction action = (CreateBranchAction)SystemAction.get(CreateBranchAction.class);
                            action.createBranch(RepositoryBrowserPanel.this.currRepository, TagNode.this.tagName);
                        }
                    }, (int)0);
                }
            });
            actions.add(new AbstractAction(NbBundle.getMessage(MergeRevisionAction.class, (String)"LBL_MergeRevisionAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Utils.postParallel((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MergeRevisionAction action = (MergeRevisionAction)SystemAction.get(MergeRevisionAction.class);
                            action.mergeRevision(RepositoryBrowserPanel.this.currRepository, TagNode.this.tagName);
                        }
                    }, (int)0);
                }

                @Override
                public boolean isEnabled() {
                    return !TagNode.this.active;
                }
            });
            return actions.toArray(new Action[actions.size()]);
        }
    }

    private class TagChildren
    extends Children.Keys<GitTag>
    implements PropertyChangeListener {
        private final Map<String, GitTag> tags = new TreeMap<String, GitTag>();
        private final File repository;

        private TagChildren(File repository) {
            this.repository = repository;
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)info));
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshTags();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        protected Node[] createNodes(GitTag key) {
            return new Node[]{new TagNode(this.repository, key)};
        }

        private void refreshTags() {
            new GitProgressSupport.NoOutputLogging(){

                @Override
                protected void perform() {
                    try {
                        GitClient client = this.getClient();
                        Map tags = client.getTags(NULL_PROGRESS_MONITOR, false);
                        if (!this.isCanceled()) {
                            TagChildren.this.refreshTags(tags);
                        }
                    }
                    catch (GitException ex) {
                        LOG.log(Level.INFO, "refreshTags()", ex);
                    }
                }
            }.start(RP, this.repository, NbBundle.getMessage(BranchesTopChildren.class, (String)"MSG_RepositoryPanel.refreshingTags"));
        }

        private void refreshTags(Map<String, GitTag> tags) {
            if (tags.isEmpty()) {
                this.tags.clear();
            } else {
                tags = new HashMap<String, GitTag>(tags);
                this.tags.keySet().retainAll(tags.keySet());
                for (Map.Entry<String, GitTag> e : this.tags.entrySet()) {
                    GitTag newTagInfo = tags.get(e.getKey());
                    if (newTagInfo == null || !newTagInfo.getTaggedObjectId().equals(e.getValue().getTaggedObjectId()) && !newTagInfo.getMessage().equals(e.getValue().getMessage())) continue;
                    tags.remove(e.getKey());
                }
                this.tags.putAll(tags);
            }
            this.setKeys(this.tags.values().toArray(new GitTag[this.tags.values().size()]));
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if ("prop.tags".equals(evt.getPropertyName())) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        TagChildren.this.refreshTags((Map)evt.getNewValue());
                    }
                });
            }
        }
    }

    private class TagsNode
    extends RepositoryBrowserNode {
        public TagsNode(File repository) {
            super((Children)new TagChildren(repository));
            assert (repository != null);
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/tags.png");
        }

        public String getDisplayName() {
            return this.getName();
        }

        public String getName() {
            return NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"LBL_RepositoryPanel.TagsNode.name");
        }

        @Override
        public Action[] getPopupActions(boolean context) {
            return new Action[]{new AbstractAction(NbBundle.getMessage(BranchesTopNode.class, (String)"LBL_RepositoryPanel.RefreshTagsAction.name")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TagChildren)TagsNode.this.getChildren()).refreshTags();
                }
            }};
        }
    }

    private class BranchNode
    extends RepositoryBrowserNode {
        private PropertyChangeListener list;
        private boolean active;
        private final String branchName;
        private String branchId;

        public BranchNode(File repository, GitBranch branch) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{new Revision(branch.getId(), branch.getName())}));
            this.branchName = branch.getName();
            this.branchId = branch.getId();
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/branch.png");
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            this.list = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("prop.activeBranch".equals(evt.getPropertyName()) || "prop.head".equals(evt.getPropertyName())) {
                        BranchNode.this.refreshActiveBranch((GitBranch)evt.getNewValue());
                    }
                }
            };
            info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.list, (Object)info));
            this.refreshActiveBranch(info.getActiveBranch());
        }

        public String getDisplayName() {
            return this.getName(false);
        }

        public String getHtmlDisplayName() {
            return this.getName(true);
        }

        public String getName() {
            return this.getName(false);
        }

        public String getName(boolean html) {
            StringBuilder sb = new StringBuilder();
            if (this.active && html) {
                sb.append("<html><strong>").append(this.branchName).append("</strong>");
            } else {
                sb.append(this.branchName);
            }
            if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_COMMIT_IDS)) {
                sb.append(" - ").append(this.branchId);
            }
            return sb.toString();
        }

        private void refreshActiveBranch(GitBranch activeBranch) {
            String newHtmlName;
            String oldHtmlName = this.getHtmlDisplayName();
            boolean oldActive = this.active;
            if (activeBranch.getName().equals(this.branchName)) {
                this.active = true;
                this.branchId = activeBranch.getId();
            } else {
                this.active = false;
            }
            if (this.active != oldActive) {
                this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/" + (this.active ? "active_branch" : "branch") + ".png");
            }
            if (!oldHtmlName.equals(newHtmlName = this.getHtmlDisplayName())) {
                this.fireDisplayNameChange(null, null);
            }
        }

        @Override
        protected Action[] getPopupActions(boolean context) {
            LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
            actions.add(new AbstractAction(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Utils.postParallel((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CheckoutRevisionAction action = (CheckoutRevisionAction)SystemAction.get(CheckoutRevisionAction.class);
                            action.checkoutRevision(RepositoryBrowserPanel.this.currRepository, BranchNode.this.branchName);
                        }
                    }, (int)0);
                }
            });
            actions.add(new AbstractAction(NbBundle.getMessage(CreateBranchAction.class, (String)"LBL_CreateBranchAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Utils.postParallel((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CreateBranchAction action = (CreateBranchAction)SystemAction.get(CreateBranchAction.class);
                            action.createBranch(RepositoryBrowserPanel.this.currRepository, BranchNode.this.branchName);
                        }
                    }, (int)0);
                }
            });
            actions.add(new AbstractAction(NbBundle.getMessage(CreateTagAction.class, (String)"LBL_CreateTagAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreateTagAction action = (CreateTagAction)SystemAction.get(CreateTagAction.class);
                    action.createTag(RepositoryBrowserPanel.this.currRepository, BranchNode.this.branchName);
                }
            });
            actions.add(new AbstractAction(NbBundle.getMessage(MergeRevisionAction.class, (String)"LBL_MergeRevisionAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Utils.postParallel((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MergeRevisionAction action = (MergeRevisionAction)SystemAction.get(MergeRevisionAction.class);
                            action.mergeRevision(RepositoryBrowserPanel.this.currRepository, BranchNode.this.branchName);
                        }
                    }, (int)0);
                }

                @Override
                public boolean isEnabled() {
                    return !BranchNode.this.active;
                }
            });
            actions.add(new AbstractAction(NbBundle.getMessage(DeleteBranchAction.class, (String)"LBL_DeleteBranchAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeleteBranchAction action = (DeleteBranchAction)SystemAction.get(DeleteBranchAction.class);
                    action.deleteBranch(RepositoryBrowserPanel.this.currRepository, BranchNode.this.branchName);
                }

                @Override
                public boolean isEnabled() {
                    return !BranchNode.this.active;
                }
            });
            return actions.toArray(new Action[actions.size()]);
        }
    }

    private class BranchesChildren
    extends Children.Keys<GitBranch> {
        private final BranchNodeType type;
        private final Map<String, GitBranch> branches;

        private BranchesChildren(BranchNodeType type, Map<String, GitBranch> branches) {
            this.type = type;
            this.branches = branches;
        }

        protected void addNotify() {
            super.addNotify();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    BranchesChildren.this.refreshKeys();
                }
            });
        }

        protected Node[] createNodes(GitBranch key) {
            Node node = this.getNode();
            while (!(node instanceof RepositoryNode)) {
                node = node.getParentNode();
            }
            File repository = ((RepositoryNode)node).getRepository();
            return new Node[]{new BranchNode(repository, key)};
        }

        private void refreshKeys() {
            LinkedList<GitBranch> keys = new LinkedList<GitBranch>();
            for (Map.Entry<String, GitBranch> e : this.branches.entrySet()) {
                GitBranch branch = e.getValue();
                if ((this.type != BranchNodeType.REMOTE || !branch.isRemote()) && (this.type != BranchNodeType.LOCAL || branch.isRemote())) continue;
                keys.add(branch);
            }
            this.setKeys(keys);
        }
    }

    private class BranchesNode
    extends RepositoryBrowserNode {
        private final BranchNodeType type;

        private BranchesNode(BranchNodeType type, Map<String, GitBranch> branches) {
            super((Children)new BranchesChildren(type, branches));
            this.type = type;
        }

        private void refresh() {
            ((BranchesChildren)this.getChildren()).refreshKeys();
        }

        public String getName() {
            return this.type.toString();
        }

        public String getDisplayName() {
            return this.getName();
        }

        public Image getIcon(int type) {
            return this.getFolderIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.getOpenedFolderIcon(type);
        }
    }

    private class BranchesTopChildren
    extends Children.Keys<BranchNodeType>
    implements PropertyChangeListener {
        private final File repository;
        private Map<String, GitBranch> branches = new TreeMap<String, GitBranch>();
        private BranchesNode local;
        private BranchesNode remote;

        private BranchesTopChildren(File repository) {
            this.repository = repository;
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            if (info == null) {
                LOG.log(Level.INFO, "BranchesTopChildren() : Null info for {0}", repository);
            } else {
                info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)info));
            }
        }

        protected void addNotify() {
            super.addNotify();
            LinkedList<BranchNodeType> keys = new LinkedList<BranchNodeType>();
            if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_BRANCHES_LOCAL)) {
                keys.add(BranchNodeType.LOCAL);
            }
            if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_BRANCHES_REMOTE)) {
                keys.add(BranchNodeType.REMOTE);
            }
            this.setKeys(keys);
            this.refreshBranches();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        protected Node[] createNodes(BranchNodeType key) {
            BranchesNode node;
            switch (key) {
                case LOCAL: {
                    node = this.local = new BranchesNode(key, this.branches);
                    break;
                }
                case REMOTE: {
                    node = this.remote = new BranchesNode(key, this.branches);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return new Node[]{node};
        }

        private void refreshBranches() {
            new GitProgressSupport.NoOutputLogging(){

                @Override
                protected void perform() {
                    try {
                        GitClient client = this.getClient();
                        Map branches = client.getBranches(true, (ProgressMonitor)this);
                        if (!this.isCanceled()) {
                            BranchesTopChildren.this.refreshBranches(branches);
                        }
                    }
                    catch (GitException ex) {
                        LOG.log(Level.INFO, "refreshBranches()", ex);
                    }
                }
            }.start(RP, this.repository, NbBundle.getMessage(BranchesTopChildren.class, (String)"MSG_RepositoryPanel.refreshingBranches"));
        }

        private void refreshBranches(Map<String, GitBranch> branches) {
            if (branches.isEmpty()) {
                this.branches.clear();
            } else {
                branches = new HashMap<String, GitBranch>(branches);
                this.branches.keySet().retainAll(branches.keySet());
                for (Map.Entry<String, GitBranch> e : this.branches.entrySet()) {
                    GitBranch newBranchInfo = branches.get(e.getKey());
                    if (newBranchInfo == null || !newBranchInfo.getId().equals(e.getValue().getId()) && newBranchInfo.isActive() != e.getValue().isActive()) continue;
                    branches.remove(e.getKey());
                }
                this.branches.putAll(branches);
            }
            if (this.local != null) {
                this.local.refresh();
            }
            if (this.remote != null) {
                this.remote.refresh();
            }
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if ("prop.branches".equals(evt.getPropertyName())) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        BranchesTopChildren.this.refreshBranches((Map)evt.getNewValue());
                    }
                });
            }
        }
    }

    private static enum BranchNodeType {
        LOCAL{

            public String toString() {
                return NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"LBL_RepositoryPanel.BranchesChildren.LocalNode.name");
            }
        }
        ,
        REMOTE{

            public String toString() {
                return NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"LBL_RepositoryPanel.BranchesChildren.RemoteNode.name");
            }
        };

    }

    private class BranchesTopNode
    extends RepositoryBrowserNode {
        public BranchesTopNode(File repository) {
            super((Children)new BranchesTopChildren(repository));
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/branches.png");
        }

        public String getDisplayName() {
            return this.getName();
        }

        public String getName() {
            return NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"LBL_RepositoryPanel.BranchesNode.name");
        }

        @Override
        public Action[] getPopupActions(boolean context) {
            return new Action[]{new AbstractAction(NbBundle.getMessage(BranchesTopNode.class, (String)"LBL_RepositoryPanel.RefreshBranchesAction.name")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((BranchesTopChildren)BranchesTopNode.this.getChildren()).refreshBranches();
                }
            }};
        }
    }

    private class RepositoryChildren
    extends Children.Keys<AbstractNode> {
        boolean initialized = false;

        private RepositoryChildren() {
        }

        protected void addNotify() {
            super.addNotify();
            if (!this.initialized) {
                this.initialized = true;
                LinkedList<RepositoryBrowserNode> keys = new LinkedList<RepositoryBrowserNode>();
                if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_BRANCHES_LOCAL) || RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_BRANCHES_REMOTE)) {
                    keys.add(new BranchesTopNode(((RepositoryNode)this.getNode()).getRepository()));
                }
                if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_TAGS)) {
                    keys.add(new TagsNode(((RepositoryNode)this.getNode()).getRepository()));
                }
                if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_REMOTES)) {
                    keys.add(new RemotesNode(((RepositoryNode)this.getNode()).getRepository()));
                }
                this.setKeys(keys);
            }
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        protected Node[] createNodes(AbstractNode key) {
            return new Node[]{key};
        }
    }

    private class RepositoryNode
    extends RepositoryBrowserNode
    implements PropertyChangeListener {
        private PropertyChangeListener list;
        private final File repository;

        public RepositoryNode(final File repository, RepositoryInfo info) {
            super((Children)new RepositoryChildren(), Lookups.fixed((Object[])new Object[]{repository}));
            this.repository = repository;
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/repository.png");
            if (info == null) {
                this.setDisplayName(repository.getName());
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        RepositoryInfo info = RepositoryInfo.getInstance(repository);
                        if (info == null) {
                            LOG.log(Level.INFO, "RepositoryNode() : Null info for {0}", repository);
                        } else {
                            RepositoryNode.this.setName(info);
                            info.addPropertyChangeListener(RepositoryNode.this.list = WeakListeners.propertyChange((PropertyChangeListener)RepositoryNode.this, (Object)info));
                        }
                    }
                });
            } else {
                this.setName(info);
                this.list = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)info);
                info.addPropertyChangeListener(this.list);
            }
        }

        private void setName(RepositoryInfo info) {
            GitRepositoryState repositoryState;
            String branchLabel = "";
            GitBranch branch = info.getActiveBranch();
            if (branch != null && (branchLabel = branch.getName()) == "(no branch)") {
                Map<String, GitTag> tags = info.getTags();
                StringBuilder tagLabel = new StringBuilder();
                for (GitTag tag : tags.values()) {
                    if (!tag.getTaggedObjectId().equals(branch.getId())) continue;
                    tagLabel.append(",").append(tag.getTagName());
                }
                if (tagLabel.length() <= 1) {
                    branchLabel = branch.getId();
                    if (branchLabel.length() > 7) {
                        branchLabel = branchLabel.substring(0, 7) + "...";
                    }
                } else {
                    tagLabel.delete(0, 1);
                    branchLabel = tagLabel.toString();
                }
            }
            String annotation = (repositoryState = info.getRepositoryState()) != GitRepositoryState.SAFE ? repositoryState.toString() + " - " + branchLabel : branchLabel;
            this.setDisplayName(info.getName() + " [" + annotation + "]");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof RepositoryInfo) {
                this.setName((RepositoryInfo)evt.getSource());
            }
        }

        public String toString() {
            return this.getDisplayName();
        }

        public File getRepository() {
            return this.repository;
        }

        @Override
        protected Action[] getPopupActions(boolean context) {
            return new Action[]{SystemAction.get(FetchAction.class)};
        }
    }

    private class RepositoriesChildren
    extends Children.SortedMap<File> {
        private final PropertyChangeListener list;
        private boolean initialized = false;

        public RepositoriesChildren() {
            this.setComparator(new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            this.list = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Set oldValues = (Set)evt.getOldValue();
                    final Set newValues = (Set)evt.getNewValue();
                    if (oldValues.size() > newValues.size()) {
                        oldValues.removeAll(newValues);
                        RepositoriesChildren.this.removeAll(oldValues);
                    } else if (oldValues.size() < newValues.size()) {
                        newValues.removeAll(oldValues);
                        RP.post(new Runnable(){

                            @Override
                            public void run() {
                                HashMap<File, RepositoryNode> nodes = new HashMap<File, RepositoryNode>();
                                for (File r : newValues) {
                                    RepositoryInfo info = RepositoryInfo.getInstance(r);
                                    if (info == null) {
                                        LOG.log(Level.INFO, "RepositoriesChildren.propertyChange() : Null info for {0}", r);
                                        continue;
                                    }
                                    nodes.put(r, new RepositoryNode(r, info));
                                }
                                RepositoriesChildren.this.putAll(nodes);
                            }
                        });
                    }
                }
            };
            GitRepositories.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.list, (Object)GitRepositories.getInstance()));
        }

        protected void addNotify() {
            super.addNotify();
            if (!this.initialized) {
                this.initialized = true;
                this.list.propertyChange(new PropertyChangeEvent(GitRepositories.getInstance(), "GitRepositories.repositories", Collections.emptySet(), GitRepositories.getInstance().getKnownRepositories()));
            }
        }
    }

    private abstract class RepositoryBrowserNode
    extends AbstractNode {
        protected RepositoryBrowserNode(Children children) {
            this(children, null);
        }

        protected RepositoryBrowserNode(Children children, Lookup lookup) {
            super(children, lookup);
        }

        public final Action[] getActions(boolean context) {
            return RepositoryBrowserPanel.this.options.contains((Object)Option.ENABLE_POPUP) ? this.getPopupActions(context) : this.getPopupActions(context);
        }

        protected Action[] getPopupActions(boolean context) {
            return new Action[0];
        }

        protected Image getFolderIcon(int type) {
            Image img = null;
            if (type == 1) {
                img = this.findIcon("Nb.Explorer.Folder.icon", "Tree.closedIcon");
            }
            if (img == null) {
                img = super.getIcon(type);
            }
            return img;
        }

        protected Image getOpenedFolderIcon(int type) {
            Image img = null;
            if (type == 1) {
                img = this.findIcon("Nb.Explorer.Folder.openedIcon", "Tree.openIcon");
            }
            if (img == null) {
                img = super.getOpenedIcon(type);
            }
            return img;
        }

        private Image findIcon(String key1, String key2) {
            Image img;
            Image image = img = cachedIcons.containsKey(key1) ? (Image)cachedIcons.get(key1) : null;
            if (img == null) {
                img = this.findIcon(key1);
                if (img == null) {
                    img = this.findIcon(key2);
                }
                cachedIcons.put(key1, img);
            }
            return img;
        }

        private Image findIcon(String key) {
            Object obj = UIManager.get(key);
            if (obj instanceof Image) {
                return (Image)obj;
            }
            if (obj instanceof Icon) {
                Icon icon = (Icon)obj;
                return ImageUtilities.icon2Image((Icon)icon);
            }
            return null;
        }
    }

    public static enum Option {
        DISPLAY_ALL_REPOSITORIES,
        DISPLAY_BRANCHES_LOCAL,
        DISPLAY_BRANCHES_REMOTE,
        DISPLAY_COMMIT_IDS,
        DISPLAY_REMOTES,
        DISPLAY_REVISIONS,
        DISPLAY_TAGS,
        DISPLAY_TOOLBAR,
        ENABLE_POPUP;

    }
}

