/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.GitUser;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.diff.ExportCommitAction;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.netbeans.modules.git.ui.revert.RevertCommitAction;
import org.netbeans.modules.git.ui.tag.CreateTagAction;
import org.netbeans.modules.git.ui.tag.ManageTagsAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.netbeans.modules.versioning.util.VCSHyperlinkSupport;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

class SummaryView
implements MouseListener,
ComponentListener,
MouseMotionListener {
    private static final String SUMMARY_DIFF_PROPERTY = "Summary-Diff-";
    private final SearchHistoryPanel master;
    private JList resultsList;
    private JScrollPane scrollPane;
    private final List dispResults;
    private String message;
    private AttributeSet searchHiliteAttrs;
    private List<RepositoryRevision> results;
    private Map<String, VCSKenaiAccessor.KenaiUser> kenaiUsersMap = null;
    private VCSHyperlinkSupport linkerSupport = new VCSHyperlinkSupport();
    private static final Logger LOG = Logger.getLogger(SummaryView.class.getName());

    public SummaryView(SearchHistoryPanel master, List<RepositoryRevision> results) {
        this.master = master;
        this.results = results;
        this.dispResults = this.expandResults(results);
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fcs.getFontColors("highlight-search");
        this.message = master.getCriteria().getCommitMessage();
        this.resultsList = new JList(new SummaryListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.addMouseListener(this);
        this.resultsList.addMouseMotionListener(this);
        this.resultsList.setCellRenderer(new SummaryCellRenderer());
        this.resultsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsList, 22, 31);
        master.addComponentListener(this);
        this.resultsList.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.resultsList.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryView.this.onPopup(Utils.getPositionForPopup((JList)SummaryView.this.resultsList));
            }
        });
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int[] selection = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SummaryListModel());
        this.resultsList.setSelectedIndices(selection);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private List expandResults(List<RepositoryRevision> results) {
        ArrayList<Object> newResults = new ArrayList<Object>(results.size());
        for (RepositoryRevision repositoryRevision : results) {
            newResults.add(repositoryRevision);
            if (!this.master.isShowInfo()) continue;
            List<RepositoryRevision.Event> events = repositoryRevision.getEvents();
            for (RepositoryRevision.Event event : events) {
                newResults.add(event);
            }
        }
        return newResults;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        Rectangle diffBounds = (Rectangle)this.resultsList.getClientProperty(SUMMARY_DIFF_PROPERTY + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.diffPrevious(idx);
        }
        this.linkerSupport.mouseClicked(p, idx);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        this.resultsList.setCursor(Cursor.getPredefinedCursor(0));
        this.resultsList.setToolTipText("");
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        Rectangle diffBounds = (Rectangle)this.resultsList.getClientProperty(SUMMARY_DIFF_PROPERTY + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        this.linkerSupport.mouseMoved(p, (JComponent)this.resultsList, idx);
    }

    private void onPopup(MouseEvent e) {
        this.onPopup(e.getPoint());
    }

    private void onPopup(Point p) {
        boolean viewEnabled;
        RepositoryRevision.Event[] drev;
        RepositoryRevision container;
        boolean revisionSelected;
        int[] sel = this.resultsList.getSelectedIndices();
        if (sel.length <= 1) {
            int idx = this.resultsList.locationToIndex(p);
            if (idx == -1) {
                return;
            }
            this.resultsList.setSelectedIndex(idx);
            sel = new int[]{idx};
        }
        final int[] selection = sel;
        JPopupMenu menu = new JPopupMenu();
        Object revCon = this.dispResults.get(selection[0]);
        boolean missingFile = false;
        boolean oneRevisionMultiselected = true;
        if (revCon instanceof RepositoryRevision) {
            revisionSelected = true;
            container = (RepositoryRevision)this.dispResults.get(selection[0]);
            drev = new RepositoryRevision.Event[]{};
            oneRevisionMultiselected = true;
        } else {
            revisionSelected = false;
            drev = new RepositoryRevision.Event[selection.length];
            for (int i = 0; i < selection.length; ++i) {
                drev[i] = (RepositoryRevision.Event)this.dispResults.get(selection[i]);
                if (!missingFile && drev[i].getFile() == null) {
                    missingFile = true;
                }
                if (!oneRevisionMultiselected || i <= 0 || !drev[0].getLogInfoHeader().getLog().getRevision().equals(drev[i].getLogInfoHeader().getLog().getRevision())) continue;
                oneRevisionMultiselected = false;
            }
            container = drev[0].getLogInfoHeader();
        }
        boolean hasParents = container.getLog().getParents().length > 0;
        final boolean singleSelection = selection.length == 1;
        boolean bl = viewEnabled = singleSelection && !revisionSelected && drev[0].getFile() != null && !drev[0].getFile().isDirectory();
        if (hasParents) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious")){
                {
                    super(x0);
                    this.setEnabled(singleSelection);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.diffPrevious(selection[0]);
                }
            }));
        }
        if (revisionSelected) {
            if (singleSelection) {
                menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(CreateTagAction.class, (String)"LBL_CreateTagAction_PopupName.revision", (Object)container.getLog().getRevision().substring(0, 7))){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CreateTagAction action = (CreateTagAction)SystemAction.get(CreateTagAction.class);
                        action.createTag(SummaryView.this.master.getRepository(), container.getLog().getRevision());
                    }
                }));
                if (container.getLog().getParents().length < 2) {
                    menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(ExportCommitAction.class, (String)"LBL_ExportCommitAction_PopupName")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExportCommitAction action = (ExportCommitAction)SystemAction.get(ExportCommitAction.class);
                            action.exportCommit(SummaryView.this.master.getRepository(), container.getLog().getRevision());
                        }
                    }));
                    menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(RevertCommitAction.class, (String)"LBL_RevertCommitAction_PopupName")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RevertCommitAction action = (RevertCommitAction)SystemAction.get(RevertCommitAction.class);
                            action.revert(SummaryView.this.master.getRepository(), SummaryView.this.master.getRoots(), container.getLog().getRevision());
                        }
                    }));
                }
            }
        } else {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    new GitProgressSupport(){

                        @Override
                        protected void perform() {
                            for (RepositoryRevision.Event evt : drev) {
                                try {
                                    File originalFile = evt.getFile();
                                    String revision = evt.getLogInfoHeader().getLog().getRevision();
                                    GitUtils.openInRevision(originalFile, revision, false, this);
                                }
                                catch (IOException ex) {
                                    LOG.log(Level.FINE, null, ex);
                                }
                            }
                        }
                    }.start(Git.getInstance().getRequestProcessor(), SummaryView.this.master.getRepository(), NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ShowAnnotations")){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    new GitProgressSupport(){

                        @Override
                        protected void perform() {
                            for (RepositoryRevision.Event evt : drev) {
                                try {
                                    File originalFile = evt.getFile();
                                    String revision = evt.getLogInfoHeader().getLog().getRevision();
                                    GitUtils.openInRevision(originalFile, revision, true, this);
                                }
                                catch (IOException ex) {
                                    LOG.log(Level.FINE, null, ex);
                                }
                            }
                        }
                    }.start(Git.getInstance().getRequestProcessor(), SummaryView.this.master.getRepository(), NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
                }
            }));
        }
        menu.show(this.resultsList, p.x, p.y);
    }

    private void diffPrevious(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event drev = (RepositoryRevision.Event)o;
            this.master.showDiff(drev);
        } else {
            RepositoryRevision container = (RepositoryRevision)o;
            this.master.showDiff(container);
        }
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    private static final class TagAliasLinker
    extends AliasLinker {
        private final File repository;

        private TagAliasLinker(File repository, StyledDocument sd, RepositoryRevision container) {
            super(sd, TagAliasLinker.computeLabels(container), true);
            this.repository = repository;
        }

        private static List<String> computeLabels(RepositoryRevision container) {
            ArrayList<String> labels = new ArrayList<String>(container.getTags().length);
            for (GitTag b : container.getTags()) {
                labels.add(b.getTagName());
            }
            Collections.sort(labels);
            return labels;
        }

        @Override
        protected String getToolTip(String label) {
            return NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView.tagAlias.TT", (Object)label);
        }

        @Override
        protected boolean mouseClicked(String label) {
            ManageTagsAction action = (ManageTagsAction)SystemAction.get(ManageTagsAction.class);
            action.showTagManager(this.repository, label);
            return true;
        }
    }

    private static final class BranchAliasLinker
    extends AliasLinker {
        private BranchAliasLinker(StyledDocument sd, RepositoryRevision container) {
            super(sd, BranchAliasLinker.computeLabels(container), false);
        }

        private static List<String> computeLabels(RepositoryRevision container) {
            LinkedList<String> labels = new LinkedList<String>();
            for (boolean remote : new boolean[]{false, true}) {
                ArrayList<String> toSort = new ArrayList<String>(container.getBranches().length);
                for (GitBranch b : container.getBranches()) {
                    if (remote != b.isRemote() || b.getName() == "(no branch)") continue;
                    toSort.add(b.getName());
                }
                Collections.sort(toSort);
                labels.addAll(toSort);
            }
            return labels;
        }

        @Override
        protected String getToolTip(String label) {
            return NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView.branchAlias.TT", (Object)label);
        }
    }

    private static final class RefAliasLinker
    extends AliasLinker {
        private RefAliasLinker(StyledDocument sd, RepositoryRevision container) {
            super(sd, RefAliasLinker.computeLabels(container), false);
        }

        private static List<String> computeLabels(RepositoryRevision container) {
            LinkedList<String> refs = new LinkedList<String>();
            for (GitBranch b : container.getBranches()) {
                if (!b.isActive()) continue;
                refs.add("HEAD");
            }
            return refs;
        }
    }

    private static abstract class AliasLinker
    extends VCSHyperlinkSupport.StyledDocumentHyperlink {
        private Rectangle[] bounds = new Rectangle[0];
        private final String[] labels;
        private final int docLen;
        private final boolean supportsClick;

        private AliasLinker(StyledDocument sd, List<String> labels, boolean supportsClick) {
            this.labels = labels.toArray(new String[labels.size()]);
            this.supportsClick = supportsClick;
            this.docLen = sd.getLength();
        }

        public void computeBounds(JTextPane textPane) {
            Rectangle tpBounds = textPane.getBounds();
            TextUI tui = textPane.getUI();
            this.bounds = new Rectangle[this.labels.length];
            int i = 0;
            int labelStartPos = this.docLen;
            for (String label : this.labels) {
                try {
                    Rectangle startr = tui.modelToView(textPane, labelStartPos, Position.Bias.Forward).getBounds();
                    Rectangle endr = tui.modelToView(textPane, labelStartPos += label.length(), Position.Bias.Backward).getBounds();
                    this.bounds[i] = new Rectangle(tpBounds.x + startr.x, startr.y, endr.x - startr.x, startr.height);
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
                ++i;
                ++labelStartPos;
            }
        }

        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null) {
                for (int i = 0; i < this.bounds.length; ++i) {
                    String toolTip;
                    if (!this.bounds[i].contains(p)) continue;
                    if (this.supportsClick) {
                        component.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    if ((toolTip = this.getToolTip(this.labels[i])) != null && !toolTip.isEmpty()) {
                        component.setToolTipText(toolTip);
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean mouseClicked(Point p) {
            if (this.supportsClick && this.bounds != null) {
                for (int i = 0; i < this.bounds.length; ++i) {
                    if (!this.bounds[i].contains(p)) continue;
                    return this.mouseClicked(this.labels[i]);
                }
            }
            return false;
        }

        public void insertString(StyledDocument sd, Style style) throws BadLocationException {
            for (String label : this.labels) {
                sd.insertString(sd.getLength(), label + " ", style);
            }
        }

        protected boolean mouseClicked(String label) {
            return false;
        }

        protected String getToolTip(String label) {
            return null;
        }
    }

    private static class HyperlinkLabel
    extends JLabel {
        public HyperlinkLabel() {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void set(String text, Color foreground, Color background) {
            StringBuilder sb = new StringBuilder(100);
            if (foreground.equals(UIManager.getColor("List.foreground"))) {
                sb.append("<html><a href=\"\">");
                sb.append(text);
                sb.append("</a>");
            } else {
                sb.append("<html><a href=\"\" style=\"color:");
                sb.append("rgb(");
                sb.append(foreground.getRed());
                sb.append(",");
                sb.append(foreground.getGreen());
                sb.append(",");
                sb.append(foreground.getBlue());
                sb.append(")");
                sb.append("\">");
                sb.append(text);
                sb.append("</a>");
            }
            this.setText(sb.toString());
            this.setBackground(background);
        }
    }

    private class SummaryCellRenderer
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private RevisionRenderer rr = new RevisionRenderer();
        private ChangepathRenderer cpr = new ChangepathRenderer();

        private SummaryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof RepositoryRevision) {
                return this.rr.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
            return this.cpr.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }

        private class ChangepathRenderer
        extends DefaultListCellRenderer {
            private ChangepathRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                RepositoryRevision.Event revisionEvent = (RepositoryRevision.Event)value;
                StringBuilder sb = new StringBuilder();
                sb.append(SummaryCellRenderer.FIELDS_SEPARATOR);
                sb.append(String.valueOf(revisionEvent.getAction()));
                sb.append(SummaryCellRenderer.FIELDS_SEPARATOR);
                sb.append(revisionEvent.getPath());
                Component renderer = super.getListCellRendererComponent((JList<?>)list, sb.toString(), index, isSelected, isSelected);
                if (renderer instanceof JLabel) {
                    ((JLabel)renderer).setToolTipText(sb.toString());
                }
                return renderer;
            }
        }

        private class RevisionRenderer
        extends JPanel
        implements ListCellRenderer {
            private static final double DARKEN_FACTOR = 0.95;
            private Style selectedStyle;
            private Style normalStyle;
            private Style filenameStyle;
            private Style indentStyle;
            private Style noindentStyle;
            private Style hiliteStyle;
            private Style issueHyperlinkStyle;
            private final Style authorStyle;
            private Color selectionBackground;
            private Color selectionForeground;
            private JTextPane textPane = new JTextPane();
            private JPanel actionsPane = new JPanel();
            private DateFormat defaultFormat;
            private int index;
            private HyperlinkLabel diffLink;

            public RevisionRenderer() {
                this.selectionBackground = new JList().getSelectionBackground();
                this.selectionForeground = new JList().getSelectionForeground();
                this.selectedStyle = this.textPane.addStyle("selected", null);
                StyleConstants.setForeground(this.selectedStyle, this.selectionForeground);
                StyleConstants.setBackground(this.selectedStyle, this.selectionBackground);
                this.normalStyle = this.textPane.addStyle("normal", null);
                StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
                this.filenameStyle = this.textPane.addStyle("filename", this.normalStyle);
                StyleConstants.setBold(this.filenameStyle, true);
                this.indentStyle = this.textPane.addStyle("indent", null);
                StyleConstants.setLeftIndent(this.indentStyle, 50.0f);
                this.noindentStyle = this.textPane.addStyle("noindent", null);
                StyleConstants.setLeftIndent(this.noindentStyle, 0.0f);
                this.defaultFormat = DateFormat.getDateTimeInstance();
                this.issueHyperlinkStyle = this.textPane.addStyle("issuehyperlink", this.normalStyle);
                StyleConstants.setForeground(this.issueHyperlinkStyle, Color.BLUE);
                StyleConstants.setUnderline(this.issueHyperlinkStyle, true);
                this.authorStyle = this.textPane.addStyle("author", this.normalStyle);
                StyleConstants.setForeground(this.authorStyle, Color.BLUE);
                this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
                Color c = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background);
                if (c != null) {
                    StyleConstants.setBackground(this.hiliteStyle, c);
                }
                if ((c = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground)) != null) {
                    StyleConstants.setForeground(this.hiliteStyle, c);
                }
                this.setLayout(new BorderLayout());
                this.add(this.textPane);
                this.add((Component)this.actionsPane, "Last");
                this.actionsPane.setLayout(new FlowLayout(4, 2, 5));
                this.diffLink = new HyperlinkLabel();
                this.diffLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
                this.actionsPane.add(this.diffLink);
                this.textPane.setBorder(null);
            }

            public Color darker(Color c) {
                return new Color(Math.max((int)((double)c.getRed() * 0.95), 0), Math.max((int)((double)c.getGreen() * 0.95), 0), Math.max((int)((double)c.getBlue() * 0.95), 0));
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.renderContainer(list, (RepositoryRevision)value, index, isSelected);
                return this;
            }

            private void renderContainer(JList list, RepositoryRevision container, int index, boolean isSelected) {
                Style style;
                Color backgroundColor;
                Color foregroundColor;
                StyledDocument sd = this.textPane.getStyledDocument();
                if (isSelected) {
                    foregroundColor = this.selectionForeground;
                    backgroundColor = this.selectionBackground;
                    style = this.selectedStyle;
                } else {
                    foregroundColor = UIManager.getColor("List.foreground");
                    backgroundColor = UIManager.getColor("List.background");
                    backgroundColor = this.darker(backgroundColor);
                    style = this.normalStyle;
                }
                this.textPane.setBackground(backgroundColor);
                this.actionsPane.setBackground(backgroundColor);
                this.index = index;
                Lookup.Result hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
                Collection hpInstances = hpResult.allInstances();
                try {
                    int idx;
                    VCSKenaiAccessor.KenaiUser kenaiUser;
                    sd.remove(0, sd.getLength());
                    sd.setParagraphAttributes(0, sd.getLength(), this.noindentStyle, false);
                    this.addAliases(SummaryView.this.linkerSupport, sd, index, container);
                    String rev = container.getLog().getRevision();
                    sd.insertString(sd.getLength(), rev.length() > 7 ? rev.substring(0, 7) : rev, null);
                    sd.setCharacterAttributes(0, sd.getLength(), this.filenameStyle, false);
                    sd.insertString(sd.getLength(), SummaryCellRenderer.FIELDS_SEPARATOR, style);
                    GitUser user = container.getLog().getAuthor();
                    if (user == null) {
                        user = container.getLog().getCommitter();
                    }
                    String author = user.toString();
                    VCSHyperlinkSupport.StyledDocumentHyperlink l = (VCSHyperlinkSupport.StyledDocumentHyperlink)SummaryView.this.linkerSupport.getLinker(VCSHyperlinkSupport.AuthorLinker.class, index);
                    if (l == null && SummaryView.this.kenaiUsersMap != null && author != null && !"".equals(author) && (kenaiUser = (VCSKenaiAccessor.KenaiUser)SummaryView.this.kenaiUsersMap.get(author)) != null) {
                        l = new VCSHyperlinkSupport.AuthorLinker(kenaiUser, this.authorStyle, sd, author);
                        SummaryView.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, index);
                    }
                    if (l != null) {
                        l.insertString(sd, isSelected ? style : null);
                    } else {
                        sd.insertString(sd.getLength(), author, style);
                    }
                    sd.insertString(sd.getLength(), SummaryCellRenderer.FIELDS_SEPARATOR + this.defaultFormat.format(new Date(container.getLog().getCommitTime())), null);
                    String commitMessage = container.getLog().getFullMessage();
                    if (commitMessage.endsWith("\n")) {
                        commitMessage = commitMessage.substring(0, commitMessage.length() - 1);
                    }
                    sd.insertString(sd.getLength(), "\n", null);
                    l = (VCSHyperlinkSupport.StyledDocumentHyperlink)SummaryView.this.linkerSupport.getLinker(VCSHyperlinkSupport.IssueLinker.class, index);
                    if (l == null) {
                        for (VCSHyperlinkProvider hp : hpInstances) {
                            l = VCSHyperlinkSupport.IssueLinker.create((VCSHyperlinkProvider)hp, (Style)this.issueHyperlinkStyle, (File)SummaryView.this.master.getRoots()[0], (StyledDocument)sd, (String)commitMessage);
                            if (l == null) continue;
                            SummaryView.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, index);
                            break;
                        }
                    }
                    if (l != null) {
                        l.insertString(sd, style);
                    } else {
                        sd.insertString(sd.getLength(), commitMessage, style);
                    }
                    int msglen = commitMessage.length();
                    int doclen = sd.getLength();
                    if (SummaryView.this.message != null && !isSelected && (idx = commitMessage.indexOf(SummaryView.this.message)) != -1) {
                        sd.setCharacterAttributes(doclen - msglen + idx, SummaryView.this.message.length(), this.hiliteStyle, true);
                    }
                    this.resizePane(commitMessage, list.getFontMetrics(list.getFont()));
                    if (isSelected) {
                        sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
                    }
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                this.actionsPane.setVisible(true);
                this.diffLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Diff"), foregroundColor, backgroundColor);
            }

            private void resizePane(String text, FontMetrics fm) {
                int width;
                if (text == null) {
                    text = "";
                }
                if ((width = SummaryView.this.master.getWidth()) > 0) {
                    Rectangle2D rect = fm.getStringBounds(text, this.textPane.getGraphics());
                    int nlc = -1;
                    int i = 0;
                    while (i != -1) {
                        i = text.indexOf(10, i + 1);
                        ++nlc;
                    }
                    int lines = (int)(rect.getWidth() / (double)(width - 80) + 1.0);
                    int ph = fm.getHeight() * (lines + ++nlc) + 0;
                    this.textPane.setPreferredSize(new Dimension(width - 50, ph));
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.index == -1) {
                    return;
                }
                Rectangle apb = this.actionsPane.getBounds();
                Rectangle bounds = this.diffLink.getBounds();
                bounds.setBounds(bounds.x, bounds.y + apb.y, bounds.width, bounds.height);
                SummaryView.this.resultsList.putClientProperty(SummaryView.SUMMARY_DIFF_PROPERTY + this.index, bounds);
                SummaryView.this.linkerSupport.computeBounds(this.textPane, this.index);
            }

            private void addAliases(VCSHyperlinkSupport linkerSupport, StyledDocument sd, int index, RepositoryRevision container) throws BadLocationException {
                VCSHyperlinkSupport.StyledDocumentHyperlink l = (VCSHyperlinkSupport.StyledDocumentHyperlink)linkerSupport.getLinker(RefAliasLinker.class, index);
                if (l == null) {
                    l = new RefAliasLinker(sd, container);
                    linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, index);
                }
                l.insertString(sd, null);
                l = (VCSHyperlinkSupport.StyledDocumentHyperlink)linkerSupport.getLinker(BranchAliasLinker.class, index);
                if (l == null) {
                    l = new BranchAliasLinker(sd, container);
                    linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, index);
                }
                l.insertString(sd, null);
                l = (VCSHyperlinkSupport.StyledDocumentHyperlink)linkerSupport.getLinker(TagAliasLinker.class, index);
                if (l == null) {
                    l = new TagAliasLinker(SummaryView.this.master.getRepository(), sd, container);
                    linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, index);
                }
                l.insertString(sd, null);
            }
        }
    }

    private class SummaryListModel
    extends AbstractListModel {
        private SummaryListModel() {
        }

        @Override
        public int getSize() {
            return SummaryView.this.dispResults.size();
        }

        @Override
        public Object getElementAt(int index) {
            return SummaryView.this.dispResults.get(index);
        }
    }
}

