/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.history.DiffResultsView;
import org.netbeans.modules.git.ui.history.Divider;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.git.ui.history.SearchExecutor;
import org.netbeans.modules.git.ui.history.SummaryView;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class SearchHistoryPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ActionListener,
DocumentListener {
    private final File[] roots;
    private final SearchCriteriaPanel criteria;
    private Divider divider;
    private Action searchAction;
    private SearchExecutor currentSearch;
    private RequestProcessor.Task currentSearchTask;
    private boolean criteriaVisible;
    private boolean searchInProgress;
    private List<RepositoryRevision> results;
    private SummaryView summaryView;
    private DiffResultsView diffView;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private final File repository;
    private ExplorerManager explorerManager;
    final JButton bNext = new JButton();
    final JButton bPrev = new JButton();
    private JButton bSearch;
    private ButtonGroup buttonGroup1;
    final JCheckBox fileInfoCheckBox = new JCheckBox();
    private JPanel jPanel1;
    private JSeparator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar jToolBar1;
    private JPanel resultsPanel;
    private JPanel searchCriteriaPanel;
    private JToggleButton tbDiff;
    private JToggleButton tbSummary;

    public SearchHistoryPanel(File repository, File[] roots, SearchCriteriaPanel criteria) {
        this.roots = roots;
        this.repository = repository;
        this.criteria = criteria;
        this.criteriaVisible = true;
        this.explorerManager = new ExplorerManager();
        this.initComponents();
        this.setupComponents();
        this.aquaBackgroundWorkaround();
        this.refreshComponents(true);
    }

    private void aquaBackgroundWorkaround() {
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            Color color = UIManager.getColor("NbExplorerView.background");
            this.setBackground(color);
            this.jToolBar1.setBackground(color);
            this.resultsPanel.setBackground(color);
            this.jPanel1.setBackground(color);
            this.searchCriteriaPanel.setBackground(color);
            this.criteria.setBackground(color);
        }
    }

    public void disableFileChangesOption(boolean b) {
        this.fileInfoCheckBox.setEnabled(false);
        this.fileInfoCheckBox.setSelected(false);
    }

    boolean isShowInfo() {
        return this.fileInfoCheckBox.isSelected();
    }

    void setSearchCriteria(boolean b) {
        this.criteriaVisible = b;
        this.refreshComponents(false);
    }

    private void setupComponents() {
        File file;
        this.remove(this.jPanel1);
        this.divider = new Divider(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.divider, gridBagConstraints);
        this.searchCriteriaPanel.add(this.criteria);
        this.searchAction = new AbstractAction(NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_Search")){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_Search"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.executeSearch();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "search");
        this.getActionMap().put("search", this.searchAction);
        this.bSearch.setAction(this.searchAction);
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_Search"));
        Dimension d1 = this.tbSummary.getPreferredSize();
        Dimension d2 = this.tbDiff.getPreferredSize();
        if (d1.width > d2.width) {
            this.tbDiff.setPreferredSize(d1);
        }
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/git/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_DiffPanel_Next_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.diffView.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/git/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_DiffPanel_Prev_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.diffView.onPrevButton();
            }
        };
        this.bNext.setAction(this.nextAction);
        this.bPrev.setAction(this.prevAction);
        this.criteria.tfFrom.getDocument().addDocumentListener(this);
        this.criteria.tfTo.getDocument().addDocumentListener(this);
        this.getActionMap().put("jumpNext", this.nextAction);
        this.getActionMap().put("jumpPrev", this.prevAction);
        this.criteria.showMergesChkBox.setSelected(GitModuleConfig.getDefault().getShowHistoryMerges());
        if (this.roots.length == 1 && !(file = this.roots[0]).isFile()) {
            this.fileInfoCheckBox.setEnabled(false);
        }
        if (this.fileInfoCheckBox.isEnabled()) {
            this.fileInfoCheckBox.setSelected(GitModuleConfig.getDefault().getShowFileInfo());
        } else {
            this.fileInfoCheckBox.setSelected(true);
        }
        this.criteria.showMergesChkBox.setOpaque(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getID() == 1) {
            this.criteriaVisible = !this.criteriaVisible;
            this.refreshComponents(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (tc == null) {
                return;
            }
            tc.setActivatedNodes((Node[])evt.getNewValue());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void removeNotify() {
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    final void refreshComponents(boolean refreshResults) {
        if (refreshResults) {
            this.resultsPanel.removeAll();
            if (this.results == null) {
                if (this.searchInProgress) {
                    this.resultsPanel.add((Component)new NoContentPanel(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistory_Searching")));
                } else {
                    this.resultsPanel.add((Component)new NoContentPanel(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistory_NoResults")));
                }
            } else if (this.tbSummary.isSelected()) {
                if (this.summaryView == null) {
                    this.summaryView = new SummaryView(this, this.results);
                }
                this.resultsPanel.add(this.summaryView.getComponent());
            } else {
                if (this.diffView == null) {
                    this.diffView = new DiffResultsView(this, this.results);
                }
                this.resultsPanel.add(this.diffView.getComponent());
            }
            this.resultsPanel.revalidate();
            this.resultsPanel.repaint();
        }
        this.updateActions();
        this.divider.setArrowDirection(this.criteriaVisible ? 1 : 0);
        this.searchCriteriaPanel.setVisible(this.criteriaVisible);
        this.bSearch.setVisible(this.criteriaVisible);
        this.revalidate();
        this.repaint();
    }

    final void updateActions() {
        this.nextAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isNextEnabled());
        this.prevAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isPrevEnabled());
    }

    void setResults(List<RepositoryRevision> newResults) {
        this.setResults(newResults, false);
    }

    private void setResults(List<RepositoryRevision> newResults, boolean searching) {
        this.results = newResults;
        this.searchInProgress = searching;
        this.summaryView = null;
        this.diffView = null;
        this.refreshComponents(true);
    }

    public File[] getRoots() {
        return this.roots;
    }

    public SearchCriteriaPanel getCriteria() {
        return this.criteria;
    }

    void executeSearch() {
        this.cancelBackgroundTasks();
        this.setResults(null, true);
        this.currentSearch = new SearchExecutor(this);
        this.currentSearch.start(Git.getInstance().getRequestProcessor(), this.repository, NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress", (Object)this.repository));
    }

    void cancelBackgroundTasks() {
        if (this.currentSearch != null) {
            this.currentSearch.cancel();
        }
    }

    void showDiff(RepositoryRevision.Event revision) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(revision);
    }

    public void showDiff(RepositoryRevision container) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(container);
    }

    public static int compareRevisions(String r1, String r2) {
        int n2;
        int n1;
        StringTokenizer st1 = new StringTokenizer(r1, ".");
        StringTokenizer st2 = new StringTokenizer(r2, ".");
        do {
            if (!st1.hasMoreTokens()) {
                return st2.hasMoreTokens() ? -1 : 0;
            }
            if (st2.hasMoreTokens()) continue;
            return st1.hasMoreTokens() ? 1 : 0;
        } while ((n1 = Integer.parseInt(st1.nextToken())) == (n2 = Integer.parseInt(st2.nextToken())));
        return n2 - n1;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.searchCriteriaPanel = new JPanel();
        this.bSearch = new JButton();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.tbSummary = new JToggleButton();
        this.tbDiff = new JToggleButton();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JToolBar.Separator();
        this.resultsPanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        this.setLayout(new GridBagLayout());
        this.searchCriteriaPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.searchCriteriaPanel, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/git/ui/history/Bundle");
        this.bSearch.setToolTipText(bundle.getString("TT_Search"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.bSearch, gridBagConstraints);
        this.jPanel1.setPreferredSize(new Dimension(10, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonGroup1.add(this.tbSummary);
        this.tbSummary.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbSummary, (String)bundle.getString("CTL_ShowSummary"));
        this.tbSummary.setToolTipText(bundle.getString("TT_Summary"));
        this.tbSummary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.onViewToggle(evt);
            }
        });
        this.jToolBar1.add(this.tbSummary);
        this.buttonGroup1.add(this.tbDiff);
        Mnemonics.setLocalizedText((AbstractButton)this.tbDiff, (String)bundle.getString("CTL_ShowDiff"));
        this.tbDiff.setToolTipText(bundle.getString("TT_ShowDiff"));
        this.tbDiff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.onViewToggle(evt);
            }
        });
        this.jToolBar1.add(this.tbDiff);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jToolBar1.add(this.jSeparator2);
        this.bNext.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/git/resources/icons/diff-next.png")));
        this.jToolBar1.add(this.bNext);
        this.bNext.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_NextDifference"));
        this.bNext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryPanel.class, (String)"ACSD_NextDifference"));
        this.bPrev.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/git/resources/icons/diff-prev.png")));
        this.jToolBar1.add(this.bPrev);
        this.bPrev.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_PrevDifference"));
        this.bPrev.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryPanel.class, (String)"ACSD_PrevDifference"));
        this.jToolBar1.add(this.jSeparator3);
        Mnemonics.setLocalizedText((AbstractButton)this.fileInfoCheckBox, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistoryPanel_AllInfo"));
        this.fileInfoCheckBox.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_TT_SearchHistoryPanel_AllInfo"));
        this.fileInfoCheckBox.setHorizontalTextPosition(4);
        this.fileInfoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.fileInfoCheckBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.fileInfoCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.resultsPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.add((Component)this.resultsPanel, gridBagConstraints);
    }

    private void onViewToggle(ActionEvent evt) {
        this.refreshComponents(true);
    }

    private void fileInfoCheckBoxActionPerformed(ActionEvent evt) {
        GitModuleConfig.getDefault().setShowFileInfo(this.fileInfoCheckBox.isSelected() && this.fileInfoCheckBox.isEnabled());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    private void validateUserInput() {
        String from = this.criteria.getFrom();
        if (from == null && this.criteria.tfFrom.getText().trim().length() > 0) {
            this.bSearch.setEnabled(false);
            return;
        }
        String to = this.criteria.getTo();
        if (to == null && this.criteria.tfTo.getText().trim().length() > 0) {
            this.bSearch.setEnabled(false);
            return;
        }
        this.bSearch.setEnabled(true);
    }

    File getRepository() {
        return this.repository;
    }
}

