/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitFileInfo;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.client.GitClientExceptionHandler;

public class RepositoryRevision {
    private GitRevisionInfo message;
    private final List<Event> events = new ArrayList<Event>(1);
    private final Map<File, String> commonAncestors = new HashMap<File, String>();
    private final Set<GitTag> tags;
    private final Set<GitBranch> branches;

    public RepositoryRevision(GitRevisionInfo message, Set<GitTag> tags, Set<GitBranch> branches, Map<File, Set<File>> renames) {
        this.message = message;
        this.tags = tags;
        this.branches = branches;
        this.initEvents(renames);
    }

    RepositoryRevision(GitRevisionInfo message, Set<GitTag> tags, Set<GitBranch> branches, File dummyFile, String dummyFileRelativePath) {
        this.message = message;
        this.tags = tags;
        this.branches = branches;
        if (dummyFile != null && dummyFileRelativePath != null) {
            this.events.add(new Event(dummyFile, dummyFileRelativePath));
        }
    }

    private void initEvents(Map<File, Set<File>> allRenames) {
        try {
            Map paths = this.message.getModifiedFiles();
            if (paths == null || paths.isEmpty()) {
                return;
            }
            for (Map.Entry path : paths.entrySet()) {
                GitFileInfo info = (GitFileInfo)path.getValue();
                Set<File> renames = allRenames.get(info.getFile());
                if (renames == null) {
                    renames = Collections.emptySet();
                }
                if (info.getStatus().equals((Object)GitFileInfo.Status.COPIED) || info.getStatus().equals((Object)GitFileInfo.Status.RENAMED)) {
                    Set<File> combinedRenames = allRenames.get(info.getOriginalFile());
                    if (combinedRenames == null) {
                        combinedRenames = new HashSet<File>();
                        allRenames.put(info.getOriginalFile(), combinedRenames);
                    }
                    combinedRenames.add(info.getFile());
                    combinedRenames.addAll(renames);
                    renames = combinedRenames;
                }
                this.events.add(new Event(info, renames));
            }
        }
        catch (GitException ex) {
            GitClientExceptionHandler.notifyException((Exception)((Object)ex), false);
        }
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public GitRevisionInfo getLog() {
        return this.message;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(this.getLog().getRevision());
        text.append("\t");
        text.append(DateFormat.getDateTimeInstance().format(new Date(this.getLog().getCommitTime())));
        text.append("\t");
        text.append(this.getLog().getAuthor());
        text.append("\n");
        text.append(this.getLog().getShortMessage());
        return text.toString();
    }

    String getAncestorCommit(File file, GitClient client, ProgressMonitor pm) throws GitException {
        String ancestorCommit = this.commonAncestors.get(file);
        if (ancestorCommit == null && !this.commonAncestors.containsKey(file)) {
            GitRevisionInfo info = null;
            if (this.getLog().getParents().length == 1) {
                info = client.getPreviousRevision(file, this.getLog().getRevision(), pm);
            } else if (this.getLog().getParents().length > 1) {
                info = client.getCommonAncestor(this.getLog().getParents(), pm);
            }
            ancestorCommit = info == null ? null : info.getRevision();
            this.commonAncestors.put(file, ancestorCommit);
        }
        return ancestorCommit;
    }

    public GitBranch[] getBranches() {
        return this.branches == null ? new GitBranch[]{} : this.branches.toArray(new GitBranch[this.branches.size()]);
    }

    public GitTag[] getTags() {
        return this.tags == null ? new GitTag[]{} : this.tags.toArray(new GitTag[this.tags.size()]);
    }

    public class Event {
        private final File file;
        private final String path;
        private final GitFileInfo.Status status;
        private final Set<File> renames;

        public Event(GitFileInfo changedPath, Set<File> renames) {
            this.path = changedPath.getRelativePath();
            this.file = changedPath.getFile();
            this.status = changedPath.getStatus();
            this.renames = Collections.unmodifiableSet(new HashSet<File>(renames));
        }

        private Event(File dummyFile, String dummyPath) {
            this.path = dummyPath;
            this.file = dummyFile;
            this.status = GitFileInfo.Status.UNKNOWN;
            this.renames = Collections.emptySet();
        }

        public RepositoryRevision getLogInfoHeader() {
            return RepositoryRevision.this;
        }

        public File getFile() {
            return this.file;
        }

        public String getName() {
            return this.getFile().getName();
        }

        public String getPath() {
            return this.path;
        }

        public char getAction() {
            switch (this.status) {
                case ADDED: {
                    return 'A';
                }
                case MODIFIED: {
                    return 'M';
                }
                case RENAMED: {
                    return 'R';
                }
                case COPIED: {
                    return 'C';
                }
                case REMOVED: {
                    return 'D';
                }
            }
            return '?';
        }

        public String toString() {
            return this.path;
        }

        public Collection<File> getRenames() {
            return this.renames;
        }
    }
}

