/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.commit;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.libs.git.GitUser;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.commit.CommitPanel;
import org.netbeans.modules.versioning.util.common.VCSCommitParameters;
import org.openide.util.NbBundle;

public class GitCommitParameters
extends VCSCommitParameters.DefaultCommitParameters
implements ItemListener,
DocumentListener {
    private CommitPanel panel;
    private String commitMessage;
    private GitUser user;
    private String errorMessage;
    private Pattern validUserFormat = Pattern.compile("(.+)\\<(.*)\\>");
    private Pattern invalidUserFormat = Pattern.compile("(\\<)?(.*)\\>");

    public GitCommitParameters(Preferences preferences, String commitMessage, GitUser user) {
        super(preferences);
        this.commitMessage = commitMessage;
        this.user = user;
    }

    public CommitPanel getPanel() {
        if (this.panel == null) {
            this.panel = this.createPanel();
            ((JTextField)this.panel.authorComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
            ((JTextField)this.panel.commiterComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
            this.panel.authorComboBox.addItemListener(this);
            this.panel.commiterComboBox.addItemListener(this);
        }
        return this.panel;
    }

    public JLabel getMessagesTemplateLink(JTextArea text) {
        return super.getMessagesTemplateLink(text);
    }

    public JLabel getRecentMessagesLink(JTextArea text) {
        return super.getRecentMessagesLink(text);
    }

    public Preferences getPreferences() {
        return super.getPreferences();
    }

    public String getLastCanceledCommitMessage() {
        return GitModuleConfig.getDefault().getLastCanceledCommitMessage();
    }

    List<String> getCommitMessages() {
        return GitCommitParameters.getRecentCommitMessages((Preferences)this.getPreferences());
    }

    protected CommitPanel createPanel() {
        return new CommitPanel(this, this.commitMessage, GitCommitParameters.getUserString(this.user));
    }

    public String getCommitMessage() {
        return this.getPanel().messageTextArea.getText();
    }

    public GitUser getAuthor() {
        return this.getUser(this.getPanel().authorComboBox);
    }

    public GitUser getCommiter() {
        return this.getUser(this.getPanel().commiterComboBox);
    }

    static String getUserString(GitUser user) {
        if (user == null) {
            return "";
        }
        String name = user.getName();
        String mail = user.getEmailAddress();
        return name + (mail != null && !mail.isEmpty() ? " <" + user.getEmailAddress() + ">" : "");
    }

    public boolean isCommitable() {
        if (this.getAuthor() != null && this.getCommiter() != null) {
            this.errorMessage = null;
            return true;
        }
        this.errorMessage = NbBundle.getMessage(GitCommitParameters.class, (String)"MSG_WARNING_WRONG_USER");
        return false;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    GitUser getUser(JComboBox combo) {
        String str = (String)combo.getEditor().getItem();
        if (str == null || str.trim().isEmpty()) {
            return null;
        }
        Matcher m = this.validUserFormat.matcher(str.trim());
        if (m.matches()) {
            String name = m.group(1).trim();
            String mail = m.groupCount() > 1 ? (m.group(2) != null ? m.group(2) : "") : "";
            mail = mail.trim();
            return new ParametersGitUser(name, mail);
        }
        m = this.invalidUserFormat.matcher(str.trim());
        if (m.matches()) {
            return null;
        }
        return new ParametersGitUser(str, "");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireChange();
    }

    private class ParametersGitUser
    extends GitUser {
        private final String mail;
        private final String name;

        public ParametersGitUser(String name, String mail) {
            this.mail = mail;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getEmailAddress() {
            return this.mail;
        }
    }
}

