/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.clone;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class CloneDestinationPanel
extends JPanel
implements ActionListener {
    private String message;
    final JComboBox branchesComboBox = new JComboBox();
    private JPanel destinationDirectoryPanel;
    private JButton directoryBrowseButton;
    final JTextField directoryField = new JTextField();
    private JLabel directoryLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    final JTextField nameField = new JTextField();
    private JLabel nameLabel;
    final JTextField remoteTextField = new JTextField();
    final JCheckBox scanForProjectsCheckBox = new JCheckBox();

    public CloneDestinationPanel() {
        this.initComponents();
        this.directoryBrowseButton.addActionListener(this);
        this.scanForProjectsCheckBox.addActionListener(this);
        this.directoryField.setText(this.defaultWorkingDirectory().getPath());
        this.scanForProjectsCheckBox.setSelected(GitModuleConfig.getDefault().getShowCloneCompleted());
    }

    @Override
    public String getName() {
        if (this.destinationDirectoryPanel == null) {
            return null;
        }
        return this.destinationDirectoryPanel.getName();
    }

    public String getDirectory() {
        return this.directoryField.getText();
    }

    public String getCloneName() {
        return this.nameField.getText();
    }

    public String getMessage() {
        return this.message;
    }

    public String getBranch() {
        Object item = this.branchesComboBox.getSelectedItem();
        return item == null ? "" : item.toString();
    }

    public String getRemoteName() {
        return this.remoteTextField.getText();
    }

    private void initComponents() {
        this.destinationDirectoryPanel = new JPanel();
        this.directoryLabel = new JLabel();
        this.directoryBrowseButton = new JButton();
        this.nameLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.destinationDirectoryPanel.setName(NbBundle.getMessage(CloneDestinationPanel.class, (String)"destinationDirectoryPanel.Name"));
        this.directoryLabel.setLabelFor(this.directoryField);
        Mnemonics.setLocalizedText((JLabel)this.directoryLabel, (String)NbBundle.getMessage(CloneDestinationPanel.class, (String)"directoryLabel.Name"));
        this.directoryField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CloneDestinationPanel.this.directoryFieldActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.directoryBrowseButton, (String)NbBundle.getMessage(CloneDestinationPanel.class, (String)"directoryBrowseButton.Name"));
        this.nameLabel.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(CloneDestinationPanel.class, (String)"nameLabel.Name"));
        this.scanForProjectsCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.scanForProjectsCheckBox, (String)NbBundle.getMessage(CloneDestinationPanel.class, (String)"CTL_Scan_After_Clone"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CloneDestinationPanel.class, (String)"directoryTitleLabel.Name"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CloneDestinationPanel.class, (String)"CloneDestinationPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CloneDestinationPanel.class, (String)"CloneDestinationPanel.jLabel3.text"));
        this.remoteTextField.setText("origin");
        this.remoteTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CloneDestinationPanel.this.remoteTextFieldActionPerformed(evt);
            }
        });
        GroupLayout destinationDirectoryPanelLayout = new GroupLayout(this.destinationDirectoryPanel);
        this.destinationDirectoryPanel.setLayout(destinationDirectoryPanelLayout);
        destinationDirectoryPanelLayout.setHorizontalGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(destinationDirectoryPanelLayout.createSequentialGroup().addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 597, -2).addGroup(destinationDirectoryPanelLayout.createSequentialGroup().addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nameLabel, -1, -1, Short.MAX_VALUE).addComponent(this.directoryLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameField, -1, 376, Short.MAX_VALUE).addComponent(this.directoryField, -1, 376, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.directoryBrowseButton))).addGap(0, 0, 0)).addGroup(destinationDirectoryPanelLayout.createSequentialGroup().addComponent(this.scanForProjectsCheckBox).addContainerGap()).addGroup(destinationDirectoryPanelLayout.createSequentialGroup().addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.remoteTextField).addComponent(this.branchesComboBox, 0, 260, Short.MAX_VALUE)).addGap(222, 222, 222)));
        destinationDirectoryPanelLayout.setVerticalGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(destinationDirectoryPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addGap(20, 20, 20).addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(destinationDirectoryPanelLayout.createSequentialGroup().addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.directoryField, -2, -1, -2).addComponent(this.directoryBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameField, -2, -1, -2)).addGroup(destinationDirectoryPanelLayout.createSequentialGroup().addComponent(this.directoryLabel, -1, 30, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameLabel).addGap(37, 37, 37))).addGap(5, 5, 5).addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.branchesComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(destinationDirectoryPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.remoteTextField, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanForProjectsCheckBox, -2, 32, -2).addContainerGap()));
        this.scanForProjectsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CloneDestinationPanel.class, (String)"ACSD_Scan_After_Clone"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.destinationDirectoryPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.destinationDirectoryPanel, -2, -1, -2).addContainerGap(64, Short.MAX_VALUE)));
    }

    private void directoryFieldActionPerformed(ActionEvent evt) {
    }

    private void remoteTextFieldActionPerformed(ActionEvent evt) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.directoryBrowseButton) {
            this.onBrowseClick();
        } else if (evt.getSource() == this.scanForProjectsCheckBox) {
            GitModuleConfig.getDefault().setShowCloneCompleted(this.scanForProjectsCheckBox.isSelected());
        }
    }

    private void onBrowseClick() {
        File oldFile = this.defaultWorkingDirectory();
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(CloneDestinationPanel.class, (String)"ACSD_BrowseFolder"), oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(CloneDestinationPanel.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter[] old = fileChooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(CloneDestinationPanel.class, (String)"Folders");
            }
        });
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this, NbBundle.getMessage(CloneDestinationPanel.class, (String)"OK_Button"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            this.directoryField.setText(f.getAbsolutePath());
        }
    }

    private File defaultWorkingDirectory() {
        File projectFolder;
        File defaultDir = null;
        String current = this.directoryField.getText();
        if (current != null && !current.trim().equals("")) {
            File currentFile;
            for (currentFile = new File(current); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
            }
            if (currentFile != null) {
                defaultDir = currentFile.isFile() ? currentFile.getParentFile() : currentFile;
            }
        }
        if (defaultDir == null && (projectFolder = ProjectChooser.getProjectsFolder()).exists() && projectFolder.isDirectory()) {
            defaultDir = projectFolder;
        }
        if (defaultDir == null) {
            defaultDir = new File(System.getProperty("user.home"));
        }
        return defaultDir;
    }
}

