/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.cnd.editor.cplusplus.CCKit;

public class CKit
extends CCKit {
    private static String START_BLOCK_COMMENT = "/*";
    private static String END_BLOCK_COMMENT = "*/";
    private static String insertStartCommentString = START_BLOCK_COMMENT + "\n";
    private static String insertEndCommentString = END_BLOCK_COMMENT + "\n";

    @Override
    public String getContentType() {
        return "text/x-c";
    }

    @Override
    protected Language<CppTokenId> getLanguage() {
        return CppTokenId.languageC();
    }

    @Override
    protected Action getCommentAction() {
        return new CCommentAction();
    }

    @Override
    protected Action getUncommentAction() {
        return new CUncommentAction();
    }

    @Override
    protected Action getToggleCommentAction() {
        return new CToggleCommentAction();
    }

    private static final class CToggleCommentAction
    extends ExtKit.ToggleCommentAction {
        private CToggleCommentAction() {
            super("//");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (this.allComments(target)) {
                CUncommentAction.doCStyleUncomment(target);
            } else {
                CCommentAction.doCStyleComment(target);
            }
        }

        private boolean allComments(final JTextComponent target) {
            final BaseDocument doc = (BaseDocument)target.getDocument();
            final AtomicBoolean res = new AtomicBoolean(false);
            doc.render(new Runnable(){

                @Override
                public void run() {
                    Caret caret = target.getCaret();
                    Token tok = null;
                    try {
                        TokenSequence ts;
                        int endPos;
                        int startPos;
                        if (Utilities.isSelectionShowing((Caret)caret)) {
                            startPos = target.getSelectionStart();
                            endPos = target.getSelectionEnd();
                            if (endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos) {
                                --endPos;
                            }
                        } else {
                            endPos = startPos = target.getSelectionStart();
                        }
                        if ((ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)startPos, (boolean)true, (boolean)false)) == null) {
                            return;
                        }
                        tok = ts.token();
                        while (ts.offset() < endPos && tok.id() == CppTokenId.WHITESPACE && ts.moveNext()) {
                            tok = ts.token();
                        }
                    }
                    catch (BadLocationException e) {
                        target.getToolkit().beep();
                    }
                    res.set(tok != null && tok.id() == CppTokenId.BLOCK_COMMENT);
                }
            });
            return res.get();
        }
    }

    private static final class CUncommentAction
    extends ExtKit.UncommentAction {
        private CUncommentAction() {
            super("//");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            CUncommentAction.doCStyleUncomment(target);
        }

        private static void doCStyleUncomment(final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    @Override
                    public void run() {
                        Caret caret = target.getCaret();
                        try {
                            TokenSequence ts;
                            int endPos;
                            int startPos;
                            if (Utilities.isSelectionShowing((Caret)caret)) {
                                startPos = target.getSelectionStart();
                                endPos = target.getSelectionEnd();
                                if (endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos) {
                                    --endPos;
                                }
                            } else {
                                endPos = startPos = target.getSelectionStart();
                            }
                            if ((ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)startPos, (boolean)true, (boolean)false)) == null) {
                                return;
                            }
                            Token tok = ts.token();
                            int offset = ts.offset();
                            while (offset < endPos && tok.id() == CppTokenId.WHITESPACE && ts.moveNext()) {
                                tok = ts.token();
                                offset = ts.offset();
                            }
                            if (tok.id() == CppTokenId.BLOCK_COMMENT) {
                                int commentBlockStartOffset = offset;
                                int commentBlockEndOffset = commentBlockStartOffset + tok.length();
                                int startLineStartPos = Utilities.getRowStart((BaseDocument)doc, (int)commentBlockStartOffset);
                                int startLineEndPos = Utilities.getRowEnd((BaseDocument)doc, (int)startLineStartPos);
                                String startLineContent = doc.getText(startLineStartPos, startLineEndPos - startLineStartPos);
                                if (!START_BLOCK_COMMENT.equals(startLineContent.trim())) {
                                    startLineStartPos = commentBlockStartOffset;
                                    startLineEndPos = startLineStartPos + START_BLOCK_COMMENT.length();
                                } else {
                                    startLineEndPos = startLineEndPos < doc.getLength() - 1 ? startLineEndPos + 1 : doc.getLength();
                                }
                                int endLineStartPos = Utilities.getRowStart((BaseDocument)doc, (int)commentBlockEndOffset);
                                int endLineEndPos = Utilities.getRowEnd((BaseDocument)doc, (int)endLineStartPos);
                                String endLineContent = doc.getText(endLineStartPos, endLineEndPos - endLineStartPos);
                                if (!END_BLOCK_COMMENT.equals(endLineContent.trim())) {
                                    endLineEndPos = commentBlockEndOffset;
                                    endLineStartPos = endLineEndPos - END_BLOCK_COMMENT.length();
                                } else {
                                    endLineEndPos = endLineEndPos < doc.getLength() - 1 ? endLineEndPos + 1 : doc.getLength();
                                }
                                doc.remove(endLineStartPos, endLineEndPos - endLineStartPos);
                                doc.remove(startLineStartPos, startLineEndPos - startLineStartPos);
                            }
                        }
                        catch (BadLocationException e) {
                            target.getToolkit().beep();
                        }
                    }
                });
            }
        }
    }

    private static final class CCommentAction
    extends ExtKit.CommentAction {
        private CCommentAction() {
            super("//");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            CCommentAction.doCStyleComment(target);
        }

        private static void doCStyleComment(final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        Caret caret = target.getCaret();
                        try {
                            int endPos;
                            int startPos;
                            String endString = insertEndCommentString;
                            if (Utilities.isSelectionShowing((Caret)caret)) {
                                startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                                endPos = target.getSelectionEnd();
                                if (endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos) {
                                    --endPos;
                                }
                                int lineCnt = Utilities.getRowCount((BaseDocument)doc, (int)startPos, (int)endPos);
                                endPos = Utilities.getRowStart((BaseDocument)doc, (int)startPos, (int)lineCnt);
                            } else {
                                startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                                endPos = Utilities.getRowStart((BaseDocument)doc, (int)startPos, (int)1);
                                if (endPos == -1) {
                                    endPos = doc.getLength();
                                    endString = "\n" + insertEndCommentString;
                                }
                            }
                            doc.insertString(endPos, endString, null);
                            doc.insertString(startPos, insertStartCommentString, null);
                        }
                        catch (BadLocationException e) {
                            target.getToolkit().beep();
                        }
                    }
                });
            }
        }
    }
}

