/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.OverviewController;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OverviewControllerUI
extends JTitledPanel {
    private static Icon ICON_INFO = Icons.getIcon((String)"GeneralIcons.Info");
    private static final String VIEW_TITLE = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_ViewTitle");
    private static final String VIEW_DESCR = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_ViewDescr");
    private static final String IN_PROGRESS_MSG = NbBundle.getMessage(OverviewControllerUI.class, (String)"OverviewControllerUI_InProgressMsg");
    private AbstractButton presenter;
    private HTMLTextArea dataArea;
    private OverviewController overviewController;
    private Instance instanceToSelect;
    private boolean showSysprops = false;
    private boolean showThreads = false;

    public OverviewControllerUI(OverviewController controller) {
        super(VIEW_TITLE, ICON_INFO, true);
        this.overviewController = controller;
        this.initComponents();
        this.refreshSummary();
    }

    public void showInThreads(Instance instance) {
        if (!this.showThreads) {
            this.showThreads = true;
            this.instanceToSelect = instance;
            this.refreshSummary();
            return;
        }
        String referenceId = String.valueOf(instance.getInstanceId());
        this.dataArea.scrollToReference(referenceId);
        Document d = this.dataArea.getDocument();
        HTMLDocument doc = (HTMLDocument)d;
        HTMLDocument.Iterator iter = doc.getIterator(HTML.Tag.A);
        while (iter.isValid()) {
            AttributeSet a = iter.getAttributes();
            String nm = (String)a.getAttribute(HTML.Attribute.NAME);
            if (nm != null && nm.equals(referenceId)) {
                this.dataArea.select(iter.getStartOffset(), iter.getEndOffset());
                this.dataArea.requestFocusInWindow();
            }
            iter.next();
        }
    }

    private void refreshSummary() {
        if (!this.showSysprops && !this.showThreads) {
            this.dataArea.setText(IN_PROGRESS_MSG);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                String summary = "<nobr>" + OverviewControllerUI.this.overviewController.computeSummary() + "</nobr>";
                String environment = "<nobr>" + OverviewControllerUI.this.overviewController.computeEnvironment() + "</nobr>";
                String properties = "<nobr>" + OverviewControllerUI.this.overviewController.computeSystemProperties(OverviewControllerUI.this.showSysprops) + "</nobr>";
                String threads = "<nobr>" + OverviewControllerUI.this.overviewController.computeThreads(OverviewControllerUI.this.showThreads) + "</nobr>";
                final String dataAreaText = summary + "<br><br>" + environment + "<br><br>" + properties + "<br><br>" + threads;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OverviewControllerUI.this.dataArea.setText(dataAreaText);
                        if (OverviewControllerUI.this.instanceToSelect != null) {
                            OverviewControllerUI.this.showInThreads(OverviewControllerUI.this.instanceToSelect);
                            OverviewControllerUI.this.instanceToSelect = null;
                        } else {
                            OverviewControllerUI.this.dataArea.setCaretPosition(0);
                        }
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.dataArea = new HTMLTextArea(){

            protected void showURL(URL url) {
                if (url == null) {
                    return;
                }
                String urls = url.toString();
                if (urls.equals("file:/sysprops")) {
                    OverviewControllerUI.this.showSysprops = true;
                    OverviewControllerUI.this.refreshSummary();
                } else if (urls.equals("file:/threads")) {
                    OverviewControllerUI.this.showThreads = true;
                    OverviewControllerUI.this.refreshSummary();
                } else {
                    OverviewControllerUI.this.overviewController.showURL(urls);
                }
            }
        };
        this.dataArea.setSelectionColor(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        JScrollPane dataAreaScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
        dataAreaScrollPane.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIUtils.getProfilerResultsBackground()));
        dataAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        dataAreaScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        dataAreaScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        JPanel contentsPanel = new JPanel();
        contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.getTitleBorderColor()));
        contentsPanel.setLayout(new BorderLayout());
        contentsPanel.setOpaque(true);
        contentsPanel.setBackground(this.dataArea.getBackground());
        contentsPanel.add((Component)dataAreaScrollPane, "Center");
        this.setLayout(new BorderLayout());
        this.add(contentsPanel, "Center");
        this.setBackground(this.dataArea.getBackground());
    }
}

