/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.DiffBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.JExtendedTablePanel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.ClassesListController;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ClassesListControllerUI
extends JTitledPanel {
    private static final String VIEW_TITLE = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ViewTitle");
    private static final String NO_INSTANCES_MSG = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_NoInstancesMsg");
    private static final String NO_CLASS_IN_BASE_MSG = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_NoClassInBaseMsg");
    private static final String FILTER_STARTS_WITH = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterStartsWith");
    private static final String FILTER_CONTAINS = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterContains");
    private static final String FILTER_ENDS_WITH = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterEndsWith");
    private static final String FILTER_REGEXP = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterRegexp");
    private static final String FILTER_IMPLEMENTATION = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterImplementation");
    private static final String FILTER_SUBCLASS = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterSubclass");
    private static final String DEFAULT_FILTER_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_DefaultFilterText");
    private static final String SHOW_IN_INSTANCES_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowInInstancesString");
    private static final String SHOW_IMPLEMENTATIONS_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowImplementationsString");
    private static final String SHOW_SUBCLASSES_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowSubclassesString");
    private static final String GO_TO_SOURCE_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_GoToSourceString");
    private static final String SHOW_HIDE_COLUMNS_STRING = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowHideColumnsString");
    private static final String FILTER_CHECKBOX_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilterCheckboxText");
    private static final String CLASSNAME_COLUMN_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ClassNameColumnText");
    private static final String CLASSNAME_COLUMN_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ClassNameColumnDescr");
    private static final String INSTANCES_REL_COLUMN_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_InstancesRelColumnText");
    private static final String INSTANCES_REL_COLUMN_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_InstancesRelColumnDescr");
    private static final String INSTANCES_COLUMN_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_InstancesColumnText");
    private static final String INSTANCES_COLUMN_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_InstancesColumnDescr");
    private static final String SIZE_COLUMN_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_SizeColumnText");
    private static final String SIZE_COLUMN_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_SizeColumnDescr");
    private static final String FITERING_PROGRESS_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_FilteringProgressText");
    private static final String CLASSES_TABLE_ACCESS_NAME = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ClassesTableAccessName");
    private static final String CLASSES_TABLE_ACCESS_DESCR = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ClassesTableAccessDescr");
    private static final String COMPARE_WITH_ANOTHER_TEXT = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_CompareWithAnotherText");
    private static final String COMPARING_MSG = NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ComparingMsg");
    private static Icon ICON_CLASSES = Icons.getIcon((String)"HeapWalkerIcons.Classes");
    private static String filterValue = "";
    private static int filterType = 20;
    private static final String DATA = "Data";
    private static final String NO_DATA = "No data";
    private static final int columnCount = 4;
    private CardLayout contents;
    private ClassesListController classesListController;
    private ClassesListTableModel realClassesListTableModel = new ClassesListTableModel();
    private ExtendedTableModel classesListTableModel = new ExtendedTableModel((SortableTableModel)this.realClassesListTableModel);
    private FilterComponent filterComponent;
    private JExtendedTable classesListTable;
    private JPanel contentsPanel;
    private JPopupMenu cornerPopup;
    private JPopupMenu tablePopup;
    private String selectedRowContents;
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private int[] columnWidths;
    private Object[][] displayCache;
    private boolean hasProjectContext;
    private boolean internalCornerButtonClick = false;
    private boolean selectionSaved = false;
    private boolean showZeroInstances = true;
    private boolean showZeroSize = true;
    private boolean sortingOrder = false;
    private int selectedRow;
    private int sortingColumn = 1;
    private boolean isDiff = false;
    private HTMLLabel l;
    private JLabel w;
    private JProgressBar p;

    public ClassesListControllerUI(ClassesListController classesListController) {
        super(VIEW_TITLE, ICON_CLASSES, true);
        this.classesListController = classesListController;
        this.hasProjectContext = classesListController.getClassesController().getHeapFragmentWalker().getHeapDumpProject() != null;
        this.initColumnsData();
        this.initData();
        this.initComponents();
    }

    public void setColumnVisibility(int column, boolean columnVisible) {
        boolean isColumnVisible = this.classesListTableModel.isRealColumnVisible(column);
        if (isColumnVisible == columnVisible) {
            return;
        }
        this.saveSelection();
        boolean sortResults = false;
        int currentSortingColumn = this.classesListTableModel.getSortingColumn();
        int realSortingColumn = this.classesListTableModel.getRealColumn(currentSortingColumn);
        if (isColumnVisible && column == realSortingColumn) {
            currentSortingColumn = currentSortingColumn + 1 == this.classesListTableModel.getColumnCount() ? currentSortingColumn - 1 : currentSortingColumn + 1;
            realSortingColumn = this.classesListTableModel.getRealColumn(currentSortingColumn);
            sortResults = true;
        }
        this.classesListTableModel.setRealColumnVisibility(column, columnVisible);
        this.classesListTable.createDefaultColumnsFromModel();
        this.classesListTableModel.setTable((JTable)this.classesListTable);
        currentSortingColumn = this.classesListTableModel.getVirtualColumn(realSortingColumn);
        if (sortResults) {
            this.sortingOrder = this.classesListTableModel.getInitialSorting(currentSortingColumn);
            this.sortingColumn = realSortingColumn;
            this.initData();
        }
        this.sortingColumn = realSortingColumn;
        this.classesListTableModel.setInitialSorting(currentSortingColumn, this.sortingOrder);
        this.classesListTable.getTableHeader().repaint();
        this.setColumnsData(true);
        this.restoreSelection();
    }

    public void ensureWillBeVisible(JavaClass javaClass) {
        if (ClassesListController.matchesFilter(javaClass, FilterComponent.getFilterStrings((String)filterValue), filterType, this.showZeroInstances, this.showZeroSize)) {
            return;
        }
        this.filterComponent.setFilterString("");
    }

    public void selectClass(JavaClass javaClass) {
        if (this.displayCache == null || this.displayCache.length == 0) {
            return;
        }
        for (int i = 0; i < this.displayCache.length; ++i) {
            if (!this.displayCache[i][4].equals(javaClass)) continue;
            this.classesListTable.setRowSelectionInterval(i, i);
            final int rowIndex = i;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassesListControllerUI.this.classesListTable.ensureRowVisible(rowIndex);
                }
            });
            break;
        }
    }

    public void updateData() {
        this.initData();
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.realClassesListTableModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.realClassesListTableModel.getColumnName(i));
            menuItem.setActionCommand(Integer.valueOf(i).toString());
            this.addMenuItemListener(menuItem);
            if (this.classesListTable != null) {
                menuItem.setState(this.classesListTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    menuItem.setEnabled(false);
                }
            } else {
                menuItem.setState(true);
            }
            this.cornerPopup.add(menuItem);
        }
        this.cornerPopup.addSeparator();
        JCheckBoxMenuItem filterMenuItem = new JCheckBoxMenuItem(FILTER_CHECKBOX_TEXT);
        filterMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(filterMenuItem);
        if (this.filterComponent == null) {
            filterMenuItem.setState(true);
        } else {
            filterMenuItem.setState(this.filterComponent.isVisible());
        }
        this.cornerPopup.add(filterMenuItem);
        this.cornerPopup.pack();
    }

    protected void saveColumnsData() {
        TableColumnModel colModel = this.classesListTable.getColumnModel();
        for (int i = 0; i < this.classesListTableModel.getColumnCount(); ++i) {
            int index = this.classesListTableModel.getRealColumn(i);
            if (index == 0) continue;
            this.columnWidths[index - 1] = colModel.getColumn(i).getPreferredWidth();
        }
    }

    private void setColumnsData(boolean widths) {
        TableColumnModel colModel = this.classesListTable.getColumnModel();
        for (int i = 0; i < this.classesListTableModel.getColumnCount(); ++i) {
            int index = this.classesListTableModel.getRealColumn(i);
            if (widths && index != 0) {
                colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            }
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private void addMenuItemListener(JCheckBoxMenuItem menuItem) {
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Filter")) {
                    ClassesListControllerUI.this.filterComponent.setVisible(!ClassesListControllerUI.this.filterComponent.isVisible());
                    return;
                }
                int column = Integer.parseInt(e.getActionCommand());
                ClassesListControllerUI.this.setColumnVisibility(column, !ClassesListControllerUI.this.classesListTableModel.isRealColumnVisible(column));
            }
        });
    }

    private JButton createHeaderPopupCornerButton(final JPopupMenu headerPopup) {
        final JButton cornerButton = new JButton(Icons.getIcon((String)"GeneralIcons.HideColumn"));
        cornerButton.setToolTipText(SHOW_HIDE_COLUMNS_STRING);
        cornerButton.setDefaultCapable(false);
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 2, 2));
        } else if (UIUtils.isWindowsXPLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 0, 1));
        } else if (UIUtils.isMetalLookAndFeel()) {
            cornerButton.setMargin(new Insets(0, 0, 2, 1));
        }
        cornerButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 32) {
                    ClassesListControllerUI.this.showColumnSelectionPopup(headerPopup, cornerButton);
                }
            }
        });
        cornerButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (headerPopup.isVisible()) {
                    ClassesListControllerUI.this.internalCornerButtonClick = true;
                    cornerButton.getModel().setArmed(false);
                } else {
                    ClassesListControllerUI.this.internalCornerButtonClick = false;
                    if (mouseEvent.getModifiers() == 4) {
                        ClassesListControllerUI.this.showColumnSelectionPopup(headerPopup, cornerButton);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && !ClassesListControllerUI.this.internalCornerButtonClick) {
                    ClassesListControllerUI.this.showColumnSelectionPopup(headerPopup, cornerButton);
                }
            }
        });
        return cornerButton;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem showInstancesItem = new JMenuItem(SHOW_IN_INSTANCES_STRING);
        showInstancesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassesListControllerUI.this.performDefaultAction();
            }
        });
        showInstancesItem.setFont(popup.getFont().deriveFont(1));
        JMenuItem showInstancesOfItem = new JMenuItem(this.hasProjectContext ? SHOW_IMPLEMENTATIONS_STRING : SHOW_SUBCLASSES_STRING);
        showInstancesOfItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ClassesListControllerUI.this.classesListTable.getSelectedRow();
                if (row != -1) {
                    ClassesListControllerUI.this.showSubclassesForClass((JavaClass)ClassesListControllerUI.this.displayCache[row][4]);
                }
            }
        });
        JMenuItem showSourceItem = null;
        if (GoToSource.isAvailable()) {
            showSourceItem = new JMenuItem(GO_TO_SOURCE_STRING);
            showSourceItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ClassesListControllerUI.this.classesListTable.getSelectedRow();
                    if (row != -1) {
                        String className = (String)ClassesListControllerUI.this.displayCache[row][0];
                        while (className.endsWith("[]")) {
                            className = className.substring(0, className.length() - 2);
                        }
                        Lookup.Provider p = ClassesListControllerUI.this.classesListController.getClassesController().getHeapFragmentWalker().getHeapDumpProject();
                        GoToSource.openSource((Lookup.Provider)p, (String)className, null, null);
                    }
                }
            });
        }
        popup.add(showInstancesItem);
        popup.add(showInstancesOfItem);
        if (showSourceItem != null) {
            popup.addSeparator();
            popup.add(showSourceItem);
        }
        return popup;
    }

    private void initColumnsData() {
        this.columnWidths = new int[3];
        this.columnNames = new String[4];
        this.columnToolTips = new String[4];
        this.columnRenderers = new TableCellRenderer[4];
        this.columnNames[0] = CLASSNAME_COLUMN_TEXT;
        this.columnToolTips[0] = CLASSNAME_COLUMN_DESCR;
        this.columnNames[1] = INSTANCES_REL_COLUMN_TEXT;
        this.columnToolTips[1] = INSTANCES_REL_COLUMN_DESCR;
        this.columnNames[2] = INSTANCES_COLUMN_TEXT;
        this.columnToolTips[2] = INSTANCES_COLUMN_DESCR;
        this.columnNames[3] = SIZE_COLUMN_TEXT;
        this.columnToolTips[3] = SIZE_COLUMN_DESCR;
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        ClassNameTableCellRenderer classNameCellRenderer = new ClassNameTableCellRenderer();
        CustomBarCellRenderer customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        LabelBracketTableCellRenderer dataCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnRenderers[0] = classNameCellRenderer;
        this.columnWidths[0] = maxWidth;
        this.columnRenderers[1] = customBarCellRenderer;
        this.columnWidths[1] = maxWidth;
        this.columnRenderers[2] = dataCellRenderer;
        this.columnWidths[2] = maxWidth;
        this.columnRenderers[3] = dataCellRenderer;
    }

    protected Component[] getAdditionalControls() {
        if (this.l == null) {
            this.l = new HTMLLabel(){

                protected void showURL(URL url) {
                    if (ClassesListControllerUI.this.classesListController.isDiff()) {
                        ClassesListControllerUI.this.classesListController.resetDiffAction();
                    } else {
                        ClassesListControllerUI.this.classesListController.compareAction();
                    }
                }
            };
            this.l.setBorder(BorderFactory.createEmptyBorder());
            this.l.setFont(UIManager.getFont("ToolTip.font"));
            this.l.setText("<nobr><a href='#'>" + COMPARE_WITH_ANOTHER_TEXT + "</a></nobr>");
        }
        if (this.w == null) {
            this.w = new JLabel(COMPARING_MSG);
            this.w.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.w.setFont(UIManager.getFont("ToolTip.font"));
        }
        if (this.p == null) {
            this.p = new JProgressBar(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = ClassesListControllerUI.this.l.getPreferredSize();
                    d.width = 130;
                    return d;
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.p.setIndeterminate(true);
        }
        JPanel indent = new JPanel(null);
        indent.setOpaque(false);
        indent.setPreferredSize(new Dimension(5, 5));
        indent.setMinimumSize(indent.getPreferredSize());
        this.w.setVisible(false);
        this.p.setVisible(false);
        this.l.setVisible(true);
        return new Component[]{this.w, this.p, this.l, indent};
    }

    public void showDiffProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClassesListControllerUI.this.w.setVisible(true);
                ClassesListControllerUI.this.p.setVisible(true);
                ClassesListControllerUI.this.l.setVisible(false);
            }
        });
    }

    public void hideDiffProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClassesListControllerUI.this.w.setVisible(false);
                ClassesListControllerUI.this.p.setVisible(false);
                if (ClassesListControllerUI.this.classesListController.isDiff()) {
                    ClassesListControllerUI.this.l.setText("<nobr>" + NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowingDiffText", (Object)"<a href='#'>", (Object)"</a>") + "</nobr>");
                } else {
                    ClassesListControllerUI.this.l.setText("<nobr><a href='#'>" + COMPARE_WITH_ANOTHER_TEXT + "</a></nobr>");
                }
                ClassesListControllerUI.this.l.setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.classesListTable = new JExtendedTable((TableModel)this.classesListTableModel){

            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                TableColumnModel colModel = this.getColumnModel();
                for (int i = 0; i < ClassesListControllerUI.this.classesListTableModel.getColumnCount(); ++i) {
                    if (ClassesListControllerUI.this.classesListTableModel.getRealColumn(i) == 0) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += colModel.getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    colModel.getColumn(realFirstColumn).setPreferredWidth(this.getWidth() - columnsWidthsSum);
                }
                super.doLayout();
            }
        };
        this.classesListTable.setSelectionMode(0);
        this.classesListTable.addMouseListener((MouseListener)new ClassesListTableMouseListener());
        this.classesListTable.addKeyListener((KeyListener)new ClassesListTableKeyListener());
        this.classesListTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.classesListTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.classesListTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.classesListTable.setShowHorizontalLines(false);
        this.classesListTable.setShowVerticalLines(true);
        this.classesListTable.setRowMargin(0);
        this.classesListTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.classesListTableModel.setTable((JTable)this.classesListTable);
        this.classesListTableModel.setInitialSorting(this.sortingColumn, this.sortingOrder);
        this.classesListTable.getColumnModel().getColumn(0).setMinWidth(150);
        this.classesListTable.getAccessibleContext().setAccessibleName(CLASSES_TABLE_ACCESS_NAME);
        this.classesListTable.getAccessibleContext().setAccessibleDescription(CLASSES_TABLE_ACCESS_DESCR);
        this.classesListTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.classesListTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassesListControllerUI.this.performDefaultAction();
            }
        });
        HashSet<KeyStroke> keys = new HashSet<KeyStroke>(this.classesListTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.classesListTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet(this.classesListTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.classesListTable.setFocusTraversalKeys(1, keys);
        this.setColumnsData(true);
        this.filterComponent = new FilterComponent();
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterStartsWith"), FILTER_STARTS_WITH, 10);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterContains"), FILTER_CONTAINS, 20);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterEndsWith"), FILTER_ENDS_WITH, 30);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"GeneralIcons.FilterRegExp"), FILTER_REGEXP, 50);
        this.filterComponent.addFilterItem(Icons.getImageIcon((String)"LanguageIcons.Class"), this.hasProjectContext ? FILTER_IMPLEMENTATION : FILTER_SUBCLASS, 1001);
        this.filterComponent.setEmptyFilterText(DEFAULT_FILTER_TEXT);
        this.filterComponent.setFilterValues(filterValue, filterType);
        this.filterComponent.addFilterListener(new FilterComponent.FilterListener(){

            public void filterChanged() {
                filterValue = ClassesListControllerUI.this.filterComponent.getFilterString();
                filterType = ClassesListControllerUI.this.filterComponent.getFilterType();
                ClassesListControllerUI.this.initData();
            }
        });
        this.tablePopup = this.createTablePopup();
        this.cornerPopup = new JPopupMenu();
        JExtendedTablePanel tablePanel = new JExtendedTablePanel(this.classesListTable);
        tablePanel.setCorner("UPPER_RIGHT_CORNER", (Component)this.createHeaderPopupCornerButton(this.cornerPopup));
        this.setLayout(new BorderLayout());
        JPanel noDataPanel = new JPanel(new BorderLayout());
        noDataPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        HTMLTextArea hintArea = new HTMLTextArea();
        hintArea.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 8));
        String progressRes = Icons.getResource((String)"HeapWalkerIcons.Progress");
        String hintText = "<img border='0' align='bottom' src='nbresloc:/" + progressRes + "'>&nbsp;&nbsp;" + FITERING_PROGRESS_TEXT;
        hintArea.setText(hintText);
        noDataPanel.add((Component)hintArea, "Center");
        this.contents = new CardLayout();
        this.contentsPanel = new JPanel(this.contents);
        this.contentsPanel.add((Component)tablePanel, DATA);
        this.contentsPanel.add((Component)noDataPanel, NO_DATA);
        this.contents.show(this.contentsPanel, NO_DATA);
        this.add(this.contentsPanel, "Center");
        this.add((Component)this.filterComponent, "South");
        this.classesListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ClassesListControllerUI.this.classesListController.classSelected(ClassesListControllerUI.this.classesListTable.getSelectedRow() == -1 ? null : (JavaClass)ClassesListControllerUI.this.displayCache[ClassesListControllerUI.this.classesListTable.getSelectedRow()][4]);
            }
        });
    }

    private void initData() {
        if (this.displayCache == null) {
            this.displayCache = new Object[0][5];
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                final AtomicBoolean initInProgress = new AtomicBoolean(false);
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (ClassesListControllerUI.this.contents != null && initInProgress.get()) {
                                    ClassesListControllerUI.this.contents.show(ClassesListControllerUI.this.contentsPanel, ClassesListControllerUI.NO_DATA);
                                }
                            }
                        });
                    }
                }, 100);
                ClassesListControllerUI.this.saveSelection();
                BrowserUtils.performTask(new Runnable(){

                    @Override
                    public void run() {
                        initInProgress.set(true);
                        final Object[][] displayCache2 = ClassesListControllerUI.this.classesListController.getData(FilterComponent.getFilterStrings((String)filterValue), filterType, ClassesListControllerUI.this.showZeroInstances, ClassesListControllerUI.this.showZeroSize, ClassesListControllerUI.this.sortingColumn, ClassesListControllerUI.this.sortingOrder, 4);
                        initInProgress.set(false);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (ClassesListControllerUI.this.isDiff != ClassesListControllerUI.this.classesListController.isDiff()) {
                                    ClassesListControllerUI.this.isDiff = !ClassesListControllerUI.this.isDiff;
                                    DiffBarCellRenderer customBarCellRenderer = ClassesListControllerUI.this.isDiff ? new DiffBarCellRenderer(((ClassesListControllerUI)ClassesListControllerUI.this).classesListController.minDiff, ((ClassesListControllerUI)ClassesListControllerUI.this).classesListController.maxDiff) : new CustomBarCellRenderer(0L, 100L);
                                    ((ClassesListControllerUI)ClassesListControllerUI.this).columnRenderers[1] = customBarCellRenderer;
                                    LabelTableCellRenderer dataCellRenderer = ClassesListControllerUI.this.isDiff ? new LabelTableCellRenderer(11) : new LabelBracketTableCellRenderer(11);
                                    ((ClassesListControllerUI)ClassesListControllerUI.this).columnRenderers[2] = dataCellRenderer;
                                    ((ClassesListControllerUI)ClassesListControllerUI.this).columnRenderers[3] = dataCellRenderer;
                                    ClassesListControllerUI.this.setColumnsData(false);
                                }
                                ClassesListControllerUI.access$402(ClassesListControllerUI.this, displayCache2);
                                ClassesListControllerUI.this.classesListTableModel.fireTableDataChanged();
                                ClassesListControllerUI.this.restoreSelection();
                                if (ClassesListControllerUI.this.contents != null) {
                                    ClassesListControllerUI.this.contents.show(ClassesListControllerUI.this.contentsPanel, ClassesListControllerUI.DATA);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private void performDefaultAction() {
        int row = this.classesListTable.getSelectedRow();
        if (row != -1) {
            this.showInstancesForClass((JavaClass)this.displayCache[row][4]);
        }
    }

    private void restoreSelection() {
        if (this.selectedRowContents != null) {
            this.classesListTable.selectRowByContents(this.selectedRowContents, 0, true);
        }
        this.selectionSaved = false;
    }

    private void saveSelection() {
        if (this.selectionSaved) {
            return;
        }
        this.selectedRow = this.classesListTable == null ? -1 : this.classesListTable.getSelectedRow();
        this.selectedRowContents = null;
        if (this.selectedRow != -1) {
            this.selectedRowContents = (String)this.classesListTable.getValueAt(this.selectedRow, 0);
        }
        this.selectionSaved = true;
    }

    private void showColumnSelectionPopup(JPopupMenu headerPopup, JButton cornerButton) {
        this.initColumnSelectorItems();
        headerPopup.show(cornerButton, cornerButton.getWidth() - headerPopup.getPreferredSize().width, cornerButton.getHeight());
    }

    private void showInstancesForClass(JavaClass jClass) {
        if (this.classesListController.isDiff() && jClass == null) {
            ProfilerDialogs.displayInfo((String)NO_CLASS_IN_BASE_MSG);
        } else if (jClass.getInstancesCount() == 0) {
            ProfilerDialogs.displayInfo((String)MessageFormat.format(NO_INSTANCES_MSG, jClass.getName()));
        } else {
            this.classesListController.getClassesController().getHeapFragmentWalker().showInstancesForClass(jClass);
        }
    }

    private void showSubclassesForClass(JavaClass jClass) {
        this.filterComponent.setFilterValues(jClass.getName(), 1001);
    }

    static /* synthetic */ Object[][] access$402(ClassesListControllerUI x0, Object[][] x1) {
        x0.displayCache = x1;
        return x1;
    }

    private class ClassesListTableMouseListener
    extends MouseAdapter {
        private ClassesListTableMouseListener() {
        }

        private void updateSelection(int row) {
            ClassesListControllerUI.this.classesListTable.requestFocusInWindow();
            if (row != -1) {
                ClassesListControllerUI.this.classesListTable.setRowSelectionInterval(row, row);
            } else {
                ClassesListControllerUI.this.classesListTable.clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row = ClassesListControllerUI.this.classesListTable.rowAtPoint(e.getPoint());
            this.updateSelection(row);
            if (e.isPopupTrigger()) {
                ClassesListControllerUI.this.tablePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int row = ClassesListControllerUI.this.classesListTable.rowAtPoint(e.getPoint());
            this.updateSelection(row);
            if (e.isPopupTrigger()) {
                ClassesListControllerUI.this.tablePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row;
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (row = ClassesListControllerUI.this.classesListTable.rowAtPoint(e.getPoint())) != -1) {
                ClassesListControllerUI.this.showInstancesForClass((JavaClass)ClassesListControllerUI.this.displayCache[row][4]);
            }
        }
    }

    private class ClassesListTableModel
    extends SortableTableModel {
        private ClassesListTableModel() {
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            return Object.class;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int columnIndex) {
            return ClassesListControllerUI.this.columnNames[columnIndex];
        }

        public String getColumnToolTipText(int col) {
            return ClassesListControllerUI.this.columnToolTips[col];
        }

        public boolean getInitialSorting(int column) {
            switch (column) {
                case 0: {
                    return true;
                }
            }
            return false;
        }

        public int getRowCount() {
            return ClassesListControllerUI.this.displayCache.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return ClassesListControllerUI.this.displayCache[rowIndex][columnIndex];
        }

        public void sortByColumn(int column, boolean order) {
            ClassesListControllerUI.this.sortingColumn = column;
            ClassesListControllerUI.this.sortingOrder = order;
            ClassesListControllerUI.this.initData();
            ClassesListControllerUI.this.repaint();
        }
    }

    private class ClassesListTableKeyListener
    extends KeyAdapter {
        private ClassesListTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int selectedRow;
            if ((e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) && (selectedRow = ClassesListControllerUI.this.classesListTable.getSelectedRow()) != -1) {
                Rectangle rowBounds = ClassesListControllerUI.this.classesListTable.getCellRect(selectedRow, 0, true);
                ClassesListControllerUI.this.tablePopup.show((Component)ClassesListControllerUI.this.classesListTable, rowBounds.x + rowBounds.width / 2, rowBounds.y + rowBounds.height / 2);
            }
        }
    }
}

