/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumnModel;

public class ETableColumn
extends TableColumn
implements Comparable<ETableColumn> {
    static final String PROP_PREFIX = "ETableColumn-";
    private static final String PROP_WIDTH = "Width";
    private static final String PROP_PREFERRED_WIDTH = "PreferredWidth";
    private static final String PROP_SORT_RANK = "SortRank";
    private static final String PROP_COMPARATOR = "Comparator";
    private static final String PROP_HEADER_VALUE = "HeaderValue";
    private static final String PROP_MODEL_INDEX = "ModelIndex";
    private static final String PROP_ASCENDING = "Ascending";
    private int sortRank = 0;
    private Comparator<ETable.RowMapping> comparator;
    private boolean ascending = true;
    private boolean headerRendererSetExternally = false;
    private ETable table;
    private Icon customIcon;
    private TableCellRenderer myHeaderRenderer;
    private Comparator nestedComparator;

    public ETableColumn(ETable table) {
        this.table = table;
    }

    public ETableColumn(int modelIndex, ETable table) {
        super(modelIndex);
        this.table = table;
    }

    public ETableColumn(int modelIndex, int width, ETable table) {
        super(modelIndex, width);
        this.table = table;
    }

    public ETableColumn(int modelIndex, int width, TableCellRenderer cellRenderer, TableCellEditor cellEditor, ETable table) {
        super(modelIndex, width, cellRenderer, cellEditor);
        this.table = table;
    }

    @Deprecated
    public void setSorted(int rank, boolean ascending) {
        if (!(this.isSortingAllowed() || rank == 0 && this.comparator == null)) {
            throw new IllegalStateException("Cannot sort an unsortable column.");
        }
        this.ascending = ascending;
        this.sortRank = rank;
        this.comparator = rank != 0 ? this.getRowComparator(this.getModelIndex(), ascending) : null;
    }

    public boolean isSorted() {
        return this.comparator != null;
    }

    public void setSortRank(int newRank) {
        if (!this.isSortingAllowed() && newRank != 0) {
            throw new IllegalStateException("Cannot sort an unsortable column.");
        }
        this.sortRank = newRank;
    }

    public int getSortRank() {
        return this.sortRank;
    }

    Comparator<ETable.RowMapping> getComparator() {
        return this.comparator;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        if (!this.isSortingAllowed()) {
            throw new IllegalStateException("Cannot sort an unsortable column.");
        }
        if (!this.isSorted()) {
            return;
        }
        if (this.ascending == ascending) {
            return;
        }
        Comparator<ETable.RowMapping> c = this.getRowComparator(this.getModelIndex(), ascending);
        if (c == null) {
            throw new IllegalStateException("getRowComparator returned null for " + this);
        }
        this.ascending = ascending;
        this.comparator = c;
    }

    @Override
    public void setHeaderRenderer(TableCellRenderer tcr) {
        this.headerRendererSetExternally = true;
        super.setHeaderRenderer(tcr);
    }

    @Override
    public TableCellRenderer getHeaderRenderer() {
        if (this.headerRendererSetExternally) {
            return super.getHeaderRenderer();
        }
        return this.createDefaultHeaderRenderer();
    }

    public boolean isHidingAllowed() {
        return true;
    }

    public boolean isSortingAllowed() {
        return true;
    }

    public void setCustomIcon(Icon i) {
        this.customIcon = i;
    }

    void updatePreferredWidth(JTable table, boolean resize) {
        TableModel dataModel = table.getModel();
        int rows = dataModel.getRowCount();
        if (rows == 0) {
            return;
        }
        int sum = 0;
        int max = 15;
        for (int i = 0; i < rows; ++i) {
            Object data = dataModel.getValueAt(i, this.modelIndex);
            int estimate = this.estimatedWidth(data, table);
            sum += estimate;
            if (estimate <= max) continue;
            max = estimate;
        }
        this.setPreferredWidth(max += 5);
        if (resize) {
            this.resize(max, table);
        }
    }

    private void resize(int newWidth, JTable table) {
        Container container;
        int oldWidth = this.getWidth();
        JTableHeader header = table.getTableHeader();
        if (header == null) {
            return;
        }
        header.setResizingColumn(this);
        final int oldMin = this.getMinWidth();
        final int oldMax = this.getMaxWidth();
        this.setMinWidth(newWidth);
        this.setMaxWidth(newWidth);
        this.setWidth(newWidth);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ETableColumn.this.setMinWidth(oldMin);
                ETableColumn.this.setMaxWidth(oldMax);
            }
        });
        if (header.getParent() == null || (container = header.getParent().getParent()) == null || !(container instanceof JScrollPane)) {
            header.setResizingColumn(null);
            return;
        }
        if (!container.getComponentOrientation().isLeftToRight() && !header.getComponentOrientation().isLeftToRight() && table != null) {
            JViewport viewport = ((JScrollPane)container).getViewport();
            int viewportWidth = viewport.getWidth();
            int diff = newWidth - oldWidth;
            int newHeaderWidth = table.getWidth() + diff;
            Dimension tableSize = table.getSize();
            tableSize.width += diff;
            table.setSize(tableSize);
            if (newHeaderWidth >= viewportWidth && table.getAutoResizeMode() == 0) {
                Point p = viewport.getViewPosition();
                p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                viewport.setViewPosition(p);
            }
        }
        header.setResizingColumn(null);
    }

    private int estimatedWidth(Object dataObject, JTable table) {
        Serializable c;
        TableCellRenderer cr = this.getCellRenderer();
        if (cr == null) {
            c = table.getModel().getColumnClass(this.modelIndex);
            cr = table.getDefaultRenderer((Class<?>)c);
        }
        c = cr.getTableCellRendererComponent(table, dataObject, false, false, 0, table.getColumnModel().getColumnIndex(this.getIdentifier()));
        return ((Component)c).getPreferredSize().width;
    }

    public void readSettings(Properties p, int index, String propertyPrefix) {
        String s3;
        String s2;
        String s1;
        String myPrefix = propertyPrefix + PROP_PREFIX + Integer.toString(index) + "-";
        String s0 = p.getProperty(myPrefix + PROP_MODEL_INDEX);
        if (s0 != null) {
            this.modelIndex = Integer.parseInt(s0);
        }
        if ((s1 = p.getProperty(myPrefix + PROP_WIDTH)) != null) {
            this.width = Integer.parseInt(s1);
        }
        if ((s2 = p.getProperty(myPrefix + PROP_PREFERRED_WIDTH)) != null) {
            this.setPreferredWidth(Integer.parseInt(s2));
        }
        this.ascending = true;
        String s4 = p.getProperty(myPrefix + PROP_ASCENDING);
        if ("false".equals(s4)) {
            this.ascending = false;
        }
        if ((s3 = p.getProperty(myPrefix + PROP_SORT_RANK)) != null) {
            this.sortRank = Integer.parseInt(s3);
            if (this.sortRank > 0) {
                this.comparator = this.getRowComparator(this.modelIndex, this.ascending);
            }
        }
        this.headerValue = p.getProperty(myPrefix + PROP_HEADER_VALUE);
    }

    public void writeSettings(Properties p, int index, String propertyPrefix) {
        String myPrefix = propertyPrefix + PROP_PREFIX + Integer.toString(index) + "-";
        p.setProperty(myPrefix + PROP_MODEL_INDEX, Integer.toString(this.modelIndex));
        p.setProperty(myPrefix + PROP_WIDTH, Integer.toString(this.width));
        p.setProperty(myPrefix + PROP_PREFERRED_WIDTH, Integer.toString(this.getPreferredWidth()));
        p.setProperty(myPrefix + PROP_SORT_RANK, Integer.toString(this.sortRank));
        p.setProperty(myPrefix + PROP_ASCENDING, this.ascending ? "true" : "false");
        if (this.headerValue != null) {
            p.setProperty(myPrefix + PROP_HEADER_VALUE, this.headerValue.toString());
        }
    }

    @Override
    public int compareTo(ETableColumn obj) {
        if (this.modelIndex < obj.modelIndex) {
            return -1;
        }
        if (this.modelIndex > obj.modelIndex) {
            return 1;
        }
        return 0;
    }

    protected Comparator<ETable.RowMapping> getRowComparator(int column, boolean ascending) {
        if (ascending) {
            return new RowComparator(column);
        }
        return new FlippingComparator(new RowComparator(column));
    }

    public void setNestedComparator(Comparator c) {
        this.nestedComparator = c;
    }

    public Comparator getNestedComparator() {
        return this.nestedComparator;
    }

    @Override
    protected TableCellRenderer createDefaultHeaderRenderer() {
        if (this.myHeaderRenderer == null) {
            this.myHeaderRenderer = new ETableHeaderRenderer();
        }
        return this.myHeaderRenderer;
    }

    private static Icon mergeIcons(Icon icon1, Icon icon2, int x, int y, Component c) {
        int w = 0;
        int h = 0;
        if (icon1 != null) {
            w = icon1.getIconWidth();
            h = icon1.getIconHeight();
        }
        if (icon2 != null) {
            w = icon2.getIconWidth() + x > w ? icon2.getIconWidth() + x : w;
            int n = h = icon2.getIconHeight() + y > h ? icon2.getIconHeight() + y : h;
        }
        if (w < 1) {
            w = 16;
        }
        if (h < 1) {
            h = 16;
        }
        ColorModel model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null);
        Graphics2D g = buffImage.createGraphics();
        if (icon1 != null) {
            icon1.paintIcon(c, g, 0, 0);
        }
        if (icon2 != null) {
            icon2.paintIcon(c, g, x, y);
        }
        g.dispose();
        return new ImageIcon(buffImage);
    }

    public class RowComparator
    implements Comparator<ETable.RowMapping> {
        protected int column;

        public RowComparator(int column) {
            this.column = column;
        }

        @Override
        public int compare(ETable.RowMapping rm1, ETable.RowMapping rm2) {
            Object obj1 = rm1.getModelObject(this.column);
            Object obj2 = rm2.getModelObject(this.column);
            obj1 = ETableColumn.this.table.transformValue(obj1);
            obj2 = ETableColumn.this.table.transformValue(obj2);
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            if (ETableColumn.this.getNestedComparator() != null) {
                return ETableColumn.this.getNestedComparator().compare(obj1, obj2);
            }
            if (obj1 instanceof Comparable && obj1.getClass().isAssignableFrom(obj2.getClass())) {
                Comparable c1 = (Comparable)obj1;
                return c1.compareTo(obj2);
            }
            return obj1.toString().compareTo(obj2.toString());
        }
    }

    private class ETableHeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private TableCellRenderer headerRenderer = new JTable().getTableHeader().getDefaultRenderer();

        private ETableHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component res = this.headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (res instanceof JLabel) {
                JLabel label = (JLabel)res;
                String valueString = "";
                if (value != null) {
                    valueString = value.toString();
                }
                if (table instanceof ETable) {
                    ETable et = (ETable)table;
                    valueString = et.getColumnDisplayName(valueString);
                }
                Icon sortIcon = null;
                List<TableColumn> sortedColumns = ((ETableColumnModel)table.getColumnModel()).getSortedColumns();
                if (ETableColumn.this.sortRank != 0) {
                    if (sortedColumns.size() > 1) {
                        valueString = valueString == null || valueString.isEmpty() ? Integer.toString(ETableColumn.this.sortRank) : ETableColumn.this.sortRank + " " + valueString;
                    }
                    label.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
                    if (ETableColumn.this.ascending) {
                        sortIcon = UIManager.getIcon("ETableHeader.ascendingIcon");
                        if (sortIcon == null) {
                            sortIcon = new SortUpIcon();
                        }
                    } else {
                        sortIcon = UIManager.getIcon("ETableHeader.descendingIcon");
                        if (sortIcon == null) {
                            sortIcon = new SortDownIcon();
                        }
                    }
                }
                label.setText(valueString);
                if (sortIcon == null) {
                    if (ETableColumn.this.customIcon == null) {
                        Icon dummy = new Icon(){

                            @Override
                            public void paintIcon(Component c, Graphics g, int x, int y) {
                            }

                            @Override
                            public int getIconWidth() {
                                return 0;
                            }

                            @Override
                            public int getIconHeight() {
                                return 0;
                            }
                        };
                        label.setIcon(dummy);
                    } else {
                        label.setIcon(ETableColumn.this.customIcon);
                    }
                } else if (ETableColumn.this.customIcon == null) {
                    label.setIcon(sortIcon);
                } else {
                    label.setIcon(ETableColumn.mergeIcons(ETableColumn.this.customIcon, sortIcon, 16, 0, this));
                }
            }
            return res;
        }
    }

    static class FlippingComparator
    implements Comparator<ETable.RowMapping> {
        private Comparator<ETable.RowMapping> origComparator;

        public FlippingComparator(Comparator<ETable.RowMapping> orig) {
            this.origComparator = orig;
        }

        @Override
        public int compare(ETable.RowMapping o1, ETable.RowMapping o2) {
            return -this.origComparator.compare(o1, o2);
        }

        public Comparator<ETable.RowMapping> getOriginalComparator() {
            return this.origComparator;
        }
    }

    private static class SortUpIcon
    implements Icon {
        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.BLACK);
            g.drawLine(x, y + 6, x + 8, y + 6);
            g.drawLine(x, y + 6, x + 4, y + 2);
            g.drawLine(x + 8, y + 6, x + 4, y + 2);
        }
    }

    private static class SortDownIcon
    implements Icon {
        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.BLACK);
            g.drawLine(x, y + 2, x + 8, y + 2);
            g.drawLine(x, y + 2, x + 4, y + 6);
            g.drawLine(x + 8, y + 2, x + 4, y + 6);
        }
    }
}

