/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.simpleunit.editor.filecreation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.editor.filecreation.BrowseFolders;
import org.netbeans.modules.cnd.editor.filecreation.CndPanelGUI;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.simpleunit.utils.MakefileUtils;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class NewTestSimplePanelGUI
extends CndPanelGUI
implements ActionListener {
    private final String baseTestName;
    private final Logger logger;
    private final String defaultExtension;
    private String expectedExtension;
    private final MIMEExtensions es;
    private final boolean fileWithoutExtension;
    protected static final String DEFAULT_TESTS_FOLDER = "tests";
    protected static final String NEW_TEST_PREFIX = NewTestSimplePanelGUI.getMessage("LBL_NewTest_NewTestPrefix");
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JTextArea createdFileArea;
    private JLabel createdFileLabel;
    private JComboBox extensionComboBox;
    private JLabel extensionLabel;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JTextArea modifiedFileArea;
    private JLabel modifiedFileLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JLabel sourceLabel;
    private JTextField sourceTextField;
    private JSeparator targetSeparator;
    private JLabel testLabel;
    private JTextField testTextField;

    NewTestSimplePanelGUI(Project project, SourceGroup[] folders, Component bottomPanel, MIMEExtensions es, String defaultExt, String baseTestName) {
        super(project, folders);
        this.baseTestName = baseTestName;
        this.logger = Logger.getLogger("cnd.editor.filecreation");
        this.es = es;
        this.fileWithoutExtension = "".equals(defaultExt);
        this.initComponents();
        this.locationComboBox.setRenderer(this.CELL_RENDERER);
        if (bottomPanel != null) {
            this.bottomPanelContainer.add(bottomPanel, "Center");
        }
        this.defaultExtension = defaultExt;
        this.initValues(null, null, null);
        this.browseButton.addActionListener(this);
        this.locationComboBox.addActionListener(this);
        this.sourceTextField.getDocument().addDocumentListener((DocumentListener)((Object)this));
        this.folderTextField.getDocument().addDocumentListener((DocumentListener)((Object)this));
        this.setName(NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)"LBL_SimpleTargetChooserPanel_Name"));
    }

    public void initValues(FileObject template, FileObject preselectedFolder, String documentName) {
        assert (this.project != null);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)this.project);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "sources is {0}", sources);
        }
        this.folders = sources.getSourceGroups("generic");
        if (this.logger.isLoggable(Level.FINE)) {
            for (int i = 0; i < this.folders.length; ++i) {
                this.logger.log(Level.FINE, "folders[{0}] = {1}", new Object[]{i, this.folders[i]});
            }
        }
        if (this.folders.length < 2) {
            this.locationLabel.setVisible(false);
            this.locationComboBox.setVisible(false);
        } else {
            this.locationLabel.setVisible(true);
            this.locationComboBox.setVisible(true);
        }
        this.locationComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup preselectedGroup = NewTestSimplePanelGUI.getPreselectedGroup((SourceGroup[])this.folders, (FileObject)preselectedFolder);
        this.locationComboBox.setSelectedItem(preselectedGroup);
        this.folderTextField.setText(NewTestSimplePanelGUI.getRelativeNativeName((FileObject)preselectedGroup.getRootFolder(), (FileObject)preselectedFolder));
        if (this.folderTextField.getText().isEmpty()) {
            this.folderTextField.setText(DEFAULT_TESTS_FOLDER);
        }
        String ext = this.defaultExtension == null ? this.es.getDefaultExtension() : this.defaultExtension;
        this.extensionComboBox.setSelectedItem(ext);
        this.extensionComboBox.enableInputMethods(true);
        this.expectedExtension = ext;
        Component editorComp = this.extensionComboBox.getEditor().getEditorComponent();
        if (editorComp instanceof JTextField) {
            ((JTextField)editorComp).getDocument().addDocumentListener(new DocumentListener(){

                private void update(Document doc) {
                    try {
                        NewTestSimplePanelGUI.this.expectedExtension = doc.getText(0, doc.getLength());
                        NewTestSimplePanelGUI.this.updateCreatedFile();
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update(e.getDocument());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update(e.getDocument());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update(e.getDocument());
                }
            });
        }
        String displayName = null;
        try {
            if (template != null) {
                DataObject templateDo = DataObject.find((FileObject)template);
                displayName = templateDo.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        if (template != null) {
            if (documentName == null) {
                FileObject currentFolder;
                String baseName;
                documentName = baseName = this.baseTestName == null ? NEW_FILE_PREFIX + template.getName() : NewTestSimplePanelGUI.getMessage("TestFileSuggestedName", this.baseTestName).replaceAll(" ", "_").toLowerCase();
                FileObject fileObject = currentFolder = preselectedFolder != null ? preselectedFolder : this.getTargetGroup().getRootFolder().getFileObject(DEFAULT_TESTS_FOLDER);
                if (currentFolder != null) {
                    FileObject _tmp;
                    int index = 0;
                    while ((_tmp = currentFolder.getFileObject(documentName, ext)) != null) {
                        documentName = baseName + ++index;
                    }
                }
            }
            this.sourceTextField.setText(documentName);
        }
        if (template != null) {
            String baseName;
            String testName = baseName = this.baseTestName == null ? NEW_TEST_PREFIX + displayName : NewTestSimplePanelGUI.getMessage("TestSuggestedName", this.baseTestName);
            Folder testsRoot = NewTestSimplePanelGUI.getTestsRootFolder(this.project);
            if (testsRoot != null) {
                int index = 0;
                while (true) {
                    boolean exist = false;
                    for (Folder folder : testsRoot.getFolders()) {
                        if (!folder.getDisplayName().equals(testName)) continue;
                        exist = true;
                    }
                    if (!exist) break;
                    testName = baseName + " " + ++index;
                }
            }
            this.testTextField.setText(testName);
            this.testTextField.selectAll();
        }
        if (MakefileUtils.hasTestTargets(this.project)) {
            this.modifiedFileLabel.setVisible(false);
            this.modifiedFileArea.setVisible(false);
        } else {
            this.modifiedFileLabel.setVisible(true);
            this.modifiedFileArea.setVisible(true);
            this.modifiedFileArea.setText(FileUtil.getFileDisplayName((FileObject)MakefileUtils.getMakefile(this.project)));
        }
    }

    private static Folder getTestsRootFolder(Project project) {
        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor projectDescriptor = cdp.getConfigurationDescriptor();
        Folder root = projectDescriptor.getLogicalFolders();
        Folder testRootFolder = null;
        for (Folder folder : root.getFolders()) {
            if (!folder.isTestRootFolder()) continue;
            testRootFolder = folder;
            break;
        }
        return testRootFolder;
    }

    public SourceGroup getTargetGroup() {
        Object selectedItem = this.locationComboBox.getSelectedItem();
        if (selectedItem == null && (selectedItem = this.locationComboBox.getItemAt(this.locationComboBox.getSelectedIndex())) == null) {
            selectedItem = this.locationComboBox.getItemAt(0);
        }
        return (SourceGroup)selectedItem;
    }

    public String getTargetName() {
        return this.getTestFileName();
    }

    public String getTargetFolder() {
        return this.getTestFolder();
    }

    public String getTestFolder() {
        String folderName = this.folderTextField.getText().trim();
        if (folderName.length() == 0) {
            return "";
        }
        return folderName.replace(File.separatorChar, '/');
    }

    public String getTestFileName() {
        String documentName = this.sourceTextField.getText().trim();
        if (documentName.length() == 0) {
            return null;
        }
        String docExt = FileUtil.getExtension((String)documentName);
        if (docExt.length() == 0 && this.expectedExtension.length() > 0) {
            documentName = documentName + '.' + this.expectedExtension;
        } else assert (docExt.equals(this.expectedExtension));
        return documentName;
    }

    public String getTestName() {
        String documentName = this.testTextField.getText().trim();
        if (documentName.length() == 0) {
            return null;
        }
        return documentName;
    }

    public String getTargetExtension() {
        return this.expectedExtension;
    }

    public boolean useTargetExtensionAsDefault() {
        return false;
    }

    protected void updateCreatedFile() {
        FileObject root = this.getTargetGroup().getRootFolder();
        String folderName = this.folderTextField.getText().trim();
        String documentName = this.sourceTextField.getText().trim();
        String docExt = FileUtil.getExtension((String)documentName);
        String createdFileName = FileUtil.getFileDisplayName((FileObject)root) + (folderName.startsWith("/") || folderName.startsWith(File.separator) ? "" : "/") + folderName + (folderName.endsWith("/") || folderName.endsWith(File.separator) || folderName.length() == 0 ? "" : "/") + documentName;
        if (docExt.length() == 0) {
            this.extensionComboBox.setEnabled(true);
            createdFileName = createdFileName + "." + this.expectedExtension;
        } else {
            this.extensionComboBox.setEnabled(false);
            this.extensionComboBox.setSelectedItem(docExt);
            this.expectedExtension = docExt;
        }
        createdFileName = createdFileName.replace('/', File.separatorChar);
        if (!createdFileName.equals(this.createdFileArea.getText())) {
            this.createdFileArea.setText(createdFileName);
            this.changeSupport.fireChange();
        }
    }

    private DefaultComboBoxModel getExtensionsCBModel() {
        Vector vExt = new Vector(this.es.getValues());
        return new DefaultComboBoxModel(vExt);
    }

    private void initComponents() {
        this.testLabel = new JLabel();
        this.testTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.sourceLabel = new JLabel();
        this.sourceTextField = new JTextField();
        this.extensionLabel = new JLabel();
        this.extensionComboBox = new JComboBox();
        this.createdFileLabel = new JLabel();
        this.createdFileArea = new JTextArea();
        this.modifiedFileLabel = new JLabel();
        this.modifiedFileArea = new JTextArea();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.testLabel.setLabelFor(this.testTextField);
        Mnemonics.setLocalizedText((JLabel)this.testLabel, (String)NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)"LBL_TargetChooser_Test_Name_Label"));
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)"LBL_TargetChooser_Project_Label"));
        this.projectTextField.setEditable(false);
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)"LBL_TargetChooser_Location_Label"));
        this.folderLabel.setLabelFor(this.folderTextField);
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)"LBL_TargetChooser_Browse_Button"));
        this.sourceLabel.setLabelFor(this.sourceTextField);
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)"LBL_TargetChooser_Test_File_Name_Label"));
        this.extensionLabel.setLabelFor(this.extensionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.extensionLabel, (String)NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)"LBL_TargetChooser_Extension_Label"));
        this.extensionComboBox.setEditable(true);
        this.extensionComboBox.setModel(this.getExtensionsCBModel());
        this.extensionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTestSimplePanelGUI.this.extensionComboBoxActionPerformed(evt);
            }
        });
        this.createdFileLabel.setDisplayedMnemonic('C');
        this.createdFileLabel.setLabelFor(this.createdFileArea);
        Mnemonics.setLocalizedText((JLabel)this.createdFileLabel, (String)NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)"LBL_TargetChooser_CreatedFile_Label"));
        this.createdFileArea.setColumns(20);
        this.createdFileArea.setEditable(false);
        this.createdFileArea.setRows(1);
        this.createdFileArea.setFocusable(false);
        this.createdFileArea.setOpaque(false);
        this.modifiedFileLabel.setLabelFor(this.modifiedFileArea);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFileLabel, (String)NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)"LBL_TargetChooser_ModifiedFile_Label"));
        this.modifiedFileArea.setColumns(20);
        this.modifiedFileArea.setEditable(false);
        this.modifiedFileArea.setRows(1);
        this.modifiedFileArea.setFocusable(false);
        this.modifiedFileArea.setOpaque(false);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testLabel).addComponent(this.projectLabel).addComponent(this.locationLabel).addComponent(this.folderLabel).addComponent(this.sourceLabel).addComponent(this.extensionLabel).addComponent(this.createdFileLabel).addComponent(this.modifiedFileLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.createdFileArea, 0, 231, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.extensionComboBox, -2, -1, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.folderTextField, -1, 156, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addComponent(this.locationComboBox, GroupLayout.Alignment.TRAILING, 0, 231, Short.MAX_VALUE).addComponent(this.testTextField, GroupLayout.Alignment.TRAILING, -1, 231, Short.MAX_VALUE).addComponent(this.projectTextField, GroupLayout.Alignment.TRAILING, -1, 231, Short.MAX_VALUE).addComponent(this.sourceTextField, GroupLayout.Alignment.TRAILING, -1, 231, Short.MAX_VALUE).addComponent(this.modifiedFileArea, 0, 231, Short.MAX_VALUE))).addComponent(this.targetSeparator, -1, 345, Short.MAX_VALUE).addComponent(this.bottomPanelContainer, GroupLayout.Alignment.TRAILING, -1, 345, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testLabel).addComponent(this.testTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.projectTextField, -2, -1, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationLabel).addComponent(this.locationComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.folderLabel).addComponent(this.browseButton).addComponent(this.folderTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceLabel).addComponent(this.sourceTextField, -2, -1, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.extensionLabel).addComponent(this.extensionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdFileLabel).addComponent(this.createdFileArea, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modifiedFileLabel).addComponent(this.modifiedFileArea, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetSeparator, -2, -1, -2).addGap(1, 1, 1).addComponent(this.bottomPanelContainer, -1, 52, Short.MAX_VALUE)));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewTestSimplePanelGUI.class).getString("AD_projectTextField"));
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewTestSimplePanelGUI.class).getString("AD_locationComboBox"));
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewTestSimplePanelGUI.class).getString("AD_folderTextField"));
        this.browseButton.getAccessibleContext().setAccessibleName("");
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewTestSimplePanelGUI.class).getString("AD_browseButton"));
        this.sourceTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewTestSimplePanelGUI.class).getString("AD_documentNameTextField"));
        this.extensionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)"AD_ExtensionTextField"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewTestSimplePanelGUI.class).getString("AD_SimpleTargetChooserPanelGUI_1"));
    }

    private void extensionComboBoxActionPerformed(ActionEvent evt) {
        this.expectedExtension = (String)this.extensionComboBox.getSelectedItem();
        this.updateCreatedFile();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.browseButton == e.getSource()) {
            FileObject fo = null;
            SourceGroup group = this.getTargetGroup();
            fo = BrowseFolders.showDialog((SourceGroup[])new SourceGroup[]{group}, (Project)this.project, (String)this.folderTextField.getText().replace(File.separatorChar, '/'));
            if (fo != null && fo.isFolder()) {
                String relPath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fo);
                this.folderTextField.setText(relPath.replace('/', File.separatorChar));
            }
        } else if (this.locationComboBox == e.getSource()) {
            this.updateCreatedFile();
        } else if (this.extensionComboBox.getEditor() == e.getSource()) {
            this.expectedExtension = (String)this.extensionComboBox.getEditor().getItem();
            this.updateCreatedFile();
        }
    }

    protected static String getMessage(String name) {
        return NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)name);
    }

    protected static String getMessage(String name, String param) {
        return NbBundle.getMessage(NewTestSimplePanelGUI.class, (String)name, (Object)param);
    }
}

