/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import org.apache.maven.artifact.versioning.ComparableVersion;
import org.openide.util.Utilities;

public final class NBVersionInfo
implements Comparable<NBVersionInfo> {
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String packaging;
    private String projectName;
    private String classifier;
    private String projectDescription;
    private String repoId;
    private long lastModified;
    private long size;
    private boolean sourcesExists;
    private boolean javadocExists;
    private boolean signatureExists;

    public NBVersionInfo(String repoId, String groupId, String artifactId, String version, String type, String packaging, String projectName, String desc, String classifier) {
        this.repoId = repoId;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.packaging = packaging;
        this.projectName = projectName;
        this.projectDescription = desc;
        this.classifier = classifier;
    }

    public String getRepoId() {
        return this.repoId;
    }

    public boolean isJavadocExists() {
        return this.javadocExists;
    }

    public void setJavadocExists(boolean javadocExists) {
        this.javadocExists = javadocExists;
    }

    public boolean isSignatureExists() {
        return this.signatureExists;
    }

    public void setSignatureExists(boolean signatureExists) {
        this.signatureExists = signatureExists;
    }

    public boolean isSourcesExists() {
        return this.sourcesExists;
    }

    public void setSourcesExists(boolean sourcesExists) {
        this.sourcesExists = sourcesExists;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version + ":" + this.repoId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NBVersionInfo)) {
            return false;
        }
        NBVersionInfo other = (NBVersionInfo)obj;
        return this.toString().equals(other.toString()) && Utilities.compareObjects((Object)this.type, (Object)other.type) && Utilities.compareObjects((Object)this.classifier, (Object)other.classifier);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(NBVersionInfo o) {
        int c = this.groupId.compareTo(o.groupId);
        if (c != 0) {
            return c;
        }
        c = this.artifactId.compareTo(o.artifactId);
        if (c != 0) {
            return c;
        }
        c = this.version().compareTo(o.version());
        if (c != 0) {
            return -c;
        }
        if (this.type != null && o.type != null && (c = this.type.compareTo(o.type)) != 0) {
            return c;
        }
        return System.identityHashCode(this) - System.identityHashCode(o);
    }

    private ComparableVersion version() {
        if (this.version.matches("RELEASE\\d+(-.+)?")) {
            return new ComparableVersion(this.version.replaceAll("(\\d)", ".$1"));
        }
        return new ComparableVersion(this.version);
    }
}

