/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmTemplateBasedReferencedObject;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Lookup;

public abstract class CsmFileReferences {
    private static final int MAX_INHERITANCE_DEPTH = 15;
    private static final CsmFileReferences EMPTY = new Empty();
    private static CsmFileReferences DEFAULT;

    public abstract void accept(CsmScope var1, Visitor var2);

    public abstract void accept(CsmScope var1, Visitor var2, Set<CsmReferenceKind> var3);

    public abstract void visit(Collection<CsmReference> var1, ReferenceVisitor var2);

    protected CsmFileReferences() {
    }

    public static CsmFileReferences getDefault() {
        if (DEFAULT != null) {
            return DEFAULT;
        }
        DEFAULT = (CsmFileReferences)Lookup.getDefault().lookup(CsmFileReferences.class);
        return DEFAULT == null ? EMPTY : DEFAULT;
    }

    public static boolean isTemplateBased(CsmReferenceContext context) {
        if (2 <= context.size() && CsmFileReferences.isDereference(context.getToken())) {
            CsmReference ref = context.getReference(context.size() - 2);
            if (ref != null) {
                if (CsmFileReferences.getDefault().isThis(ref)) {
                    return CsmFileReferences.hasTemplateBasedAncestors(CsmFileReferences.findContextClass(context), 15);
                }
                CsmObject refObj = ref.getReferencedObject();
                if (CsmFileReferences.isTemplateParameterInvolved(refObj)) {
                    return true;
                }
                return CsmFileReferences.hasTemplateBasedAncestors(CsmFileReferences.getType(refObj), 15);
            }
        } else {
            return CsmFileReferences.hasTemplateBasedAncestors(CsmFileReferences.findContextClass(context), 15);
        }
        return false;
    }

    private static CsmType getType(CsmObject obj) {
        if (CsmKindUtilities.isFunction((CsmObject)obj)) {
            return ((CsmFunction)obj).getReturnType();
        }
        if (CsmKindUtilities.isVariable((CsmObject)obj)) {
            return ((CsmVariable)obj).getType();
        }
        if (CsmKindUtilities.isTypedef((CsmObject)obj)) {
            return ((CsmTypedef)obj).getType();
        }
        return null;
    }

    private static CsmClass findContextClass(CsmReferenceContext context) {
        CsmObject owner = context.getReference().getOwner();
        while (CsmKindUtilities.isScopeElement((CsmObject)owner)) {
            CsmFunction decl;
            if (CsmKindUtilities.isClass((CsmObject)owner)) {
                return (CsmClass)owner;
            }
            if (CsmKindUtilities.isClassMember((CsmObject)owner)) {
                return ((CsmMember)owner).getContainingClass();
            }
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)owner) ? CsmKindUtilities.isClassMember((CsmObject)(decl = ((CsmFunctionDefinition)owner).getDeclaration())) : CsmKindUtilities.isVariableDefinition((CsmObject)owner) && CsmKindUtilities.isClassMember((CsmObject)(decl = ((CsmVariableDefinition)owner).getDeclaration()))) {
                return ((CsmMember)decl).getContainingClass();
            }
            owner = ((CsmScopeElement)owner).getScope();
        }
        return null;
    }

    public static boolean hasTemplateBasedAncestors(CsmType type) {
        return CsmFileReferences.hasTemplateBasedAncestors(type, 15);
    }

    private static boolean hasTemplateBasedAncestors(CsmType type, int level) {
        if (type != null) {
            if (level == 0) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("Infinite recursion in file " + type.getContainingFile() + " class " + type));
                return false;
            }
            CsmClassifier cls = type.getClassifier();
            if (CsmKindUtilities.isClass((CsmObject)cls)) {
                return CsmFileReferences.hasTemplateBasedAncestors((CsmClass)cls, level - 1);
            }
        }
        return false;
    }

    private static boolean hasTemplateBasedAncestors(CsmClass cls, int level) {
        if (cls != null) {
            if (level == 0) {
                return false;
            }
            if (CsmFileReferences.isActualInstantiation(cls)) {
                return false;
            }
            for (CsmInheritance inh : cls.getBaseClasses()) {
                if (inh.getAncestorType().isTemplateBased()) {
                    return true;
                }
                CsmClassifier classifier = inh.getClassifier();
                if (!(classifier instanceof CsmClass) || !CsmFileReferences.hasTemplateBasedAncestors((CsmClass)classifier, level - 1)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isActualInstantiation(CsmClass cls) {
        if (CsmKindUtilities.isInstantiation((CsmObject)cls)) {
            CsmInstantiation instantiation = (CsmInstantiation)cls;
            Map mapping = instantiation.getMapping();
            for (CsmSpecializationParameter param : mapping.values()) {
                if (!CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param) || !((CsmTypeBasedSpecializationParameter)param).isTemplateBased()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isMacroBased(CsmReferenceContext context) {
        CsmReference ref;
        if (2 <= context.size() && CsmFileReferences.isDereference(context.getToken()) && (ref = context.getReference(context.size() - 2)) != null && CsmKindUtilities.isMacro((CsmObject)ref.getReferencedObject())) {
            return true;
        }
        for (int i = context.size() - 1; 0 < i; --i) {
            CsmReference ref2;
            if (context.getToken(i) != CppTokenId.LPAREN || (ref2 = context.getReference(i - 1)) == null || !CsmKindUtilities.isMacro((CsmObject)ref2.getReferencedObject())) continue;
            return true;
        }
        return false;
    }

    public static boolean isBuiltInBased(CsmReference ref) {
        CharSequence txt = null;
        if (ref != null) {
            txt = ref.getText();
        }
        if (txt != null && txt.length() > 0) {
            String strTxt = ((Object)txt).toString();
            if (strTxt.equals("__func__")) {
                return true;
            }
            if (strTxt.startsWith("__builtin_")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAfterUnresolved(CsmReferenceContext context) {
        CsmObject referencedObject;
        CsmReference ref;
        return 2 <= context.size() && CsmFileReferences.isDereference(context.getToken()) && (ref = context.getReference(context.size() - 2)) != null && !CsmFileReferences.getDefault().isThis(ref) && ((referencedObject = ref.getReferencedObject()) == null || referencedObject instanceof CsmTemplateBasedReferencedObject);
    }

    public static boolean isTemplateParameterInvolved(CsmObject obj) {
        if (CsmKindUtilities.isTemplateParameter((CsmObject)obj)) {
            return true;
        }
        CsmType type = CsmFileReferences.getType(obj);
        return type == null ? false : type.isTemplateBased();
    }

    public static boolean isDereference(CppTokenId token) {
        if (token == null) {
            return false;
        }
        switch (token) {
            case DOT: 
            case DOTMBR: 
            case ARROW: 
            case ARROWMBR: 
            case SCOPE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBracket(CppTokenId token) {
        if (token == null) {
            return false;
        }
        switch (token) {
            case LBRACE: 
            case LBRACKET: 
            case LPAREN: 
            case LT: {
                return true;
            }
        }
        return false;
    }

    protected boolean isThis(CsmReference ref) {
        return ref != null && "this".equals(ref.getText());
    }

    public static interface ReferenceVisitor {
        public void visit(CsmReference var1);
    }

    public static interface Visitor {
        public void visit(CsmReferenceContext var1);
    }

    private static final class Empty
    extends CsmFileReferences {
        Empty() {
        }

        @Override
        public void accept(CsmScope csmScope, Visitor visitor) {
        }

        @Override
        public void accept(CsmScope csmScope, Visitor visitor, Set<CsmReferenceKind> kinds) {
        }

        @Override
        public void visit(Collection<CsmReference> refs, ReferenceVisitor visitor) {
        }
    }
}

