/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javawebstart.ui.customizer.JWSCompositeCategoryProvider;
import org.netbeans.modules.javawebstart.ui.customizer.JWSCustomizerPanel;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class JWSProjectProperties {
    public static final String JNLP_ENABLED = "jnlp.enabled";
    public static final String JNLP_ICON = "jnlp.icon";
    public static final String JNLP_OFFLINE = "jnlp.offline-allowed";
    public static final String JNLP_CBASE_TYPE = "jnlp.codebase.type";
    public static final String JNLP_CBASE_USER = "jnlp.codebase.user";
    public static final String JNLP_CBASE_URL = "jnlp.codebase.url";
    public static final String JNLP_DESCRIPTOR = "jnlp.descriptor";
    public static final String JNLP_APPLET = "jnlp.applet.class";
    public static final String JNLP_SPEC = "jnlp.spec";
    public static final String JNLP_INIT_HEAP = "jnlp.initial-heap-size";
    public static final String JNLP_MAX_HEAP = "jnlp.max-heap-size";
    public static final String JNLP_SIGNED = "jnlp.signed";
    public static final String JNLP_MIXED_CODE = "jnlp.mixed.code";
    public static final String JNLP_SIGNING = "jnlp.signing";
    public static final String JNLP_SIGNING_KEYSTORE = "jnlp.signing.keystore";
    public static final String JNLP_SIGNING_KEY = "jnlp.signing.alias";
    public static final String JNLP_SIGNING_KEYSTORE_PASSWORD = "jnlp.signing.storepass";
    public static final String JNLP_SIGNING_KEY_PASSWORD = "jnlp.signing.keypass";
    public static final String RUN_CP = "run.classpath";
    public static final String BUILD_CLASSES = "build.classes.dir";
    public static final String JNLP_LAZY_JARS = "jnlp.lazy.jars";
    private static final String JNLP_LAZY_JAR = "jnlp.lazy.jar.";
    private static final String JNLP_LAZY_FORMAT = "jnlp.lazy.jar.%s";
    static final String SIGNING_GENERATED = "generated";
    static final String SIGNING_KEY = "key";
    public static final String CB_TYPE_LOCAL = "local";
    public static final String CB_TYPE_WEB = "web";
    public static final String CB_TYPE_USER = "user";
    public static final String CB_NO_CODEBASE = "no.codebase";
    public static final String DEFAULT_APPLET_WIDTH = "300";
    public static final String DEFAULT_APPLET_HEIGHT = "300";
    private static final String JAR_INDEX = "jar.index";
    private static final String JAR_ARCHIVE_DISABLED = "jar.archive.disabled";
    public static final String BUILD_SCRIPT = "buildfile";
    public static final String CB_URL_WEB = "$$codebase";
    public static final String JNLP_EXT_RES_PREFIX = "jnlp.ext.resource.";
    public static final String JNLP_APPLET_PARAMS_PREFIX = "jnlp.applet.param.";
    public static final String JNLP_APPLET_WIDTH = "jnlp.applet.width";
    public static final String JNLP_APPLET_HEIGHT = "jnlp.applet.height";
    public static final String COS_UNSUPPORTED_PROPNAME = "compile.on.save.unsupported.javawebstart";
    public static final String CB_URL_WEB_PROP_VALUE = "$$$$codebase";
    private StoreGroup jnlpPropGroup = new StoreGroup();
    private J2SEPropertyEvaluator j2sePropEval;
    private PropertyEvaluator evaluator;
    private Project project;
    private List<Map<String, String>> extResProperties;
    private List<Map<String, String>> appletParamsProperties;
    public static final String[] extResSuffixes = new String[]{"href", "name", "version"};
    public static final String[] appletParamsSuffixes = new String[]{"name", "value"};
    public static final String CONFIG_LABEL_PROPNAME = "$label";
    public static final String CONFIG_TARGET_RUN_PROPNAME = "$target.run";
    public static final String CONFIG_TARGET_DEBUG_PROPNAME = "$target.debug";
    public static final String CONFIG_TARGET_RUN = "jws-run";
    public static final String CONFIG_TARGET_DEBUG = "jws-debug";
    private static final String LIB_JAVAWS = "javaws.jar";
    private static final String LIB_PLUGIN = "plugin.jar";
    private DescType selectedDescType = null;
    boolean jnlpImplOldOrModified = false;
    String signing;
    String signingKeyStore;
    String signingKeyAlias;
    char[] signingKeyStorePassword;
    char[] signingKeyPassword;
    List<? extends File> runtimeCP;
    List<? extends File> lazyJars;
    boolean lazyJarsChanged;
    JToggleButton.ToggleButtonModel enabledModel;
    JToggleButton.ToggleButtonModel allowOfflineModel;
    ComboBoxModel codebaseModel;
    ComboBoxModel appletClassModel;
    ComboBoxModel mixedCodeModel;
    ButtonModel applicationDescButtonModel;
    ButtonModel appletDescButtonModel;
    ButtonModel compDescButtonModel;
    private ButtonGroup bg;
    PropertiesTableModel extResTableModel;
    PropertiesTableModel appletParamsTableModel;
    Document iconDocument;
    Document codebaseURLDocument;
    Document appletWidthDocument;
    Document appletHeightDocument;

    public JWSProjectProperties(Lookup context) {
        this.project = (Project)context.lookup(Project.class);
        if (this.project != null) {
            this.j2sePropEval = (J2SEPropertyEvaluator)this.project.getLookup().lookup(J2SEPropertyEvaluator.class);
            this.evaluator = this.j2sePropEval.evaluator();
            this.enabledModel = this.jnlpPropGroup.createToggleButtonModel(this.evaluator, JNLP_ENABLED);
            this.allowOfflineModel = this.jnlpPropGroup.createToggleButtonModel(this.evaluator, JNLP_OFFLINE);
            this.iconDocument = this.jnlpPropGroup.createStringDocument(this.evaluator, JNLP_ICON);
            this.appletWidthDocument = this.jnlpPropGroup.createStringDocument(this.evaluator, JNLP_APPLET_WIDTH);
            this.appletHeightDocument = this.jnlpPropGroup.createStringDocument(this.evaluator, JNLP_APPLET_HEIGHT);
            this.codebaseModel = new CodebaseComboBoxModel();
            this.codebaseURLDocument = this.createCBTextFieldDocument();
            this.appletClassModel = new AppletClassComboBoxModel(this.project);
            this.mixedCodeModel = JWSProjectProperties.createMixedCodeModel(this.j2sePropEval.evaluator());
            this.initRadioButtons();
            this.initSigning(this.evaluator);
            this.extResProperties = JWSProjectProperties.readProperties(this.evaluator, JNLP_EXT_RES_PREFIX, extResSuffixes);
            this.appletParamsProperties = JWSProjectProperties.readProperties(this.evaluator, JNLP_APPLET_PARAMS_PREFIX, appletParamsSuffixes);
            this.initResources(this.evaluator, this.project);
            FileObject jnlpImlpFO = this.project.getProjectDirectory().getFileObject("nbproject/jnlp-impl.xml");
            if (jnlpImlpFO != null) {
                try {
                    String crc = JWSCompositeCategoryProvider.computeCrc32(jnlpImlpFO.getInputStream());
                    this.jnlpImplOldOrModified = !JWSCompositeCategoryProvider.isJnlpImplCurrentVer(crc);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    boolean isJWSEnabled() {
        return !this.jnlpImplOldOrModified && this.enabledModel.isSelected();
    }

    public DescType getDescTypeProp() {
        if (this.selectedDescType != null) {
            return this.selectedDescType;
        }
        String desc = this.evaluator.getProperty(JNLP_DESCRIPTOR);
        DescType toReturn = desc != null ? DescType.valueOf(desc) : DescType.application;
        return toReturn;
    }

    public void updateDescType() {
        this.selectedDescType = this.getSelectedDescType();
    }

    public List<Map<String, String>> getExtResProperties() {
        return this.extResProperties;
    }

    public void setExtResProperties(List<Map<String, String>> props) {
        this.extResProperties = props;
    }

    public List<Map<String, String>> getAppletParamsProperties() {
        return this.appletParamsProperties;
    }

    public void setAppletParamsProperties(List<Map<String, String>> props) {
        this.appletParamsProperties = props;
    }

    private void initRadioButtons() {
        this.applicationDescButtonModel = new JToggleButton.ToggleButtonModel();
        this.appletDescButtonModel = new JToggleButton.ToggleButtonModel();
        this.compDescButtonModel = new JToggleButton.ToggleButtonModel();
        this.bg = new ButtonGroup();
        this.applicationDescButtonModel.setGroup(this.bg);
        this.appletDescButtonModel.setGroup(this.bg);
        this.compDescButtonModel.setGroup(this.bg);
        String desc = this.evaluator.getProperty(JNLP_DESCRIPTOR);
        if (desc != null) {
            if (desc.equals(DescType.application.toString())) {
                this.applicationDescButtonModel.setSelected(true);
            } else if (desc.equals(DescType.applet.toString())) {
                this.appletDescButtonModel.setSelected(true);
            } else if (desc.equals(DescType.component.toString())) {
                this.compDescButtonModel.setSelected(true);
            }
        } else {
            this.applicationDescButtonModel.setSelected(true);
        }
    }

    private void storeRest(EditableProperties editableProps, EditableProperties privProps) {
        DescType descType;
        String appletClassName;
        String selItem = ((CodebaseComboBoxModel)this.codebaseModel).getSelectedCodebaseItem();
        String propName = null;
        String propValue = null;
        if (CB_TYPE_USER.equals(selItem)) {
            propName = JNLP_CBASE_USER;
            try {
                propValue = this.codebaseURLDocument.getText(0, this.codebaseURLDocument.getLength());
            }
            catch (BadLocationException ex) {
                return;
            }
        } else if (!CB_TYPE_LOCAL.equals(selItem) && CB_TYPE_WEB.equals(selItem)) {
            propName = JNLP_CBASE_URL;
            propValue = CB_URL_WEB_PROP_VALUE;
        }
        editableProps.setProperty(JNLP_CBASE_TYPE, selItem);
        if (propName != null && propValue != null) {
            editableProps.setProperty(propName, propValue);
        }
        if ((appletClassName = (String)this.appletClassModel.getSelectedItem()) != null && !appletClassName.equals("")) {
            editableProps.setProperty(JNLP_APPLET, appletClassName);
            String appletWidth = null;
            try {
                appletWidth = this.appletWidthDocument.getText(0, this.appletWidthDocument.getLength());
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            if (appletWidth == null || "".equals(appletWidth)) {
                editableProps.setProperty(JNLP_APPLET_WIDTH, "300");
            }
            String appletHeight = null;
            try {
                appletHeight = this.appletHeightDocument.getText(0, this.appletHeightDocument.getLength());
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            if (appletHeight == null || "".equals(appletHeight)) {
                editableProps.setProperty(JNLP_APPLET_HEIGHT, "300");
            }
        }
        if ((descType = this.getSelectedDescType()) != null) {
            editableProps.setProperty(JNLP_DESCRIPTOR, descType.toString());
        }
        MixedCodeOptions option = (MixedCodeOptions)((Object)this.mixedCodeModel.getSelectedItem());
        editableProps.setProperty(JNLP_MIXED_CODE, option.getPropertyValue());
        if (editableProps.getProperty(JAR_INDEX) == null) {
            editableProps.setProperty(JAR_INDEX, String.format("${%s}", JNLP_ENABLED));
        }
        if (editableProps.getProperty(JAR_ARCHIVE_DISABLED) == null) {
            editableProps.setProperty(JAR_ARCHIVE_DISABLED, String.format("${%s}", JNLP_ENABLED));
        }
        editableProps.setProperty(JNLP_SIGNING, this.signing);
        editableProps.setProperty(JNLP_SIGNED, "".equals(this.signing) ? "false" : "true");
        this.setOrRemove(editableProps, JNLP_SIGNING_KEY, this.signingKeyAlias);
        this.setOrRemove(editableProps, JNLP_SIGNING_KEYSTORE, this.signingKeyStore);
        this.setOrRemove(privProps, JNLP_SIGNING_KEYSTORE_PASSWORD, this.signingKeyStorePassword);
        this.setOrRemove(privProps, JNLP_SIGNING_KEY_PASSWORD, this.signingKeyPassword);
        this.storeResources(editableProps);
        JWSProjectProperties.storeProperties(editableProps, this.extResProperties, JNLP_EXT_RES_PREFIX);
        JWSProjectProperties.storeProperties(editableProps, this.appletParamsProperties, JNLP_APPLET_PARAMS_PREFIX);
    }

    private void setOrRemove(EditableProperties props, String name, char[] value) {
        this.setOrRemove(props, name, value != null ? new String(value) : null);
    }

    private void setOrRemove(EditableProperties props, String name, String value) {
        if (value != null) {
            props.setProperty(name, value);
        } else {
            props.remove((Object)name);
        }
    }

    public void store() throws IOException {
        final EditableProperties ep = new EditableProperties(true);
        final FileObject projPropsFO = this.project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final EditableProperties pep = new EditableProperties(true);
        final FileObject privPropsFO = this.project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        try {
            final InputStream is = projPropsFO.getInputStream();
            final InputStream pis = privPropsFO.getInputStream();
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    try {
                        ep.load(is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    try {
                        pep.load(pis);
                    }
                    finally {
                        if (pis != null) {
                            pis.close();
                        }
                    }
                    JWSProjectProperties.this.jnlpPropGroup.store(ep);
                    JWSProjectProperties.this.storeRest(ep, pep);
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        lock = projPropsFO.lock();
                        os = projPropsFO.getOutputStream(lock);
                        ep.store(os);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    try {
                        lock = privPropsFO.lock();
                        os = privPropsFO.getOutputStream(lock);
                        pep.store(os);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    JWSProjectProperties.updateWebStartJars(JWSProjectProperties.this.project, JWSProjectProperties.this.evaluator);
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
    }

    private DescType getSelectedDescType() {
        DescType toReturn = null;
        if (this.applicationDescButtonModel.isSelected()) {
            toReturn = DescType.application;
        } else if (this.appletDescButtonModel.isSelected()) {
            toReturn = DescType.applet;
        } else if (this.compDescButtonModel.isSelected()) {
            toReturn = DescType.component;
        }
        return toReturn;
    }

    private Document createCBTextFieldDocument() {
        PlainDocument doc = new PlainDocument();
        String valueType = this.evaluator.getProperty(JNLP_CBASE_TYPE);
        String docString = "";
        if (CB_TYPE_LOCAL.equals(valueType)) {
            docString = this.getProjectDistDir();
        } else if (CB_TYPE_WEB.equals(valueType)) {
            docString = CB_URL_WEB;
        } else if (CB_TYPE_USER.equals(valueType)) {
            docString = this.getCodebaseLocation();
        }
        try {
            doc.insertString(0, docString, null);
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
        return doc;
    }

    public String getCodebaseLocation() {
        return this.evaluator.getProperty(JNLP_CBASE_USER);
    }

    public String getProjectDistDir() {
        String dD = this.evaluator.getProperty("dist.dir");
        File distDir = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), dD != null ? dD : "");
        return distDir.toURI().toString();
    }

    public String getProperty(String propName) {
        return this.evaluator.getProperty(propName);
    }

    public static void updateWebStartJars(Project project, PropertyEvaluator eval) throws IOException {
        FileObject srcRoot = null;
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            if (JWSProjectProperties.isTest(sg.getRootFolder(), project)) continue;
            srcRoot = sg.getRootFolder();
            break;
        }
        if (srcRoot != null) {
            Collection<Object> toAdd = JWSProjectProperties.isWebStart(eval) ? JWSProjectProperties.findWebStartJars(eval, JWSProjectProperties.isApplet(eval)) : new LinkedList();
            ClassPath bootCp = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/endorsed");
            Collection<? extends URL> included = JWSProjectProperties.findWebStartJars(bootCp);
            ArrayList<? extends URL> toRemove = new ArrayList<URL>(included);
            toRemove.removeAll(toAdd);
            toAdd.removeAll(included);
            if (!toRemove.isEmpty()) {
                ProjectClassPathModifier.removeRoots((URL[])toRemove.toArray(new URL[toRemove.size()]), (FileObject)srcRoot, (String)"classpath/endorsed");
            }
            if (!toAdd.isEmpty()) {
                ProjectClassPathModifier.addRoots((URL[])toAdd.toArray(new URL[toAdd.size()]), (FileObject)srcRoot, (String)"classpath/endorsed");
            }
        }
    }

    private static List<Map<String, String>> readProperties(PropertyEvaluator evaluator, String propPrefix, String[] propSuffixes) {
        ArrayList<Map<String, String>> listToReturn = new ArrayList<Map<String, String>>();
        int index = 0;
        while (true) {
            HashMap<String, String> map = new HashMap<String, String>();
            int numProps = 0;
            for (String propSuffix : propSuffixes) {
                String propValue = evaluator.getProperty(propPrefix + index + "." + propSuffix);
                if (propValue == null) continue;
                map.put(propSuffix, propValue);
                ++numProps;
            }
            if (numProps == 0) break;
            listToReturn.add(map);
            ++index;
        }
        return listToReturn;
    }

    private static void storeProperties(EditableProperties editableProps, List<Map<String, String>> newProps, String prefix) {
        int propGroupIndex = 0;
        Set keys = editableProps.keySet();
        HashSet<String> keys2Remove = new HashSet<String>();
        for (String string : keys) {
            if (!string.startsWith(prefix)) continue;
            keys2Remove.add(string);
        }
        for (String string : keys2Remove) {
            editableProps.remove((Object)string);
        }
        for (Map map : newProps) {
            boolean allEmpty = true;
            for (String val : map.values()) {
                if (val == null || val.equals("")) continue;
                allEmpty = false;
                break;
            }
            if (!allEmpty) {
                for (String key : map.keySet()) {
                    String value = (String)map.get(key);
                    String propName = prefix + propGroupIndex + "." + key;
                    editableProps.setProperty(propName, value);
                }
            }
            ++propGroupIndex;
        }
    }

    private void initSigning(PropertyEvaluator eval) {
        this.signing = eval.getProperty(JNLP_SIGNING);
        if (this.signing == null) {
            this.signing = "";
        }
        this.signingKeyStore = eval.getProperty(JNLP_SIGNING_KEYSTORE);
        if (this.signingKeyStore == null) {
            this.signingKeyStore = "";
        }
        this.signingKeyAlias = eval.getProperty(JNLP_SIGNING_KEY);
        if (this.signingKeyAlias == null) {
            this.signingKeyAlias = "";
        }
        if (eval.getProperty(JNLP_SIGNING_KEYSTORE_PASSWORD) != null) {
            this.signingKeyStorePassword = eval.getProperty(JNLP_SIGNING_KEYSTORE_PASSWORD).toCharArray();
        }
        if (eval.getProperty(JNLP_SIGNING_KEY_PASSWORD) != null) {
            this.signingKeyPassword = eval.getProperty(JNLP_SIGNING_KEY_PASSWORD).toCharArray();
        }
        if ("".equals(this.signing) && "true".equals(eval.getProperty(JNLP_SIGNED))) {
            this.signing = SIGNING_GENERATED;
        }
    }

    private void initResources(PropertyEvaluator eval, Project prj) {
        String[] paths;
        String lz = eval.getProperty(JNLP_LAZY_JARS);
        String rcp = eval.getProperty(RUN_CP);
        String bc = eval.getProperty(BUILD_CLASSES);
        File prjDir = FileUtil.toFile((FileObject)prj.getProjectDirectory());
        File bcDir = bc == null ? null : PropertyUtils.resolveFile((File)prjDir, (String)bc);
        ArrayList<? extends File> lazyFileList = new ArrayList<File>();
        if (lz != null) {
            for (String p : paths = PropertyUtils.tokenizePath((String)lz)) {
                lazyFileList.add(PropertyUtils.resolveFile((File)prjDir, (String)p));
            }
        }
        paths = PropertyUtils.tokenizePath((String)rcp);
        ArrayList<? extends File> resFileList = new ArrayList<File>(paths.length);
        for (String p : paths) {
            if (p.startsWith("${") && p.endsWith("}")) continue;
            File f = PropertyUtils.resolveFile((File)prjDir, (String)p);
            if (bc != null && bcDir.equals(f)) continue;
            resFileList.add(f);
            if (!JWSProjectProperties.isTrue(eval.getProperty(String.format(JNLP_LAZY_FORMAT, f.getName())))) continue;
            lazyFileList.add(f);
        }
        this.lazyJars = lazyFileList;
        this.runtimeCP = resFileList;
        this.lazyJarsChanged = false;
    }

    private void storeResources(EditableProperties props) {
        if (this.lazyJarsChanged) {
            props.remove((Object)JNLP_LAZY_JARS);
            Iterator it = props.entrySet().iterator();
            while (it.hasNext()) {
                if (!((String)((Map.Entry)it.next()).getKey()).startsWith(JNLP_LAZY_JAR)) continue;
                it.remove();
            }
            for (File file : this.lazyJars) {
                props.setProperty(String.format(JNLP_LAZY_FORMAT, file.getName()), "true");
            }
        }
    }

    private static ComboBoxModel createMixedCodeModel(PropertyEvaluator eval) {
        MixedCodeOptions value;
        assert (eval != null);
        DefaultComboBoxModel<MixedCodeOptions> model = new DefaultComboBoxModel<MixedCodeOptions>();
        for (MixedCodeOptions option : MixedCodeOptions.values()) {
            model.addElement(option);
        }
        String strValue = eval.getProperty(JNLP_MIXED_CODE);
        MixedCodeOptions mixedCodeOptions = value = strValue == null ? null : MixedCodeOptions.fromPropertyValue(strValue);
        if (value != null) {
            model.setSelectedItem((Object)value);
        }
        return model;
    }

    private static Collection<? extends URL> findWebStartJars(PropertyEvaluator evaluator, boolean applet) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>(2);
        String platformName = evaluator.getProperty("platform.active");
        if (platformName != null) {
            JavaPlatform active = null;
            for (JavaPlatform platform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                if (!platformName.equals(platform.getProperties().get("platform.ant.name"))) continue;
                active = platform;
                break;
            }
            if (active != null) {
                URL lib = JWSProjectProperties.findLib(LIB_JAVAWS, active.getInstallFolders());
                if (lib != null) {
                    result.add(lib);
                }
                if (applet && (lib = JWSProjectProperties.findLib(LIB_PLUGIN, active.getInstallFolders())) != null) {
                    result.add(lib);
                }
            }
        }
        return result;
    }

    private static Collection<? extends URL> findWebStartJars(ClassPath cp) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>(2);
        Pattern pattern = Pattern.compile(".*/(" + Pattern.quote(LIB_JAVAWS) + "|" + Pattern.quote(LIB_PLUGIN) + ")!/", 2);
        for (ClassPath.Entry entry : cp.entries()) {
            URL url = entry.getURL();
            if (!pattern.matcher(url.toString()).matches()) continue;
            result.add(url);
        }
        return result;
    }

    private static URL findLib(String name, Iterable<? extends FileObject> installFolders) throws IOException {
        if (Utilities.isMac()) {
            File deployFramework = new File("/System/Library/Frameworks/JavaVM.framework/Resources/Deploy.bundle/Contents/Home/lib/");
            File file = FileUtil.normalizeFile((File)new File(deployFramework, name));
            if (file.exists()) {
                return FileUtil.getArchiveRoot((URL)file.toURI().toURL());
            }
        } else {
            for (FileObject fileObject : installFolders) {
                FileObject lib = fileObject.getFileObject(String.format("jre/lib/%s", name));
                if (lib == null) continue;
                return FileUtil.getArchiveRoot((URL)lib.getURL());
            }
        }
        return null;
    }

    private static boolean isTest(FileObject root, Project project) {
        assert (root != null);
        assert (project != null);
        ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
        for (ClassPath.Entry entry : cp.entries()) {
            FileObject[] srcRoots;
            for (FileObject srcRoot : srcRoots = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots()) {
                if (!project.equals(FileOwnerQuery.getOwner((FileObject)srcRoot))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isWebStart(PropertyEvaluator eval) {
        assert (eval != null);
        return JWSProjectProperties.isTrue(eval.getProperty(JNLP_ENABLED));
    }

    private static boolean isApplet(PropertyEvaluator eval) {
        return DescType.applet.toString().equals(eval.getProperty(JNLP_DESCRIPTOR));
    }

    public static boolean isTrue(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }

    private static final class MixedCodeOptions
    extends Enum<MixedCodeOptions> {
        public static final /* enum */ MixedCodeOptions DEFAULT = new MixedCodeOptions("default");
        public static final /* enum */ MixedCodeOptions TRUSTED_ONLY = new MixedCodeOptions("trusted_only");
        public static final /* enum */ MixedCodeOptions TRUSTED_LIBRARY = new MixedCodeOptions("trusted_library");
        private final String propValue;
        private static final /* synthetic */ MixedCodeOptions[] $VALUES;

        public static MixedCodeOptions[] values() {
            return (MixedCodeOptions[])$VALUES.clone();
        }

        public static MixedCodeOptions valueOf(String name) {
            return Enum.valueOf(MixedCodeOptions.class, name);
        }

        private MixedCodeOptions(String propValue) {
            this.propValue = propValue;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(JWSCustomizerPanel.class, (String)String.format("TXT_MIXED_MODE_%s", this.name()));
        }

        public String getPropertyValue() {
            return this.propValue;
        }

        public String toString() {
            return this.getDisplayName();
        }

        static MixedCodeOptions fromPropertyValue(String propValue) {
            assert (propValue != null);
            for (MixedCodeOptions option : MixedCodeOptions.values()) {
                if (!propValue.equals(option.getPropertyValue())) continue;
                return option;
            }
            return null;
        }

        static {
            $VALUES = new MixedCodeOptions[]{DEFAULT, TRUSTED_ONLY, TRUSTED_LIBRARY};
        }
    }

    public static class PropertiesTableModel
    extends AbstractTableModel {
        private List<Map<String, String>> properties;
        private String[] propSuffixes;
        private String[] columnNames;

        public PropertiesTableModel(List<Map<String, String>> props, String[] sfxs, String[] clmns) {
            if (sfxs.length != clmns.length) {
                throw new IllegalArgumentException();
            }
            this.properties = props;
            this.propSuffixes = sfxs;
            this.columnNames = clmns;
        }

        @Override
        public int getRowCount() {
            return this.properties.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.properties.get(rowIndex).put(this.propSuffixes[columnIndex], (String)aValue);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.properties.get(rowIndex).get(this.propSuffixes[columnIndex]);
        }

        public void addRow() {
            HashMap<String, String> emptyMap = new HashMap<String, String>();
            for (String suffix : this.propSuffixes) {
                emptyMap.put(suffix, "");
            }
            this.properties.add(emptyMap);
        }

        public void removeRow(int index) {
            this.properties.remove(index);
        }
    }

    public class AppletClassComboBoxModel
    extends DefaultComboBoxModel {
        Set<ClassIndex.SearchKind> kinds = new HashSet<ClassIndex.SearchKind>(Arrays.asList(ClassIndex.SearchKind.IMPLEMENTORS));
        Set<ClassIndex.SearchScope> scopes = new HashSet<ClassIndex.SearchScope>(Arrays.asList(ClassIndex.SearchScope.SOURCE));

        public AppletClassComboBoxModel(Project proj) {
            Sources sources = ProjectUtils.getSources((Project)proj);
            SourceGroup[] srcGroups = sources.getSourceGroups("java");
            final HashMap classpathMap = new HashMap();
            for (SourceGroup srcGroup : srcGroups) {
                FileObject srcRoot = srcGroup.getRootFolder();
                ClassPath bootCP = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/boot");
                ClassPath executeCP = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/execute");
                ClassPath sourceCP = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/source");
                ArrayList<ClassPath> cpList = new ArrayList<ClassPath>();
                if (bootCP != null) {
                    cpList.add(bootCP);
                }
                if (executeCP != null) {
                    cpList.add(executeCP);
                }
                if (sourceCP != null) {
                    cpList.add(sourceCP);
                }
                if (cpList.size() != 3) continue;
                classpathMap.put(srcRoot, cpList);
            }
            final HashSet appletNames = new HashSet();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    for (FileObject fo : classpathMap.keySet()) {
                        List paths = (List)classpathMap.get(fo);
                        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)((ClassPath)paths.get(0)), (ClassPath)((ClassPath)paths.get(1)), (ClassPath)((ClassPath)paths.get(2)));
                        final ClassIndex classIndex = cpInfo.getClassIndex();
                        JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
                        try {
                            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                                public void run(CompilationController controller) throws Exception {
                                    Elements elems = controller.getElements();
                                    TypeElement appletElement = elems.getTypeElement("java.applet.Applet");
                                    ElementHandle appletHandle = ElementHandle.create((Element)appletElement);
                                    TypeElement jappletElement = elems.getTypeElement("javax.swing.JApplet");
                                    ElementHandle jappletHandle = ElementHandle.create((Element)jappletElement);
                                    Set appletHandles = classIndex.getElements(appletHandle, AppletClassComboBoxModel.this.kinds, AppletClassComboBoxModel.this.scopes);
                                    for (ElementHandle elemHandle : appletHandles) {
                                        appletNames.add(elemHandle.getQualifiedName());
                                    }
                                    Set jappletElemHandles = classIndex.getElements(jappletHandle, AppletClassComboBoxModel.this.kinds, AppletClassComboBoxModel.this.scopes);
                                    for (ElementHandle elemHandle : jappletElemHandles) {
                                        appletNames.add(elemHandle.getQualifiedName());
                                    }
                                }

                                public void cancel() {
                                }
                            }, true);
                        }
                        catch (Exception e) {}
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AppletClassComboBoxModel.this.addElements(appletNames);
                            String appletClassName = JWSProjectProperties.this.evaluator.getProperty(JWSProjectProperties.JNLP_APPLET);
                            if (appletClassName != null && appletNames.contains(appletClassName)) {
                                AppletClassComboBoxModel.this.setSelectedItem(appletClassName);
                            }
                        }
                    });
                }
            });
        }

        private void addElements(Set<String> elems) {
            for (String elem : elems) {
                this.addElement(elem);
            }
        }
    }

    public class CodebaseComboBoxModel
    extends DefaultComboBoxModel {
        final String localLabel = NbBundle.getBundle(JWSProjectProperties.class).getString("LBL_CB_Combo_Local");
        final String webLabel = NbBundle.getBundle(JWSProjectProperties.class).getString("LBL_CB_Combo_Web");
        final String userLabel = NbBundle.getBundle(JWSProjectProperties.class).getString("LBL_CB_Combo_User");
        final String noCodeBaseLabel = NbBundle.getMessage(JWSProjectProperties.class, (String)"LBL_CB_No_Codebase");
        final String[] visItems = new String[]{this.noCodeBaseLabel, this.localLabel, this.webLabel, this.userLabel};
        final String[] cbItems = new String[]{"no.codebase", "local", "web", "user"};

        public CodebaseComboBoxModel() {
            for (String visItem : this.visItems) {
                this.addElement(visItem);
            }
            String propValue = JWSProjectProperties.this.evaluator.getProperty(JWSProjectProperties.JNLP_CBASE_TYPE);
            for (int i = 0; i < this.cbItems.length; ++i) {
                if (!this.cbItems[i].equals(propValue)) continue;
                this.setSelectedItem(this.visItems[i]);
                break;
            }
        }

        public String getSelectedCodebaseItem() {
            return this.cbItems[this.getIndexOf(this.getSelectedItem())];
        }
    }

    public static enum DescType {
        application,
        applet,
        component;

    }
}

