/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.validation;

import java.io.IOException;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.LinkedList;
import java.util.List;
import nu.validator.htmlparser.common.CharacterHandler;
import org.xml.sax.SAXException;

public class CharacterHandlerReader
extends StringReader {
    private List<CharacterHandler> handlers = new LinkedList<CharacterHandler>();
    private boolean reading = false;

    public CharacterHandlerReader(String s) {
        super(s);
    }

    public void addCharacterHandler(CharacterHandler handler) {
        this.handlers.add(handler);
    }

    public boolean removeCharacterHandler(CharacterHandler handler) {
        return this.handlers.remove(handler);
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        super.mark(readAheadLimit);
    }

    @Override
    public int read() throws IOException {
        this.reading();
        int read = super.read();
        this.characters(new char[]{(char)read}, 0, 1);
        return read;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.reading();
        int read = super.read(cbuf, off, len);
        this.characters(cbuf, off, len);
        return read;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
    }

    @Override
    public long skip(long ns) throws IOException {
        return super.skip(ns);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        this.reading();
        int len = target.remaining();
        char[] cbuf = new char[len];
        int n = this.read(cbuf, 0, len);
        if (n > 0) {
            this.characters(cbuf, 0, n);
        }
        target.put(cbuf, 0, n);
        return n;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public void close() {
        super.close();
        this.end();
    }

    private void characters(char[] chars, int offset, int len) throws IOException {
        assert (chars != null);
        assert (chars.length > 0);
        assert (offset >= 0);
        assert (len > 0);
        try {
            for (CharacterHandler handler : this.handlers) {
                handler.characters(chars, offset, len);
            }
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    private void start() throws IOException {
        try {
            for (CharacterHandler handler : this.handlers) {
                handler.start();
            }
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    private void end() {
        try {
            for (CharacterHandler handler : this.handlers) {
                handler.end();
            }
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void reading() throws IOException {
        if (!this.reading) {
            this.start();
            this.reading = true;
        }
    }
}

