/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.api.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.netbeans.modules.profiler.selector.api.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.api.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorNode;

public class PackageNode
extends ContainerNode {
    private ClientUtils.SourceCodeSelection signature;
    private SourcePackageInfo pkg;
    public static final String DEFAULT_NAME = "<default>";
    public static final Comparator COMPARATOR = new Comparator<PackageNode>(){

        @Override
        public int compare(PackageNode o1, PackageNode o2) {
            if (o1.getNodeName().equals(PackageNode.DEFAULT_NAME)) {
                return -1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    };
    protected static final Logger LOGGER = Logger.getLogger(PackageNode.class.getName());

    public PackageNode(SourcePackageInfo pkg, ContainerNode parent) {
        super(pkg.getSimpleName(), PackageNode.stripName(PackageNode.defaultizeName(pkg.getBinaryName())), Icons.getIcon((String)"LanguageIcons.Package"), parent);
        this.pkg = pkg;
        this.signature = new ClientUtils.SourceCodeSelection(pkg.getBinaryName() + ".**", null, null);
    }

    @Override
    protected final SelectorChildren getChildren() {
        return new PackageChildren();
    }

    @Override
    public final ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }

    private List<ClassNode> getContainedClasses() {
        ArrayList<ClassNode> nodes = new ArrayList<ClassNode>();
        for (SourceClassInfo clz : this.pkg.getClasses()) {
            nodes.add(new ClassNode(clz, this));
        }
        return nodes;
    }

    private List<PackageNode> getContainedPackages() {
        ArrayList<PackageNode> nodes = new ArrayList<PackageNode>();
        for (SourcePackageInfo p : this.pkg.getSubpackages()) {
            nodes.add(new PackageNode(p, this));
        }
        return nodes;
    }

    private static String defaultizeName(String name) {
        return name == null || name.length() == 0 ? DEFAULT_NAME : name;
    }

    private static String stripName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot > -1) {
            return name.substring(lastDot + 1);
        }
        return name;
    }

    private static class PackageChildren
    extends SelectorChildren<PackageNode> {
        private PackageChildren() {
        }

        @Override
        protected List<SelectorNode> prepareChildren(PackageNode parent) {
            ArrayList<SelectorNode> nodes = new ArrayList<SelectorNode>();
            List<PackageNode> subs = this.getSubpackages(parent);
            List<ClassNode> classes = this.getClasses(parent);
            nodes.addAll(subs);
            nodes.addAll(classes);
            return nodes;
        }

        private List<ClassNode> getClasses(PackageNode parent) {
            List nodes = parent.getContainedClasses();
            Collections.sort(nodes, ClassNode.COMPARATOR);
            return nodes;
        }

        private List<PackageNode> getSubpackages(PackageNode parent) {
            List nodes = parent.getContainedPackages();
            Collections.sort(nodes, COMPARATOR);
            return nodes;
        }
    }
}

