/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.api.nodes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.selector.api.nodes.ConstructorNode;
import org.netbeans.modules.profiler.selector.api.nodes.ConstructorsNode;
import org.netbeans.modules.profiler.selector.api.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.api.nodes.InnerClassesNode;
import org.netbeans.modules.profiler.selector.api.nodes.MethodNode;
import org.netbeans.modules.profiler.selector.api.nodes.MethodsNode;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorNode;

public class ClassNode
extends ContainerNode {
    private SourceClassInfo cInfo;
    public static final Comparator COMPARATOR = new Comparator<ClassNode>(){

        @Override
        public int compare(ClassNode o1, ClassNode o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };

    public ClassNode(SourceClassInfo cInfo, String displayName, Icon icon, ContainerNode parent) {
        super(cInfo.getQualifiedName(), displayName, icon, parent);
        this.cInfo = cInfo;
        if (this.isAnonymous()) {
            String implementing = null;
            Set ifcs = cInfo.getInterfaces();
            if (ifcs.size() == 1) {
                implementing = ((SourceClassInfo)ifcs.iterator().next()).getQualifiedName();
            } else {
                SourceClassInfo superType = cInfo.getSuperType();
                if (!superType.getQualifiedName().equals(Object.class.getName())) {
                    implementing = superType.getQualifiedName();
                }
            }
            if (implementing != null) {
                this.updateDisplayName(displayName + " [" + implementing + "]");
            }
        }
    }

    public ClassNode(SourceClassInfo cInfo, ContainerNode parent) {
        this(cInfo, cInfo.getSimpleName(), Icons.getIcon((String)"LanguageIcons.Class"), parent);
    }

    @Override
    protected final SelectorChildren getChildren() {
        return new ClassChildren();
    }

    public final boolean isAnonymous() {
        return this.cInfo.isAnonymous();
    }

    protected ConstructorsNode getConstructorsNode() {
        return new ConstructorsNode(this){

            @Override
            protected List<SelectorNode> getConstructorNodes(ConstructorsNode parent) {
                ArrayList<SelectorNode> constructorNodes = new ArrayList<SelectorNode>();
                for (SourceMethodInfo mi : ClassNode.this.cInfo.getConstructors()) {
                    ConstructorNode cn = new ConstructorNode(mi, parent);
                    constructorNodes.add(cn);
                }
                return constructorNodes;
            }
        };
    }

    protected MethodsNode getMethodsNode() {
        return new MethodsNode(this){

            @Override
            protected List<MethodNode> getMethodNodes(MethodsNode parent) {
                ArrayList<MethodNode> methodNodes = new ArrayList<MethodNode>();
                for (SourceMethodInfo smi : ClassNode.this.cInfo.getMethods(false)) {
                    methodNodes.add(new MethodNode(smi, parent));
                }
                return methodNodes;
            }
        };
    }

    private InnerClassesNode getInnerClassesNode() {
        return new InnerClassesNode(this){

            @Override
            protected Set<ClassNode> getInnerClassNodes(InnerClassesNode parent) {
                HashSet<ClassNode> innerClassNodes = new HashSet<ClassNode>();
                for (SourceClassInfo inner : ClassNode.this.cInfo.getInnerClases()) {
                    innerClassNodes.add(new ClassNode(inner, parent));
                }
                return innerClassNodes;
            }
        };
    }

    private static class ClassChildren
    extends SelectorChildren<ClassNode> {
        private ClassChildren() {
        }

        @Override
        protected List<SelectorNode> prepareChildren(ClassNode parent) {
            ArrayList<SelectorNode> contents = new ArrayList<SelectorNode>();
            ContainerNode content = null;
            if (!parent.isAnonymous() && (content = parent.getConstructorsNode()) != null && !content.isLeaf()) {
                contents.add(content);
            }
            if ((content = parent.getMethodsNode()) != null && !content.isLeaf()) {
                contents.add(content);
            }
            if ((content = parent.getInnerClassesNode()) != null && !content.isLeaf()) {
                contents.add(content);
            }
            return contents;
        }
    }
}

