/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.websvc.api.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.api.customization.model.JavaClass;
import org.netbeans.modules.websvc.api.customization.model.ServiceCustomization;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.WeakListeners;

public class ServicePanel
extends SaveableSectionInnerPanel {
    private Service service;
    private WSDLModel model;
    private boolean wsdlDirty;
    private DefaultItemListener itemListener;
    private JCheckBox defaultJavaClassCB;
    private JLabel javaClassLabel;
    private JTextField javaClassText;

    public ServicePanel(SectionView sectionView, Service service) {
        super(sectionView);
        this.service = service;
        this.model = this.service.getModel();
        this.initComponents();
        this.disableEnterKey();
        this.sync();
        this.itemListener = new DefaultItemListener();
        ItemListener itemListener = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.itemListener, (Object)this.defaultJavaClassCB);
        this.defaultJavaClassCB.addItemListener(itemListener);
        this.addModifier(this.javaClassText);
        this.addModifier(this.defaultJavaClassCB);
        this.addValidatee(this.javaClassText);
    }

    private void sync() {
        List list = this.service.getExtensibilityElements(ServiceCustomization.class);
        if (list.size() > 0) {
            ServiceCustomization serviceCustomization = (ServiceCustomization)list.get(0);
            JavaClass javaClass = serviceCustomization.getJavaClass();
            if (javaClass != null) {
                this.setJavaClass(javaClass.getName());
            } else {
                this.defaultJavaClassCB.setSelected(true);
                this.javaClassText.setEnabled(false);
            }
        } else {
            this.defaultJavaClassCB.setSelected(true);
            this.javaClassText.setEnabled(false);
        }
    }

    public void setJavaClass(String string) {
        this.javaClassText.setText(string);
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List list = this.service.getExtensibilityElements(ServiceCustomization.class);
        CustomizationComponentFactory customizationComponentFactory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.javaClassText || jComponent == this.defaultJavaClassCB) {
            ServiceCustomization serviceCustomization;
            JavaClass javaClass;
            String string = this.javaClassText.getText();
            if (string != null && !string.trim().equals("") && !this.defaultJavaClassCB.isSelected()) {
                if (!JaxWsUtils.isJavaIdentifier((String)string)) {
                    return;
                }
                if (list.size() == 1) {
                    ServiceCustomization serviceCustomization2 = (ServiceCustomization)list.get(0);
                    JavaClass javaClass2 = serviceCustomization2.getJavaClass();
                    if (javaClass2 == null) {
                        try {
                            javaClass2 = customizationComponentFactory.createJavaClass(this.model);
                            this.model.startTransaction();
                            javaClass2.setName(string);
                            serviceCustomization2.setJavaClass(javaClass2);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    } else {
                        try {
                            this.model.startTransaction();
                            javaClass2.setName(string);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                } else {
                    ServiceCustomization serviceCustomization3 = customizationComponentFactory.createServiceCustomization(this.model);
                    JavaClass javaClass3 = customizationComponentFactory.createJavaClass(this.model);
                    try {
                        this.model.startTransaction();
                        javaClass3.setName(string);
                        serviceCustomization3.setJavaClass(javaClass3);
                        this.service.addExtensibilityElement((ExtensibilityElement)serviceCustomization3);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else if (list.size() == 1 && (javaClass = (serviceCustomization = (ServiceCustomization)list.get(0)).getJavaClass()) != null) {
                try {
                    this.model.startTransaction();
                    serviceCustomization.removeJavaClass(javaClass);
                    if (serviceCustomization.getChildren().size() == 0) {
                        this.service.removeExtensibilityElement((ExtensibilityElement)serviceCustomization);
                    }
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        if (jTextComponent == this.javaClassText && !JaxWsUtils.isJavaIdentifier((String)string)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, string, (JComponent)jTextComponent));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (jTextComponent == this.javaClassText) {
            ServiceCustomization serviceCustomization;
            JavaClass javaClass;
            String string = "";
            List list = this.service.getExtensibilityElements(ServiceCustomization.class);
            if (list.size() == 1 && (javaClass = (serviceCustomization = (ServiceCustomization)list.get(0)).getJavaClass()) != null) {
                string = javaClass.getName();
            }
            this.javaClassText.setText(string);
        }
    }

    @Override
    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    @Override
    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.javaClassLabel = new JLabel();
        this.javaClassText = new JTextField();
        this.defaultJavaClassCB = new JCheckBox();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.javaClassLabel.setText(resourceBundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.setToolTipText(resourceBundle.getString("TOOLTIP_SERVICE_CLASS"));
        this.defaultJavaClassCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultJavaClassCB.setText(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.defaultJavaClassCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultJavaClassCB.setContentAreaFilled(false);
        this.defaultJavaClassCB.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.javaClassLabel).addGap(21, 21, 21).addComponent(this.javaClassText, -2, 172, -2).addGap(20, 20, 20).addComponent(this.defaultJavaClassCB).addContainerGap(70, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(31, 31, 31).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaClassLabel).addComponent(this.javaClassText, -2, -1, -2).addComponent(this.defaultJavaClassCB)).addContainerGap(29, Short.MAX_VALUE)));
        this.javaClassLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_JAVA_CLASS"));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_USE_DEFAULT"));
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (ServicePanel.this.defaultJavaClassCB.isSelected()) {
                ServicePanel.this.javaClassText.setEnabled(false);
            } else {
                ServicePanel.this.javaClassText.setEnabled(true);
                ServicePanel.this.javaClassText.requestFocus();
            }
        }
    }
}

