/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.shelve.impl;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.versioning.shelve.ShelveChangesActionsRegistry;
import org.netbeans.modules.versioning.shelve.impl.PatchStorage;
import org.netbeans.modules.versioning.shelve.impl.UnshelveChangesAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class ShelveChangesMenu
extends AbstractAction
implements DynamicMenuContent {
    public static final String PREF_KEY_SHELVED_PATCHES = "shelvedPatches";

    public final JComponent[] getMenuPresenters() {
        return new JComponent[0];
    }

    public final JComponent[] synchMenuPresenters(JComponent[] items) {
        return this.getActions();
    }

    private JComponent[] getActions() {
        List<JComponent> items = new LinkedList<JComponent>();
        items.addAll(this.getShelveActions());
        items.addAll(this.getUnshelveActions());
        if (!items.isEmpty()) {
            JMenu menu = new JMenu();
            Mnemonics.setLocalizedText((AbstractButton)menu, (String)NbBundle.getMessage(ShelveChangesMenu.class, (String)"CTL_Menu_ShelveChanges"));
            for (JComponent item : items) {
                menu.add(item);
            }
            items = Collections.singletonList(menu);
        }
        return items.toArray(new JComponent[items.size()]);
    }

    private List<JComponent> getShelveActions() {
        LinkedList<JComponent> items = new LinkedList<JComponent>();
        VCSContext ctx = VCSContext.forNodes((Node[])TopComponent.getRegistry().getActivatedNodes());
        VersioningSystem[] vs = Utils.getOwners(ctx);
        if (vs.length == 1) {
            Action action = ShelveChangesActionsRegistry.getInstance().getAction(vs[0]);
            if (action != null && action.isEnabled()) {
                JMenuItem item = new JMenuItem();
                Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
                items.add(item);
            }
            for (Action a : Utilities.actionsForPath((String)"Actions/Versioning/ShelveChanges")) {
                JMenuItem item = new JMenuItem();
                Actions.connect((JMenuItem)item, (Action)a, (boolean)false);
                items.add(item);
            }
        }
        return items;
    }

    private List<JComponent> getUnshelveActions() {
        LinkedList<JComponent> items = new LinkedList<JComponent>();
        List<String> list = Utils.getStringList(NbPreferences.forModule(ShelveChangesMenu.class), PREF_KEY_SHELVED_PATCHES);
        for (Lookup.Item item : Lookups.forPath((String)"Actions/Versioning/UnshelveChanges").lookupResult(Object.class).allItems()) {
            if (!Action.class.isAssignableFrom(item.getType()) || list.isEmpty() && item.getId().endsWith("/org-netbeans-modules-versioning-shelve-impl-UnshelveChangesAction")) continue;
            JMenuItem mItem = new JMenuItem();
            Actions.connect((JMenuItem)mItem, (Action)((Action)item.getInstance()), (boolean)false);
            items.add(mItem);
        }
        if (!list.isEmpty()) {
            List<PatchStorage.Patch> patches = PatchStorage.getInstance().getPatches();
            int i = 0;
            ListIterator<PatchStorage.Patch> it = patches.listIterator();
            while (it.hasNext() && ++i < 6) {
                PatchStorage.Patch patch = it.next();
                JMenuItem mItem = new JMenuItem();
                Actions.connect((JMenuItem)mItem, (Action)new UnshelveChangesAction(patch.getPatchName()), (boolean)false);
                items.add(mItem);
            }
        }
        return items;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

