/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectToObjectConverter
implements ConditionalGenericConverter {
    ObjectToObjectConverter() {
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return ObjectToObjectConverter.hasValueOfMethodOrConstructor(targetType.getObjectType(), sourceType.getObjectType());
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Object target;
        if (sourceType.isAssignableTo(targetType)) {
            return source;
        }
        Class<?> sourceClass = sourceType.getObjectType();
        Class<?> targetClass = targetType.getObjectType();
        Method method = ObjectToObjectConverter.getValueOfMethodOn(targetClass, sourceClass);
        if (method != null) {
            ReflectionUtils.makeAccessible(method);
            target = ReflectionUtils.invokeMethod(method, null, source);
        } else {
            Constructor<?> constructor = ObjectToObjectConverter.getConstructor(targetClass, sourceClass);
            if (constructor != null) {
                try {
                    target = constructor.newInstance(source);
                }
                catch (IllegalArgumentException ex) {
                    throw new ConversionFailedException(sourceType, targetType, source, ex);
                }
                catch (InstantiationException ex) {
                    throw new ConversionFailedException(sourceType, targetType, source, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new ConversionFailedException(sourceType, targetType, source, ex);
                }
                catch (InvocationTargetException ex) {
                    throw new ConversionFailedException(sourceType, targetType, source, ex);
                }
            } else {
                throw new IllegalStateException("No static valueOf(" + sourceClass.getName() + ") method or Constructor(" + sourceClass.getName() + ") exists on " + targetClass.getName());
            }
        }
        return target;
    }

    public static boolean hasValueOfMethodOrConstructor(Class<?> targetClass, Class<?> sourceClass) {
        return ObjectToObjectConverter.getValueOfMethodOn(targetClass, sourceClass) != null || ObjectToObjectConverter.getConstructor(targetClass, sourceClass) != null;
    }

    private static Method getValueOfMethodOn(Class<?> targetClass, Class<?> sourceClass) {
        return ClassUtils.getStaticMethod(targetClass, "valueOf", sourceClass);
    }

    private static Constructor<?> getConstructor(Class<?> targetClass, Class<?> sourceClass) {
        return ClassUtils.getConstructorIfAvailable(targetClass, sourceClass);
    }
}

