/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericConversionService
implements ConversionService,
ConverterRegistry {
    private static final Log logger = LogFactory.getLog(GenericConversionService.class);
    private static final GenericConverter NO_OP_CONVERTER = new GenericConverter(){

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return null;
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source;
        }
    };
    private final Map<Class<?>, Map<Class<?>, MatchableConverters>> converters = new HashMap(36);

    @Override
    public void addConverter(GenericConverter converter) {
        Set<GenericConverter.ConvertiblePair> convertibleTypes = converter.getConvertibleTypes();
        for (GenericConverter.ConvertiblePair convertibleType : convertibleTypes) {
            this.getMatchableConvertersList(convertibleType.getSourceType(), convertibleType.getTargetType()).add(converter);
        }
    }

    @Override
    public void addConverter(Converter<?, ?> converter) {
        GenericConverter.ConvertiblePair typeInfo = this.getRequiredTypeInfo(converter, Converter.class);
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to the determine sourceType <S> and targetType <T> which your Converter<S, T> converts between; declare these generic types.");
        }
        this.addConverter(new ConverterAdapter(typeInfo, converter));
    }

    @Override
    public void addConverterFactory(ConverterFactory<?, ?> converterFactory) {
        GenericConverter.ConvertiblePair typeInfo = this.getRequiredTypeInfo(converterFactory, ConverterFactory.class);
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to the determine sourceType <S> and targetRangeType R which your ConverterFactory<S, R> converts between; declare these generic types.");
        }
        this.addConverter(new ConverterFactoryAdapter(typeInfo, converterFactory));
    }

    @Override
    public void removeConvertible(Class<?> sourceType, Class<?> targetType) {
        this.getSourceConverterMap(sourceType).remove(targetType);
    }

    @Override
    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.canConvert(TypeDescriptor.valueOf(sourceType), TypeDescriptor.valueOf(targetType));
    }

    @Override
    public <T> T convert(Object source, Class<T> targetType) {
        return (T)this.convert(source, TypeDescriptor.forObject(source), TypeDescriptor.valueOf(targetType));
    }

    @Override
    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        this.assertNotNull(sourceType, targetType);
        if (sourceType == TypeDescriptor.NULL || targetType == TypeDescriptor.NULL) {
            return true;
        }
        return this.getConverter(sourceType, targetType) != null;
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        this.assertNotNull(sourceType, targetType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Converting value of " + sourceType + " to " + targetType));
        }
        if (sourceType == TypeDescriptor.NULL) {
            Assert.isTrue(source == null, "The source must be null if sourceType == TypeDescriptor.NULL");
            return this.convertNullSource(sourceType, targetType);
        }
        if (targetType == TypeDescriptor.NULL) {
            return null;
        }
        GenericConverter converter = this.getConverter(sourceType, targetType);
        if (converter == null) {
            throw new ConverterNotFoundException(sourceType, targetType);
        }
        return ConversionUtils.invokeConverter(converter, source, sourceType, targetType);
    }

    public String toString() {
        ArrayList<String> converterStrings = new ArrayList<String>();
        for (Map<Class<?>, MatchableConverters> targetConverters : this.converters.values()) {
            for (MatchableConverters matchable : targetConverters.values()) {
                converterStrings.add(matchable.toString());
            }
        }
        Collections.sort(converterStrings);
        StringBuilder builder = new StringBuilder();
        builder.append("ConversionService converters = ").append("\n");
        for (String converterString : converterStrings) {
            builder.append("\t");
            builder.append(converterString);
            builder.append("\n");
        }
        return builder.toString();
    }

    protected Object convertNullSource(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType.isPrimitive()) {
            throw new ConversionFailedException(sourceType, targetType, null, new IllegalArgumentException("A null value cannot be assigned to a primitive type"));
        }
        return null;
    }

    protected GenericConverter getConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        GenericConverter converter = this.findConverterForClassPair(sourceType, targetType);
        if (converter != null) {
            return converter;
        }
        return this.getDefaultConverter(sourceType, targetType);
    }

    protected GenericConverter getDefaultConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.isAssignableTo(targetType)) {
            return NO_OP_CONVERTER;
        }
        return null;
    }

    private GenericConverter.ConvertiblePair getRequiredTypeInfo(Object converter, Class<?> genericIfc) {
        Class[] args = GenericTypeResolver.resolveTypeArguments(converter.getClass(), genericIfc);
        return args != null ? new GenericConverter.ConvertiblePair(args[0], args[1]) : null;
    }

    private MatchableConverters getMatchableConvertersList(Class<?> sourceType, Class<?> targetType) {
        Map<Class<?>, MatchableConverters> sourceMap = this.getSourceConverterMap(sourceType);
        MatchableConverters matchable = sourceMap.get(targetType);
        if (matchable == null) {
            matchable = new MatchableConverters();
            sourceMap.put(targetType, matchable);
        }
        return matchable;
    }

    private Map<Class<?>, MatchableConverters> getSourceConverterMap(Class<?> sourceType) {
        Map<Class<?>, MatchableConverters> sourceMap = this.converters.get(sourceType);
        if (sourceMap == null) {
            sourceMap = new HashMap();
            this.converters.put(sourceType, sourceMap);
        }
        return sourceMap;
    }

    private void assertNotNull(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Assert.notNull(sourceType, "The sourceType to convert to is required");
        Assert.notNull(targetType, "The targetType to convert to is required");
    }

    private GenericConverter findConverterForClassPair(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Class<?> sourceObjectType;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Looking for Converter to convert from " + sourceType + " to " + targetType));
        }
        if ((sourceObjectType = sourceType.getObjectType()).isInterface()) {
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(sourceObjectType);
            while (!classQueue.isEmpty()) {
                Class<?>[] interfaces;
                Class currentClass = (Class)classQueue.removeLast();
                Map<Class<?>, MatchableConverters> converters = this.getTargetConvertersForSource(currentClass);
                GenericConverter converter = this.getMatchingConverterForTarget(sourceType, targetType, converters);
                if (converter != null) {
                    return converter;
                }
                Class<?>[] classArray = interfaces = currentClass.getInterfaces();
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> ifc = classArray[n2];
                    classQueue.addFirst(ifc);
                    ++n2;
                }
            }
            Map<Class<?>, MatchableConverters> objectConverters = this.getTargetConvertersForSource(Object.class);
            return this.getMatchingConverterForTarget(sourceType, targetType, objectConverters);
        }
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(sourceObjectType);
        while (!classQueue.isEmpty()) {
            Class<?>[] interfaces;
            Class currentClass = (Class)classQueue.removeLast();
            Map<Class<?>, MatchableConverters> converters = this.getTargetConvertersForSource(currentClass);
            GenericConverter converter = this.getMatchingConverterForTarget(sourceType, targetType, converters);
            if (converter != null) {
                return converter;
            }
            if (currentClass.isArray()) {
                Class<?> componentType = ClassUtils.resolvePrimitiveIfNecessary(currentClass.getComponentType());
                if (componentType.getSuperclass() == null) continue;
                classQueue.addFirst(Array.newInstance(componentType.getSuperclass(), 0).getClass());
                continue;
            }
            Class<?>[] classArray = interfaces = currentClass.getInterfaces();
            int n = interfaces.length;
            int n3 = 0;
            while (n3 < n) {
                Class<?> ifc = classArray[n3];
                this.addInterfaceHierarchy(ifc, classQueue);
                ++n3;
            }
            if (currentClass.getSuperclass() == null) continue;
            classQueue.addFirst(currentClass.getSuperclass());
        }
        return null;
    }

    private Map<Class<?>, MatchableConverters> getTargetConvertersForSource(Class<?> sourceType) {
        Map<Class<Object>, MatchableConverters> converters = this.converters.get(sourceType);
        if (converters == null) {
            converters = Collections.emptyMap();
        }
        return converters;
    }

    private GenericConverter getMatchingConverterForTarget(TypeDescriptor sourceType, TypeDescriptor targetType, Map<Class<?>, MatchableConverters> converters) {
        Class<?> targetObjectType = targetType.getObjectType();
        if (targetObjectType.isInterface()) {
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(targetObjectType);
            while (!classQueue.isEmpty()) {
                Class<?>[] interfaces;
                Class currentClass = (Class)classQueue.removeLast();
                MatchableConverters matchable = converters.get(currentClass);
                GenericConverter converter = this.matchConverter(matchable, sourceType, targetType);
                if (converter != null) {
                    return converter;
                }
                Class<?>[] classArray = interfaces = currentClass.getInterfaces();
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> ifc = classArray[n2];
                    classQueue.addFirst(ifc);
                    ++n2;
                }
            }
            return this.matchConverter(converters.get(Object.class), sourceType, targetType);
        }
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(targetObjectType);
        while (!classQueue.isEmpty()) {
            Class<?>[] interfaces;
            Class currentClass = (Class)classQueue.removeLast();
            MatchableConverters matchable = converters.get(currentClass);
            GenericConverter converter = this.matchConverter(matchable, sourceType, targetType);
            if (converter != null) {
                return converter;
            }
            if (currentClass.isArray()) {
                Class<?> componentType = ClassUtils.resolvePrimitiveIfNecessary(currentClass.getComponentType());
                if (componentType.getSuperclass() == null) continue;
                classQueue.addFirst(Array.newInstance(componentType.getSuperclass(), 0).getClass());
                continue;
            }
            Class<?>[] classArray = interfaces = currentClass.getInterfaces();
            int n = interfaces.length;
            int n3 = 0;
            while (n3 < n) {
                Class<?> ifc = classArray[n3];
                this.addInterfaceHierarchy(ifc, classQueue);
                ++n3;
            }
            if (currentClass.getSuperclass() == null) continue;
            classQueue.addFirst(currentClass.getSuperclass());
        }
        return null;
    }

    private void addInterfaceHierarchy(Class<?> ifc, LinkedList<Class<?>> classQueue) {
        classQueue.addFirst(ifc);
        Class<?>[] classArray = ifc.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inheritedIfc = classArray[n2];
            this.addInterfaceHierarchy(inheritedIfc, classQueue);
            ++n2;
        }
    }

    private GenericConverter matchConverter(MatchableConverters matchable, TypeDescriptor sourceFieldType, TypeDescriptor targetFieldType) {
        return matchable != null ? matchable.matchConverter(sourceFieldType, targetFieldType) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConverterAdapter
    implements GenericConverter {
        private final GenericConverter.ConvertiblePair typeInfo;
        private final Converter converter;

        public ConverterAdapter(GenericConverter.ConvertiblePair typeInfo, Converter<?, ?> converter) {
            this.converter = converter;
            this.typeInfo = typeInfo;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(this.typeInfo);
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return GenericConversionService.this.convertNullSource(sourceType, targetType);
            }
            return this.converter.convert(source);
        }

        public String toString() {
            return String.valueOf(this.typeInfo.getSourceType().getName()) + " -> " + this.typeInfo.getTargetType().getName() + " : " + this.converter.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConverterFactoryAdapter
    implements GenericConverter {
        private final GenericConverter.ConvertiblePair typeInfo;
        private final ConverterFactory converterFactory;

        public ConverterFactoryAdapter(GenericConverter.ConvertiblePair typeInfo, ConverterFactory<?, ?> converterFactory) {
            this.converterFactory = converterFactory;
            this.typeInfo = typeInfo;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(this.typeInfo);
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return GenericConversionService.this.convertNullSource(sourceType, targetType);
            }
            return this.converterFactory.getConverter(targetType.getObjectType()).convert(source);
        }

        public String toString() {
            return String.valueOf(this.typeInfo.getSourceType().getName()) + " -> " + this.typeInfo.getTargetType().getName() + " : " + this.converterFactory.toString();
        }
    }

    private static class MatchableConverters {
        private LinkedList<ConditionalGenericConverter> conditionalConverters;
        private GenericConverter defaultConverter;

        private MatchableConverters() {
        }

        public void add(GenericConverter converter) {
            if (converter instanceof ConditionalGenericConverter) {
                if (this.conditionalConverters == null) {
                    this.conditionalConverters = new LinkedList();
                }
                this.conditionalConverters.addFirst((ConditionalGenericConverter)converter);
            } else {
                this.defaultConverter = converter;
            }
        }

        public GenericConverter matchConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (this.conditionalConverters != null) {
                for (ConditionalGenericConverter conditional : this.conditionalConverters) {
                    if (conditional.matches(sourceType, targetType)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Conditional converter lookup [MATCHED] " + conditional));
                        }
                        return conditional;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Conditional converter lookup [DID NOT MATCH] " + conditional));
                }
            }
            if (this.defaultConverter != null && logger.isDebugEnabled()) {
                logger.debug((Object)("Default converter lookup [MATCHED] " + this.defaultConverter));
            }
            return this.defaultConverter;
        }

        public String toString() {
            if (this.conditionalConverters != null) {
                StringBuilder builder = new StringBuilder();
                Iterator it = this.conditionalConverters.iterator();
                while (it.hasNext()) {
                    builder.append(it.next());
                    if (!it.hasNext()) continue;
                    builder.append(", ");
                }
                if (this.defaultConverter != null) {
                    builder.append(", ").append(this.defaultConverter);
                }
                return builder.toString();
            }
            return this.defaultConverter.toString();
        }
    }
}

