/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.switchfiles;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.JumpList;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class CppSwitchAction
extends BaseAction {
    private static final String actionName = "cpp-switch-header-source";
    private static final String ICON = "org/netbeans/modules/cnd/navigation/resources/header_source_icon.png";
    private static CppSwitchAction instance;
    private static final RequestProcessor RP;

    public static synchronized CppSwitchAction getInstance() {
        if (instance == null) {
            instance = new CppSwitchAction();
        }
        return instance;
    }

    public CppSwitchAction() {
        super(actionName);
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.putValue("IconResource", ICON);
        this.putValue("ShortDescription", this.getDefaultShortDescription());
    }

    public void actionPerformed(ActionEvent evt, JTextComponent txt) {
        DataObject activatedDataObject = this.getActivatedDataObject();
        if (activatedDataObject != null) {
            FileObject res = CppSwitchAction.findToggleFile(activatedDataObject);
            boolean isToggled = false;
            if (res != null) {
                CppSwitchAction.doToggle(res);
                isToggled = true;
            } else {
                DataObject dob;
                CsmFile target = CppSwitchAction.getTarget(activatedDataObject);
                if (target != null && (dob = CsmUtilities.getDataObject((CsmFile)target)) != null) {
                    CppSwitchAction.doToggle(dob);
                    isToggled = true;
                }
            }
            if (!isToggled) {
                String status;
                switch (CppSwitchAction.getTargetNodeKind(activatedDataObject)) {
                    case HEADER: {
                        status = CppSwitchAction.getMessage("cpp-switch-source-not-found");
                        break;
                    }
                    case SOURCE: {
                        status = CppSwitchAction.getMessage("cpp-switch-header-not-found");
                        break;
                    }
                    default: {
                        status = CppSwitchAction.getMessage("cpp-switch-file-not-found");
                    }
                }
                StatusDisplayer.getDefault().setStatusText(status);
            }
        }
    }

    public String getPopupMenuText(JTextComponent target) {
        String trimmedNameKey = "goto-cpp-switch-file";
        switch (CppSwitchAction.getTargetNodeKind(this.getActivatedDataObject())) {
            case HEADER: {
                trimmedNameKey = "goto-cpp-header-file";
                break;
            }
            case SOURCE: {
                trimmedNameKey = "goto-cpp-source-file";
            }
        }
        return CppSwitchAction.getMessage(trimmedNameKey);
    }

    protected Object getDefaultShortDescription() {
        return CppSwitchAction.getMessage(actionName);
    }

    private DataObject getActivatedDataObject() {
        TopComponent activated;
        DataObject dob = null;
        Node[] activatedNodes = TopComponent.getRegistry().getActivatedNodes();
        if (activatedNodes != null && activatedNodes.length == 1) {
            dob = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        }
        if (dob == null && (activated = TopComponent.getRegistry().getActivated()) != null && WindowManager.getDefault().isOpenedEditorTopComponent(activated)) {
            dob = (DataObject)activated.getLookup().lookup(DataObject.class);
        }
        return dob;
    }

    private static NodeKind getTargetNodeKind(DataObject dobj) {
        if (dobj != null) {
            String mime;
            FileObject fo = dobj == null ? null : dobj.getPrimaryFile();
            String string = mime = fo == null ? "" : fo.getMIMEType();
            if ("text/x-h".equals(mime)) {
                return NodeKind.SOURCE;
            }
            if (MIMENames.isCppOrC((String)mime)) {
                return NodeKind.HEADER;
            }
        }
        return NodeKind.UNKNOWN;
    }

    private static CsmFile getTarget(DataObject dobj) {
        CsmFile f = CsmUtilities.getCsmFile((DataObject)dobj, (boolean)false, (boolean)false);
        CsmFile target = null;
        if (f != null) {
            if (f.isHeaderFile()) {
                target = CppSwitchAction.findSource(f);
            } else if (f.isSourceFile()) {
                target = CppSwitchAction.findHeader(f);
            }
        }
        return target;
    }

    static CsmFile findHeader(CsmFile source) {
        String name = CppSwitchAction.getName(((Object)source.getAbsolutePath()).toString());
        for (CsmInclude h : source.getIncludes()) {
            if (h.getIncludeFile() == null || !CndFileUtils.areFilenamesEqual((String)name, (String)CppSwitchAction.getName(((Object)h.getIncludeFile().getAbsolutePath()).toString()))) continue;
            return h.getIncludeFile();
        }
        String path = CppSwitchAction.trimExtension(((Object)source.getAbsolutePath()).toString());
        CsmFile namesake = null;
        for (CsmFile f : source.getProject().getHeaderFiles()) {
            if (!CndFileUtils.areFilenamesEqual((String)CppSwitchAction.getName(((Object)f.getAbsolutePath()).toString()), (String)name)) continue;
            if (CndFileUtils.areFilenamesEqual((String)path, (String)CppSwitchAction.trimExtension(((Object)f.getAbsolutePath()).toString()))) {
                return f;
            }
            if (namesake != null) continue;
            namesake = f;
        }
        return namesake;
    }

    static CsmFile findSource(CsmFile header) {
        String name = CppSwitchAction.getName(((Object)header.getAbsolutePath()).toString());
        Collection includers = CsmIncludeHierarchyResolver.getDefault().getFiles(header);
        for (CsmFile f : includers) {
            if (!CndFileUtils.areFilenamesEqual((String)CppSwitchAction.getName(((Object)f.getAbsolutePath()).toString()), (String)name)) continue;
            return f;
        }
        for (CsmFile f : header.getProject().getSourceFiles()) {
            if (!CndFileUtils.areFilenamesEqual((String)CppSwitchAction.getName(((Object)f.getAbsolutePath()).toString()), (String)name)) continue;
            return f;
        }
        return null;
    }

    private static void doToggle(DataObject toggled) {
        final OpenCookie oc = (OpenCookie)toggled.getCookie(OpenCookie.class);
        if (oc != null) {
            JTextComponent textComponent = EditorRegistry.lastFocusedComponent();
            JumpList.checkAddEntry((JTextComponent)textComponent);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    oc.open();
                }
            }, 0, 10);
        }
    }

    private static void doToggle(FileObject fo) {
        assert (fo != null);
        try {
            DataObject toggled = DataObject.find((FileObject)fo);
            if (toggled != null) {
                CppSwitchAction.doToggle(toggled);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    private static FileObject findToggleFile(DataObject dob) {
        FileObject res = null;
        FileObject fo = dob.getPrimaryFile();
        if (fo != null) {
            String mimeType = FileUtil.getMIMEType((FileObject)fo, (String[])new String[]{"text/x-h", "text/x-c++", "text/x-c"});
            if (MIMENames.isCppOrC((String)mimeType)) {
                res = CppSwitchAction.findBrother(dob, MIMEExtensions.get((String)"text/x-h").getValues());
            } else if ("text/x-h".equals(mimeType) && (res = CppSwitchAction.findBrother(dob, MIMEExtensions.get((String)"text/x-c++").getValues())) == null) {
                res = CppSwitchAction.findBrother(dob, MIMEExtensions.get((String)"text/x-c").getValues());
            }
        }
        return res;
    }

    private static FileObject findBrother(DataObject dob, Collection<String> extensions) {
        assert (dob != null);
        assert (dob.getPrimaryFile() != null);
        if (!extensions.isEmpty()) {
            FileObject fo = dob.getPrimaryFile();
            FileObject[] childs = fo.getParent().getChildren();
            for (String ext : extensions) {
                String ne = fo.getName() + '.' + ext;
                for (int j = 0; j < childs.length; ++j) {
                    FileObject fileObject = childs[j];
                    if (!CndFileUtils.areFilenamesEqual((String)fileObject.getNameExt(), (String)ne)) continue;
                    return fileObject;
                }
            }
        }
        return null;
    }

    private static String getName(String path) {
        int idxSlash = path.lastIndexOf(File.separatorChar);
        String name = path.substring(idxSlash == -1 ? 0 : idxSlash + 1);
        int idxDot = name.lastIndexOf(46);
        return name.substring(0, idxDot == -1 ? name.length() : idxDot);
    }

    private static String trimExtension(String path) {
        int idxDot = path.lastIndexOf(46);
        return idxDot == -1 ? path : path.substring(0, idxDot);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(CppSwitchAction.class, (String)key);
    }

    static {
        RP = new RequestProcessor(CppSwitchAction.class.getName(), 1);
    }

    private static enum NodeKind {
        HEADER,
        SOURCE,
        UNKNOWN;

    }
}

