/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Dialog;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.ConnectUsingDriverAction;
import org.netbeans.modules.db.explorer.dlg.ChoosingDriverPanel;
import org.netbeans.modules.db.explorer.dlg.ChoosingSchemaPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionPanel;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class AddConnectionWizard
extends ConnectionDialogMediator
implements WizardDescriptor.Iterator<AddConnectionWizard> {
    private String driverName;
    private String downloadFrom;
    private final Set<String> allPrivilegedFileNames = new HashSet<String>();
    private String privilegedFileName;
    private String[] steps;
    private WizardDescriptor.Panel<AddConnectionWizard>[] panels;
    private int index;
    private ChoosingDriverPanel driverPanel;
    private String pwd;
    private String driverDN;
    private String driverClass;
    private String databaseUrl;
    private String user;
    private DatabaseConnection connection;
    private List<String> schemas = null;
    private String currentSchema;
    private JDBCDriver jdbcDriver;
    private boolean increase = false;
    private WizardDescriptor wd;

    private AddConnectionWizard(String driverName, String driverClass, String databaseUrl, String user, String password) {
        assert (driverName != null || driverClass == null && databaseUrl == null && user == null) : "Inconsistent state when driverName is null but other parameters (url?" + databaseUrl + ", class?" + driverClass + ", user? " + (user == null) + " are not";
        this.updateState(driverName, driverClass, databaseUrl, user, password);
    }

    @Override
    protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection dbcon, String defaultSchema) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void showWizard(String driverName, String driverClass, String databaseUrl, String user, String password) {
        AddConnectionWizard wiz = new AddConnectionWizard(driverName, driverClass, databaseUrl, user, password);
        wiz.openWizard();
    }

    private void openWizard() {
        boolean cancelled;
        this.wd = new WizardDescriptor((WizardDescriptor.Iterator)this, (Object)this);
        this.wd.setTitleFormat(new MessageFormat("{0}"));
        this.wd.setTitle(NbBundle.getMessage(AddConnectionWizard.class, (String)"PredefinedWizard.WizardTitle"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wd);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = this.wd.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            assert (this.getDatabaseConnection() != null) : "DatabaseConnection found.";
            DatabaseConnection conn = this.getDatabaseConnection();
            if (this.getSchemas() != null) {
                conn.setSchema(this.getCurrentSchema());
            }
            try {
                ConnectionList.getDefault().add(this.getDatabaseConnection());
            }
            catch (DatabaseException ex) {
                Logger.getLogger(AddConnectionWizard.class.getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
                DbUtilities.reportError(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableToAddConnection"), ex.getMessage());
                this.closeConnection();
            }
        }
    }

    private WizardDescriptor.Panel<AddConnectionWizard>[] getPanels() {
        if (this.panels == null) {
            FileObject jarFO;
            URL[] jars;
            JDBCDriver drv = AddConnectionWizard.getDriver(this.driverName, this.driverClass);
            if (drv != null && (jars = drv.getURLs()) != null && jars.length > 0 && (jarFO = URLMapper.findFileObject((URL)jars[0])) != null && jarFO.isValid()) {
                this.allPrivilegedFileNames.add(jarFO.getNameExt());
                this.jdbcDriver = drv;
                this.increase = true;
            }
            this.driverPanel = new ChoosingDriverPanel(drv);
            this.panels = new Panel[]{this.driverPanel, new ConnectionPanel(), new ChoosingSchemaPanel()};
            this.steps = new String[this.panels.length];
            this.steps = new String[]{NbBundle.getMessage(AddConnectionWizard.class, (String)"ChoosingDriverUI.Name"), NbBundle.getMessage(AddConnectionWizard.class, (String)"ConnectionPanel.Name"), NbBundle.getMessage(AddConnectionWizard.class, (String)"ChoosingSchemaPanel.Name")};
        }
        return this.panels;
    }

    private static JDBCDriver getDriver(String driverName, String driverClass) {
        if (driverName == null) {
            return null;
        }
        JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers(driverClass);
        if (drivers != null && drivers.length > 0) {
            for (JDBCDriver drv : drivers) {
                if (!driverName.equals(drv.getName())) continue;
                return drv;
            }
        }
        return null;
    }

    public WizardDescriptor.Panel<AddConnectionWizard> current() {
        this.getPanels();
        if (this.increase) {
            ++this.index;
            this.increase = false;
        }
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    void setDriver(JDBCDriver driver) {
        this.jdbcDriver = driver;
        if (driver == null) {
            this.updateState(null, null, null, null, null);
        } else {
            this.updateState(driver.getName(), driver.getClassName(), null, null, null);
        }
    }

    JDBCDriver getDriver() {
        return this.jdbcDriver;
    }

    String getDriverDisplayName() {
        return this.driverDN;
    }

    String getDatabaseUrl() {
        return this.databaseUrl;
    }

    String getUser() {
        return this.user;
    }

    String getPassword() {
        return this.pwd;
    }

    String[] getSteps() {
        return this.steps;
    }

    void setDatabaseConnection(DatabaseConnection conn) {
        this.connection = conn;
    }

    DatabaseConnection getDatabaseConnection() {
        return this.connection;
    }

    void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    List<String> getSchemas() {
        return this.schemas;
    }

    void setCurrentSchema(String schema) {
        this.currentSchema = schema;
    }

    String getCurrentSchema() {
        return this.currentSchema;
    }

    String getDownloadFrom() {
        return this.downloadFrom;
    }

    Collection<String> getAllPrivilegedNames() {
        return this.allPrivilegedFileNames;
    }

    String getPrivilegedName() {
        return this.privilegedFileName;
    }

    @Override
    public void closeConnection() {
        Connection conn;
        if (this.connection != null && (conn = this.connection.getConnection()) != null) {
            try {
                conn.close();
                this.connection.setConnection(null);
            }
            catch (SQLException e) {
                this.connection.setConnection(null);
            }
        }
    }

    private void updateState(String driverName, String driverClass, String databaseUrl, String user, String password) {
        this.driverName = driverName;
        this.driverClass = driverClass;
        if (driverName != null) {
            if (driverName.contains("Oracle")) {
                if (driverName.contains("OCI")) {
                    this.driverDN = NbBundle.getMessage(AddConnectionWizard.class, (String)"OracleOCIDriverDisplayName");
                    this.driverClass = NbBundle.getMessage(AddConnectionWizard.class, (String)"OracleOCIDriverClass");
                    this.databaseUrl = databaseUrl != null ? databaseUrl : NbBundle.getMessage(AddConnectionWizard.class, (String)"OracleOCIDatabaseUrl");
                } else {
                    this.driverDN = NbBundle.getMessage(AddConnectionWizard.class, (String)"OracleThinDriverDisplayName");
                    this.driverClass = NbBundle.getMessage(AddConnectionWizard.class, (String)"OracleThinDriverClass");
                    this.databaseUrl = databaseUrl != null ? databaseUrl : NbBundle.getMessage(AddConnectionWizard.class, (String)"OracleThinDatabaseUrl");
                }
                this.user = user != null ? user : NbBundle.getMessage(AddConnectionWizard.class, (String)"OracleSampleUser");
                this.pwd = password != null ? password : NbBundle.getMessage(AddConnectionWizard.class, (String)"OracleSamplePassword");
                this.downloadFrom = NbBundle.getMessage(AddConnectionWizard.class, (String)"oracle.from");
                this.allPrivilegedFileNames.clear();
                this.privilegedFileName = NbBundle.getMessage(AddConnectionWizard.class, (String)"oracle.driver.name");
                StringTokenizer st = new StringTokenizer(NbBundle.getMessage(AddConnectionWizard.class, (String)"oracle.driver.name.prefix"), ",");
                while (st.hasMoreTokens()) {
                    this.allPrivilegedFileNames.add(st.nextToken().trim());
                }
            } else if (driverName.contains("MySQL")) {
                this.driverDN = NbBundle.getMessage(AddConnectionWizard.class, (String)"MySQLDriverDisplayName");
                this.driverClass = NbBundle.getMessage(AddConnectionWizard.class, (String)"MySQLDriverClass");
                this.databaseUrl = NbBundle.getMessage(AddConnectionWizard.class, (String)"MySQLSampleDatabaseUrl");
                this.user = user == null ? NbBundle.getMessage(AddConnectionWizard.class, (String)"MySQLSampleUser") : user;
                this.pwd = password == null ? NbBundle.getMessage(AddConnectionWizard.class, (String)"MySQLSamplePassword") : password;
                this.downloadFrom = NbBundle.getMessage(AddConnectionWizard.class, (String)"mysql.from");
                this.allPrivilegedFileNames.clear();
                this.privilegedFileName = NbBundle.getMessage(AddConnectionWizard.class, (String)"mysql.driver.name");
                StringTokenizer st = new StringTokenizer(NbBundle.getMessage(AddConnectionWizard.class, (String)"mysql.driver.name.prefix"), ",");
                while (st.hasMoreTokens()) {
                    this.allPrivilegedFileNames.add(st.nextToken().trim());
                }
            } else {
                this.driverClass = driverClass;
                this.databaseUrl = databaseUrl;
                this.user = user;
                this.pwd = password;
                this.downloadFrom = null;
                this.driverDN = null;
                this.privilegedFileName = "";
                this.allPrivilegedFileNames.clear();
            }
        }
    }

    public NotificationLineSupport getNotificationLineSupport() {
        return this.wd.getNotificationLineSupport();
    }

    public static interface Panel
    extends WizardDescriptor.Panel<AddConnectionWizard> {
    }
}

