/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnectionConvertor;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class ConnectionList {
    private static ConnectionList DEFAULT;
    private final List<ConnectionListener> listeners = new CopyOnWriteArrayList<ConnectionListener>();
    private Lookup.Result<DatabaseConnection> result = this.getLookupResult();

    public static ConnectionList getDefault(boolean initialize) {
        if (initialize) {
            return ConnectionList.getDefault();
        }
        return DEFAULT;
    }

    public static synchronized ConnectionList getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new ConnectionList();
        }
        return DEFAULT;
    }

    private ConnectionList() {
        this.result.allInstances();
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent e) {
                ConnectionList.this.fireListeners();
            }
        });
    }

    public DatabaseConnection[] getConnections() {
        Collection dbconns = this.result.allInstances();
        return dbconns.toArray(new DatabaseConnection[dbconns.size()]);
    }

    public DatabaseConnection getConnection(DatabaseConnection impl) {
        if (impl == null) {
            throw new NullPointerException();
        }
        DatabaseConnection[] dbconns = this.getConnections();
        for (int i = 0; i < dbconns.length; ++i) {
            if (!impl.equals(dbconns[i])) continue;
            return dbconns[i];
        }
        return null;
    }

    public void add(DatabaseConnection dbconn) throws DatabaseException {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        if (this.contains(dbconn)) {
            throw new DatabaseException(NbBundle.getMessage(ConnectionList.class, (String)"EXC_ConnectionAlreadyExists"));
        }
        try {
            DatabaseConnectionConvertor.create(dbconn);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
    }

    public boolean contains(DatabaseConnection dbconn) {
        return this.getConnection(dbconn) != null;
    }

    public void remove(DatabaseConnection dbconn) throws DatabaseException {
        if (dbconn == null) {
            throw new NullPointerException();
        }
        try {
            DatabaseConnectionConvertor.remove(dbconn);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    private void fireListeners() {
        for (ConnectionListener listener : this.listeners) {
            listener.connectionsChanged();
        }
    }

    private synchronized Lookup.Result<DatabaseConnection> getLookupResult() {
        return Lookups.forPath((String)"Databases/Connections").lookupResult(DatabaseConnection.class);
    }
}

