/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.support.SourceGroupUISupport;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class HibernateCodeGenerationPanel
extends JPanel {
    private Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JTextComponent packageComboBoxEditor;
    private HibernateEnvironment env;
    List<FileObject> configFileObjects;
    List<FileObject> revengFileObjects;
    private JCheckBox chkDomain;
    private JCheckBox chkEjb;
    private JCheckBox chkHbm;
    private JCheckBox chkJava;
    private JComboBox cmbConf;
    private JComboBox cmbLocation;
    private JComboBox cmbPackage;
    private JComboBox cmbReveng;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JTextField txtProject;

    public HibernateCodeGenerationPanel() {
        this.initComponents();
        this.packageComboBoxEditor = (JTextComponent)this.cmbPackage.getEditor().getEditorComponent();
        Document packageComboBoxDocument = this.packageComboBoxEditor.getDocument();
        packageComboBoxDocument.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                HibernateCodeGenerationPanel.this.packageChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                HibernateCodeGenerationPanel.this.packageChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HibernateCodeGenerationPanel.this.packageChanged();
            }
        });
    }

    public void initialize(Project project, FileObject targetFolder) {
        SourceGroup targetSourceGroup;
        this.project = project;
        this.env = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        this.fillConfiguration();
        this.fillRevengFiles();
        this.txtProject.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        SourceGroup[] sourceGroups = SourceGroups.getJavaSourceGroups((Project)project);
        if (sourceGroups != null && sourceGroups.length == 0) {
            sourceGroups = HibernateUtil.getSourceGroups(project);
        }
        SourceGroupUISupport.connect(this.cmbLocation, sourceGroups);
        this.cmbPackage.setRenderer(PackageView.listRenderer());
        this.updatePackageComboBox();
        if (targetFolder != null && (targetSourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])sourceGroups, (FileObject)targetFolder)) != null) {
            this.cmbLocation.setSelectedItem(targetSourceGroup);
            String targetPackage = SourceGroups.getPackageForFolder((SourceGroup)targetSourceGroup, (FileObject)targetFolder);
            if (targetPackage != null) {
                this.packageComboBoxEditor.setText(targetPackage);
            }
        }
    }

    private void fillConfiguration() {
        String[] configFiles = this.getConfigFilesFromProject(this.project);
        this.cmbConf.setModel(new DefaultComboBoxModel<String>(configFiles));
    }

    private void fillRevengFiles() {
        String[] revengFiles = this.getRevengFilesFromProject(this.project);
        this.cmbReveng.setModel(new DefaultComboBoxModel<String>(revengFiles));
    }

    public String[] getConfigFilesFromProject(Project project) {
        ArrayList<String> configFiles = new ArrayList<String>();
        this.configFileObjects = this.env.getAllHibernateConfigFileObjects();
        for (FileObject fo : this.configFileObjects) {
            configFiles.add(fo.getNameExt());
        }
        return configFiles.toArray(new String[0]);
    }

    public String[] getRevengFilesFromProject(Project project) {
        ArrayList<String> revengFiles = new ArrayList<String>();
        this.revengFileObjects = this.env.getAllHibernateReverseEnggFileObjects();
        for (FileObject fo : this.revengFileObjects) {
            revengFiles.add(fo.getNameExt());
        }
        return revengFiles.toArray(new String[0]);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    private void packageChanged() {
        this.changeSupport.fireChange();
    }

    private void updatePackageComboBox() {
        SourceGroup sourceGroup = (SourceGroup)this.cmbLocation.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel model = PackageView.createListView((SourceGroup)sourceGroup);
            if (model.getSelectedItem() != null && model.getSelectedItem().toString().startsWith("META-INF") && model.getSize() > 1) {
                model.setSelectedItem(model.getElementAt(1));
            }
            this.cmbPackage.setModel(model);
        }
    }

    public FileObject getConfigurationFile() {
        if (this.cmbConf.getSelectedIndex() != -1) {
            return this.configFileObjects.get(this.cmbConf.getSelectedIndex());
        }
        return null;
    }

    public FileObject getRevengFile() {
        if (this.cmbReveng.getSelectedIndex() != -1) {
            return this.revengFileObjects.get(this.cmbReveng.getSelectedIndex());
        }
        return null;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.cmbLocation.getSelectedItem();
    }

    public String getPackageName() {
        return this.packageComboBoxEditor.getText();
    }

    public boolean getChkDomain() {
        return this.chkDomain.isSelected();
    }

    public boolean getChkHbm() {
        return this.chkHbm.isSelected();
    }

    public boolean getChkJava() {
        return this.chkJava.isSelected();
    }

    public boolean getChkEjb() {
        return this.chkEjb.isSelected();
    }

    private void locationChanged() {
        this.updatePackageComboBox();
        this.changeSupport.fireChange();
    }

    private void configFileChnaged() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.chkDomain = new JCheckBox();
        this.chkHbm = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.txtProject = new JTextField();
        this.jLabel3 = new JLabel();
        this.cmbLocation = new JComboBox();
        this.jLabel4 = new JLabel();
        this.cmbPackage = new JComboBox();
        this.jLabel5 = new JLabel();
        this.chkJava = new JCheckBox();
        this.chkEjb = new JCheckBox();
        this.cmbConf = new JComboBox();
        this.cmbReveng = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.setName(NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"LBL_GenerateClasses"));
        this.jLabel1.setText(NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel1.text"));
        this.chkDomain.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkDomain, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.chkDomain.text"));
        this.chkHbm.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkHbm, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.chkHbm.text"));
        this.jLabel2.setLabelFor(this.txtProject);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel2.text"));
        this.txtProject.setEditable(false);
        this.txtProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateCodeGenerationPanel.this.txtProjectActionPerformed(evt);
            }
        });
        this.jLabel3.setLabelFor(this.cmbLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel3.text"));
        this.cmbLocation.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateCodeGenerationPanel.this.cmbLocationActionPerformed(evt);
            }
        });
        this.jLabel4.setLabelFor(this.cmbPackage);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel4.text"));
        this.cmbPackage.setEditable(true);
        this.cmbPackage.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel5.setText(NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkJava, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.chkJava.text"));
        this.chkJava.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateCodeGenerationPanel.this.chkJavaActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.chkEjb, (String)NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.chkEjb.text"));
        this.cmbConf.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbConf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateCodeGenerationPanel.this.cmbConfActionPerformed(evt);
            }
        });
        this.cmbReveng.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel6.setText(NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel6.text"));
        this.jLabel7.setText(NbBundle.getMessage(HibernateCodeGenerationPanel.class, (String)"HibernateCodeGenerationPanel.jLabel7.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel7, -2, 217, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbReveng, 0, 273, Short.MAX_VALUE).addComponent(this.cmbConf, 0, 273, Short.MAX_VALUE))).addComponent(this.jLabel5).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkJava).addComponent(this.chkEjb))).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkDomain).addComponent(this.chkHbm))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel4).addComponent(this.jLabel3, -2, 74, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtProject, -1, 416, Short.MAX_VALUE).addComponent(this.cmbPackage, 0, 416, Short.MAX_VALUE).addComponent(this.cmbLocation, 0, 416, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.cmbConf, -2, -1, -2)).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.cmbReveng, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkJava).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkEjb).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkDomain).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkHbm).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.txtProject, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbLocation, -2, -1, -2).addComponent(this.jLabel3)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbPackage, -2, -1, -2).addComponent(this.jLabel4)).addContainerGap()));
    }

    private void cmbLocationActionPerformed(ActionEvent evt) {
        this.locationChanged();
    }

    private void chkJavaActionPerformed(ActionEvent evt) {
    }

    private void txtProjectActionPerformed(ActionEvent evt) {
    }

    private void cmbConfActionPerformed(ActionEvent evt) {
        this.configFileChnaged();
    }
}

