/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.tool.hbm2x.HibernateMappingExporter;
import org.hibernate.tool.hbm2x.POJOExporter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.spi.hibernate.HibernateFileLocationProvider;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.HibernateCodGenNameLocationWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.HibernateCodeGenWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.HibernateCodeGenWizardHelper;
import org.netbeans.modules.hibernate.wizards.HibernateRevengDbTablesWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.WizardErrorPanel;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HibernateCodeGenWizard
implements WizardDescriptor.ProgressInstantiatingIterator {
    private static final String PROP_HELPER = "wizard-helper";
    private int index;
    private Project project;
    private WizardDescriptor wizardDescriptor;
    private HibernateCodeGenWizardHelper helper;
    private HibernateCodGenNameLocationWizardDescriptor nameLocationDescriptor;
    private HibernateRevengDbTablesWizardDescriptor dbTablesDescriptor;
    private HibernateCodeGenWizardDescriptor codeGenDescriptor;
    private WizardDescriptor.Panel[] panels;
    private final String DEFAULT_REVENG_FILENAME = "hibernate.reveng";
    private final String CATALOG_NAME = "match-catalog";
    private final String EXCLUDE_NAME = "exclude";
    private final String ATTRIBUTE_NAME = "match-schema";
    private final String MATCH_NAME = "match-name";
    private final String resourceAttr = "resource";
    private final String classAttr = "class";
    private Logger logger = Logger.getLogger(HibernateCodeGenWizard.class.getName());

    public static HibernateCodeGenWizard create() {
        return new HibernateCodeGenWizard();
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            Object object;
            String[] stringArray;
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnvironment == null) {
                this.logger.info("Unsupported project " + this.project + ". Existing config wizard.");
                this.panels = new WizardDescriptor.Panel[]{WizardErrorPanel.getWizardErrorWizardPanel()};
            } else {
                stringArray = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
                SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)stringArray).getSourceGroups("generic");
                object = Templates.createSimpleTargetChooser((Project)stringArray, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)this.nameLocationDescriptor);
                this.panels = new WizardDescriptor.Panel[]{this.codeGenDescriptor};
            }
            stringArray = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                object = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = ((Component)object).getName();
                }
                if (!(object instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)object;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    static HibernateCodeGenWizardHelper getHelper(WizardDescriptor wizardDescriptor) {
        return (HibernateCodeGenWizardHelper)wizardDescriptor.getProperty(PROP_HELPER);
    }

    public String name() {
        return NbBundle.getMessage(HibernateCodeGenWizard.class, (String)"Templates/Hibernate/CodeGen");
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizardDescriptor.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }

    private boolean foundRevengFileInProject(List<FileObject> list, String string) {
        for (FileObject fileObject : list) {
            if (!fileObject.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Set instantiate() throws IOException {
        assert (false) : "This method cannot be called if the class implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public final void initialize(WizardDescriptor wizardDescriptor) {
        Object object;
        HibernateFileLocationProvider hibernateFileLocationProvider;
        this.wizardDescriptor = wizardDescriptor;
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        this.helper = new HibernateCodeGenWizardHelper(this.project);
        wizardDescriptor.putProperty(PROP_HELPER, (Object)this.helper);
        String string = NbBundle.getMessage(HibernateCodeGenWizard.class, (String)"Templates/Hibernate/CodeGen");
        this.nameLocationDescriptor = new HibernateCodGenNameLocationWizardDescriptor(this.project, string);
        this.dbTablesDescriptor = new HibernateRevengDbTablesWizardDescriptor(this.project, string);
        this.codeGenDescriptor = new HibernateCodeGenWizardDescriptor(this.project, string);
        if (Templates.getTargetFolder((WizardDescriptor)wizardDescriptor) == null) {
            hibernateFileLocationProvider = this.project != null ? (HibernateFileLocationProvider)this.project.getLookup().lookup(HibernateFileLocationProvider.class) : null;
            Object object2 = object = hibernateFileLocationProvider != null ? hibernateFileLocationProvider.getSourceLocation() : null;
            if (object != null) {
                Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)object);
            }
        }
        if (wizardDescriptor instanceof TemplateWizard) {
            hibernateFileLocationProvider = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateFileLocationProvider == null) {
                return;
            }
            object = hibernateFileLocationProvider.getAllHibernateReverseEnggFileObjects();
            String string2 = "hibernate.reveng";
            if (!object.isEmpty() && this.foundRevengFileInProject((List<FileObject>)object, "hibernate.reveng")) {
                int n = object.size();
                string2 = "hibernate" + n++ + ".reveng";
                while (this.foundRevengFileInProject((List<FileObject>)object, string2)) {
                    string2 = "hibernate" + n++ + ".reveng";
                }
            }
            ((TemplateWizard)wizardDescriptor).setTargetName(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateClasses(FileObject fileObject, ProgressHandle progressHandle) throws IOException {
        JDBCMetaDataConfiguration jDBCMetaDataConfiguration = null;
        ReverseEngineeringSettings reverseEngineeringSettings = null;
        ClassLoader classLoader = null;
        File file = FileUtil.toFile((FileObject)this.helper.getConfigurationFile());
        File file2 = FileUtil.toFile((FileObject)this.helper.getLocation().getRootFolder());
        File file3 = FileUtil.toFile((FileObject)HibernateUtil.getFirstSourceGroup(this.project).getRootFolder());
        try {
            DefaultReverseEngineeringStrategy defaultReverseEngineeringStrategy;
            this.logger.info("Setting up classloader");
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            ClassLoader classLoader2 = hibernateEnvironment.getProjectClassLoader(hibernateEnvironment.getProjectClassPath(fileObject).toArray(new URL[0]));
            classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader2);
            try {
                jDBCMetaDataConfiguration = new JDBCMetaDataConfiguration();
                DefaultReverseEngineeringStrategy defaultReverseEngineeringStrategy2 = defaultReverseEngineeringStrategy = new DefaultReverseEngineeringStrategy();
                OverrideRepository overrideRepository = new OverrideRepository();
                Configuration configuration = jDBCMetaDataConfiguration.configure(file);
                overrideRepository.addFile(FileUtil.toFile((FileObject)fileObject));
                defaultReverseEngineeringStrategy2 = overrideRepository.getReverseEngineeringStrategy((ReverseEngineeringStrategy)defaultReverseEngineeringStrategy2);
                reverseEngineeringSettings = new ReverseEngineeringSettings((ReverseEngineeringStrategy)defaultReverseEngineeringStrategy2);
                reverseEngineeringSettings.setDefaultPackageName(this.helper.getPackageName());
                defaultReverseEngineeringStrategy.setSettings(reverseEngineeringSettings);
                defaultReverseEngineeringStrategy2.setSettings(reverseEngineeringSettings);
                jDBCMetaDataConfiguration.setReverseEngineeringStrategy(overrideRepository.getReverseEngineeringStrategy((ReverseEngineeringStrategy)defaultReverseEngineeringStrategy2));
                jDBCMetaDataConfiguration.readFromJDBC();
                jDBCMetaDataConfiguration.buildMappings();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            try {
                if (this.helper.getDomainGen()) {
                    progressHandle.progress(NbBundle.getMessage(HibernateCodeGenWizard.class, (String)"HibernateCodeGenerationPanel_WizardProgress_GenPOJO"), 1);
                    defaultReverseEngineeringStrategy = new POJOExporter((Configuration)jDBCMetaDataConfiguration, file2);
                    defaultReverseEngineeringStrategy.getProperties().setProperty("jdk5", new Boolean(this.helper.getJavaSyntax()).toString());
                    defaultReverseEngineeringStrategy.getProperties().setProperty("ejb3", new Boolean(this.helper.getEjbAnnotation()).toString());
                    defaultReverseEngineeringStrategy.start();
                    FileUtil.refreshFor((File[])new File[]{file2});
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            try {
                if (this.helper.getHbmGen()) {
                    progressHandle.progress(NbBundle.getMessage(HibernateCodeGenWizard.class, (String)"HibernateCodeGenerationPanel_WizardProgress_GenMapping"), 2);
                    defaultReverseEngineeringStrategy = new HibernateMappingExporter((Configuration)jDBCMetaDataConfiguration, file3);
                    defaultReverseEngineeringStrategy.start();
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (Throwable throwable) {
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
    }

    public void updateConfiguration() {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.helper.getConfigurationFile());
            HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)dataObject;
            SessionFactory sessionFactory = hibernateCfgDataObject.getHibernateConfiguration().getSessionFactory();
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            FileObject fileObject = SourceGroups.getFolderForPackage((SourceGroup)HibernateUtil.getFirstSourceGroup(this.project), (String)this.helper.getPackageName(), (boolean)false);
            if (fileObject != null && fileObject.isFolder()) {
                fileObject.getFileSystem().refresh(true);
                Enumeration enumeration = fileObject.getChildren(true);
                if (this.helper.getDomainGen() && this.helper.getEjbAnnotation() && !this.helper.getHbmGen()) {
                    while (enumeration.hasMoreElements()) {
                        FileObject fileObject2 = (FileObject)enumeration.nextElement();
                        if (fileObject2.getNameExt() == null || !fileObject2.getMIMEType().equals("text/x-java")) continue;
                        int n = sessionFactory.addMapping(true);
                        String string = HibernateUtil.getRelativeSourcePath(fileObject2, hibernateEnvironment.getSourceLocation());
                        String string2 = string.replaceAll("/", ".").substring(0, string.indexOf(".java", 0));
                        sessionFactory.setAttributeValue("Mapping", n, "class", string2);
                        hibernateCfgDataObject.modelUpdatedFromUI();
                        hibernateCfgDataObject.save();
                    }
                } else {
                    block3: while (enumeration.hasMoreElements()) {
                        FileObject fileObject3 = (FileObject)enumeration.nextElement();
                        if (fileObject3.getNameExt() == null || !fileObject3.getMIMEType().equals("text/x-hibernate-mapping+xml")) continue;
                        int n = sessionFactory.addMapping(true);
                        String string = HibernateUtil.getRelativeSourcePath(fileObject3, hibernateEnvironment.getSourceLocation());
                        for (int i = 0; i < n; ++i) {
                            String string3 = sessionFactory.getAttributeValue("Mapping", i, "resource");
                            if (string3 == null ? string == null : string3.equals(string)) continue block3;
                        }
                        sessionFactory.setAttributeValue("Mapping", n, "resource", string);
                        hibernateCfgDataObject.modelUpdatedFromUI();
                        hibernateCfgDataObject.save();
                    }
                }
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public Set instantiate(ProgressHandle progressHandle) throws IOException {
        progressHandle.start(3);
        try {
            this.generateClasses(this.helper.getRevengFile(), progressHandle);
            progressHandle.progress(NbBundle.getMessage(HibernateCodeGenWizard.class, (String)"HibernateCodeGenerationPanel_WizardProgress_UpdateConf"), 3);
            this.updateConfiguration();
            return Collections.singleton(this.helper.getRevengFile());
        }
        catch (Exception exception) {
            return Collections.EMPTY_SET;
        }
    }
}

