/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.SecurityTableModel;
import org.openide.util.NbBundle;

public class CollectionCachesTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Collection"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Region"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Usage")};
    private static final String[] attrNames = new String[]{"Collection", "Region", "Usage"};
    private SessionFactory sessionFactory;

    public CollectionCachesTableModel(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.sessionFactory == null) {
            return null;
        }
        String attrValue = this.sessionFactory.getAttributeValue("CollectionCache", row, attrNames[column]);
        return attrValue;
    }

    @Override
    public int getRowCount() {
        if (this.sessionFactory == null) {
            return 0;
        }
        return this.sessionFactory.sizeCollectionCache();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void addRow(String[] values) {
        int index = this.sessionFactory.addCollectionCache(true);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].length() <= 0) continue;
            this.sessionFactory.setAttributeValue("CollectionCache", index, attrNames[i], values[i]);
        }
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void editRow(int row, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.sessionFactory.setAttributeValue("CollectionCache", row, attrNames[i], values[i]);
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void removeRow(int row) {
        this.sessionFactory.removeCollectionCache(row);
        this.fireTableRowsDeleted(row, row);
    }
}

