/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.SwingUtilities;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.Security;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.HbXmlMultiViewEditorSupport;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataLoader;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataNode;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgMetadata;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.netbeans.modules.xml.multiview.XmlMultiViewElement;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.xml.sax.InputSource;

public class HibernateCfgDataObject
extends XmlMultiViewDataObject {
    private static final int TYPE_TOOLBAR = 0;
    public static final int UPDATE_DELAY = 200;
    public static final String DESIGN_VIEW_ID = "hibernate_configuration_multiview_design";
    private HibernateConfiguration configuration;
    private ModelSynchronizer modelSynchronizer;
    public static final String ICON = "org/netbeans/modules/hibernate/resources/hibernate-configuration.png";
    private static final String SECURITY_ADDED_OR_REMOVED = "security_added_or_removed";

    public HibernateCfgDataObject(FileObject pf, HibernateCfgDataLoader loader) throws DataObjectExistsException, IOException {
        super(pf, (MultiFileLoader)loader);
        this.getEditorSupport().setMIMEType("text/x-hibernate-cfg+xml");
        this.modelSynchronizer = new ModelSynchronizer(this);
        CookieSet cookies = this.getCookieSet();
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        cookies.add((Node.Cookie)checkCookie);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        cookies.add((Node.Cookie)validateCookie);
        this.parseDocument();
    }

    public boolean parseDocument() {
        block9: {
            if (this.configuration == null) {
                try {
                    this.configuration = this.getHibernateConfiguration();
                }
                catch (RuntimeException ex) {
                    return false;
                }
            }
            try {
                InputStream is = this.getEditorSupport().getInputStream();
                HibernateConfiguration newConfiguration = null;
                try {
                    newConfiguration = HibernateConfiguration.createGraph(is);
                }
                catch (RuntimeException ex) {
                    return false;
                }
                if (newConfiguration == null) break block9;
                try {
                    this.configuration.merge(newConfiguration, 3);
                }
                catch (IllegalArgumentException iae) {
                    return false;
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected String getEditorMimeType() {
        return "text/x-hibernate-cfg+xml";
    }

    public static XmlMultiViewElement createXmlMultiViewElement(Lookup lookup) {
        return new XmlMultiViewElement((XmlMultiViewDataObject)lookup.lookup(XmlMultiViewDataObject.class));
    }

    public boolean viewCanBeDisplayed() {
        boolean switchView = false;
        NotifyDescriptor.Message nd = null;
        if (!this.parseDocument() && this.getSelectedPerspective().preferredID().startsWith(DESIGN_VIEW_ID)) {
            nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(HibernateCfgDataObject.class, (String)"TXT_DocumentUnparsable", (Object)this.getPrimaryFile().getNameExt()), 2);
            switchView = true;
        }
        if (switchView) {
            DialogDisplayer.getDefault().notify(nd);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HibernateCfgDataObject.this.goToXmlView();
                }
            });
        }
        return !switchView;
    }

    public HibernateConfiguration getHibernateConfiguration() {
        if (this.configuration == null) {
            try {
                this.configuration = HibernateCfgMetadata.getDefault().getRoot(this.getPrimaryFile());
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        assert (this.configuration != null);
        return this.configuration;
    }

    public void addSessionFactory(SessionFactory sFactory) {
        this.getHibernateConfiguration().setSessionFactory(sFactory);
        this.modelUpdatedFromUI();
    }

    public void save() {
        EditorCookie edit = (EditorCookie)this.getCookie(EditorCookie.class);
        if (edit != null) {
            try {
                edit.saveDocument();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    protected synchronized XmlMultiViewEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            this.editorSupport = new HbXmlMultiViewEditorSupport(this);
            this.editorSupport.getMultiViewDescriptions();
        }
        return this.editorSupport;
    }

    protected Node createNodeDelegate() {
        return new HibernateCfgDataNode(this);
    }

    protected String getPrefixMark() {
        return null;
    }

    public void modelUpdatedFromUI() {
        this.setModified(true);
        this.modelSynchronizer.requestUpdateData();
    }

    protected Image getXmlViewIcon() {
        return ImageUtilities.loadImage((String)ICON);
    }

    public void showElement(Object element) {
        Object target = null;
        if (element instanceof SessionFactory || element instanceof Security) {
            this.openView(0);
            target = element;
        }
        if (target != null) {
            final Object key = target;
            Utils.runInAwtDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    HibernateCfgDataObject.this.getActiveMultiViewElement0().getSectionView().openPanel(key);
                }
            });
        }
    }

    public ToolBarMultiViewElement getActiveMultiViewElement0() {
        return (ToolBarMultiViewElement)super.getActiveMultiViewElement();
    }

    private class ModelSynchronizer
    extends XmlMultiViewDataSynchronizer {
        public ModelSynchronizer(XmlMultiViewDataObject dataObject) {
            super(dataObject, 200);
        }

        protected boolean mayUpdateData(boolean allowDialog) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateDataFromModel(Object model, FileLock lock, boolean modify) {
            if (model == null) {
                return;
            }
            try {
                StringWriter out = new StringWriter();
                ((HibernateConfiguration)((Object)model)).write(out);
                ((Writer)out).close();
                HibernateCfgDataObject.this.getDataCache().setData(lock, ((Object)out).toString(), modify);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (Schema2BeansException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }

        protected Object getModel() {
            return HibernateCfgDataObject.this.getHibernateConfiguration();
        }

        protected void reloadModelFromData() {
            HibernateCfgDataObject.this.parseDocument();
        }
    }
}

