/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryTopComponent;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public class ShowLocalHistoryAction
extends NodeAction {
    public ShowLocalHistoryAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] activatedNodes) {
        VCSContext ctx = VCSContext.forNodes((Node[])activatedNodes);
        Set rootSet = ctx.getRootFiles();
        final File[] files = rootSet.toArray(new File[rootSet.size()]);
        if (!files[0].isFile()) {
            return;
        }
        File file = files[0];
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (dataObject != null) {
                EditCookie cookie;
                if (this.activateInOpenedTC(dataObject)) {
                    return;
                }
                if (this.hasHistoryElement(dataObject) && (cookie = (EditCookie)dataObject.getLookup().lookup(EditCookie.class)) != null) {
                    TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)new TCOpenedListener(dataObject));
                    cookie.edit();
                    return;
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LocalHistoryTopComponent tc = new LocalHistoryTopComponent();
                tc.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_LocalHistoryTopComponent", (Object)files[0].getName()));
                tc.open();
                tc.requestActive();
                tc.init(files);
            }
        });
    }

    private boolean hasHistoryElement(DataObject dataObject) {
        String mime = dataObject.getPrimaryFile().getMIMEType();
        Lookup l = MimeLookup.getLookup((MimePath)MimePath.get((String)mime));
        Collection descs = l.lookupAll(MultiViewDescription.class);
        if (descs.size() > 1) {
            for (MultiViewDescription desc : descs) {
                if (!desc.preferredID().equals("text.history")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean activateInOpenedTC(DataObject dataObject) {
        Set tcs = TopComponent.getRegistry().getOpened();
        for (TopComponent tc : tcs) {
            Lookup l = tc.getLookup();
            DataObject tcDataObject = (DataObject)l.lookup(DataObject.class);
            if (tcDataObject == null || !dataObject.equals(tcDataObject)) continue;
            return this.activateHistoryTab(tc);
        }
        return false;
    }

    private boolean activateHistoryTab(final TopComponent tc) {
        final MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)tc);
        if (handler != null) {
            MultiViewPerspective[] perspectives;
            for (final MultiViewPerspective p : perspectives = handler.getPerspectives()) {
                if (!p.preferredID().equals("text.history")) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tc.open();
                        tc.requestActive();
                        handler.requestActive(p);
                    }
                });
                return true;
            }
        }
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        VCSContext ctx = VCSContext.forNodes((Node[])activatedNodes);
        Set rootSet = ctx.getRootFiles();
        if (rootSet == null || rootSet.isEmpty()) {
            return false;
        }
        for (File file : rootSet) {
            if (file == null || file.isFile()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ShowLocalHistory");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ShowLocalHistoryAction.class);
    }

    private class TCOpenedListener
    implements PropertyChangeListener {
        private final DataObject dataObject;

        public TCOpenedListener(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("activated".equals(evt.getPropertyName())) {
                try {
                    Set tcs = TopComponent.getRegistry().getOpened();
                    for (TopComponent tc : tcs) {
                        Lookup l = tc.getLookup();
                        DataObject tcDataObject = (DataObject)l.lookup(DataObject.class);
                        if (tcDataObject == null || !this.dataObject.equals(tcDataObject) || !ShowLocalHistoryAction.this.activateHistoryTab(tc)) continue;
                        return;
                    }
                }
                finally {
                    TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    }
}

