/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.ui.view.Bundle;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryDiffView;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryFileView;
import org.netbeans.modules.versioning.history.LinkButton;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.SearchHistorySupport;
import org.openide.awt.UndoRedo;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class LocalHistoryTopComponent
extends TopComponent
implements MultiViewElement {
    private static LocalHistoryTopComponent instance;
    private LocalHistoryFileView masterView;
    static final String PREFERRED_ID = "text.history";
    private final DelegatingUndoRedo delegatingUndoRedo = new DelegatingUndoRedo();
    private JPanel toolBar;
    private boolean isPartOfMultiview = false;
    final JSplitPane splitPane = new JSplitPane();

    public LocalHistoryTopComponent() {
        this.initComponents();
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.setToolTipText(NbBundle.getMessage(LocalHistoryTopComponent.class, (String)"HINT_LocalHistoryTopComponent"));
    }

    public LocalHistoryTopComponent(Lookup context) {
        this();
        this.isPartOfMultiview = true;
        DataObject dataObject = (DataObject)context.lookup(DataObject.class);
        LinkedList<File> files = new LinkedList<File>();
        if (dataObject instanceof DataShadow) {
            dataObject = ((DataShadow)dataObject).getOriginal();
        }
        if (dataObject != null) {
            Collection<File> doFiles = this.toFileCollection(dataObject.files());
            files.addAll(doFiles);
        }
        this.init(files.toArray(new File[files.size()]));
    }

    private Collection<File> toFileCollection(Collection<? extends FileObject> fileObjects) {
        HashSet<File> files = new HashSet<File>(fileObjects.size() * 4 / 3 + 1);
        for (FileObject fileObject : fileObjects) {
            files.add(FileUtil.toFile((FileObject)fileObject));
        }
        files.remove(null);
        return files;
    }

    public void init(final File ... files) {
        final LocalHistoryFileView fileView = new LocalHistoryFileView();
        LocalHistoryDiffView diffView = new LocalHistoryDiffView(this);
        fileView.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)diffView);
        fileView.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    LocalHistoryTopComponent.this.setActivatedNodes((Node[])evt.getNewValue());
                }
            }
        });
        this.masterView = fileView;
        this.splitPane.setTopComponent(this.masterView.getPanel());
        this.splitPane.setBottomComponent(diffView.getPanel());
        this.masterView.requestActive();
        LocalHistory.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                this.initToolbar();
                fileView.refresh(files);
            }

            private boolean initToolbar() {
                if (files.length == 0) {
                    return true;
                }
                FileObject fo = FileUtil.toFileObject((File)files[0]);
                if (fo == null) {
                    return true;
                }
                final Object attr = fo.getAttribute("ProvidedExtensions.SearchHistorySupport");
                if (attr == null || !(attr instanceof SearchHistorySupport)) {
                    return true;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((Toolbar)LocalHistoryTopComponent.this.getToolbarRepresentation()).setSupport((SearchHistorySupport)attr);
                    }
                });
                return false;
            }
        });
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.splitPane.setDividerLocation(150);
        this.splitPane.setOrientation(0);
        this.splitPane.setOneTouchExpandable(true);
        this.add(this.splitPane, "Center");
    }

    public UndoRedo getUndoRedo() {
        return this.delegatingUndoRedo;
    }

    void setDiffView(JComponent currentDiffView) {
        this.delegatingUndoRedo.setDiffView(currentDiffView);
    }

    public static synchronized LocalHistoryTopComponent getDefault() {
        if (instance == null) {
            instance = new LocalHistoryTopComponent();
        }
        return instance;
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentClosed() {
        if (this.masterView != null) {
            this.masterView.close();
        }
        super.componentClosed();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent getToolbarRepresentation() {
        LocalHistoryTopComponent localHistoryTopComponent = this;
        synchronized (localHistoryTopComponent) {
            if (this.toolBar == null) {
                this.toolBar = new Toolbar();
            }
        }
        return this.toolBar;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
    }

    public CloseOperationState canCloseElement() {
        File file = this.masterView.getFiles()[0];
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            DataObject dataObject;
            try {
                dataObject = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                LocalHistory.LOG.log(Level.WARNING, null, ex);
                return CloseOperationState.STATE_OK;
            }
            if (dataObject != null && dataObject.isModified()) {
                AbstractAction save = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SaveCookie sc = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
                        if (sc != null) {
                            try {
                                sc.save();
                            }
                            catch (IOException ex) {
                                LocalHistory.LOG.log(Level.WARNING, null, ex);
                            }
                        }
                    }
                };
                save.putValue("LongDescription", Bundle.MSG_SaveModified(dataObject.getPrimaryFile().getNameExt()));
                return MultiViewFactory.createUnsafeCloseState((String)"editor", (Action)save, null);
            }
        }
        return CloseOperationState.STATE_OK;
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void componentActivated() {
        super.componentActivated();
        if (this.masterView != null) {
            this.masterView.requestActive();
        }
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentShowing() {
        super.componentShowing();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.isPartOfMultiview ? "org.netbeans.modules.localhistory.ui.view.LHHistoryTab" : "org.netbeans.modules.localhistory.ui.view.LocalHistoryTopComponent");
    }

    private class Toolbar
    extends JPanel {
        private LinkButton searchHistoryButton;
        private SearchHistorySupport support;

        public Toolbar() {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.setOpaque(false);
            this.setBackground(Color.white);
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel(NbBundle.getMessage(this.getClass(), (String)"LBL_LocalHistory"));
            Font f = label.getFont();
            label.setFont(f.deriveFont(f.getStyle() | 1));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 10;
            c.weightx = 1.0;
            this.add((Component)label, c);
            this.searchHistoryButton = new LinkButton(NbBundle.getMessage(this.getClass(), (String)"LBL_ShowVersioningHistory"));
            this.searchHistoryButton.setVisible(false);
            this.searchHistoryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LocalHistory.getInstance().getParallelRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            if (Toolbar.this.support == null) {
                                return;
                            }
                            try {
                                Toolbar.this.support.searchHistory(-1);
                            }
                            catch (IOException ex) {
                                LocalHistory.LOG.log(Level.WARNING, null, ex);
                            }
                        }
                    });
                }
            });
            c = new GridBagConstraints();
            c.anchor = 13;
            c.weightx = 0.0;
            this.add((Component)this.searchHistoryButton, c);
        }

        public void setSupport(SearchHistorySupport support) {
            this.support = support;
            this.searchHistoryButton.setVisible(true);
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return LocalHistoryTopComponent.getDefault();
        }
    }
}

