/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.localhistory.LocalHistorySettings;
import org.netbeans.modules.localhistory.LocalHistoryVCS;
import org.netbeans.modules.localhistory.LocalHistoryVCSAnnotator;
import org.netbeans.modules.localhistory.LocalHistoryVCSInterceptor;
import org.netbeans.modules.localhistory.store.LocalHistoryStore;
import org.netbeans.modules.localhistory.store.LocalHistoryStoreFactory;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class LocalHistory {
    private static LocalHistory instance;
    private VCSInterceptor vcsInterceptor;
    private VCSAnnotator vcsAnnotator;
    private LocalHistoryStore store;
    private ListenersSupport listenerSupport = new ListenersSupport((Object)this);
    private Set<File> userDefinedRoots;
    private Set<File> roots = new HashSet<File>();
    private Pattern includeFiles = null;
    private Pattern excludeFiles = null;
    private final Pattern metadataPattern = Pattern.compile(".*\\" + File.separatorChar + "((\\.|_)svn|.hg|CVS)(\\" + File.separatorChar + ".*|$)");
    public static final Object EVENT_FILE_CREATED;
    static final Object EVENT_PROJECTS_CHANGED;
    public static final Logger LOG;
    private final Set<File> openedFiles = new HashSet<File>();
    private final Set<File> touchedFiles = new HashSet<File>();
    private LocalHistoryVCS lhvcs;
    private RequestProcessor parallelRP;
    PropertyChangeListener openProjectsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("openProjects")) {
                final Project[] projects = (Project[])evt.getNewValue();
                LocalHistory.this.getParallelRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        LocalHistory.this.setRoots(projects);
                    }
                });
            }
        }
    };

    public LocalHistory() {
        String rootPaths;
        String exclude;
        String include = System.getProperty("netbeans.localhistory.includeFiles");
        if (include != null && !include.trim().equals("")) {
            this.includeFiles = Pattern.compile(include);
        }
        if ((exclude = System.getProperty("netbeans.localhistory.excludeFiles")) != null && !exclude.trim().equals("")) {
            this.excludeFiles = Pattern.compile(exclude);
        }
        if ((rootPaths = System.getProperty("netbeans.localhistory.historypath")) == null || rootPaths.trim().equals("")) {
            this.userDefinedRoots = Collections.EMPTY_SET;
        } else {
            String[] paths = rootPaths.split(";");
            this.userDefinedRoots = new HashSet<File>(paths.length);
            for (String root : paths) {
                this.addRootFile(this.userDefinedRoots, new File(root));
            }
        }
        WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)new OpenedFilesListener());
    }

    private synchronized LocalHistoryVCS getLocalHistoryVCS() {
        if (this.lhvcs == null) {
            this.lhvcs = (LocalHistoryVCS)((Object)Lookup.getDefault().lookup(LocalHistoryVCS.class));
        }
        return this.lhvcs;
    }

    void init() {
        LocalHistoryStore s;
        if (!LocalHistorySettings.getInstance().getKeepForever() && (s = this.getLocalHistoryStore(false)) != null) {
            this.getLocalHistoryStore().cleanUp(LocalHistorySettings.getInstance().getTTLMillis());
        }
        this.getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                LocalHistory.this.setRoots(OpenProjects.getDefault().getOpenProjects());
                OpenProjects.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)LocalHistory.this.openProjectsListener, null));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRoots(Project[] projects) {
        HashSet<File> newRoots = new HashSet<File>();
        for (Project project : projects) {
            SourceGroup[] groups;
            Sources sources = ProjectUtils.getSources((Project)project);
            for (SourceGroup group : groups = sources.getSourceGroups("generic")) {
                FileObject fo = group.getRootFolder();
                File root = FileUtil.toFile((FileObject)fo);
                if (root == null) {
                    LOG.warning("source group" + group.getDisplayName() + " returned null root folder");
                    continue;
                }
                this.addRootFile(newRoots, root);
            }
            File root = FileUtil.toFile((FileObject)project.getProjectDirectory());
            if (root == null) {
                LOG.warning("project " + project.getProjectDirectory() + " returned null root folder");
                continue;
            }
            this.addRootFile(newRoots, root);
        }
        Set<File> set = this.roots;
        synchronized (set) {
            this.roots = newRoots;
        }
        this.fireFileEvent(EVENT_PROJECTS_CHANGED, null);
    }

    private void addRootFile(Set<File> set, File file) {
        if (file == null) {
            return;
        }
        LOG.fine("adding root folder " + file);
        set.add(file);
    }

    public static synchronized LocalHistory getInstance() {
        if (instance == null) {
            instance = new LocalHistory();
        }
        return instance;
    }

    VCSInterceptor getVCSInterceptor() {
        if (this.vcsInterceptor == null) {
            this.vcsInterceptor = new LocalHistoryVCSInterceptor();
        }
        return this.vcsInterceptor;
    }

    VCSAnnotator getVCSAnnotator() {
        if (this.vcsAnnotator == null) {
            this.vcsAnnotator = new LocalHistoryVCSAnnotator();
        }
        return this.vcsAnnotator;
    }

    public LocalHistoryStore getLocalHistoryStore() {
        return this.getLocalHistoryStore(true);
    }

    public LocalHistoryStore getLocalHistoryStore(boolean force) {
        if (this.store == null) {
            this.store = LocalHistoryStoreFactory.getInstance().createLocalHistoryStorage(force);
        }
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File isManagedByParent(File file) {
        if (this.roots == null) {
            return file;
        }
        File parent = null;
        while (file != null) {
            Set<File> set = this.roots;
            synchronized (set) {
                if (this.roots.contains(file) || this.userDefinedRoots.contains(file)) {
                    parent = file;
                }
            }
            file = file.getParentFile();
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void touch(File file) {
        if (!this.isOpened(file)) {
            return;
        }
        Set<File> set = this.touchedFiles;
        synchronized (set) {
            this.touchedFiles.add(file);
        }
        set = this.openedFiles;
        synchronized (set) {
            this.openedFiles.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOpened(File file) {
        Set<File> set = this.openedFiles;
        synchronized (set) {
            return this.openedFiles.contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOpenedOrTouched(File file) {
        if (this.isOpened(file)) {
            return true;
        }
        Set<File> set = this.touchedFiles;
        synchronized (set) {
            return this.touchedFiles.contains(file);
        }
    }

    boolean isManaged(File file) {
        LocalHistory.log("isManaged() " + file);
        if (file == null) {
            return false;
        }
        String path = file.getAbsolutePath();
        if (this.metadataPattern.matcher(path).matches()) {
            return false;
        }
        if (this.includeFiles != null) {
            return this.includeFiles.matcher(path).matches();
        }
        if (this.excludeFiles != null) {
            return !this.excludeFiles.matcher(path).matches();
        }
        return true;
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    void fireFileEvent(Object id, File file) {
        this.listenerSupport.fireVersioningEvent(id, new Object[]{file});
    }

    public static void logCreate(File file, File storeFile, long ts, String from, String to) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("create");
        sb.append('\t');
        sb.append(file.getAbsolutePath());
        sb.append('\t');
        sb.append(storeFile.getAbsolutePath());
        sb.append('\t');
        sb.append(ts);
        sb.append('\t');
        sb.append(from);
        sb.append('\t');
        sb.append(to);
        LocalHistory.log(sb.toString());
    }

    public static void logChange(File file, File storeFile, long ts) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("change");
        sb.append('\t');
        sb.append(file.getAbsolutePath());
        sb.append('\t');
        sb.append(storeFile.getAbsolutePath());
        sb.append('\t');
        sb.append(ts);
        LocalHistory.log(sb.toString());
    }

    public static void logDelete(File file, File storeFile, long ts) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("delete");
        sb.append('\t');
        sb.append(file.getAbsolutePath());
        sb.append('\t');
        sb.append(storeFile.getAbsolutePath());
        sb.append('\t');
        sb.append(ts);
        LocalHistory.log(sb.toString());
    }

    public static void logFile(String msg, File file) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(msg);
        sb.append('\t');
        sb.append(file.getAbsolutePath());
        LocalHistory.log(sb.toString());
    }

    public static void log(String msg) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat defaultFormat = new SimpleDateFormat("dd-MM-yyyy:HH-mm-ss.S");
        sb.append(defaultFormat.format(new Date(System.currentTimeMillis())));
        sb.append(":");
        sb.append(msg);
        sb.append('\t');
        sb.append(Thread.currentThread().getName());
        LOG.fine(sb.toString());
    }

    public RequestProcessor getParallelRequestProcessor() {
        if (this.parallelRP == null) {
            this.parallelRP = new RequestProcessor("LocalHistory.ParallelTasks", 5, true);
        }
        return this.parallelRP;
    }

    static {
        EVENT_FILE_CREATED = new Object();
        EVENT_PROJECTS_CHANGED = new Object();
        LOG = Logger.getLogger("org.netbeans.modules.localhistory");
    }

    private class OpenedFilesListener
    implements PropertyChangeListener {
        private OpenedFilesListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            WindowManager.getDefault().getRegistry();
            if ("tcOpened".equals(evt.getPropertyName())) {
                List<File> files = this.getFiles(evt);
                Set set = LocalHistory.this.openedFiles;
                synchronized (set) {
                    for (File file : files) {
                        LOG.log(Level.FINE, " adding to opened files : ", new Object[]{file});
                        LocalHistory.this.openedFiles.add(file);
                    }
                    for (File file : files) {
                        if (this.handleManaged(file)) break;
                    }
                }
            }
            WindowManager.getDefault().getRegistry();
            if ("tcClosed".equals(evt.getPropertyName())) {
                List<File> files = this.getFiles(evt);
                Set set = LocalHistory.this.openedFiles;
                synchronized (set) {
                    for (File file : files) {
                        LOG.log(Level.FINE, " removing from opened files {0} ", new Object[]{file});
                        LocalHistory.this.openedFiles.remove(file);
                    }
                }
            }
        }

        private List<File> getFiles(PropertyChangeEvent evt) {
            Object obj = evt.getNewValue();
            if (obj instanceof TopComponent) {
                ArrayList<File> ret = new ArrayList<File>();
                TopComponent tc = (TopComponent)obj;
                LOG.log(Level.FINER, " getting nodes from tc ", new Object[]{tc});
                Node[] nodes = tc.getActivatedNodes();
                if (nodes != null) {
                    for (Node node : nodes) {
                        LOG.log(Level.FINER, " getting files from node ", new Object[]{node});
                        Collection fos = node.getLookup().lookupAll(FileObject.class);
                        if (fos == null) continue;
                        for (FileObject fo : fos) {
                            File f = FileUtil.toFile((FileObject)fo);
                            if (f == null) continue;
                            ret.add(f);
                        }
                    }
                }
                return ret;
            }
            return Collections.EMPTY_LIST;
        }

        private boolean handleManaged(File file) {
            if (LocalHistory.this.isManagedByParent(file) != null) {
                return false;
            }
            LocalHistoryVCS lh = LocalHistory.this.getLocalHistoryVCS();
            if (lh == null) {
                return false;
            }
            lh.managedFilesChanged();
            return true;
        }
    }
}

