/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.netbeans.modules.masterfs.watcher.FAMNotifier;
import org.netbeans.modules.masterfs.watcher.FOFile;
import org.netbeans.modules.masterfs.watcher.LinuxNotifier;
import org.netbeans.modules.masterfs.watcher.Notifier;
import org.netbeans.modules.masterfs.watcher.OSXNotifier;
import org.netbeans.modules.masterfs.watcher.WindowsNotifier;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class Watcher
extends AnnotationProvider {
    static final Logger LOG = Logger.getLogger(Watcher.class.getName());
    private Ext<?> ext;
    private final Object lock = new Object();
    private Set<FileObject> pending;
    private static RequestProcessor RP = new RequestProcessor("Pending refresh", 1);
    private RequestProcessor.Task refreshTask = RP.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set toRefresh;
            Object object = Watcher.this.lock;
            synchronized (object) {
                toRefresh = Watcher.this.pending;
                Watcher.this.pending = null;
            }
            LOG.log(Level.FINE, "Refreshing {0} directories", toRefresh.size());
            for (FileObject fileObject : toRefresh) {
                LOG.log(Level.FINEST, "Refreshing {0}", fileObject);
                fileObject.refresh();
            }
            LOG.fine("Refresh finished");
        }
    });

    public Watcher() {
        if (Boolean.getBoolean("org.netbeans.modules.masterfs.watcher.disable")) {
            this.ext = null;
            return;
        }
        this.ext = this.make(Watcher.getNotifierForPlatform());
    }

    final void installNotifier(Notifier<?> n) {
        this.ext = this.make(n);
    }

    private static Ext<?> ext() {
        Watcher w = (Watcher)Lookup.getDefault().lookup(Watcher.class);
        return w == null ? null : w.ext;
    }

    public static boolean isEnabled() {
        return Watcher.ext() != null;
    }

    public static boolean isWatched(FileObject fo) {
        Ext<?> ext = Watcher.ext();
        if (ext == null) {
            return false;
        }
        if (fo.isData()) {
            fo = fo.getParent();
        }
        return ((Ext)ext).isWatched(fo);
    }

    public static void register(FileObject fo) {
        Ext<?> ext = Watcher.ext();
        if (ext == null) {
            return;
        }
        if (fo.isData()) {
            fo = fo.getParent();
        }
        ext.register(fo);
    }

    public static void unregister(FileObject fo) {
        Ext<?> ext = Watcher.ext();
        if (ext == null) {
            return;
        }
        if (fo.isData()) {
            fo = fo.getParent();
        }
        ext.unregister(fo);
    }

    public static File wrap(File f, FileObject fo) {
        if (f instanceof FOFile) {
            return f;
        }
        return new FOFile(f, fo);
    }

    @Override
    public String annotateName(String name, Set<? extends FileObject> files) {
        return null;
    }

    @Override
    public Image annotateIcon(Image icon, int iconType, Set<? extends FileObject> files) {
        return null;
    }

    @Override
    public String annotateNameHtml(String name, Set<? extends FileObject> files) {
        return null;
    }

    @Override
    public Action[] actions(Set<? extends FileObject> files) {
        return null;
    }

    @Override
    public InterceptionListener getInterceptionListener() {
        return this.ext;
    }

    public void shutdown() {
        if (this.ext != null) {
            try {
                this.ext.shutdown();
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Error on shutdown", ex);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.INFO, "Error on shutdown", ex);
            }
        }
    }

    private <KEY> Ext<KEY> make(Notifier<KEY> impl) {
        return impl == null ? null : new Ext<KEY>(impl);
    }

    final void clearQueue() throws IOException {
        this.ext.clearQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(FileObject fo) {
        assert (fo != null);
        Object object = this.lock;
        synchronized (object) {
            if (this.pending == null) {
                this.refreshTask.schedule(1500);
                this.pending = new HashSet<FileObject>();
            }
            this.pending.add(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueAll(Set<FileObject> fos) {
        assert (fos != null);
        assert (!fos.contains(null)) : "No nulls";
        Object object = this.lock;
        synchronized (object) {
            if (this.pending == null) {
                this.refreshTask.schedule(1500);
                this.pending = new HashSet<FileObject>();
            }
            this.pending.addAll(fos);
        }
    }

    private static Notifier<?> getNotifierForPlatform() {
        block10: {
            try {
                if (Utilities.isWindows()) {
                    return new WindowsNotifier();
                }
                if (Utilities.getOperatingSystem() == 16) {
                    return new LinuxNotifier();
                }
                if (Utilities.getOperatingSystem() == 4096) {
                    try {
                        OSXNotifier notifier = new OSXNotifier();
                        notifier.start();
                        return notifier;
                    }
                    catch (IOException ioe) {
                        LOG.log(Level.INFO, null, ioe);
                    }
                }
                if (Utilities.getOperatingSystem() != 8) break block10;
                try {
                    return new FAMNotifier();
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, null, e);
                }
                catch (LinkageError x) {
                }
            }
            catch (LinkageError x) {
                LOG.warning(x.toString());
            }
        }
        return null;
    }

    private class Ext<KEY>
    extends ProvidedExtensions
    implements Runnable {
        private final ReferenceQueue<FileObject> REF = new ReferenceQueue();
        private final Notifier<KEY> impl;
        private final Object LOCK = new Object();
        private final Set<Notifier.KeyRef> references = new HashSet<Notifier.KeyRef>();
        private final Thread watcher;
        private volatile boolean shutdown;

        public Ext(Notifier<KEY> impl) {
            this.impl = impl;
            this.watcher = new Thread((Runnable)this, "File Watcher");
            this.watcher.start();
        }

        @Override
        public long refreshRecursively(File dir, long lastTimeStamp, List<? super File> children) {
            assert (dir instanceof FOFile);
            FileObject fo = ((FOFile)dir).fo;
            if (fo == null && !dir.exists()) {
                return -1L;
            }
            assert (fo != null) : "No fileobject for " + dir;
            this.register(fo);
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isWatched(FileObject fo) {
            assert (fo.isFolder()) : "Should be a folder: " + fo;
            try {
                this.clearQueue();
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Exception while clearing the queue", ex);
            }
            Object object = this.LOCK;
            synchronized (object) {
                Notifier<KEY> notifier = this.impl;
                notifier.getClass();
                Notifier.KeyRef kr = notifier.new Notifier.KeyRef(fo, null, null);
                return this.getReferences().contains(kr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void register(FileObject fo) {
            assert (fo.isFolder()) : "Should be a folder: " + fo;
            try {
                this.clearQueue();
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Exception while clearing the queue", ex);
            }
            Object object = this.LOCK;
            synchronized (object) {
                Notifier<KEY> notifier = this.impl;
                notifier.getClass();
                Notifier.KeyRef kr = notifier.new Notifier.KeyRef(fo, null, null);
                if (this.getReferences().contains(kr)) {
                    return;
                }
                try {
                    Set<Notifier.KeyRef> set = this.getReferences();
                    Notifier<KEY> notifier2 = this.impl;
                    notifier2.getClass();
                    set.add(notifier2.new Notifier.KeyRef(fo, this.impl.addWatch(fo.getPath()), this.REF));
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Cannot add filesystem watch for {0}: {1}", new Object[]{fo.getPath(), ex});
                    LOG.log(Level.FINE, null, ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void unregister(FileObject fo) {
            assert (fo.isFolder()) : "Should be a folder: " + fo;
            Object object = this.LOCK;
            synchronized (object) {
                final Notifier.KeyRef[] equalOne = new Notifier.KeyRef[1];
                Notifier<KEY> notifier = this.impl;
                notifier.getClass();
                Notifier.KeyRef kr = new Notifier.KeyRef(notifier, fo, null, null){
                    {
                        Notifier notifier = x0;
                        notifier.getClass();
                        super(x1, x2, x3);
                    }

                    @Override
                    public boolean equals(Object obj) {
                        if (super.equals(obj)) {
                            equalOne[0] = (Notifier.KeyRef)obj;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int hashCode() {
                        return super.hashCode();
                    }
                };
                if (!this.references.contains(kr)) {
                    return;
                }
                assert (equalOne[0] != null);
                this.getReferences().remove(equalOne[0]);
                try {
                    equalOne[0].removeWatch();
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Cannot remove filesystem watch for {0}", fo.getPath());
                    LOG.log(Level.INFO, "Exception", ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void clearQueue() throws IOException {
            Notifier.KeyRef kr;
            while ((kr = (Notifier.KeyRef)this.REF.poll()) != null) {
                Object object = this.LOCK;
                synchronized (object) {
                    this.getReferences().remove(kr);
                    kr.removeWatch();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    this.clearQueue();
                    String path = this.impl.nextEvent();
                    LOG.log(Level.FINEST, "nextEvent: {0}", path);
                    if (path == null) {
                        HashSet<FileObject> set = new HashSet<FileObject>();
                        Object object = this.LOCK;
                        synchronized (object) {
                            for (Notifier.KeyRef kr : this.getReferences()) {
                                FileObject ref = kr.get();
                                if (ref == null) continue;
                                set.add(ref);
                            }
                        }
                        Watcher.this.enqueueAll(set);
                        continue;
                    }
                    File file = new File(path);
                    FileObjectFactory factory = FileObjectFactory.getInstance(file);
                    BaseFileObj fo = factory.getCachedOnly(file);
                    if (fo == null) {
                        fo = factory.getCachedOnly(file.getParentFile());
                    }
                    if (fo == null) continue;
                    Object object = this.LOCK;
                    synchronized (object) {
                        Notifier<KEY> notifier = this.impl;
                        notifier.getClass();
                        Notifier.KeyRef kr = notifier.new Notifier.KeyRef(fo, null, null);
                        if (this.getReferences().contains(kr)) {
                            Watcher.this.enqueue(fo);
                        }
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (InterruptedException ie) {
                    if (this.shutdown) continue;
                    LOG.log(Level.INFO, "Interrupted", ie);
                }
                catch (Throwable t) {
                    LOG.log(Level.INFO, "Error dispatching FS changes", t);
                }
            }
        }

        final void shutdown() throws IOException, InterruptedException {
            this.shutdown = true;
            this.watcher.interrupt();
            this.impl.stop();
            this.watcher.join(1000L);
        }

        private Set<Notifier.KeyRef> getReferences() {
            assert (Thread.holdsLock(this.LOCK));
            return this.references;
        }
    }
}

