/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project;

import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.applet.AppletSupport;
import org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl;
import org.netbeans.modules.java.api.common.project.ui.customizer.CustomizerProvider2;
import org.netbeans.modules.java.api.common.project.ui.customizer.MainClassChooser;
import org.netbeans.modules.java.api.common.project.ui.customizer.MainClassWarning;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.SingleMethod;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public abstract class BaseActionProvider
implements ActionProvider {
    public static final String AUTOMATIC_BUILD_TAG = ".netbeans_automatic_build";
    private static final Logger LOG = Logger.getLogger(BaseActionProvider.class.getName());
    public static final String PROPERTY_RUN_SINGLE_ON_SERVER = "run.single.on.server";
    private final Project project;
    final AntProjectHelper antProjectHelper;
    private final Callback callback;
    private UpdateHelper updateHelper;
    private final PropertyEvaluator evaluator;
    private Set<String> dirty = null;
    private Sources src;
    private List<FileObject> roots;
    public String unitTestingSupport_fixClasses;
    private volatile Boolean allowsFileTracking;
    private SourceRoots projectSourceRoots;
    private SourceRoots projectTestRoots;
    private boolean serverExecution = false;
    private final FileChangeListener modificationListener = new FileChangeAdapter(){

        public void fileChanged(FileEvent fe) {
            BaseActionProvider.this.modification(fe.getFile());
        }

        public void fileDataCreated(FileEvent fe) {
            BaseActionProvider.this.modification(fe.getFile());
        }
    };
    private final ChangeListener sourcesChangeListener = new ChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            BaseActionProvider baseActionProvider = BaseActionProvider.this;
            synchronized (baseActionProvider) {
                BaseActionProvider.this.roots = null;
            }
        }
    };
    public static final String BUILD_SCRIPT = "buildfile";
    private static final Pattern SRCDIRJAVA = Pattern.compile("\\.java$");
    private static final String SUBST = "Test.java";

    public BaseActionProvider(Project project, UpdateHelper updateHelper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testRoots, AntProjectHelper antProjectHelper, Callback callback) {
        this.antProjectHelper = antProjectHelper;
        this.callback = callback;
        this.updateHelper = updateHelper;
        this.project = project;
        this.evaluator = evaluator;
        this.projectSourceRoots = sourceRoots;
        this.projectTestRoots = testRoots;
        this.evaluator.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Class<BaseActionProvider> clazz = BaseActionProvider.class;
                synchronized (BaseActionProvider.class) {
                    String propName = evt.getPropertyName();
                    if (propName == null || "track.file.changes".equals(propName)) {
                        BaseActionProvider.this.allowsFileTracking = null;
                        BaseActionProvider.this.dirty = null;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    protected abstract String[] getPlatformSensitiveActions();

    protected abstract String[] getActionsDisabledForQuickRun();

    public abstract Map<String, String[]> getCommands();

    protected abstract Set<String> getScanSensitiveActions();

    protected abstract Set<String> getJavaModelActions();

    protected abstract boolean isCompileOnSaveEnabled();

    protected void setServerExecution(boolean serverExecution) {
        this.serverExecution = serverExecution;
    }

    protected boolean isServerExecution() {
        return this.serverExecution;
    }

    protected PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    protected UpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    protected AntProjectHelper getAntProjectHelper() {
        return this.antProjectHelper;
    }

    protected Callback getCallback() {
        return this.callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allowsFileChangesTracking() {
        BaseActionProvider baseActionProvider = this;
        synchronized (baseActionProvider) {
            if (this.allowsFileTracking != null) {
                return this.allowsFileTracking;
            }
        }
        String val = this.evaluator.getProperty("track.file.changes");
        BaseActionProvider baseActionProvider2 = this;
        synchronized (baseActionProvider2) {
            if (this.allowsFileTracking == null) {
                this.allowsFileTracking = "true".equals(val) ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.allowsFileTracking;
        }
    }

    public void startFSListener() {
        try {
            FileSystem fs = this.project.getProjectDirectory().getFileSystem();
            fs.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.modificationListener, (Object)fs));
        }
        catch (FileStateInvalidException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modification(FileObject f) {
        if (!this.allowsFileChangesTracking()) {
            return;
        }
        Iterable<? extends FileObject> _roots = this.getRoots();
        assert (_roots != null);
        for (FileObject fileObject : _roots) {
            String path = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)f);
            if (path == null) continue;
            BaseActionProvider baseActionProvider = this;
            synchronized (baseActionProvider) {
                if (this.dirty != null) {
                    this.dirty.add(path);
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<? extends FileObject> getRoots() {
        Sources _src = null;
        BaseActionProvider baseActionProvider = this;
        synchronized (baseActionProvider) {
            if (this.roots != null) {
                return this.roots;
            }
            if (this.src == null) {
                this.src = (Sources)this.project.getLookup().lookup(Sources.class);
                this.src.addChangeListener(this.sourcesChangeListener);
            }
            _src = this.src;
        }
        assert (_src != null);
        SourceGroup[] sgs = _src.getSourceGroups("java");
        ArrayList<FileObject> _roots = new ArrayList<FileObject>(sgs.length);
        for (SourceGroup sg : sgs) {
            FileObject root = sg.getRootFolder();
            if (UnitTestForSourceQuery.findSources((FileObject)root).length != 0) continue;
            _roots.add(root);
        }
        BaseActionProvider baseActionProvider2 = this;
        synchronized (baseActionProvider2) {
            if (this.roots == null) {
                this.roots = _roots;
            }
            return this.roots;
        }
    }

    public static String getBuildXmlName(Project project, PropertyEvaluator evaluator) {
        assert (project != null);
        String buildScriptPath = evaluator.getProperty(BUILD_SCRIPT);
        if (buildScriptPath == null) {
            buildScriptPath = "build.xml";
        }
        return buildScriptPath;
    }

    public static FileObject getBuildXml(Project project, PropertyEvaluator evaluator) {
        return project.getProjectDirectory().getFileObject(BaseActionProvider.getBuildXmlName(project, evaluator));
    }

    private FileObject findBuildXml() {
        return BaseActionProvider.getBuildXml(this.project, this.evaluator);
    }

    protected final Project getProject() {
        return this.project;
    }

    public void invokeAction(final String command, final Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        final boolean isCompileOnSaveEnabled = this.isCompileOnSaveEnabled();
        final AtomicReference<Thread> caller = new AtomicReference<Thread>(Thread.currentThread());
        final AtomicBoolean called = new AtomicBoolean(false);
        class Action
        implements Runnable {
            private boolean needsJavaModel = true;
            private boolean doJavaChecks = true;

            Action() {
            }

            @Override
            public void run() {
                block33: {
                    if (!this.needsJavaModel && caller.get() != Thread.currentThread()) {
                        return;
                    }
                    called.set(true);
                    Properties p = new Properties();
                    String[] targetNames = BaseActionProvider.this.getTargetNames(command, context, p, this.doJavaChecks);
                    if (targetNames == null) {
                        return;
                    }
                    if (isCompileOnSaveEnabled) {
                        if ("build".equals(command) && !BaseActionProvider.this.allowAntBuild()) {
                            BaseActionProvider.this.showBuildActionWarning(context);
                            return;
                        }
                        HashMap<String, Object> execProperties = new HashMap<String, Object>();
                        BaseActionProvider.this.copyMultiValue("run.jvmargs", execProperties);
                        BaseActionProvider.this.prepareWorkDir(execProperties);
                        execProperties.put("platform", CommonProjectUtils.getActivePlatform(BaseActionProvider.this.evaluator.getProperty("platform.active")));
                        execProperties.put("project.name", ProjectUtils.getInformation((Project)BaseActionProvider.this.project).getDisplayName());
                        String runtimeEnc = BaseActionProvider.this.evaluator.getProperty("runtime.encoding");
                        if (runtimeEnc != null) {
                            try {
                                Charset runtimeChs = Charset.forName(runtimeEnc);
                                execProperties.put("runtime.encoding", runtimeChs);
                            }
                            catch (IllegalCharsetNameException ichsn) {
                                LOG.log(Level.WARNING, "Illegal charset name: {0}", runtimeEnc);
                            }
                            catch (UnsupportedCharsetException uchs) {
                                LOG.log(Level.WARNING, "Unsupported charset : {0}", runtimeEnc);
                            }
                        }
                        if (targetNames.length == 1 && ("run-applet".equals(targetNames[0]) || "debug-applet".equals(targetNames[0]))) {
                            try {
                                FileObject[] selectedFiles = BaseActionProvider.this.findSources(context);
                                if (selectedFiles != null) {
                                    FileObject file = selectedFiles[0];
                                    String url = p.getProperty("applet.url");
                                    execProperties.put("applet.url", url);
                                    execProperties.put("execute.file", file);
                                    BaseActionProvider.this.prepareSystemProperties(execProperties, false);
                                    JavaRunner.execute((String)targetNames[0], execProperties);
                                }
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            return;
                        }
                        if (!BaseActionProvider.this.isServerExecution() && ("run".equals(command) || "debug".equals(command) || "debug.stepinto".equals(command))) {
                            BaseActionProvider.this.prepareSystemProperties(execProperties, false);
                            BaseActionProvider.this.bypassAntBuildScript(command, context, execProperties);
                            return;
                        }
                        boolean serverExecution = p.getProperty(BaseActionProvider.PROPERTY_RUN_SINGLE_ON_SERVER) != null;
                        p.remove(BaseActionProvider.PROPERTY_RUN_SINGLE_ON_SERVER);
                        if (!serverExecution && ("run.single".equals(command) || "debug.single".equals(command))) {
                            BaseActionProvider.this.prepareSystemProperties(execProperties, false);
                            if ("run.single".equals(command)) {
                                execProperties.put("classname", p.getProperty("run.class"));
                            } else {
                                execProperties.put("classname", p.getProperty("debug.class"));
                            }
                            BaseActionProvider.this.bypassAntBuildScript(command, context, execProperties);
                            return;
                        }
                        if ("test.single".equals(command) || "debug.test.single".equals(command)) {
                            FileObject[] files = BaseActionProvider.this.findTestSources(context, true);
                            try {
                                BaseActionProvider.this.prepareSystemProperties(execProperties, true);
                                execProperties.put("execute.file", files[0]);
                                execProperties.put("tmp.dir", BaseActionProvider.this.updateHelper.getAntProjectHelper().resolvePath(BaseActionProvider.this.evaluator.getProperty("build.dir")));
                                BaseActionProvider.this.updateJavaRunnerClasspath(command, execProperties);
                                JavaRunner.execute((String)("test.single".equals(command) ? "junit" : "junit-debug"), execProperties);
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            return;
                        }
                        if ("run.single.method".equals(command) || "debug.single.method".equals(command)) {
                            SingleMethod methodSpec = BaseActionProvider.this.findTestMethods(context)[0];
                            try {
                                execProperties.put("methodname", methodSpec.getMethodName());
                                execProperties.put("execute.file", methodSpec.getFile());
                                execProperties.put("tmp.dir", BaseActionProvider.this.updateHelper.getAntProjectHelper().resolvePath(BaseActionProvider.this.evaluator.getProperty("build.dir")));
                                BaseActionProvider.this.updateJavaRunnerClasspath(command, execProperties);
                                JavaRunner.execute((String)(command.equals("run.single.method") ? "junit" : "junit-debug"), execProperties);
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            return;
                        }
                    }
                    if (targetNames.length == 0) {
                        targetNames = null;
                    }
                    if (p.keySet().isEmpty()) {
                        p = null;
                    }
                    try {
                        Callback2 cb2;
                        FileObject buildFo = BaseActionProvider.this.findBuildXml();
                        if (buildFo == null || !buildFo.isValid()) {
                            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(MainClassChooser.class, (String)"LBL_No_Build_XML_Found"), 2);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                            break block33;
                        }
                        Callback cb = BaseActionProvider.this.getCallback();
                        Callback2 callback2 = cb2 = cb instanceof Callback2 ? (Callback2)cb : null;
                        if (cb2 != null) {
                            cb2.antTargetInvocationStarted(command, context);
                        }
                        try {
                            ActionUtils.runTarget((FileObject)buildFo, (String[])targetNames, (Properties)p).addTaskListener(new TaskListener(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void taskFinished(Task task) {
                                    block7: {
                                        try {
                                            if (((ExecutorTask)task).result() == 0) break block7;
                                            BaseActionProvider baseActionProvider = BaseActionProvider.this;
                                            synchronized (baseActionProvider) {
                                                BaseActionProvider.this.dirty = null;
                                            }
                                        }
                                        finally {
                                            if (cb2 != null) {
                                                cb2.antTargetInvocationFinished(command, context, ((ExecutorTask)task).result());
                                            }
                                        }
                                    }
                                }
                            });
                        }
                        catch (IOException ex) {
                            if (cb2 != null) {
                                cb2.antTargetInvocationFailed(command, context);
                            }
                            throw ex;
                        }
                        catch (RuntimeException ex) {
                            if (cb2 != null) {
                                cb2.antTargetInvocationFailed(command, context);
                            }
                            throw ex;
                        }
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            }
        }
        Action action = new Action();
        if (this.getJavaModelActions().contains(command) || isCompileOnSaveEnabled && this.getScanSensitiveActions().contains(command)) {
            ScanDialog.runWhenScanFinished((Runnable)action, (String)NbBundle.getMessage(BaseActionProvider.class, (String)("ACTION_" + command)));
        } else if (this.getScanSensitiveActions().contains(command)) {
            try {
                action.needsJavaModel = false;
                BaseActionProvider.invokeByJavaSource(action);
                if (!called.get()) {
                    action.doJavaChecks = false;
                    action.run();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            action.run();
        }
    }

    protected void updateJavaRunnerClasspath(String command, Map<String, Object> execProperties) {
    }

    private static void invokeByJavaSource(final Runnable runnable) throws IOException {
        Parameters.notNull((CharSequence)"runnable", (Object)runnable);
        ClasspathInfo info = ClasspathInfo.create((ClassPath)JavaPlatform.getDefault().getBootstrapLibraries(), (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[0]), (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[0]));
        JavaSource js = JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]);
        js.runWhenScanFinished((org.netbeans.api.java.source.Task)new org.netbeans.api.java.source.Task<CompilationController>(){

            public void run(CompilationController controller) throws Exception {
                runnable.run();
            }
        }, true);
    }

    public String[] getTargetNames(String command, Lookup context, Properties p) throws IllegalArgumentException {
        return this.getTargetNames(command, context, p, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getTargetNames(String command, Lookup context, Properties p, boolean doJavaChecks) throws IllegalArgumentException {
        String activePlatformId;
        if (Arrays.asList(this.getPlatformSensitiveActions()).contains(command) && CommonProjectUtils.getActivePlatform(activePlatformId = this.evaluator.getProperty("platform.active")) == null) {
            this.showPlatformWarning();
            return null;
        }
        LOG.log(Level.FINE, "COMMAND: {0}", command);
        String[] targetNames = new String[]{};
        HashMap<String, String[]> targetsFromConfig = this.loadTargetsFromConfig();
        if (command.equals("compile.single")) {
            boolean recursive;
            FileObject[] sourceRoots = this.projectSourceRoots.getRoots();
            FileObject[] files = this.findSourcesAndPackages(context, sourceRoots);
            boolean bl = recursive = context.lookup(NonRecursiveFolder.class) == null;
            if (files != null) {
                p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)this.getRoot(sourceRoots, files[0]), (boolean)recursive));
                String[] targets = (String[])targetsFromConfig.get(command);
                return targets != null ? targets : this.getCommands().get(command);
            }
            FileObject[] testRoots = this.projectTestRoots.getRoots();
            files = this.findSourcesAndPackages(context, testRoots);
            if (files == null) return null;
            p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)this.getRoot(testRoots, files[0]), (boolean)recursive));
            return new String[]{"compile-test-single"};
        }
        if (command.equals("test")) {
            p.setProperty("ignore.failing.tests", "true");
            return this.getCommands().get(command);
        }
        if (command.equals("test.single")) {
            FileObject[] files = this.findTestSources(context, true);
            if (files != null) return this.setupTestSingle(p, files);
            return null;
        }
        if (command.equals("debug.test.single")) {
            FileObject[] files = this.findTestSources(context, true);
            if (files != null) return this.setupDebugTestSingle(p, files);
            return null;
        }
        if (command.equals("run.single.method")) {
            SingleMethod[] methodSpecs = this.findTestMethods(context);
            if (methodSpecs == null) return new String[0];
            if (methodSpecs.length == 1) return this.setupRunSingleTestMethod(p, methodSpecs[0]);
            return new String[0];
        }
        if (command.equals("debug.single.method")) {
            SingleMethod[] methodSpecs = this.findTestMethods(context);
            if (methodSpecs == null) return new String[0];
            if (methodSpecs.length == 1) return this.setupDebugSingleTestMethod(p, methodSpecs[0]);
            return new String[0];
        }
        if (command.equals("debug.fix")) {
            FileObject[] files = this.findSources(context);
            String path = null;
            String classes = "";
            if (files != null) {
                path = FileUtil.getRelativePath((FileObject)this.getRoot(this.projectSourceRoots.getRoots(), files[0]), (FileObject)files[0]);
                targetNames = new String[]{"debug-fix"};
                classes = this.getTopLevelClasses(files[0]);
            } else {
                files = this.findTestSources(context, false);
                assert (files != null) : "findTestSources () can't be null: " + Arrays.toString(this.projectTestRoots.getRoots());
                path = FileUtil.getRelativePath((FileObject)this.getRoot(this.projectTestRoots.getRoots(), files[0]), (FileObject)files[0]);
                targetNames = new String[]{"debug-fix-test"};
            }
            if (path.endsWith(".java")) {
                path = path.substring(0, path.length() - 5);
            }
            p.setProperty("fix.includes", path);
            p.setProperty("fix.classes", classes);
            return targetNames;
        }
        if (!this.isServerExecution() && (command.equals("run") || command.equals("debug") || command.equals("debug.stepinto"))) {
            String[] targets;
            String config = this.evaluator.getProperty("config");
            String path = config == null || config.length() == 0 ? "nbproject/project.properties" : "nbproject/configs/" + config + ".properties";
            EditableProperties ep = this.updateHelper.getProperties(path);
            String mainClass = this.evaluator.getProperty("main.class");
            MainClassStatus result = doJavaChecks ? this.isSetMainClass(this.projectSourceRoots.getRoots(), mainClass) : MainClassStatus.SET_AND_VALID;
            if (context.lookup(ProjectConfiguration.class) != null) {
                result = MainClassStatus.SET_AND_VALID;
            }
            if (result != MainClassStatus.SET_AND_VALID) {
                do {
                    if (this.showMainClassWarning(mainClass, ProjectUtils.getInformation((Project)this.project).getDisplayName(), ep, result)) {
                        return null;
                    }
                    mainClass = ep.get((Object)"main.class");
                } while ((result = this.isSetMainClass(this.projectSourceRoots.getRoots(), mainClass)) != MainClassStatus.SET_AND_VALID);
                try {
                    if (!this.updateHelper.requestUpdate()) return null;
                    this.updateHelper.putProperties(path, ep);
                    ProjectManager.getDefault().saveProject(this.project);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, "Error while saving project: " + ioe);
                }
            }
            if (!command.equals("run") && mainClass != null) {
                p.setProperty("debug.class", mainClass);
            }
            String[] stringArray = targetNames = (targets = (String[])targetsFromConfig.get(command)) != null ? targets : this.getCommands().get(command);
            if (targetNames == null) {
                throw new IllegalArgumentException(command);
            }
            this.prepareDirtyList(p, false);
            return targetNames;
        }
        if (command.equals("run.single") || command.equals("debug.single")) {
            String[] stringArray;
            boolean hasMainClassFromTest;
            FileObject[] files = this.findTestSources(context, false);
            FileObject[] rootz = this.projectTestRoots.getRoots();
            boolean isTest = true;
            if (files == null) {
                isTest = false;
                files = this.findSources(context);
                rootz = this.projectSourceRoots.getRoots();
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Is test: {0} Files: {1} Roots: {2}", new Object[]{isTest, BaseActionProvider.asPaths(files), BaseActionProvider.asPaths(rootz)});
            }
            if (files == null) {
                return null;
            }
            FileObject file = files[0];
            assert (file != null);
            if (!file.isValid()) {
                LOG.log(Level.WARNING, "FileObject to execute: {0} is not valid.", FileUtil.getFileDisplayName((FileObject)file));
                return null;
            }
            String clazz = FileUtil.getRelativePath((FileObject)this.getRoot(rootz, file), (FileObject)file);
            p.setProperty("javac.includes", clazz);
            if (clazz.endsWith(".java")) {
                clazz = clazz.substring(0, clazz.length() - 5);
            }
            clazz = clazz.replace('/', '.');
            LOG.log(Level.FINE, "Class to run: {0}", clazz);
            boolean bl = hasMainClassFromTest = MainClassChooser.unitTestingSupport_hasMainMethodResult == null ? false : MainClassChooser.unitTestingSupport_hasMainMethodResult;
            if (doJavaChecks) {
                String[] stringArray2;
                Collection<ElementHandle<TypeElement>> mainClasses = CommonProjectUtils.getMainMethods(file);
                LOG.log(Level.FINE, "Main classes: {0} ", mainClasses);
                if (!hasMainClassFromTest && mainClasses.isEmpty()) {
                    if (!isTest && AppletSupport.isApplet(file)) {
                        EditableProperties ep = this.updateHelper.getProperties("nbproject/project.properties");
                        String jvmargs = ep.getProperty("run.jvmargs");
                        URL url = null;
                        if (jvmargs == null || jvmargs.indexOf("java.security.policy") <= 0) {
                            AppletSupport.generateSecurityPolicy(this.project.getProjectDirectory());
                            if (jvmargs == null || jvmargs.length() == 0) {
                                ep.setProperty("run.jvmargs", "-Djava.security.policy=applet.policy");
                            } else {
                                ep.setProperty("run.jvmargs", jvmargs + " -Djava.security.policy=applet.policy");
                            }
                            this.updateHelper.putProperties("nbproject/project.properties", ep);
                            try {
                                ProjectManager.getDefault().saveProject(this.project);
                            }
                            catch (Exception e) {
                                ErrorManager.getDefault().log(1, "Error while saving project: " + e);
                            }
                        }
                        if ((url = file.existsExt("html") || file.existsExt("HTML") ? this.copyAppletHTML(file, "html") : this.generateAppletHTML(file)) == null) {
                            return null;
                        }
                        p.setProperty("applet.url", url.toString());
                        if (command.equals("run.single")) {
                            return new String[]{"run-applet"};
                        }
                        p.setProperty("debug.class", clazz);
                        return new String[]{"debug-applet"};
                    }
                    ArrayList<String> alternativeTargetNames = new ArrayList<String>();
                    if (isTest) {
                        if (!command.equals("run.single")) return this.setupDebugTestSingle(p, files);
                        return this.setupTestSingle(p, files);
                    }
                    if (this.handleJavaClass(p, file, command, alternativeTargetNames)) {
                        if (alternativeTargetNames.size() <= 0) return this.getCommands().get(command);
                        return alternativeTargetNames.toArray(new String[alternativeTargetNames.size()]);
                    }
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(MainClassChooser.class, (String)"LBL_No_Main_Classs_Found", (Object)clazz), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return null;
                }
                if (!hasMainClassFromTest) {
                    if (mainClasses.size() == 1) {
                        clazz = mainClasses.iterator().next().getBinaryName();
                    } else {
                        clazz = this.showMainClassWarning(file, mainClasses);
                        if (clazz == null) {
                            return null;
                        }
                    }
                }
                if (command.equals("run.single")) {
                    String[] stringArray3;
                    p.setProperty("run.class", clazz);
                    String[] targets = (String[])targetsFromConfig.get(command);
                    if (targets != null) {
                        stringArray3 = targets;
                        return stringArray3;
                    } else if (isTest) {
                        String[] stringArray4 = new String[1];
                        stringArray3 = stringArray4;
                        stringArray4[0] = "run-test-with-main";
                        return stringArray3;
                    } else {
                        stringArray3 = this.getCommands().get("run.single");
                    }
                    return stringArray3;
                }
                p.setProperty("debug.class", clazz);
                String[] targets = (String[])targetsFromConfig.get(command);
                if (targets != null) {
                    stringArray2 = targets;
                    return stringArray2;
                } else if (isTest) {
                    String[] stringArray5 = new String[1];
                    stringArray2 = stringArray5;
                    stringArray5[0] = "debug-test-with-main";
                    return stringArray2;
                } else {
                    stringArray2 = this.getCommands().get("debug.single");
                }
                return stringArray2;
            }
            if (clazz == null) {
                return null;
            }
            if (command.equals("run.single")) {
                String[] stringArray6;
                p.setProperty("run.class", clazz);
                String[] targets = (String[])targetsFromConfig.get(command);
                if (targets != null) {
                    stringArray6 = targets;
                    return stringArray6;
                } else if (isTest) {
                    String[] stringArray7 = new String[1];
                    stringArray6 = stringArray7;
                    stringArray7[0] = "run-test-with-main";
                    return stringArray6;
                } else {
                    stringArray6 = this.getCommands().get("run.single");
                }
                return stringArray6;
            }
            p.setProperty("debug.class", clazz);
            String[] targets = (String[])targetsFromConfig.get(command);
            if (targets != null) {
                stringArray = targets;
                return stringArray;
            } else if (isTest) {
                String[] stringArray8 = new String[1];
                stringArray = stringArray8;
                stringArray8[0] = "debug-test-with-main";
                return stringArray;
            } else {
                stringArray = this.getCommands().get("debug.single");
            }
            return stringArray;
        }
        String[] targets = (String[])targetsFromConfig.get(command);
        String[] stringArray = targetNames = targets != null ? targets : this.getCommands().get(command);
        if (targetNames == null) {
            String buildTarget;
            String string = buildTarget = "false".equalsIgnoreCase(this.evaluator.getProperty("do.jar")) ? "compile" : "jar";
            if (command.equals("build")) {
                targetNames = new String[]{buildTarget};
                this.prepareDirtyList(p, true);
            } else {
                if (!command.equals("rebuild")) throw new IllegalArgumentException(command);
                targetNames = new String[]{"clean", buildTarget};
            }
        }
        if (!"clean".equals(command)) return targetNames;
        this.dirty = null;
        return targetNames;
    }

    protected boolean handleJavaClass(Properties p, FileObject javaFile, String command, List<String> targetNames) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDirtyList(Properties p, boolean isExplicitBuildTarget) {
        String doDepend = this.evaluator.getProperty("do.depend");
        String buildClassesDirValue = this.evaluator.getProperty("build.classes.dir");
        if (buildClassesDirValue == null) {
            StringBuilder logRecord = new StringBuilder();
            logRecord.append("EVALUATOR: " + this.evaluator.getProperties().toString() + ";");
            logRecord.append("PROJECT_PROPS: " + this.updateHelper.getProperties("nbproject/project.properties").entrySet() + ";");
            logRecord.append("PRIVATE_PROPS: " + this.updateHelper.getProperties("nbproject/private/private.properties").entrySet() + ";");
            LOG.log(Level.WARNING, "No build.classes.dir property: {0}", logRecord.toString());
            return;
        }
        File buildClassesDir = this.antProjectHelper.resolveFile(buildClassesDirValue);
        BaseActionProvider baseActionProvider = this;
        synchronized (baseActionProvider) {
            if (this.dirty == null) {
                if (this.allowsFileChangesTracking()) {
                    this.dirty = new TreeSet<String>();
                }
                return;
            }
            for (DataObject d : DataObject.getRegistry().getModified()) {
                this.modification(d.getPrimaryFile());
            }
            boolean wasBuiltAutomatically = new File(buildClassesDir, AUTOMATIC_BUILD_TAG).canRead();
            if (!("true".equalsIgnoreCase(doDepend) || isExplicitBuildTarget && this.dirty.isEmpty() || wasBuiltAutomatically)) {
                if (this.dirty.isEmpty()) {
                    this.dirty.add("nothing whatsoever");
                }
                StringBuilder dirtyList = new StringBuilder();
                for (String f : this.dirty) {
                    if (dirtyList.length() > 0) {
                        dirtyList.append(',');
                    }
                    dirtyList.append(f);
                }
                p.setProperty("includes", dirtyList.toString());
            }
            this.dirty.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String[]> loadTargetsFromConfig() {
        HashMap<String, String[]> targets = new HashMap<String, String[]>(6);
        String config = this.evaluator.getProperty("config");
        FileObject propFO = this.project.getProjectDirectory().getFileObject("nbproject/configs/" + config + ".properties");
        if (propFO == null) {
            return targets;
        }
        Properties props = new Properties();
        try {
            InputStream is = propFO.getInputStream();
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return targets;
        }
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (!propName.startsWith("$target.")) continue;
            String tNameVal = props.getProperty(propName);
            String cmdNameKey = null;
            if (tNameVal == null || tNameVal.equals("")) continue;
            cmdNameKey = propName.substring("$target.".length());
            StringTokenizer stok = new StringTokenizer(tNameVal.trim(), " ");
            ArrayList<String> targetNames = new ArrayList<String>(3);
            while (stok.hasMoreTokens()) {
                targetNames.add(stok.nextToken());
            }
            targets.put(cmdNameKey, targetNames.toArray(new String[targetNames.size()]));
        }
        return targets;
    }

    private String[] setupTestSingle(Properties p, FileObject[] files) {
        FileObject[] testSrcPath = this.projectTestRoots.getRoots();
        FileObject root = this.getRoot(testSrcPath, files[0]);
        p.setProperty("test.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        return new String[]{"test-single"};
    }

    private String[] setupDebugTestSingle(Properties p, FileObject[] files) {
        FileObject[] testSrcPath = this.projectTestRoots.getRoots();
        FileObject root = this.getRoot(testSrcPath, files[0]);
        String path = FileUtil.getRelativePath((FileObject)root, (FileObject)files[0]);
        p.setProperty("test.class", path.substring(0, path.length() - 5).replace('/', '.'));
        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        return new String[]{"debug-test"};
    }

    private String[] setupRunSingleTestMethod(Properties p, SingleMethod methodSpec) {
        return this.setupTestSingle(p, new FileObject[]{methodSpec.getFile()});
    }

    private String[] setupDebugSingleTestMethod(Properties p, SingleMethod methodSpec) {
        return this.setupDebugTestSingle(p, new FileObject[]{methodSpec.getFile()});
    }

    private static String getClassName(String relPath) {
        return relPath.substring(0, relPath.length() - 5).replace('/', '.');
    }

    private boolean allowAntBuild() {
        String buildClasses = this.evaluator.getProperty("build.classes.dir");
        if (buildClasses == null) {
            return false;
        }
        File buildClassesFile = this.updateHelper.getAntProjectHelper().resolveFile(buildClasses);
        return !new File(buildClassesFile, AUTOMATIC_BUILD_TAG).exists();
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if ("delete".equals(command) || "move".equals(command) || "copy".equals(command) || "rename".equals(command)) {
            return true;
        }
        FileObject buildXml = this.findBuildXml();
        if (buildXml == null || !buildXml.isValid()) {
            return false;
        }
        if (Arrays.asList(this.getActionsDisabledForQuickRun()).contains(command) && this.isCompileOnSaveEnabled() && !this.allowAntBuild()) {
            return false;
        }
        if (command.equals("compile.single")) {
            return this.findSourcesAndPackages(context, this.projectSourceRoots.getRoots()) != null || this.findSourcesAndPackages(context, this.projectTestRoots.getRoots()) != null;
        }
        if (command.equals("test.single")) {
            FileObject[] fos = this.findTestSources(context, true);
            return fos != null && fos.length == 1;
        }
        if (command.equals("debug.test.single")) {
            FileObject[] fos = this.findTestSources(context, true);
            return fos != null && fos.length == 1;
        }
        if (command.equals("run.single") || command.equals("debug.single") || command.equals("debug.fix")) {
            FileObject[] fos = this.findSources(context);
            if (fos != null && fos.length == 1) {
                return true;
            }
            fos = this.findTestSources(context, false);
            if (fos != null && fos.length == 1) {
                return true;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Source Roots: {0} Test Roots: {1} Lookup Content: {2}", new Object[]{BaseActionProvider.asPaths(this.projectSourceRoots.getRoots()), BaseActionProvider.asPaths(this.projectTestRoots.getRoots()), BaseActionProvider.asPaths(context)});
            }
            return false;
        }
        if (command.equals("run.single.method") || command.equals("debug.single.method")) {
            if (this.isCompileOnSaveEnabled()) {
                SingleMethod[] methodSpecs = this.findTestMethods(context);
                return methodSpecs != null && methodSpecs.length == 1;
            }
            return false;
        }
        return true;
    }

    private String getTopLevelClasses(FileObject file) {
        assert (file != null);
        if (this.unitTestingSupport_fixClasses != null) {
            return this.unitTestingSupport_fixClasses;
        }
        final String[] classes = new String[]{""};
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js != null) {
            try {
                js.runUserActionTask((org.netbeans.api.java.source.Task)new org.netbeans.api.java.source.Task<CompilationController>(){

                    public void run(CompilationController ci) throws Exception {
                        if (ci.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                            ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                            return;
                        }
                        List types = ci.getTopLevelElements();
                        if (types.size() > 0) {
                            for (TypeElement type : types) {
                                if (classes[0].length() > 0) {
                                    classes[0] = classes[0] + " ";
                                }
                                classes[0] = classes[0] + type.getQualifiedName().toString().replace('.', '/') + "*.class";
                            }
                        }
                    }
                }, true);
            }
            catch (IOException ioex) {
                Exceptions.printStackTrace((Throwable)ioex);
            }
        }
        return classes[0];
    }

    private FileObject[] findSources(Lookup context) {
        FileObject[] srcPath = this.projectSourceRoots.getRoots();
        for (int i = 0; i < srcPath.length; ++i) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcPath[i], (String)".java", (boolean)true);
            if (files == null) continue;
            return files;
        }
        return null;
    }

    private FileObject[] findSourcesAndPackages(Lookup context, FileObject srcDir) {
        if (srcDir != null) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcDir, null, (boolean)true);
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isFolder() || "java".equals(files[i].getExt())) continue;
                    return null;
                }
            }
            return files;
        }
        return null;
    }

    private FileObject[] findSourcesAndPackages(Lookup context, FileObject[] srcRoots) {
        for (int i = 0; i < srcRoots.length; ++i) {
            FileObject[] result = this.findSourcesAndPackages(context, srcRoots[i]);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private FileObject[] findTestSources(Lookup context, boolean checkInSrcDir) {
        FileObject[] files;
        FileObject[] testSrcPath = this.projectTestRoots.getRoots();
        for (int i = 0; i < testSrcPath.length; ++i) {
            FileObject[] files2 = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)testSrcPath[i], (String)".java", (boolean)true);
            if (files2 == null) continue;
            return files2;
        }
        if (checkInSrcDir && testSrcPath.length > 0 && (files = this.findSources(context)) != null) {
            FileObject srcRoot = this.getRoot(this.projectSourceRoots.getRoots(), files[0]);
            for (int i = 0; i < testSrcPath.length; ++i) {
                FileObject[] files2 = ActionUtils.regexpMapFiles((FileObject[])files, (FileObject)srcRoot, (Pattern)SRCDIRJAVA, (FileObject)testSrcPath[i], (String)SUBST, (boolean)true);
                if (files2 == null) continue;
                return files2;
            }
        }
        return null;
    }

    private SingleMethod[] findTestMethods(Lookup context) {
        Collection methodSpecs = context.lookupAll(SingleMethod.class);
        if (methodSpecs.isEmpty()) {
            return null;
        }
        FileObject[] testSrcPath = this.projectTestRoots.getRoots();
        if (testSrcPath == null || testSrcPath.length == 0) {
            return null;
        }
        LinkedHashSet<SingleMethod> specs = new LinkedHashSet<SingleMethod>();
        for (FileObject testRoot : testSrcPath) {
            for (SingleMethod spec : methodSpecs) {
                FileObject f = spec.getFile();
                if (FileUtil.toFile((FileObject)f) == null || f != testRoot && !FileUtil.isParentOf((FileObject)testRoot, (FileObject)f) || !f.getNameExt().endsWith(".java")) continue;
                specs.add(spec);
            }
        }
        if (specs.isEmpty()) {
            return null;
        }
        return specs.toArray(new SingleMethod[specs.size()]);
    }

    private FileObject getRoot(FileObject[] roots, FileObject file) {
        assert (file != null) : "File can't be null";
        FileObject srcDir = null;
        for (int i = 0; i < roots.length; ++i) {
            assert (roots[i] != null) : "Source Path Root can't be null";
            if (!FileUtil.isParentOf((FileObject)roots[i], (FileObject)file) && !roots[i].equals(file)) continue;
            srcDir = roots[i];
            break;
        }
        return srcDir;
    }

    private void bypassAntBuildScript(String command, Lookup context, Map<String, Object> p) throws IllegalArgumentException {
        boolean run = true;
        boolean hasMainMethod = true;
        if ("run".equals(command) || "debug".equals(command) || "debug.stepinto".equals(command)) {
            String mainClass = this.evaluator.getProperty("main.class");
            p.put("classname", mainClass);
            p.put("execute.classpath", this.callback.getProjectSourcesClassPath("classpath/execute"));
            if ("debug.stepinto".equals(command)) {
                p.put("stopclassname", mainClass);
            }
        } else {
            FileObject[] files = this.findSources(context);
            if (files == null || files.length != 1) {
                files = this.findTestSources(context, false);
                hasMainMethod = CommonProjectUtils.hasMainMethod(files[0]);
                run = false;
            }
            if (files == null || files.length != 1) {
                return;
            }
            p.put("execute.file", files[0]);
        }
        boolean debug = "debug".equals(command) || "debug.single".equals(command) || "debug.stepinto".equals(command);
        try {
            this.updateJavaRunnerClasspath(command, p);
            if (run) {
                this.copyMultiValue("application.args", p);
                JavaRunner.execute((String)(debug ? "debug" : "run"), p);
            } else if (hasMainMethod) {
                JavaRunner.execute((String)(debug ? "debug" : "run"), p);
            } else {
                JavaRunner.execute((String)(debug ? "junit-debug" : "junit"), p);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void prepareWorkDir(Map<String, Object> properties) {
        String val = this.evaluator.getProperty("work.dir");
        if (val == null) {
            val = ".";
        }
        File file = this.updateHelper.getAntProjectHelper().resolveFile(val);
        properties.put("work.dir", file);
    }

    private void copyMultiValue(String propertyName, Map<String, Object> properties) {
        String val = this.evaluator.getProperty(propertyName);
        if (val != null) {
            this.putMultiValue(properties, propertyName, val);
        }
    }

    private void putMultiValue(Map<String, Object> properties, String propertyName, String val) {
        LinkedList<String> it = (LinkedList<String>)properties.get(propertyName);
        if (it == null) {
            it = new LinkedList<String>();
            properties.put(propertyName, it);
        }
        it.add(val);
    }

    private void prepareSystemProperties(Map<String, Object> properties, boolean test) {
        String prefix = test ? "test-sys-prop." : "run-sys-prop.";
        Map evaluated = this.evaluator.getProperties();
        if (evaluated == null) {
            return;
        }
        for (Map.Entry e : evaluated.entrySet()) {
            if (!((String)e.getKey()).startsWith(prefix) || e.getValue() == null) continue;
            this.putMultiValue(properties, "run.jvmargs", "-D" + ((String)e.getKey()).substring(prefix.length()) + "=" + (String)e.getValue());
        }
    }

    private MainClassStatus isSetMainClass(FileObject[] sourcesRoots, String mainClass) {
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult != false ? MainClassStatus.SET_AND_VALID : MainClassStatus.SET_BUT_INVALID;
        }
        if (mainClass == null || mainClass.length() == 0) {
            LOG.fine("Main class is not set");
            return MainClassStatus.UNSET;
        }
        if (sourcesRoots.length > 0) {
            LOG.log(Level.FINE, "Searching main class {0} for root: {1}", new Object[]{mainClass, FileUtil.getFileDisplayName((FileObject)sourcesRoots[0])});
            ClassPath bootPath = null;
            ClassPath compilePath = null;
            try {
                bootPath = ClassPath.getClassPath((FileObject)sourcesRoots[0], (String)"classpath/boot");
                assert (bootPath != null) : this.assertPath(sourcesRoots[0], sourcesRoots, "classpath/boot");
            }
            catch (AssertionError e) {
                Exceptions.printStackTrace((Throwable)((Object)e));
            }
            try {
                compilePath = ClassPath.getClassPath((FileObject)sourcesRoots[0], (String)"classpath/execute");
                assert (compilePath != null) : this.assertPath(sourcesRoots[0], sourcesRoots, "classpath/execute");
            }
            catch (AssertionError e) {
                Exceptions.printStackTrace((Throwable)((Object)e));
            }
            if (bootPath == null) {
                LOG.fine("Source root has no boot classpath, using project boot classpath.");
                bootPath = this.callback.getProjectSourcesClassPath("classpath/boot");
            }
            if (compilePath == null) {
                LOG.fine("Source root has no execute classpath, using project execute classpath.");
                compilePath = this.callback.getProjectSourcesClassPath("classpath/execute");
            }
            ClassPath sourcePath = ClassPath.getClassPath((FileObject)sourcesRoots[0], (String)"classpath/source");
            LOG.log(Level.FINE, "Classpaths used to resolve main boot: {0}, exec: {1}, src: {2}", new Object[]{bootPath, compilePath, sourcePath});
            if (CommonProjectUtils.isMainClass(mainClass, bootPath, compilePath, sourcePath)) {
                return MainClassStatus.SET_AND_VALID;
            }
        } else {
            LOG.log(Level.FINE, "Searching main class {0} without source root", mainClass);
            ClassPath bootPath = this.callback.getProjectSourcesClassPath("classpath/boot");
            ClassPath compilePath = this.callback.getProjectSourcesClassPath("classpath/execute");
            ClassPath sourcePath = this.callback.getProjectSourcesClassPath("classpath/source");
            LOG.log(Level.FINE, "Classpaths used to resolve main boot: {0}, exec: {1}, src: {2}", new Object[]{bootPath, compilePath, sourcePath});
            if (CommonProjectUtils.isMainClass(mainClass, bootPath, compilePath, sourcePath)) {
                return MainClassStatus.SET_AND_VALID;
            }
        }
        LOG.log(Level.FINE, "Main class {0} is invalid.", mainClass);
        return MainClassStatus.SET_BUT_INVALID;
    }

    private String assertPath(FileObject fileObject, FileObject[] expectedRoots, String pathType) {
        SourceGroup[] sgs;
        StringBuilder sb = new StringBuilder();
        sb.append("File: ").append(fileObject);
        sb.append("\nPath Type: ").append(pathType);
        Project owner = FileOwnerQuery.getOwner((FileObject)fileObject);
        sb.append("\nOwner: ").append(owner == null ? "" : ProjectUtils.getInformation((Project)owner).getDisplayName());
        sb.append("\nClassPathProviders: ");
        for (ClassPathProvider impl : Lookup.getDefault().lookupResult(ClassPathProvider.class).allInstances()) {
            sb.append("\n  ").append(impl);
        }
        sb.append("\nProject SourceGroups:");
        for (SourceGroup sourceGroup : sgs = ProjectUtils.getSources((Project)this.project).getSourceGroups("java")) {
            sb.append("\n  ").append(FileUtil.getFileDisplayName((FileObject)sourceGroup.getRootFolder()));
        }
        sb.append("\nProject Source Roots:");
        for (SourceGroup sourceGroup : expectedRoots) {
            sb.append("\n  ").append(FileUtil.getFileDisplayName((FileObject)sourceGroup));
        }
        return sb.toString();
    }

    private boolean showMainClassWarning(String mainClass, String projectName, EditableProperties ep, MainClassStatus messageType) {
        boolean canceled;
        String message;
        final JButton okButton = new JButton(NbBundle.getMessage(MainClassChooser.class, (String)"LBL_MainClassWarning_ChooseMainClass_OK"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooser.class, (String)"AD_MainClassWarning_ChooseMainClass_OK"));
        switch (messageType) {
            case UNSET: {
                message = MessageFormat.format(NbBundle.getMessage(MainClassChooser.class, (String)"LBL_MainClassNotFound"), projectName);
                break;
            }
            case SET_BUT_INVALID: {
                message = MessageFormat.format(NbBundle.getMessage(MainClassChooser.class, (String)"LBL_MainClassWrong"), mainClass, projectName);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        final MainClassWarning panel = new MainClassWarning(message, this.projectSourceRoots.getRoots());
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                    okButton.doClick();
                } else {
                    okButton.setEnabled(panel.getSelectedMainClass() != null);
                }
            }
        });
        okButton.setEnabled(false);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(MainClassChooser.class, (String)"CTL_MainClassWarning_Title", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName()), true, options, options[0], 0, null, null);
        desc.setMessageType(1);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.setVisible(true);
        if (desc.getValue() != options[0]) {
            canceled = true;
        } else {
            mainClass = panel.getSelectedMainClass();
            canceled = false;
            ep.put("main.class", mainClass == null ? "" : mainClass);
        }
        dlg.dispose();
        return canceled;
    }

    private String showMainClassWarning(FileObject file, Collection<ElementHandle<TypeElement>> mainClasses) {
        assert (mainClasses != null);
        String mainClass = null;
        final JButton okButton = new JButton(NbBundle.getMessage(MainClassChooser.class, (String)"LBL_MainClassWarning_ChooseMainClass_OK"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooser.class, (String)"AD_MainClassWarning_ChooseMainClass_OK"));
        final MainClassWarning panel = new MainClassWarning(NbBundle.getMessage(MainClassChooser.class, (String)"CTL_FileMultipleMain", (Object)file.getNameExt()), mainClasses);
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                    okButton.doClick();
                } else {
                    okButton.setEnabled(panel.getSelectedMainClass() != null);
                }
            }
        });
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(MainClassChooser.class, (String)"CTL_FileMainClass_Title"), true, options, options[0], 0, null, null);
        desc.setMessageType(1);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.setVisible(true);
        if (desc.getValue() == options[0]) {
            mainClass = panel.getSelectedMainClass();
        }
        dlg.dispose();
        return mainClass;
    }

    private void showPlatformWarning() {
        JButton closeOption = new JButton(NbBundle.getMessage(BaseActionProvider.class, (String)"CTL_BrokenPlatform_Close"));
        closeOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BaseActionProvider.class, (String)"AD_BrokenPlatform_Close"));
        ProjectInformation pi = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String projectDisplayName = pi == null ? NbBundle.getMessage(BaseActionProvider.class, (String)"TEXT_BrokenPlatform_UnknownProjectName") : pi.getDisplayName();
        DialogDescriptor dd = new DialogDescriptor((Object)NbBundle.getMessage(BaseActionProvider.class, (String)"TEXT_BrokenPlatform", (Object)projectDisplayName), NbBundle.getMessage(BaseActionProvider.class, (String)"MSG_BrokenPlatform_Title"), true, new Object[]{closeOption}, (Object)closeOption, 0, null, null);
        dd.setMessageType(2);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.setVisible(true);
    }

    private URL generateAppletHTML(FileObject file) {
        URL url = null;
        try {
            String buildDirProp = this.evaluator.getProperty("build.dir");
            String classesDirProp = this.evaluator.getProperty("build.classes.dir");
            FileObject buildDir = this.updateHelper.getAntProjectHelper().resolveFileObject(buildDirProp);
            FileObject classesDir = this.updateHelper.getAntProjectHelper().resolveFileObject(classesDirProp);
            if (buildDir == null) {
                buildDir = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)buildDirProp);
            }
            if (classesDir == null) {
                classesDir = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)classesDirProp);
            }
            String activePlatformName = this.evaluator.getProperty("platform.active");
            url = AppletSupport.generateHtmlFileURL(file, buildDir, classesDir, activePlatformName);
        }
        catch (FileStateInvalidException fe) {
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return null;
        }
        return url;
    }

    private URL copyAppletHTML(FileObject file, String ext) {
        URL url = null;
        try {
            FileObject targetHtml;
            String buildDirProp = this.evaluator.getProperty("build.dir");
            FileObject buildDir = this.updateHelper.getAntProjectHelper().resolveFileObject(buildDirProp);
            if (buildDir == null) {
                buildDir = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)buildDirProp);
            }
            FileObject htmlFile = null;
            htmlFile = file.getParent().getFileObject(file.getName(), "html");
            if (htmlFile == null) {
                htmlFile = file.getParent().getFileObject(file.getName(), "HTML");
            }
            if (htmlFile == null) {
                return null;
            }
            FileObject existingFile = buildDir.getFileObject(htmlFile.getName(), htmlFile.getExt());
            if (existingFile != null) {
                existingFile.delete();
            }
            if ((targetHtml = htmlFile.copy(buildDir, file.getName(), ext)) != null) {
                String activePlatformName = this.evaluator.getProperty("platform.active");
                url = AppletSupport.getHTMLPageURL(targetHtml, activePlatformName);
            }
        }
        catch (FileStateInvalidException fe) {
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return null;
        }
        return url;
    }

    private void showBuildActionWarning(Lookup context) {
        String text = NbBundle.getMessage(BaseActionProvider.class, (String)"LBL_ProjectBuiltAutomatically");
        String projectProperties = NbBundle.getMessage(BaseActionProvider.class, (String)"BTN_ProjectProperties");
        String cleanAndBuild = NbBundle.getMessage(BaseActionProvider.class, (String)"BTN_CleanAndBuild");
        String ok = NbBundle.getMessage(BaseActionProvider.class, (String)"BTN_OK");
        String titleFormat = NbBundle.getMessage(BaseActionProvider.class, (String)"TITLE_BuildProjectWarning");
        String title = MessageFormat.format(titleFormat, ProjectUtils.getInformation((Project)this.project).getDisplayName());
        DialogDescriptor dd = new DialogDescriptor((Object)text, title, true, new Object[]{projectProperties, cleanAndBuild, ok}, (Object)ok, 0, null, null);
        dd.setMessageType(2);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result == projectProperties) {
            CustomizerProvider2 p = (CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class);
            p.showCustomizer("Build", null);
            return;
        }
        if (result == cleanAndBuild) {
            this.invokeAction("rebuild", context);
            return;
        }
    }

    @CheckForNull
    private static Collection<? extends String> asPaths(@NullAllowed FileObject[] fos) {
        if (fos == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(fos.length);
        for (FileObject fo : fos) {
            result.add(FileUtil.getFileDisplayName((FileObject)fo));
        }
        return result;
    }

    @NonNull
    private static Collection<? extends String> asPaths(@NonNull Lookup context) {
        Collection dobjs = context.lookupAll(DataObject.class);
        ArrayList<String> result = new ArrayList<String>(dobjs.size());
        for (DataObject dobj : dobjs) {
            result.add(FileUtil.getFileDisplayName((FileObject)dobj.getPrimaryFile()));
        }
        return result;
    }

    public static final class CallbackImpl
    implements Callback {
        private ClassPathProviderImpl cp;

        public CallbackImpl(ClassPathProviderImpl cp) {
            this.cp = cp;
        }

        @Override
        public ClassPath getProjectSourcesClassPath(String type) {
            return this.cp.getProjectSourcesClassPath(type);
        }

        @Override
        public ClassPath findClassPath(FileObject file, String type) {
            return this.cp.findClassPath(file, type);
        }
    }

    public static interface Callback2
    extends Callback {
        public void antTargetInvocationStarted(String var1, Lookup var2);

        public void antTargetInvocationFinished(String var1, Lookup var2, int var3);

        public void antTargetInvocationFailed(String var1, Lookup var2);
    }

    public static interface Callback {
        public ClassPath getProjectSourcesClassPath(String var1);

        public ClassPath findClassPath(FileObject var1, String var2);
    }

    private static enum MainClassStatus {
        SET_AND_VALID,
        SET_BUT_INVALID,
        UNSET;

    }
}

