/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.util.TreePath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.ui.JavaScopeBuilder;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class WhereUsedPanel
extends JPanel
implements CustomRefactoringPanel {
    private static final String PACKAGE = "org/netbeans/spi/java/project/support/ui/package.gif";
    private final transient TreePathHandle element;
    private TreePathHandle newElement;
    private final transient ChangeListener parent;
    private static final int MAX_NAME = 50;
    private static final int SCOPE_COMBOBOX_COLUMNS = 14;
    public static final String ELLIPSIS = "\u2026";
    private Scope customScope;
    private boolean enableScope;
    private boolean initialized = false;
    private String methodDeclaringSuperClass = null;
    private String methodDeclaringClass = null;
    private FileObject packageFolder = null;
    private FileObject[] projectSources = null;
    private JButton btnCustomScope;
    private ButtonGroup buttonGroup;
    private JRadioButton c_directOnly;
    private JRadioButton c_subclasses;
    private JRadioButton c_usages;
    private JPanel classesPanel;
    private JPanel commentsPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel label;
    private JCheckBox m_isBaseClass;
    private JCheckBox m_overriders;
    private JCheckBox m_usages;
    private JPanel methodsPanel;
    private JComboBox scope;
    private JLabel scopeLabel;
    private JPanel scopePanel;
    private JCheckBox searchInComments;

    public WhereUsedPanel(String name, TreePathHandle e, ChangeListener parent) {
        this.setName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed"));
        this.element = e;
        this.parent = parent;
        this.enableScope = true;
        this.initComponents();
        this.btnCustomScope.setAction(new ScopeAction(this.scope));
    }

    public Scope getCustomScope() {
        FileObject file = RetoucheUtils.getFileObject(this.element);
        Scope value = null;
        if (!this.enableScope) {
            return Scope.create(null, null, Arrays.asList(file));
        }
        switch (this.scope.getSelectedIndex()) {
            case 1: {
                value = Scope.create(Arrays.asList(this.projectSources), null, null);
                break;
            }
            case 2: {
                NonRecursiveFolder nonRecursiveFolder = new NonRecursiveFolder(){

                    public FileObject getFolder() {
                        return WhereUsedPanel.this.packageFolder;
                    }
                };
                value = Scope.create(null, Arrays.asList(nonRecursiveFolder), null);
                break;
            }
            case 3: {
                value = Scope.create(null, null, Arrays.asList(file));
                break;
            }
            case 4: {
                value = this.customScope;
            }
        }
        return value;
    }

    String getMethodDeclaringClass() {
        return this.isMethodFromBaseClass() ? this.methodDeclaringSuperClass : this.methodDeclaringClass;
    }

    private Collection getOverriddenMethods(ExecutableElement m, CompilationInfo info) {
        return RetoucheUtils.getOverridenMethods(m, info);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        JavaSource source = JavaSource.forFileObject((FileObject)this.element.getFileObject());
        final Project p = FileOwnerQuery.getOwner((FileObject)this.element.getFileObject());
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void cancel() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void run(CompilationController info) throws Exception {
                JLabel allProjects;
                JLabel currentProject;
                JLabel currentPackage;
                JLabel currentFile;
                JLabel customScope;
                String packageName;
                String labelText;
                info.toPhase(JavaSource.Phase.RESOLVED);
                String m_isBaseClassText = null;
                Set<Object> modif = new HashSet();
                final Element element = WhereUsedPanel.this.element.resolveElement((CompilationInfo)info);
                if (element.getKind() == ElementKind.METHOD) {
                    ExecutableElement method = (ExecutableElement)element;
                    modif = method.getModifiers();
                    labelText = NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_MethodUsages", (Object)WhereUsedPanel.this.getHeader(method, (CompilationInfo)info), (Object)WhereUsedPanel.this.getSimpleName(method.getEnclosingElement()));
                    WhereUsedPanel.this.methodDeclaringClass = WhereUsedPanel.this.getSimpleName(method.getEnclosingElement());
                    Collection overridens = WhereUsedPanel.this.getOverriddenMethods(method, (CompilationInfo)info);
                    if (!overridens.isEmpty()) {
                        ExecutableElement el = (ExecutableElement)overridens.iterator().next();
                        assert (el != null);
                        m_isBaseClassText = new MessageFormat(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_UsagesOfBaseClass")).format(new Object[]{WhereUsedPanel.this.methodDeclaringSuperClass = WhereUsedPanel.this.getSimpleName(el.getEnclosingElement())});
                        WhereUsedPanel.this.newElement = TreePathHandle.create((Element)el, (CompilationInfo)info);
                    }
                } else {
                    labelText = element.getKind().isClass() || element.getKind().isInterface() ? NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_ClassUsages", (Object)element.getSimpleName()) : (element.getKind() == ElementKind.CONSTRUCTOR ? NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_ConstructorUsages", (Object)WhereUsedPanel.this.getHeader(element, (CompilationInfo)info), (Object)WhereUsedPanel.this.getSimpleName(element.getEnclosingElement())) : (element.getKind().isField() ? NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_FieldUsages", (Object)element.getSimpleName(), (Object)WhereUsedPanel.this.getSimpleName(element.getEnclosingElement())) : (element.getKind() == ElementKind.PACKAGE ? NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_PackageUsages", (Object)element.getSimpleName()) : NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_VariableUsages", (Object)element.getSimpleName()))));
                }
                TreePath path = WhereUsedPanel.this.element.resolve((CompilationInfo)info);
                ExpressionTree packageName1 = path.getCompilationUnit().getPackageName();
                String string = packageName = packageName1 == null ? "<default package>" : packageName1.toString();
                if (packageName1 == null) {
                    WhereUsedPanel.this.packageFolder = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).findOwnerRoot(WhereUsedPanel.this.element.getFileObject());
                } else {
                    WhereUsedPanel.this.packageFolder = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).findResource(packageName.replaceAll("\\.", "/"));
                }
                final Set<Object> modifiers = modif;
                final String isBaseClassText = m_isBaseClassText;
                if (p != null) {
                    ProjectInformation pi = ProjectUtils.getInformation((Project)FileOwnerQuery.getOwner((FileObject)WhereUsedPanel.this.element.getFileObject()));
                    SourceGroup[] sources = ProjectUtils.getSources((Project)pi.getProject()).getSourceGroups("java");
                    WhereUsedPanel.access$902(WhereUsedPanel.this, new FileObject[sources.length]);
                    for (int i = 0; i < sources.length; ++i) {
                        ((WhereUsedPanel)WhereUsedPanel.this).projectSources[i] = sources[i].getRootFolder();
                    }
                    DataObject currentFileDo = null;
                    try {
                        currentFileDo = DataObject.find((FileObject)WhereUsedPanel.this.element.getFileObject());
                    }
                    catch (DataObjectNotFoundException ex) {
                        // empty catch block
                    }
                    customScope = new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_CustomScope"), pi.getIcon(), 2);
                    currentFile = new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_CurrentFile", (Object)WhereUsedPanel.this.element.getFileObject().getNameExt()), currentFileDo != null ? new ImageIcon(currentFileDo.getNodeDelegate().getIcon(1)) : pi.getIcon(), 2);
                    currentPackage = new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_CurrentPackage", (Object)packageName), ImageUtilities.loadImageIcon((String)WhereUsedPanel.PACKAGE, (boolean)false), 2);
                    currentProject = new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_CurrentProject", (Object)pi.getDisplayName()), pi.getIcon(), 2);
                    allProjects = new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_AllProjects"), pi.getIcon(), 2);
                } else {
                    customScope = null;
                    currentFile = null;
                    currentPackage = null;
                    currentProject = null;
                    allProjects = null;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WhereUsedPanel.this.remove(WhereUsedPanel.this.classesPanel);
                        WhereUsedPanel.this.remove(WhereUsedPanel.this.methodsPanel);
                        WhereUsedPanel.this.label.setText(labelText);
                        if (element instanceof ExecutableElement) {
                            WhereUsedPanel.this.add((Component)WhereUsedPanel.this.methodsPanel, "Center");
                            WhereUsedPanel.this.methodsPanel.setVisible(true);
                            WhereUsedPanel.this.m_usages.setVisible(!modifiers.contains((Object)Modifier.STATIC));
                            WhereUsedPanel.this.m_overriders.setVisible(!element.getEnclosingElement().getModifiers().contains((Object)Modifier.FINAL) && !modifiers.contains((Object)Modifier.FINAL) && !modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.PRIVATE) && element.getKind() != ElementKind.CONSTRUCTOR);
                            if (WhereUsedPanel.this.methodDeclaringSuperClass != null) {
                                WhereUsedPanel.this.m_isBaseClass.setVisible(true);
                                WhereUsedPanel.this.m_isBaseClass.setSelected(true);
                                Mnemonics.setLocalizedText((AbstractButton)WhereUsedPanel.this.m_isBaseClass, (String)isBaseClassText);
                            } else {
                                WhereUsedPanel.this.m_isBaseClass.setVisible(false);
                                WhereUsedPanel.this.m_isBaseClass.setSelected(false);
                            }
                        } else if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE) {
                            WhereUsedPanel.this.add((Component)WhereUsedPanel.this.classesPanel, "Center");
                            WhereUsedPanel.this.classesPanel.setVisible(true);
                        } else {
                            WhereUsedPanel.this.remove(WhereUsedPanel.this.classesPanel);
                            WhereUsedPanel.this.remove(WhereUsedPanel.this.methodsPanel);
                            WhereUsedPanel.this.c_subclasses.setVisible(false);
                            WhereUsedPanel.this.m_usages.setVisible(false);
                            WhereUsedPanel.this.c_usages.setVisible(false);
                            WhereUsedPanel.this.c_directOnly.setVisible(false);
                        }
                        ElementKind kind = element.getKind();
                        if (kind.equals((Object)ElementKind.LOCAL_VARIABLE) || kind.equals((Object)ElementKind.PARAMETER) || element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                            WhereUsedPanel.this.enableScope = false;
                        }
                        if (WhereUsedPanel.this.enableScope && currentProject != null) {
                            WhereUsedPanel.this.scope.setModel(new DefaultComboBoxModel<Object>(new Object[]{allProjects, currentProject, currentPackage, currentFile, customScope}));
                            int defaultItem = RefactoringModule.getOption("whereUsed.scope", 0);
                            WhereUsedPanel.this.scope.setSelectedIndex(defaultItem);
                            WhereUsedPanel.this.scope.setRenderer(new JLabelRenderer());
                        } else {
                            WhereUsedPanel.this.scopePanel.setVisible(false);
                        }
                        WhereUsedPanel.this.validate();
                    }
                });
            }
        };
        try {
            source.runUserActionTask((Task)task, true);
        }
        catch (IOException ioe) {
            throw (RuntimeException)new RuntimeException().initCause(ioe);
        }
        this.initialized = true;
    }

    private String getSimpleName(Element clazz) {
        return clazz.getSimpleName().toString();
    }

    private String getHeader(Element call, CompilationInfo info) {
        String result = ElementHeaders.getHeader((Element)call, (CompilationInfo)info, (String)"%name%%parameters%");
        if (result.length() > 50) {
            result = result.substring(0, 49) + "...";
        }
        return RetoucheUtils.htmlize(result);
    }

    public TreePathHandle getBaseMethod() {
        return this.newElement;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.methodsPanel = new JPanel();
        this.m_isBaseClass = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.m_overriders = new JCheckBox();
        this.m_usages = new JCheckBox();
        this.classesPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.c_subclasses = new JRadioButton();
        this.c_usages = new JRadioButton();
        this.c_directOnly = new JRadioButton();
        this.commentsPanel = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.scopePanel = new JPanel();
        this.scopeLabel = new JLabel();
        this.scope = new JComboBox();
        this.btnCustomScope = new JButton();
        this.setLayout(new BorderLayout());
        this.methodsPanel.setLayout(new GridBagLayout());
        this.m_isBaseClass.setSelected(true);
        this.m_isBaseClass.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WhereUsedPanel.this.m_isBaseClassStateChanged(evt);
            }
        });
        this.m_isBaseClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_isBaseClassActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_isBaseClass, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle");
        this.m_isBaseClass.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_isBaseClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.methodsPanel.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.m_overriders, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindOverridingMethods"));
        this.m_overriders.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WhereUsedPanel.this.m_overridersStateChanged(evt);
            }
        });
        this.m_overriders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_overridersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_overriders, gridBagConstraints);
        this.m_overriders.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_overriders"));
        this.m_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.m_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.m_usages.setMargin(new Insets(10, 2, 2, 2));
        this.m_usages.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WhereUsedPanel.this.m_usagesStateChanged(evt);
            }
        });
        this.m_usages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_usagesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_usages, gridBagConstraints);
        this.m_usages.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_usages"));
        this.add((Component)this.methodsPanel, "Center");
        this.classesPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.classesPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.buttonGroup.add(this.c_subclasses);
        Mnemonics.setLocalizedText((AbstractButton)this.c_subclasses, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindAllSubtypes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_subclasses, gridBagConstraints);
        this.c_subclasses.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_subclasses"));
        this.buttonGroup.add(this.c_usages);
        this.c_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.c_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.c_usages.setMargin(new Insets(4, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_usages, gridBagConstraints);
        this.c_usages.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_usages"));
        this.buttonGroup.add(this.c_directOnly);
        Mnemonics.setLocalizedText((AbstractButton)this.c_directOnly, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindDirectSubtypesOnly"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_directOnly, gridBagConstraints);
        this.c_directOnly.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_directOnly"));
        this.add((Component)this.classesPanel, "Center");
        this.commentsPanel.setLayout(new BorderLayout());
        this.commentsPanel.add((Component)this.label, "North");
        this.searchInComments.setSelected(RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)NbBundle.getBundle(WhereUsedPanel.class).getString("LBL_SearchInComents"));
        this.searchInComments.setMargin(new Insets(10, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WhereUsedPanel.this.searchInCommentsItemStateChanged(evt);
            }
        });
        this.commentsPanel.add((Component)this.searchInComments, "South");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.commentsPanel, "North");
        this.scopeLabel.setLabelFor(this.scope);
        Mnemonics.setLocalizedText((JLabel)this.scopeLabel, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_Scope"));
        ((JTextField)this.scope.getEditor().getEditorComponent()).setColumns(14);
        this.scope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.scopeActionPerformed(evt);
            }
        });
        this.btnCustomScope.setText(ELLIPSIS);
        GroupLayout scopePanelLayout = new GroupLayout(this.scopePanel);
        this.scopePanel.setLayout(scopePanelLayout);
        scopePanelLayout.setHorizontalGroup(scopePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scopePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.scopeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scope, 0, 150, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCustomScope).addContainerGap()));
        scopePanelLayout.setVerticalGroup(scopePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scopeLabel).addComponent(this.scope).addComponent(this.btnCustomScope));
        this.scope.getAccessibleContext().setAccessibleDescription("N/A");
        this.add((Component)this.scopePanel, "Last");
    }

    private void scopeActionPerformed(ActionEvent evt) {
        RefactoringModule.setOption("whereUsed.scope", this.scope.getSelectedIndex());
    }

    private void searchInCommentsItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.whereUsed", b);
    }

    private void m_isBaseClassActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_overridersActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_usagesActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_isBaseClassStateChanged(ChangeEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_overridersStateChanged(ChangeEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_usagesStateChanged(ChangeEvent evt) {
        this.parent.stateChanged(null);
    }

    public boolean isMethodFromBaseClass() {
        return this.m_isBaseClass.isSelected();
    }

    public boolean isMethodOverriders() {
        return this.m_overriders.isSelected();
    }

    public boolean isClassSubTypes() {
        return this.c_subclasses.isSelected();
    }

    public boolean isClassSubTypesDirectOnly() {
        return this.c_directOnly.isSelected();
    }

    public boolean isMethodFindUsages() {
        return this.m_usages.isSelected();
    }

    public boolean isClassFindUsages() {
        return this.c_usages.isSelected();
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public Component getComponent() {
        return this;
    }

    static /* synthetic */ FileObject[] access$902(WhereUsedPanel x0, FileObject[] x1) {
        x0.projectSources = x1;
        return x1;
    }

    private class ScopeAction
    extends AbstractAction {
        private final JComboBox scope;

        private ScopeAction(JComboBox scope) {
            this.scope = scope;
            this.putValue("Name", WhereUsedPanel.ELLIPSIS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Scope customScope = WhereUsedPanel.this.getCustomScope();
            customScope = JavaScopeBuilder.open(NbBundle.getMessage(WhereUsedPanel.class, (String)"DLG_CustomScope"), customScope);
            if (customScope != null) {
                WhereUsedPanel.this.customScope = customScope;
                this.scope.setSelectedIndex(4);
            }
        }
    }

    private static class JLabelRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public JLabelRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                this.setText(((JLabel)value).getText());
                this.setIcon(((JLabel)value).getIcon());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

