/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.event.ChangeListener;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.JavaRenameProperties;
import org.netbeans.modules.refactoring.java.ui.RenamePanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class RenameRefactoringUI
implements RefactoringUI,
RefactoringUIBypass,
Openable {
    private final AbstractRefactoring refactoring;
    private String oldName = null;
    private String dispOldName;
    private String newName;
    private RenamePanel panel;
    private boolean fromListener = false;
    private TreePathHandle handle;
    private ElementHandle elementHandle;
    private FileObject byPassFolder;
    private boolean byPassPakageRename;
    private boolean pkgRename = true;

    public RenameRefactoringUI(TreePathHandle handle, CompilationInfo info) {
        this.handle = handle;
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)handle));
        Element element = handle.resolveElement(info);
        if (element.getKind() != ElementKind.LOCAL_VARIABLE && element.getKind() != ElementKind.PARAMETER) {
            this.elementHandle = ElementHandle.create((Element)element);
        }
        this.oldName = element.getSimpleName().toString();
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(false, handle.getFileObject()));
        } else {
            this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(true, true, RetoucheUtils.getFileObject(handle)));
        }
        this.dispOldName = this.oldName;
    }

    public RenameRefactoringUI(FileObject file, TreePathHandle handle, CompilationInfo info) {
        if (handle != null) {
            this.handle = handle;
            this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{file, handle}));
            Element element = handle.resolveElement(info);
            if (element.getKind() != ElementKind.LOCAL_VARIABLE && element.getKind() != ElementKind.PARAMETER) {
                this.elementHandle = ElementHandle.create((Element)element);
            }
            this.oldName = element.getSimpleName().toString();
        } else {
            this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{file}));
            this.oldName = file.getName();
        }
        this.dispOldName = this.oldName;
        ClasspathInfo cpInfo = handle == null ? RetoucheUtils.getClasspathInfoFor(file) : RetoucheUtils.getClasspathInfoFor(handle);
        this.refactoring.getContext().add((Object)cpInfo);
    }

    public RenameRefactoringUI(NonRecursiveFolder file) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)file));
        this.oldName = RetoucheUtils.getPackageName(file.getFolder());
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(file.getFolder()));
        this.dispOldName = this.oldName;
        this.pkgRename = true;
    }

    RenameRefactoringUI(FileObject jmiObject, String newName, TreePathHandle handle, CompilationInfo info) {
        if (handle != null) {
            this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{jmiObject, handle}));
            Element element = handle.resolveElement(info);
            if (element.getKind() != ElementKind.LOCAL_VARIABLE && element.getKind() != ElementKind.PARAMETER) {
                this.elementHandle = ElementHandle.create((Element)element);
            }
        } else {
            this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{jmiObject}));
        }
        this.oldName = newName;
        this.dispOldName = jmiObject.getName();
        ClasspathInfo cpInfo = handle == null ? RetoucheUtils.getClasspathInfoFor(jmiObject) : RetoucheUtils.getClasspathInfoFor(handle);
        this.refactoring.getContext().add((Object)cpInfo);
        this.fromListener = true;
    }

    RenameRefactoringUI(NonRecursiveFolder jmiObject, String newName) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)jmiObject));
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(jmiObject.getFolder()));
        this.oldName = newName;
        this.dispOldName = RetoucheUtils.getPackageName(jmiObject.getFolder());
        this.fromListener = true;
        this.pkgRename = true;
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            String name = this.oldName;
            String suffix = "";
            if (this.handle != null) {
                ElementKind kind = RetoucheUtils.getElementKind(this.handle);
                if (kind != null && (kind.isClass() || kind.isInterface())) {
                    suffix = kind.isInterface() ? RenameRefactoringUI.getString("LBL_Interface") : RenameRefactoringUI.getString("LBL_Class");
                } else if (kind == ElementKind.METHOD) {
                    suffix = RenameRefactoringUI.getString("LBL_Method");
                } else if (kind == ElementKind.FIELD) {
                    suffix = RenameRefactoringUI.getString("LBL_Field");
                } else if (kind == ElementKind.LOCAL_VARIABLE) {
                    suffix = RenameRefactoringUI.getString("LBL_LocalVar");
                } else if (kind == ElementKind.PACKAGE || this.handle == null && this.fromListener) {
                    suffix = this.pkgRename ? RenameRefactoringUI.getString("LBL_Package") : RenameRefactoringUI.getString("LBL_Folder");
                } else if (kind == ElementKind.PARAMETER) {
                    suffix = RenameRefactoringUI.getString("LBL_Parameter");
                }
            }
            suffix = suffix + " " + this.dispOldName;
            this.panel = new RenamePanel(this.handle, name, parent, NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename") + " " + suffix, !this.fromListener, this.fromListener && !this.byPassPakageRename);
        }
        return this.panel;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(RenameRefactoringUI.class, (String)key);
    }

    public Problem setParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
            ((RenameRefactoring)this.refactoring).setSearchInComments(this.panel.searchJavadoc());
            JavaRenameProperties properties = (JavaRenameProperties)this.refactoring.getContext().lookup(JavaRenameProperties.class);
            if (properties == null) {
                properties = new JavaRenameProperties();
                this.refactoring.getContext().add((Object)properties);
            }
            properties.setIsRenameGettersSetters(this.panel.isRenameGettersSetters());
            properties.setIsRenameTestClass(this.panel.isRenameTestClass());
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (!this.panel.isUpdateReferences()) {
            return null;
        }
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
            JavaRenameProperties properties = (JavaRenameProperties)this.refactoring.getContext().lookup(JavaRenameProperties.class);
            if (properties == null) {
                properties = new JavaRenameProperties();
                this.refactoring.getContext().add((Object)properties);
            }
            properties.setIsRenameGettersSetters(this.panel.isRenameGettersSetters());
        }
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(RenamePanel.class, (String)"DSC_Rename")).format(new Object[]{this.dispOldName, this.newName});
    }

    public String getName() {
        return NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        ElementKind k;
        String postfix = this.handle == null ? ".JavaPackage" : ((k = RetoucheUtils.getElementKind(this.handle)) == null ? "" : (k.isClass() || k.isInterface() ? ".JavaClass" : (k == ElementKind.METHOD ? ".Method" : (k.isField() ? ".Field" : ""))));
        return new HelpCtx(RenameRefactoringUI.class.getName() + postfix);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    DataFolder dob = null;
                    if (RenameRefactoringUI.this.byPassFolder != null) {
                        dob = DataFolder.findFolder((FileObject)RenameRefactoringUI.this.byPassFolder);
                    } else {
                        FileObject fob = (FileObject)RenameRefactoringUI.this.refactoring.getRefactoringSource().lookup(FileObject.class);
                        if (fob != null) {
                            dob = DataObject.find((FileObject)((FileObject)RenameRefactoringUI.this.refactoring.getRefactoringSource().lookup(FileObject.class)));
                        }
                    }
                    DataFolder dobFin = dob;
                    FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction((DataObject)dobFin){
                        final /* synthetic */ DataObject val$dobFin;
                        {
                            this.val$dobFin = dataObject;
                        }

                        public void run() throws IOException {
                            if (this.val$dobFin != null) {
                                this.val$dobFin.rename(RenameRefactoringUI.this.panel.getNameValue());
                            } else {
                                NonRecursiveFolder pack = (NonRecursiveFolder)RenameRefactoringUI.this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
                                if (pack != null) {
                                    RenameRefactoringUI.this.renamePackage(pack.getFolder(), RenameRefactoringUI.this.panel.getNameValue());
                                }
                            }
                        }
                    });
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
    }

    private void renamePackage(FileObject source, String name) {
        int index;
        int i;
        FileObject root = ClassPath.getClassPath((FileObject)source, (String)"classpath/source").findOwnerRoot(source);
        name = name.replace('.', '/') + '/';
        String oldName = this.dispOldName.replace('.', '/') + '/';
        for (i = 0; i < oldName.length() && i < name.length() && oldName.charAt(i) == name.charAt(i); ++i) {
        }
        String commonPrefix = (index = oldName.lastIndexOf(47, --i)) == -1 ? null : oldName.substring(0, index);
        String toCreate = index + 1 == name.length() ? "" : name.substring(index + 1);
        try {
            FileObject commonFolder;
            FileObject destination = commonFolder = commonPrefix == null ? root : root.getFileObject(commonPrefix);
            StringTokenizer dtk = new StringTokenizer(toCreate, "/");
            while (dtk.hasMoreTokens()) {
                String pathElement = dtk.nextToken();
                FileObject tmp = destination.getFileObject(pathElement);
                if (tmp == null) {
                    tmp = destination.createFolder(pathElement);
                }
                destination = tmp;
            }
            DataFolder sourceFolder = DataFolder.findFolder((FileObject)source);
            DataFolder destinationFolder = DataFolder.findFolder((FileObject)destination);
            DataObject[] children = sourceFolder.getChildren();
            for (int j = 0; j < children.length; ++j) {
                if (!children[j].getPrimaryFile().isData()) continue;
                children[j].move(destinationFolder);
            }
            while (!commonFolder.equals(source) && source.getChildren().length == 0) {
                FileObject tmp = source;
                source = source.getParent();
                tmp.delete();
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }

    public void open() {
        if (this.elementHandle != null) {
            ElementOpen.open((FileObject)this.handle.getFileObject(), (ElementHandle)this.elementHandle);
        }
    }
}

