/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.javadoc.Doc;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.ui.ChangeParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class IntroduceParameterPanel
extends JPanel
implements CustomRefactoringPanel {
    private static final String OVERLOADMETHOD = "overloadmethod.introduceParameter";
    private static final String REPLACEALL = "replaceall.introduceParameter";
    private static final String DECLAREFINAL = "declarefinal.introduceParameter";
    private static final String UPDATEJAVADOC = "updateJavadoc.introduceParameters";
    private static final String GENJAVADOC = "generateJavadoc.introduceParameters";
    private static final String MIME_JAVA = "text/x-java";
    private static final String DEFAULT_NAME = "par";
    TreePathHandle refactoredObj;
    private ChangeListener parent;
    private final JComponent[] singleLineEditor;
    private final DocumentListener nameChangedListener;
    private int startOffset;
    private boolean initialized = false;
    private ButtonGroup bgOverloadMethod;
    private JCheckBox chkGenJavadoc;
    private JCheckBox chkIsDeclareFinal;
    private JCheckBox chkIsReplaceAll;
    private JCheckBox chkUpdateJavadoc;
    private JScrollPane jScrollPane1;
    private JLabel lblCodeGeneration;
    private JLabel lblName;
    private JRadioButton rbOverloadMethod;
    private JRadioButton rbUpdateMethod;

    public Component getComponent() {
        return this;
    }

    public IntroduceParameterPanel(TreePathHandle refactoredObj, final ChangeListener parent) {
        this.refactoredObj = refactoredObj;
        this.parent = parent;
        this.singleLineEditor = Utilities.createSingleLineEditor((String)MIME_JAVA);
        this.initComponents();
        this.nameChangedListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                parent.stateChanged(null);
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                parent.stateChanged(null);
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                parent.stateChanged(null);
            }
        };
        ((JEditorPane)this.singleLineEditor[1]).getDocument().addDocumentListener(this.nameChangedListener);
    }

    public void initialize() {
        try {
            if (this.initialized) {
                return;
            }
            JavaSource source = JavaSource.forFileObject((FileObject)this.refactoredObj.getFileObject());
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController info) {
                    try {
                        info.toPhase(JavaSource.Phase.RESOLVED);
                        final FileObject fileObject = IntroduceParameterPanel.this.refactoredObj.getFileObject();
                        DataObject dob = DataObject.find((FileObject)fileObject);
                        ((JEditorPane)IntroduceParameterPanel.this.singleLineEditor[1]).getDocument().putProperty("stream", dob);
                        TreePath path = IntroduceParameterPanel.this.refactoredObj.resolve((CompilationInfo)info);
                        TreePath methodPath = JavaPluginUtils.findMethod(path);
                        MethodTree methodTree = (MethodTree)methodPath.getLeaf();
                        final int[] parameterSpan = info.getTreeUtilities().findMethodParameterSpan(methodTree);
                        final TypeMirror tm = info.getTrees().getTypeMirror(path);
                        Element methodElement = info.getTrees().getElement(methodPath);
                        Doc javadocDoc = info.getElementUtilities().javaDocFor(methodElement);
                        if (javadocDoc.commentText() == null || javadocDoc.getRawCommentText().equals("")) {
                            IntroduceParameterPanel.this.chkGenJavadoc.setEnabled(true);
                            IntroduceParameterPanel.this.chkGenJavadoc.setVisible(true);
                            IntroduceParameterPanel.this.chkUpdateJavadoc.setVisible(false);
                        } else {
                            IntroduceParameterPanel.this.chkUpdateJavadoc.setEnabled(true);
                            IntroduceParameterPanel.this.chkUpdateJavadoc.setVisible(true);
                            IntroduceParameterPanel.this.chkGenJavadoc.setVisible(false);
                        }
                        String name = IntroduceParameterPanel.getName(path.getLeaf());
                        if (name == null) {
                            name = IntroduceParameterPanel.DEFAULT_NAME;
                        }
                        Scope scope = null;
                        TreePath bodyPath = new TreePath(methodPath, methodTree.getBody());
                        scope = info.getTrees().getScope(bodyPath);
                        final String parameterName = IntroduceParameterPanel.makeNameUnique((CompilationInfo)info, scope, name, methodTree);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JEditorPane editorPane = (JEditorPane)IntroduceParameterPanel.this.singleLineEditor[1];
                                DialogBinding.bindComponentToFile((FileObject)fileObject, (int)(parameterSpan[0] + 1), (int)(parameterSpan[1] - parameterSpan[0]), (JTextComponent)editorPane);
                                editorPane.setText(((Object)tm).toString() + " " + parameterName);
                                IntroduceParameterPanel.this.startOffset = ((Object)tm).toString().length() + 1;
                                int endOffset = parameterName.length() + IntroduceParameterPanel.this.startOffset;
                                editorPane.select(IntroduceParameterPanel.this.startOffset, endOffset);
                                try {
                                    Position startPos = editorPane.getDocument().createPosition(IntroduceParameterPanel.this.startOffset);
                                    Position endPos = editorPane.getDocument().createPosition(endOffset);
                                    editorPane.putClientProperty("document-view-start-position", startPos);
                                    editorPane.putClientProperty("document-view-end-position", endPos);
                                }
                                catch (BadLocationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                ((JEditorPane)IntroduceParameterPanel.this.singleLineEditor[1]).getDocument().addDocumentListener(IntroduceParameterPanel.this.nameChangedListener);
                                ((JEditorPane)IntroduceParameterPanel.this.singleLineEditor[1]).putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
                                IntroduceParameterPanel.this.initialized = true;
                            }
                        });
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }

                public void cancel() {
                }
            }, true);
            this.initialized = true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.bgOverloadMethod = new ButtonGroup();
        this.lblName = new JLabel();
        this.chkIsDeclareFinal = new JCheckBox();
        this.chkIsReplaceAll = new JCheckBox();
        this.jScrollPane1 = (JScrollPane)this.singleLineEditor[0];
        this.chkGenJavadoc = new JCheckBox();
        this.chkUpdateJavadoc = new JCheckBox();
        this.rbUpdateMethod = new JRadioButton();
        this.rbOverloadMethod = new JRadioButton();
        this.lblCodeGeneration = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setAutoscrolls(true);
        this.setName(IntroduceParameterPanel.getString("LBL_TitleIntroduceParameter"));
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.lblName.text"));
        this.chkIsDeclareFinal.setSelected(RefactoringModule.getOption(DECLAREFINAL, Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.chkIsDeclareFinal, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.chkIsDeclareFinal.text"));
        this.chkIsDeclareFinal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceParameterPanel.this.chkIsDeclareFinalItemStateChanged(evt);
            }
        });
        this.chkIsReplaceAll.setSelected(RefactoringModule.getOption(REPLACEALL, Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.chkIsReplaceAll, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.chkIsReplaceAll.text"));
        this.chkIsReplaceAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceParameterPanel.this.chkIsReplaceAllItemStateChanged(evt);
            }
        });
        this.chkGenJavadoc.setSelected(RefactoringModule.getOption(GENJAVADOC, Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.chkGenJavadoc, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.chkGenJavadoc.text"));
        this.chkGenJavadoc.setEnabled(false);
        this.chkGenJavadoc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceParameterPanel.this.chkGenJavadocItemStateChanged(evt);
            }
        });
        this.chkUpdateJavadoc.setSelected(RefactoringModule.getOption(UPDATEJAVADOC, Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.chkUpdateJavadoc, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.chkUpdateJavadoc.text"));
        this.chkUpdateJavadoc.setEnabled(false);
        this.chkUpdateJavadoc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceParameterPanel.this.chkUpdateJavadocItemStateChanged(evt);
            }
        });
        this.bgOverloadMethod.add(this.rbUpdateMethod);
        this.rbUpdateMethod.setSelected(Boolean.valueOf(RefactoringModule.getOption(OVERLOADMETHOD, Boolean.FALSE)) == false);
        Mnemonics.setLocalizedText((AbstractButton)this.rbUpdateMethod, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.rbUpdateMethod.text"));
        this.bgOverloadMethod.add(this.rbOverloadMethod);
        this.rbOverloadMethod.setSelected(RefactoringModule.getOption(OVERLOADMETHOD, Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.rbOverloadMethod, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.rbOverloadMethod.text"));
        this.rbOverloadMethod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceParameterPanel.this.rbOverloadMethodItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblCodeGeneration, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.lblCodeGeneration.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblName).addGap(2, 2, 2).addComponent(this.jScrollPane1, -1, 428, Short.MAX_VALUE)).addComponent(this.chkIsDeclareFinal).addComponent(this.chkIsReplaceAll).addComponent(this.chkUpdateJavadoc).addComponent(this.chkGenJavadoc).addComponent(this.lblCodeGeneration).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.rbUpdateMethod)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.rbOverloadMethod)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblName, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addGap(18, 18, 18).addComponent(this.chkIsDeclareFinal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkIsReplaceAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkUpdateJavadoc).addComponent(this.chkGenJavadoc)).addGap(18, 18, 18).addComponent(this.lblCodeGeneration).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbUpdateMethod).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbOverloadMethod).addContainerGap(24, Short.MAX_VALUE)));
    }

    private void chkIsReplaceAllItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(REPLACEALL, b);
        this.parent.stateChanged(null);
    }

    private void chkIsDeclareFinalItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(DECLAREFINAL, b);
        this.parent.stateChanged(null);
    }

    private void chkGenJavadocItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(GENJAVADOC, b);
        this.parent.stateChanged(null);
    }

    private void chkUpdateJavadocItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(UPDATEJAVADOC, b);
        this.parent.stateChanged(null);
    }

    private void rbOverloadMethodItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(OVERLOADMETHOD, b);
        this.parent.stateChanged(null);
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ChangeParametersPanel.class, (String)key);
    }

    public boolean isCompatible() {
        return this.rbOverloadMethod.isSelected();
    }

    public boolean isDeclareFinal() {
        return this.chkIsDeclareFinal.isSelected();
    }

    public boolean isReplaceAll() {
        return this.chkIsReplaceAll.isSelected();
    }

    public String getParameterName() {
        return ((JEditorPane)this.singleLineEditor[1]).getText().substring(this.startOffset);
    }

    protected ChangeParametersPanel.Javadoc getJavadoc() {
        if (this.chkUpdateJavadoc.isVisible() && this.chkUpdateJavadoc.isSelected()) {
            return ChangeParametersPanel.Javadoc.UPDATE;
        }
        if (this.chkGenJavadoc.isVisible() && this.chkGenJavadoc.isSelected()) {
            return ChangeParametersPanel.Javadoc.GENERATE;
        }
        return ChangeParametersPanel.Javadoc.NONE;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        ((JEditorPane)this.singleLineEditor[1]).requestFocus();
    }

    private static String makeNameUnique(CompilationInfo info, Scope s, String name, MethodTree method) {
        int counter = 0;
        boolean cont = true;
        String proposedName = name;
        block0: while (cont) {
            proposedName = name + (counter != 0 ? String.valueOf(counter) : "");
            cont = false;
            if (s == null) continue;
            for (Element e : info.getElementUtilities().getLocalMembersAndVars(s, (ElementUtilities.ElementAcceptor)new VariablesFilter())) {
                if (!proposedName.equals(e.getSimpleName().toString())) continue;
                ++counter;
                cont = true;
                continue block0;
            }
        }
        return proposedName;
    }

    public static String getName(Tree et) {
        return IntroduceParameterPanel.adjustName(IntroduceParameterPanel.getNameRaw(et));
    }

    private static String getNameRaw(Tree et) {
        if (et == null) {
            return null;
        }
        switch (et.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)et).getName().toString();
            }
            case METHOD_INVOCATION: {
                return IntroduceParameterPanel.getName(((MethodInvocationTree)et).getMethodSelect());
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)et).getIdentifier().toString();
            }
            case NEW_CLASS: {
                return IntroduceParameterPanel.firstToLower(IntroduceParameterPanel.getName(((NewClassTree)et).getIdentifier()));
            }
            case PARAMETERIZED_TYPE: {
                return IntroduceParameterPanel.firstToLower(IntroduceParameterPanel.getName(((ParameterizedTypeTree)et).getType()));
            }
            case STRING_LITERAL: {
                String name = IntroduceParameterPanel.guessLiteralName((String)((LiteralTree)et).getValue());
                if (name == null) {
                    return IntroduceParameterPanel.firstToLower(String.class.getSimpleName());
                }
                return IntroduceParameterPanel.firstToLower(name);
            }
            case VARIABLE: {
                return ((VariableTree)et).getName().toString();
            }
        }
        return null;
    }

    static String adjustName(String name) {
        if (name == null) {
            return null;
        }
        String shortName = null;
        if (name.startsWith("get") && name.length() > 3) {
            shortName = name.substring(3);
        }
        if (name.startsWith("is") && name.length() > 2) {
            shortName = name.substring(2);
        }
        if (shortName != null) {
            return IntroduceParameterPanel.firstToLower(shortName);
        }
        if (SourceVersion.isKeyword(name)) {
            return "a" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    private static String firstToLower(String name) {
        if (name.length() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean toLower = true;
        char last = Character.toLowerCase(name.charAt(0));
        for (int i = 1; i < name.length(); ++i) {
            if (toLower && Character.isUpperCase(name.charAt(i))) {
                result.append(Character.toLowerCase(last));
            } else {
                result.append(last);
                toLower = false;
            }
            last = name.charAt(i);
        }
        result.append(last);
        if (SourceVersion.isKeyword(result)) {
            return "a" + name;
        }
        return result.toString();
    }

    private static String guessLiteralName(String str) {
        StringBuilder sb = new StringBuilder();
        if (str.length() == 0) {
            return null;
        }
        char first = str.charAt(0);
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            sb.append(first);
        }
        for (int i = 1; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == ' ') {
                sb.append('_');
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
            }
            if (i > 40) break;
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public static final class VariablesFilter
    implements ElementUtilities.ElementAcceptor {
        private static final Set<ElementKind> ACCEPTABLE_KINDS = EnumSet.of(ElementKind.ENUM_CONSTANT, ElementKind.EXCEPTION_PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

        public boolean accept(Element e, TypeMirror type) {
            return ACCEPTABLE_KINDS.contains((Object)e.getKind());
        }
    }
}

