/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.InlineRefactoring;
import org.netbeans.modules.refactoring.java.ui.InlineAction;
import org.netbeans.modules.refactoring.java.ui.InnerToOuterAction;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class InlineRefactoringUI
implements RefactoringUI {
    private final InlineRefactoring refactoring;
    private final String type;
    private final String elementName;

    public InlineRefactoringUI(TreePathHandle selectedElement, CompilationInfo info) {
        InlineRefactoring.Type refactoringType;
        Element element = selectedElement.resolveElement(info);
        if (element == null) {
            switch (selectedElement.getKind()) {
                case BOOLEAN_LITERAL: 
                case CHAR_LITERAL: 
                case DOUBLE_LITERAL: 
                case FLOAT_LITERAL: 
                case INT_LITERAL: 
                case LONG_LITERAL: 
                case NULL_LITERAL: 
                case STRING_LITERAL: {
                    TreePath tp = selectedElement.resolve(info);
                    TreePath parent = tp.getParentPath();
                    Element parentElement = info.getTrees().getElement(parent);
                    if (parentElement.getKind() != ElementKind.LOCAL_VARIABLE) break;
                    element = (VariableElement)parentElement;
                    selectedElement = TreePathHandle.create((TreePath)parent, (CompilationInfo)info);
                }
            }
        }
        switch (selectedElement.getKind()) {
            case VARIABLE: {
                if (element.getKind().equals((Object)ElementKind.FIELD)) {
                    this.type = "Constant";
                    refactoringType = InlineRefactoring.Type.CONSTANT;
                    break;
                }
                this.type = "Temp";
                refactoringType = InlineRefactoring.Type.TEMP;
                break;
            }
            case METHOD: {
                this.type = "Method";
                refactoringType = InlineRefactoring.Type.METHOD;
                break;
            }
            default: {
                this.type = "Not Supported";
                refactoringType = InlineRefactoring.Type.UNSUPPORTED;
            }
        }
        this.refactoring = new InlineRefactoring(selectedElement, refactoringType);
        this.elementName = element.getSimpleName().toString();
    }

    public String getName() {
        return NbBundle.getMessage(InlineAction.class, (String)"LBL_Inline", (Object)this.type);
    }

    public String getDescription() {
        return NbBundle.getMessage(InnerToOuterAction.class, (String)"DSC_Inline", (Object)this.elementName);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        return null;
    }

    public Problem setParameters() {
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        return this.refactoring.fastCheckParameters();
    }

    public boolean hasParameters() {
        return false;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(InlineRefactoringUI.class.getName());
    }
}

