/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;

public class RenameTransformer
extends RefactoringVisitor {
    private Set<ElementHandle<ExecutableElement>> allMethods;
    private String newName;
    private boolean renameInComments;

    public RenameTransformer(String newName, Set<ElementHandle<ExecutableElement>> am, boolean renameInComments) {
        this.newName = newName;
        this.allMethods = am;
        this.renameInComments = renameInComments;
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        if (!this.renameInComments) {
            return (Tree)super.visitCompilationUnit(node, p);
        }
        if (p.getKind() == ElementKind.PARAMETER) {
            this.renameParameterInMethodComments(p);
        } else {
            String originalName = this.getOldSimpleName(p);
            if (originalName != null) {
                TokenSequence ts = this.workingCopy.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                while (ts.moveNext()) {
                    Token t = ts.token();
                    if (!this.isComment((Token<JavaTokenId>)t)) continue;
                    this.rewriteAllInComment(((Object)t.text()).toString(), ts.offset(), originalName);
                }
            }
        }
        return (Tree)super.visitCompilationUnit(node, p);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Element p) {
        this.renameUsageIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitIdentifier(node, p);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        this.renameUsageIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitMemberSelect(node, p);
    }

    private String getOldSimpleName(Element p) {
        if (p != null) {
            return p.getSimpleName().toString();
        }
        for (ElementHandle<ExecutableElement> mh : this.allMethods) {
            ExecutableElement baseMethod = (ExecutableElement)mh.resolve((CompilationInfo)this.workingCopy);
            if (baseMethod == null) continue;
            return baseMethod.getSimpleName().toString();
        }
        return null;
    }

    private void renameUsageIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(path)) {
            return;
        }
        TreePath elementPath = path;
        Trees trees = this.workingCopy.getTrees();
        Element el = this.workingCopy.getTrees().getElement(elementPath);
        if (el == null) {
            if ((elementPath = elementPath.getParentPath()) != null && elementPath.getLeaf().getKind() == Tree.Kind.IMPORT) {
                ImportTree impTree = (ImportTree)elementPath.getLeaf();
                if (!impTree.isStatic()) {
                    return;
                }
                Tree idTree = impTree.getQualifiedIdentifier();
                if (idTree.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return;
                }
                final Name id = ((MemberSelectTree)idTree).getIdentifier();
                if (id == null || id.contentEquals("*")) {
                    return;
                }
                ExpressionTree classTree = ((MemberSelectTree)idTree).getExpression();
                elementPath = trees.getPath(this.workingCopy.getCompilationUnit(), classTree);
                el = trees.getElement(elementPath);
                if (el == null) {
                    return;
                }
                Iterator iterator = this.workingCopy.getElementUtilities().getMembers(el.asType(), new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror type) {
                        return ((Object)id).equals(e.getSimpleName());
                    }
                }).iterator();
                if (iterator.hasNext()) {
                    el = (Element)iterator.next();
                }
                if (iterator.hasNext()) {
                    return;
                }
            } else {
                return;
            }
        }
        if (((Object)el).equals(elementToFind) || this.isMethodMatch(el)) {
            Types types;
            Scope scope;
            String useThis = null;
            String useSuper = null;
            if (elementToFind != null && elementToFind.getKind().isField()) {
                scope = this.workingCopy.getTrees().getScope(elementPath);
                for (Element element : scope.getLocalElements()) {
                    String isThis;
                    if (element.getKind() != ElementKind.LOCAL_VARIABLE && element.getKind() != ElementKind.PARAMETER || !element.getSimpleName().toString().equals(this.newName)) continue;
                    if (tree.getKind() == Tree.Kind.MEMBER_SELECT && ((isThis = ((MemberSelectTree)tree).getExpression().toString()).equals("this") || isThis.endsWith(".this"))) break;
                    if (elementToFind.getModifiers().contains((Object)Modifier.STATIC)) {
                        useThis = elementToFind.getEnclosingElement().getSimpleName().toString() + ".";
                        break;
                    }
                    types = this.workingCopy.getTypes();
                    if (types.isSubtype(scope.getEnclosingClass().asType(), elementToFind.getEnclosingElement().asType())) {
                        useThis = "this.";
                        break;
                    }
                    useThis = elementToFind.getEnclosingElement().getSimpleName() + ".this.";
                    break;
                }
            }
            if (elementToFind != null && elementToFind.getKind().isField() || elementToFind.getKind().equals((Object)ElementKind.METHOD)) {
                scope = this.workingCopy.getTrees().getScope(elementPath);
                TypeElement enclosingTypeElement = scope.getEnclosingClass();
                TypeMirror typeMirror = enclosingTypeElement.getSuperclass();
                types = this.workingCopy.getTypes();
                if (!types.isSameType(types.getNoType(TypeKind.NONE), typeMirror) && types.isSubtype(elementToFind.getEnclosingElement().asType(), typeMirror)) {
                    ElementUtilities utils;
                    if (elementToFind.getKind().isField()) {
                        for (Element element : enclosingTypeElement.getEnclosedElements()) {
                            String isSuper;
                            if (!element.getKind().isField() || !element.getSimpleName().toString().equals(this.newName)) continue;
                            if (tree.getKind() != Tree.Kind.MEMBER_SELECT || !(isSuper = ((MemberSelectTree)tree).getExpression().toString()).equals("super") && !isSuper.endsWith(".super")) {
                                useSuper = types.isSubtype(enclosingTypeElement.asType(), elementToFind.getEnclosingElement().asType()) ? "super." : elementToFind.getEnclosingElement().getSimpleName() + ".super.";
                            }
                            break;
                        }
                    } else if (elementToFind.getKind() == ElementKind.METHOD && (utils = this.workingCopy.getElementUtilities()).alreadyDefinedIn((CharSequence)this.newName, (ExecutableType)elementToFind.asType(), enclosingTypeElement)) {
                        boolean bl;
                        String superString;
                        boolean bl2 = false;
                        if (tree.getKind() == Tree.Kind.MEMBER_SELECT && ((superString = ((MemberSelectTree)tree).getExpression().toString()).equals("super") || superString.endsWith(".super"))) {
                            bl = true;
                        }
                        if (!bl) {
                            useSuper = types.isSubtype(enclosingTypeElement.asType(), elementToFind.getEnclosingElement().asType()) ? "super." : elementToFind.getEnclosingElement().getSimpleName() + ".super.";
                        }
                    }
                }
            }
            Tree nju = null;
            if (useThis != null) {
                nju = this.make.setLabel(tree, (CharSequence)(useThis + this.newName));
            } else if (useSuper != null) {
                nju = this.make.setLabel(tree, (CharSequence)(useSuper + this.newName));
            } else if (elementToFind.getKind().isClass()) {
                boolean duplicate = this.duplicateDeclaration();
                TreePath treePath = path.getParentPath();
                if (treePath != null && treePath.getLeaf().getKind() == Tree.Kind.IMPORT) {
                    ImportTree importTree = (ImportTree)treePath.getLeaf();
                    if (duplicate) {
                        nju = this.make.removeCompUnitImport(this.workingCopy.getCompilationUnit(), importTree);
                        tree = this.workingCopy.getCompilationUnit();
                    }
                } else {
                    nju = duplicate ? this.make.QualIdent(((ExpressionTree)this.make.setLabel((Tree)this.make.QualIdent(elementToFind), (CharSequence)this.newName)).toString()) : this.make.setLabel(tree, (CharSequence)this.newName);
                }
            } else {
                nju = this.make.setLabel(tree, (CharSequence)this.newName);
            }
            if (nju != null) {
                this.rewrite(tree, nju);
            }
        }
    }

    @Override
    public Tree visitMethod(MethodTree tree, Element p) {
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        return (Tree)super.visitMethod(tree, p);
    }

    @Override
    public Tree visitClass(ClassTree tree, Element p) {
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        return (Tree)super.visitClass(tree, p);
    }

    @Override
    public Tree visitVariable(VariableTree tree, Element p) {
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        return (Tree)super.visitVariable(tree, p);
    }

    @Override
    public Tree visitTypeParameter(TypeParameterTree arg0, Element arg1) {
        this.renameDeclIfMatch(this.getCurrentPath(), arg0, arg1);
        return (Tree)super.visitTypeParameter(arg0, arg1);
    }

    private void renameDeclIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(path)) {
            return;
        }
        Element el = this.workingCopy.getTrees().getElement(path);
        if (el == null) {
            return;
        }
        if (((Object)el).equals(elementToFind) || this.isMethodMatch(el)) {
            Tree nju = this.make.setLabel(tree, (CharSequence)this.newName);
            this.rewrite(tree, nju);
            return;
        }
    }

    private boolean isMethodMatch(Element method) {
        if (method.getKind() == ElementKind.METHOD && this.allMethods != null) {
            for (ElementHandle<ExecutableElement> mh : this.allMethods) {
                ExecutableElement baseMethod = (ExecutableElement)mh.resolve((CompilationInfo)this.workingCopy);
                if (baseMethod == null) {
                    Logger.getLogger("org.netbeans.modules.refactoring.java").info("RenameTransformer cannot resolve " + mh);
                    continue;
                }
                if (!baseMethod.equals(method) && !this.workingCopy.getElements().overrides((ExecutableElement)method, baseMethod, this.workingCopy.getElementUtilities().enclosingTypeElement((Element)baseMethod))) continue;
                return true;
            }
        }
        return false;
    }

    private void renameParameterInMethodComments(Element parameter) {
        Tree method = this.workingCopy.getTrees().getPath(parameter).getParentPath().getLeaf();
        String originalName = this.getOldSimpleName(parameter);
        int methodStart = (int)this.workingCopy.getTrees().getSourcePositions().getStartPosition(this.workingCopy.getCompilationUnit(), method);
        TokenSequence tokenSequence = this.workingCopy.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(methodStart);
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            if (this.isComment((Token<JavaTokenId>)token)) {
                this.rewriteAllInComment(((Object)token.text()).toString(), tokenSequence.offset(), originalName);
                continue;
            }
            if (token.id() == JavaTokenId.WHITESPACE) continue;
            break;
        }
        int methodEnd = (int)this.workingCopy.getTrees().getSourcePositions().getEndPosition(this.workingCopy.getCompilationUnit(), method);
        tokenSequence.move(methodStart);
        while (tokenSequence.moveNext() && tokenSequence.offset() < methodEnd) {
            Token token = tokenSequence.token();
            if (!this.isComment((Token<JavaTokenId>)token)) continue;
            this.rewriteAllInComment(((Object)token.text()).toString(), tokenSequence.offset(), originalName);
        }
    }

    private boolean isComment(Token<JavaTokenId> token) {
        switch ((JavaTokenId)token.id()) {
            case LINE_COMMENT: 
            case BLOCK_COMMENT: 
            case JAVADOC_COMMENT: {
                return true;
            }
        }
        return false;
    }

    private void rewriteAllInComment(String text, int offset, String originalName) {
        int index = text.indexOf(originalName);
        while (index != -1) {
            if (!(index > 0 && Character.isJavaIdentifierPart(text.charAt(index - 1)) || index + originalName.length() < text.length() && Character.isJavaIdentifierPart(text.charAt(index + originalName.length())) || text.charAt(index - 1) == '<' || text.charAt(index - 1) == '/')) {
                this.workingCopy.rewriteInComment(offset + index, originalName.length(), this.newName);
            }
            index = text.indexOf(originalName, index + 1);
        }
    }

    private boolean duplicateDeclaration() {
        TreeScanner<Boolean, String> duplicateIds = new TreeScanner<Boolean, String>(){

            @Override
            public Boolean visitClass(ClassTree node, String p) {
                if (node.getSimpleName().contentEquals(p)) {
                    return Boolean.TRUE;
                }
                return (Boolean)super.visitClass(node, p);
            }
        };
        return Boolean.TRUE == duplicateIds.scan(this.workingCopy.getCompilationUnit(), this.newName);
    }
}

